META
key;value
description;District PB in Warszawa, Praga-Południe
country;Poland
unit;Warszawa
district;Praga-Południe
subunit;Praga-Południe
instance;2024
num_projects;66
num_votes;8244
budget;7201326
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
1120;1440000;4803;Więcej zieleni na całej Pradze-Południe - drzewa, krzewy, łąki kwietne.;environmental protection,public space,urban greenery;children,seniors;1;52.234970831228885;21.066886123158792
907;399942;3328;Zielona Praga Południe - mniej betonu i smogu, więcej zieleni i ławek .;education,public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.24664143644729;21.07029313034737
996;1440000;3029;Zieleń zamiast betonu;environmental protection,public space,urban greenery;children,seniors;1;52.228315134763555;21.08450144033762
891;775937;3008;Zielone ulice na Pradze Południe - Bora-Komorowskiego i Grochowska;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.23882155607913;21.076623916451357
1668;70000;2893;Chronimy ptaki i wiewiórki, żyjące na Pradze Południe – utrzymanie i konserwacja skrzynek lęgowych;environmental protection;;1;;
1259;423000;2889;Drzewa i krzewy - Zielono na Grochowie;education,environmental protection,public space,urban greenery;children,seniors;1;52.24040851363636;21.081762109843638
749;80000;2523;50 drzew nad Kanałem Gocławskim;environmental protection,public space,urban greenery;children,seniors;1;52.22829227000042;21.095198392868042
92;65000;2469;Domki, hotele dla owadów w parkach i na skwerach. Gocław, Grochów, Saska Kępa oraz Kamionek;education,environmental protection,public space,urban greenery;children,seniors;1;52.229517415508624;21.092609155789187
796;225590;2406;Zielony Wał Miedzeszyński: drzewa i krzewy w pasie między jezdniami, czyli... więcej natury, mniej hałasu, lepsza przestrzeń publiczna (kontynuacja);environmental protection,public space,urban greenery;seniors;1;52.229278463887375;21.051910723541592
680;1440000;2381;Wygodnie rowerem wzdłuż Kanału Wystawowego;public transit and roads,environmental protection,public space,sport;children,seniors;1;52.23534362967911;21.06881634342569
215;990000;2349;Reprezentacyjne wejście do parku od przystanku Park Skaryszewski;environmental protection,public space,urban greenery;children,seniors;0;52.24112475600164;21.06160640716553
987;370000;2348;Park Skaryszewski: Wykonanie pomostu na Jeziorku Kamionkowskim + slip dla młodych żeglarzy;education,public transit and roads,culture,public space,sport;children,seniors;1;52.24481061119721;21.05712175369263
976;1420000;2280;Kamionkowskie Błonia Elekcyjne: Modernizacja alejek i ławek (kontynuacja);public transit and roads,public space,urban greenery;children,seniors;0;52.24449003535555;21.063885211944584
1450;800000;2260;Zieleń na Grochowie;environmental protection,public space,urban greenery;children,seniors;0;52.23954416411597;21.077725266414173
1449;640000;2187;Nowy teren zielony na Gocławiu. Strefa relaksu – polana, hamaki, ławki, drzewa, alejki oraz latarnie LED;environmental protection,public space,sport,urban greenery;children,seniors;0;52.227904565391675;21.11074447631836
675;178000;2030;Wakacyjna Bezpłatna Wypożyczalnia kajaków na Pradze Południe - Jeziorko Kamionkowskie 2024;education,sport;children,seniors;1;52.2447510782613;21.057829856872562
1440;200000;1944;Stojaki rowerowe na Pradze Południe - kontynuacja;public transit and roads,public space,sport;children;1;52.242726502;21.085991664801153
1039;1439270;1862;Aktywne Jordanki - nowe boiska i nowe zajęcia na Grochowie i Saskiej Kępie;education,culture,sport,urban greenery;children;0;52.23873313159383;21.08600378036499
1212;293140;1750;Zielone ekrany;environmental protection,public space,urban greenery;children,seniors;0;52.23593384534996;21.09187602996826
1669;25000;1746;Zimowe dokarmianie ptaków i wiewiórek na terenie Pragi Południe;education,environmental protection;;1;;
1197;99000;1707;Jadłodzielnia przy Teatrze Powszechnym;education,environmental protection,welfare;seniors;0;52.2471225;21.048311259262295
40;32000;1604;Kosze na odpady wzdłuż Kanału Wystawowego na Saskiej Kępie;public transit and roads,environmental protection,public space;children,seniors;1;52.2367046;21.064529
795;160000;1521;Ratujemy rzeźby plenerowe na Gocławiu, Grochowie i Saskiej Kępie;education,culture,public space;children,seniors;0;52.22986287374063;21.069116592407227
950;1200000;1491;Biblioteka na Meksykańskiej OD/NOWA;education,culture,public space;children,seniors;0;52.2306164;21.0573106
1501;350000;1481;Zielony azyl przy ul. Gocławskiej dla ludzi, drzew i zwierząt;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.248123050000004;21.063806886488873
207;405000;1472;Bezpłatne wejściówki dla Wszystkich na Pływalnię „Wodnik”, dmuchany tor przeszkód dla dzieci i młodzieży i modernizacja boksu.;education,public space,sport;children,seniors;0;52.22592945;21.089694264626388
146;25000;1471;Bajkowa Praga-Południe - bezpłatne spektakle teatralne dla dzieci;culture;children;1;52.247083950000004;21.07550455149378
582;290000;1464;Wiszące ogrody + eko-stacje i sportowe atrakcje;education,environmental protection,sport,urban greenery;children,seniors;0;52.22561757233706;21.08744144474745
255;306280;1400;Bezpłatne zajęcia rekreacyjno-sportowe Zumba, Bieganie, Trampoliny, Wspinaczka - Gocław, Grochów, Saska Kępa;education,public space,sport;children,seniors;0;52.24276806;21.08198670055954
941;872562;1386;Więcej zieleni na Małej Grochowskiej;public transit and roads,public space,urban greenery;children,seniors;0;52.2420356958117;21.1045501306803
465;987500;1290;Widoczne chodniki i ulice na Gocławiu i Grochowie - nowoczesne latarnie LED przy ulicach Jana Nowaka Jeziorańskiego i Stanisława Żółkiewskiego;public transit and roads,public space;children,seniors;0;52.2386186923712;21.100169634583
930;455000;1234;Bezpłatny Mini Golf z zazielenieniem przestrzeni w dzielnicy Praga-Południe;education,public space,sport;children,seniors;0;52.25142425;21.078557202589266
1268;1282000;1205;Jaśniej w historycznych zakątkach Saskiej Kępy i Grochowa - nowe, eleganckie oświetlenie uliczne dla Walecznych, Lubieszowskiej i Płowce;public transit and roads,public space;children,seniors;0;52.24061236345425;21.081032262656624
748;10000;1185;Ławki przy rurze nad Balatonem;public space,urban greenery;children,seniors;1;52.22956059025075;21.086711883544925
1443;120000;1184;Zielone ściany w szkołach;education,environmental protection,public space,urban greenery;children;0;;
790;1128400;1113;Widno i bezpiecznie przy pawilonach na Bora Komorowskiego;public transit and roads,public space,urban greenery;children,seniors;0;52.224285410280544;21.093518257403048
1219;79000;1095;Targ dla mieszkańców na placu Szembeka;education,environmental protection,welfare,public space;children,seniors;0;52.2436198;21.102687
1713;194000;1058;Ogród różany przy skrzyżowaniu ulic Saska/Argentyńska;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.2275469;21.062815443212507
155;5000;1054;Zakup nowości do Wypożyczalni dla Dorosłych i Młodzieży nr 100;culture;seniors;0;52.2334151;21.0681456
516;100000;1012;Poprawienie bezpieczeństwa - wykonanie oświetlenia na ul. Siennickiej;public transit and roads,public space;children,seniors;0;52.25334269745372;21.077270507812504
1209;207950;1006;Eko pływanie po Wiśle kajakami, deskami sup lub łódką elektryczną.;environmental protection,sport,urban greenery;children,seniors;0;52.22672165267365;21.050362586975098
742;1080000;994;Remont placu zabaw;public space,sport;children,seniors;0;52.2292608;21.063285793521217
607;180000;965;Książkomat - Biblioteka Publiczna przy ul. Meissnera;education,culture,public space;children,seniors;0;52.22187625;21.087335636709312
1562;366350;893;Nowy chodnik dla ulicy Walecznych;public transit and roads,public space;children,seniors;0;52.23580955538566;21.05907440185547
104;35000;873;Garażówka na Gocławiu oraz szkolenie dorosłych i dzieci z pierwszej pomocy przedmedycznej;education,culture,environmental protection,welfare,public space;children,seniors;0;52.23147939894375;21.094608306884766
725;453000;873;Remont wybiegu dla psów w parku im. płk. Jana Szypowskiego „Leśnika”;public space;seniors;0;52.24320073037206;21.11239242527518
117;248000;832;Wymiana latarni parkowych sodowych na LED;public transit and roads,environmental protection,public space;children,seniors;0;52.22763740932892;21.06574467250279
1233;485000;727;Zielony Plac przy Rodziewiczówny 1;public transit and roads,public space,urban greenery;seniors;0;52.23470833034839;21.112189293125994
1235;750000;658;Suchą stopą nad kanał - Budowa chodnika przy Kanale Nowa Ulga;public transit and roads,public space,urban greenery;children,seniors;0;52.22668090726056;21.11066722791293
1324;460000;653;Zdrowo na sportowo. Modernizacja boiska do piłki nożnej przy Szkole Podstawowej nr 168 im. Czesława Niemena w Warszawie przy ul. Zwycięzców 44 w dzielnicy Praga Południe;sport;children,seniors;0;52.232842250000004;21.066100422050738
1205;15000;644;Piknik edukacyjny dla dzieci na osiedlu Gocław;education,culture;children;0;52.22226441736389;21.09622192409006
145;6400;631;Bezpłatne kreatywne warsztaty rozwojowo-artystyczne dla dzieci;culture;children;0;52.247083950000004;21.07550455149378
1229;600000;625;Plac zabaw przy Szkole Podstawowej nr 401;education,public space,sport;children;0;;
1472;1440265;611;Przyjazna ulica Perkuna;public transit and roads,public space;children,seniors;0;52.2328668;21.1008631
1186;7000;508;Filmowe spotkanie z komedią na osiedlu Gocław;culture;children,seniors;0;52.22225258687003;21.09611034393311
456;120000;503;Malort - pracownia zabawy malarskiej i darmowe zajęcia dla mieszkańców;culture;children,seniors;0;52.2315624;21.09332472090064
1639;1440000;488;Przyjazna okolica pawilonu przy ul. Grenadierów 34;public transit and roads,public space,urban greenery;children,seniors;0;52.24268204001316;21.080161882403846
1670;60000;485;Lampy na Skwerze Seniora;public transit and roads,environmental protection,public space,urban greenery;seniors;0;52.2490159;21.0808564
1436;500000;484;Likwidacja jezior okresowych na Grochowie;public transit and roads,public space;seniors;0;52.24309562007988;21.083553313947053
769;122000;456;Ulice bez błota i kurzu - Alfreda Nobla i Dąbrowiecka;public transit and roads,environmental protection;children,seniors;0;52.23316945801454;21.054686307907104
771;20000;344;Kalejdoskop sztuki - spotkania z lokalną twórczością artystyczną;education,culture;children,seniors;0;52.23140752725363;21.093385219573975
998;42000;311;Jasna Genewska - brakująca latarnia na drodze do Dog-parku;public transit and roads,public space;children,seniors;0;52.2280431;21.055603496434898
167;870000;310;Remont ulicy Kanadyjskiej;public transit and roads,public space;children,seniors;0;52.227354761540006;21.06182826502545
1143;7500;249;Koncert muzyki powstańczej na osiedlu;education,culture;children,seniors;0;52.2221076633903;21.09622192409006
1134;14200;197;Osiedlowe spotkanie mieszkańców;culture,public space;children,seniors;0;52.22223582710695;21.096136093401583
1164;9000;195;Koncert z okazji 105 rocznicy odzyskania niepodległości na osiedlu;education,culture;children,seniors;0;52.22231568263375;21.09622192409006
VOTES
voter_id;vote;age;sex
24;465,92,1449;30;M
25;1197,40,680,1120,790,891,1668,907,795,748,1268,92,1669,1324,950;46;F
31;1668,996,795,117,1268,907,1501,941,987,215,1450,891,1259,1120,976;48;F
39;92,996,1186,146,749,104;50;F
44;1039,950;41;F
62;1233,1229;8;F
89;1186,790,40,1197,104,215,771,1164,1259,1120,976,795,1143,1668,749;76;F
92;1143,996,1134,1186,1164,1205,790;65;F
104;1039,104,1443,255,748,796,1449,680,891,146,749,930,675,1205,1120;33;M
105;1713,1436,987,996,1670,207,1209,465,748,255,1449,891,675,790,1197;52;F
115;1039,1669,742,1713,950,1443,795,769,1562,40;43;M
118;749,1449;46;M
133;1268,1440,725,1562,92,207,748,255,155,998,987,146,1205,675,40;31;F
134;891,680,516,1235,255,748,1440,1670,117,465,1449;45;M
144;795,1120,987,996,465,1449,680,891,1212,749,1472,790,40,976,215;35;F
162;1449;37;F
189;465,92,1449,104;31;F
192;1233,1443,1212,749,976,796,1209,907,996,1450,891,1259,675,1120,215;50;F
198;1268,92,465,796,1440,207,255,1449,1219,582,680,891,1212,1205,675;43;F
210;1233,1229;4;F
215;1164,1205,40,1120,742,996,907,117,465,1669,1143,1449,891,749,790;45;F
245;104,1449,465,92,748,607,930,1120;23;F
253;207,796,1209,1324,1440,255,1449,996,1219,680,891,930,675,1039,215;47;M
261;1472,996,155,516,1235,907,456,117,725,1436,92,1440,1639,1212,40;33;F
276;92,207,255,891,1120,215,907,516,996,1501,1668,987,930,675,976;35;F
287;907,1443,996,1219,1668,582,941,1450,891,1212,146,1259,1120,1197,1039;48;F
296;207,1449,1197,1669,1436,92,1268,907,996,1668,941,1450,891,1259,1120;44;F
311;749,1669,92,1449,155,1472,790,950;36;M
312;796,907,1668,891,1120,976,1039;39;M
316;456;33;F
322;907,1235,1449,996,987,749,1120,40,976,215,796,92,1668,891,790;39;F
390;145,1440,92,117,1669,465,207,907,1443,582,987,1450,1259,1120,976;31;F
411;117,1219,1259,1436,1450,1501,1197,1120,941,1440,907,976,891,996,516;37;M
414;790,1120,40,976,748,1440,1268,92,796,1197,749,1186,465,1669,725;40;M
463;1268,796,1713,92,907,996,167,1212,1120;57;M
484;725,1669,92,1440,155,996,1668,680,941,1259,1120,1197;47;F
493;1440,92,1713,796,907,996,1501,941,1450,891,1212,1233,749,1259,1120;29;M
503;1440,456,996,1501,582,680,987,1450,749,930,1259,950,675,1120,1197;32;F
513;795,1669,92,907,996,1668,941,1450,891,1212,1259,1120,215;36;M
521;976,1120,1562,930,795,167,680,1668,742,987,749,950,675,1039;68;F
530;675,907,795,1440,1209,1562,1713,987,976;28;F
545;207,1039,582,255,1229;37;F
574;950,1039,771,607,907,675,1120,1197,795,796,1209,1713,155,207,1443;39;F
577;1039,465,725,1235,92,1219,1268,1440,941;39;M
587;1501,675,1197,465,1669,145,255,907,1143,1449,155,996,1668,1120,104;38;F
632;1449;27;F
651;1669,92,795,1219,1668,1233,1120,215;29;F
697;1268,1235,1668,1450,930,675,1120,680,1501,1219,996,796,1209,1440,1669;51;M
703;104,950,1259,749,891,1450,680,1668,155,1449,516,607,725,796,1440;32;F
775;1268,1235,1668,742,749,40,675,1440,1449,680,987,1259,1120,976,215;39;M
821;1229,1443,1209,1501,1668,582;30;F
845;996,1219,742,146,749,1120,1209,748,987,1233,930,1259,675,1229;38;M
849;1668,1501,1134,1449,907,92,465,725,996,1219,1186,582,675,1120,104;20;F
863;796,215,976,907,1120,1449,725,1268,1440,465,749,1259,941,1472,1233;37;M
924;796,465,92,1440,907,1443,1449,996,1668,680,891,749,1120,40;40;M
990;1209,207,255,1229,516,1449,996,742,941,1233,675,930;23;F
1037;930,40,1039,1209,1713,769,748,795,1501,215,1669,92,1668,998,950;30;M
1059;1229;36;M
1064;1450,1259,40,769,1440,1436,891,976,215,1669,92,907,996,1501,1120;29;M
1117;891,1450,1259,907,456,1229,255,1440,1120,950,987,1639,207,1209,976;40;M
1120;680,1212,1233,40,1039,796,92,1229,987,976,1143,1164,146,930,215;37;M
1146;167;59;M
1167;1562,675,40,1039,207,1443,950;40;F
1179;675,930,891,987,582,996,907,456,748,207,1209,1562,255,516,1449;45;F
1225;941,891,146,749,1259,1120,1197,725,1669,207,1229,680,1233,675,1039;37;F
1263;930,146,1233,1229;39;F
1266;1209,742,930,987,1197,215,796,1562,1669,117,1713,769,795,1668,680;49;F
1288;1186,742,582,891,1212,146,1120,796,1209,207,907,1449,996,1205,790;34;F
1289;1186,941,1450,891,1233,749,1259,1120,40,1039,976,104,255,1229,1205;47;F
1307;465,749,1235,1449;31;M
1321;796,92,996,1450,1668,680,891,749,1120,976,1440,1449,1212,1197,1472;34;F
1360;456,1562,796,1268,207,748,1668,1186,1120,1209,1713,1449,675,1197,1039;30;M
1369;465,1440,725,941;29;F
1419;1668,998,1197,976,215,1562,1713,1235,749,1120,40;42;F
1439;725,907,1443,996,1219,941,1450,1212,146,930,1259,1120;28;M
1441;92,771,1449,996,1219,1501,1668,582,680,1450,1233,749,930,675,1197;30;F
1460;1669,749,40,725,907,516,1668,930,675,976;31;M
1462;996,1134,582,146,749,1205,117,1669,465,790,1120,104,1209,748,1443;41;M
1472;516,907,456,1436,1440,145,1449,891,1120,1039;27;F
1534;207,748,742,987,950,1205;44;F
1561;1436,92,255,456,907,996,1219,1668,582,680,1450,891,1212,1259,1120;22;F
1567;1209,1449,155,996,1134,1668,1186,582,987,891,930,675,1197,104,1219;32;F
1570;1669,92,907,155,1219,1668,1450,891,1233,1259,1120;43;F
1622;215,1120,1562,1668;56;F
1640;1229;36;F
1645;1562,1440,769,207,795,1501,941,1472,748,607,680,40;38;M
1648;1436,207,907,1443,996,941,1450,891,1212,749,1259,1120;62;F
1678;465,1268,1440,748,907,996,680,1450,891,950,1472,1120,1562,796,725;26;F
1679;215,950;26;M
1713;796,215,1669,607,1235,1449,996,1186,790;28;F
1776;1501,1450,976,92,1668,1259,1120;48;M
1777;1562,1209,1143,987,1120,1197,976,1669,92,795,1668,680,749,675,40;30;F
1784;996,1219,742,941,987,1450,891,146,675,1039,465,207,255,1229,215;30;F
1818;92,145,456,907,1219,207,255,155,582,930,1120,146,950,1039,167;45;F
1836;996,907,1501,1450,891,1233,40,976,215,1259,1120,796,680,987,1212;27;F
1940;1235,582,117,680,1212,748,749,465;41;M
1979;796,1669,1713,1668,950;42;F
1999;1449,582,941,987,1233,749,1205,1472,790,725,1219,680,930,104,1039;33;M
2017;749,930,1205,104,465,207,748,255,1235,1449,146,1233,790,1120,40;30;F
2045;1562,1268,1436,796,1440,795,907,996,1668,680,1212,950,1120,40,104;44;F
2146;1440,1449,891,1233,675,1120,40,1229;33;F
2149;1209,1120,1450,907,680,1259;36;F
2151;749,891,1668,1268,92,117,465,790;36;F
2164;1209,465,1713,748,795,907,1449,1219,680,987,749,930,1472,1120,1197;34;F
2169;1268,1443,891,1212,749,1259,1197,1562,907,987,796,680,1120,976,215;52;M
2225;92,1443,582,1450,950,104,1039,1120,907,145,1440,1233,1197,255,1229;40;F
2229;255,1219,1668,1450,930,1259,1120,976;24;F
2231;1501,941,1450,891,1233,790,1120,215,1259,749,987,1449,907,1713,796;41;M
2300;796,1669,907,1235,1449,680,987,891,749,1120,40,976,215;32;F
2307;1440,795,1229,1235,516,1668,742,987,1450,891,1259,1120,40,1039,215;31;M
2309;207,255,465,748,907,1186,582,891,1212,146,749,930,1205,1120,215;39;F
2360;1450,1259,675,1120,1209,516,996,1219,941,987;28;F
2370;92,1713,796,1669,1440,996,1501,1668,680,941,1450,146,1259,1197,1120;35;M
2431;1443,1501,941,891,1259,1639,907,996,1450,1120;34;M
2469;215,976,987,680,1668;34;M
2503;1449,516,907,607,207,1440,796,465,145,255,155,1120,1197,1039,104;21;F
2508;167;84;F
2530;941,215,796,1562,117,1713,1440,996,680,1450,891,1212,749,1259,1120;30;M
2533;1229;35;M
2561;1440,1669,796,1668,907,117,725,1449,680,749;37;F
2618;742,1440,456,1235,1443,1449,155,749,790,1120,104,796,1324,607,950;54;F
2658;725,796,1713,795,155,996,1668,1212,1233,1259,950,790,1120,1039,976;30;M
2661;769,1440,1268,1713,1562,796,998,40,1039,976,92,680,987,675,215;38;F
2664;1713,795,998,1120,215,950,167;51;M
2683;1235,465,748,907,1449,1668,891,1233,1472,790;35;M
2690;1259,1229;38;F
2695;1501,796,1164,92,748,1143,1205,1324,207,255,790,607,996,749,582;40;M
2728;1440,145,1212,1039,255,1229,146,1205;42;F
2747;1669,92,145,207,748,795,255,1668,749,930,1120,40,1197,1039,976;56;M
2750;215;33;F
2753;1229;45;F
2754;796,117,907,996,1212,1501,1668,987,891,749,1259,675,1120,976,215;51;M
2756;941,1450,1120,1259,891,996,1670,907,675,215,207,516,987,146,976;42;F
2759;795,1120,1229;57;F
2804;748,795,255,1235,1668,582,930,1713,769,167,680,987,1212,976,104;36;F
2808;1713,1268,207,795,167,950;44;M
2834;996,987,1450,1120,40,976;32;F
2857;1219,1039,996,1668,941,1450,891,1259,1120;50;F
2869;465,1501,1450,1212,749,1472,796,907,1120,1259,1233,891,941,1219,1440;28;F
2882;465,117,207,607,255,1449,996,790,215,1229;37;F
2893;1229;39;F
2900;1197,1436,1670,607,1639,167;67;M
2914;748,790,40,1120,976,1639,92,795,1235,1449,680,749,1668,215;37;M
2931;907,1670,516,996,998,1450,1259,725,1440,1639,941,1668,1501,891,1120;27;F
2944;1450,1219,996,255,92,117,1209,796,1120,891,987,1668,907,207,1669;31;F
2950;891,749,1205,996,680;35;M
2961;1229;32;F
2967;987,941,907,1669,92,996,1219,1668,680,1259,675,1120,40,976,215;69;F
2973;790;44;M
2983;796,1669,92,1440,607,907,1449,996,1501,1668,680,891,950,675,1120;29;F
2985;1219,742,680,1450,891,146,749,930,1205,1472,790,1120,40,1039,976;76;M
2993;749,1268,1670,795,1639,516,996,1450,215;30;M
2994;1229;36;F
3051;950,1197,796,117,1670,1440,795,607,907,40,1268,996,155,680,1120;51;F
3106;167;44;M
3112;1562,795,680,40,976,215;46;F
3126;796,1669,92,1436,1440,748,607,1639,1235,1668,680,749,1120,1197,976;46;F
3132;1229;33;F
3144;907,941,680,891,749,1120,40,725,1669,1440,1668,1450,215,1259,976;46;M
3149;796,1669,92,748,795,907,1449,1668,987,891,749,790,1120,40,104;40;M
3163;1713,1669,725,92,996,987,1233,749,40,104,796,1449,1259,1120,117;27;F
3179;1450,1668,1501,680,941,987,891,749,1259,675,1669,996,1212,1233,1120;46;F
3231;155;72;F
3238;1443,1229,255,1440,1669,1324,907,1449,996,1120,930,1450,941,891,1259;41;F
3244;1472,215,1449,465,1235,680,749;37;M
3340;796,748,607,1449,891,749,790,1120,40;36;F
3374;725,1209,456,1449,941,987,117,1268,996,1450,215,907,1259,1120;50;F
3377;1212,796,1440,1235,1449,996,1450,891,749,1259,790,1120,1039,976,215;32;M
3427;167;44;F
3467;117,976,1268,998,950,1472,40,796,1562,1713,769,795,167,1120,215;30;M
3489;1186,582,255,771,92,465,1668,1120,40,1669,748,607,155,950,104;48;F
3520;1268,117,1669,465,796,92,207,748,996,891,749,1205,675,790,1120;54;M
3552;1229;8;F
3598;1229;6;M
3631;1233,1472;35;M
3653;1229;68;F
3658;1197,987,891,146,749,1120,207,748,456,1449,1219,582,930,1472,104;31;F
3670;1562,1209,1268,795,255,907,1501,680,40,976,215,987,1212,1259,1120;32;M
3699;1713,1669,1209,92,255,1219,1668,582,1450,1233,930,1259,1205,675,1039;37;F
3710;1562,748,207,1449,996,1186,680,891,146,749,1205,675,790,1120,40;34;M
3729;1440,516,941,680,1450,987,749,930,1259,950,40,1120,907,155,976;40;F
3759;996,771,207,748,795,607,255,1449,891,146,749,930,1472,790,104;37;F
3786;748,207,117,465,796,680,891,1164,1205,790,1120,976;41;M
3840;40,1205,1120,1259,749,1212,1450,582,1449,1443,907,1440,796,996,891;32;F
3874;796,456,907,1450,749,1120,1197,104;27;F
3925;1324,465,796,1669,145,255,907,1443,1501,1450,1212,1233,1259,675,1120;24;F
3976;117,796,92,145,795,1668,582,941,1450,1259,1120,1039,1324,1501,987;41;M
3978;795,1440,796,607,155,1212,1233,950,680,891,930,1472,1120,976,215;19;M
3993;465,1449;30;F
4025;680,1450,146,930,976,215,1209,1669,1268,516,1668,987,1440,1259,675;56;F
4037;1233,796,795,907,996,1668,680,941,1450,1259,1120;52;M
4073;891,582,1668,1501,996,1669,117,1713,92,207,1449,749,1472,790,1120;25;M
4079;1668,1219,996,516,907,255,1669,465,725,796,1670,92,930,1039,215;42;F
4084;465,167,215;41;F
4108;748,207,255,146,930,675;44;F
4111;976,950,1501,907,92,1436,795,155,1120,1669,1668,941,891,1450,1259;48;F
4115;1233,1205,1134,1186,675,1039,207,748,255,1229,146,104;38;F
4158;796,1209,1670,1639,907,987,675,1120,215,795,1219,1259,1212;58;F
4182;1436,748,155,987,950,675,907,1450,891,1259,941,680,1219,255,1440;36;F
4217;92,207,796,465,1669,1440,1668,680,749,40,215;57;F
4234;1669,92,1219,1668;29;F
4235;1268,1639,907,996,1501,941,987,1450,891,1212,749,1259,1120,1039,215;36;M
4249;950,1205,1164,1143,1186,1134,465,582,92,790;27;M
4250;1209,725,465,1669,92,255,680,941,987,1212,675,1039,215,976,1668;34;F
4256;456;34;F
4295;1197,941,155,516,456,1639,1440,1670,796,907,996,987,1450,1259,675;33;F
4302;907,996,680,1233,1472,215,1669,92,941,1450,891,1212,749,1259,1120;29;F
4319;1229;36;M
4343;465,92,1449,1219,1259,790,1120;42;F
4349;796,117,795,1449,40,1120,891,92;42;M
4365;1229;37;F
4366;215,1713,1669,92,907,1443,996,1219,1668,941,1450,1212,1259,1120,1039;60;F
4408;92,207,891,749,1120,1233,1229;38;F
4424;796,465,1440,607,1639,1235,1449,996,680,146,749,790,1120,976,1039;31;F
4432;1436,607,516,155,1668,950,40;33;M
4435;680,950,40,796,1562,92,1268,1440,769,795,1668,987,1120,976,215;32;F
4486;796,907,1443,1450,891,1259,215,255,1268,742,1219,1212,1472,941,1233;43;M
4492;976,92,1440,996,1197,215,1669,255,907,516,155,1668,1450,1259,1120;55;F
4504;725,1562,1324,117,1268,1440,795,1449,998,987,675,40,1039,215,769;45;M
4517;795,996,1668,941,1450,891,749,976,92,1440,907,680,1212,1259,1120;48;M
4538;465,796,748,795,1443,1186,582,891,1120,104,996,1449,146,1205,790;35;F
4566;996,742,680,941,987,40,215,725,1440,155,891,675,1120,1039,976;37;F
4584;255,607,145,1324,465,92,748,1229,907,996,742,146,1259,675,1120;39;F
4604;582,891,607,1440,92,1713,1324,465,749,1205,1120,1197,215,976,680;52;F
4620;456,1443,996,742,1450,1212,930,675,1120,976,215,907,1501,987,1259;60;F
4653;1209,167,987,675,790,725,1562,1669,1324,1440,795,255,680,930,40;38;F
4655;725,1669,92,207,255,1235,1668,680,790,749,1212,748,1440,1324,465;41;F
4661;1259,930,680,582,1668,1219,996,1449,907,1440,92,1669,796,104,1501;28;F
4670;1668,1449,795,92,1324,1669,465,1562,796,1713,1268,207,255,996,950;48;F
4730;465,907,996,1668,742,680,1450,891,1212,1039,1197,1120,1259,749,1233;40;M
4736;146,1205,796,748,1235,465,1669,92,207,1668,891,749,790,1120,104;38;F
4764;1229,207,255;37;F
4774;1562,1268,769,146,215,1039;45;M
4824;1259,104,1205,796,996,1134,582,891,749,790,1120;31;F
4852;795,907,996,680,1212,40,976,215,796,1562,92,1668,987,749,1120;24;M
4888;40,1212,1670,891,749,1472,1120,790,1186,996,1449,907,255,748,465;44;F
4910;907,1501,891,976,950,456,92,607,155,1219,1668,987,930,675,104;33;F
4978;1259,790,1143,907,1440,1669,465,1209,796,117,92,255,996,1668,1120;41;M
4997;1164,1235,582,891,749,104,1186,795,748,207,145,465,1472,1120;38;M
5010;1450,1039,796,1440,907,1443,996,1501,941,1259,1197,976,1120,749,146;47;M
5015;796,465,1713,748,907,1449,996,1668,891,1212,749,790,1120;42;M
5025;790,796,1209,465,1669,92,207,748,1443,1449,996,1668,891,1212,749;32;M
5040;1669,796,1501,1450,891,749,215,1670,92,907,996,1668,941,1259,1120;41;F
5086;742,582,987,1229;40;F
5114;996,582,1450,749,1259,1120,1197,891,941,1668,1501,907,92,1669,976;16;F
5134;155,1134,742,941,1450,930,725,1436,1440,207,255,987,146,1205,675;45;M
5141;465,255,1229,456,1443,146,1212,907,996,1450,930,1259,1120,1039,215;35;F
5164;1212,1450,996,796,607,155,891,1197,1669,907,1219,1668,941,1259,1120;42;F
5173;796,1209,907,1443,1449,996,1186,582,146,1120;44;F
5206;1235,1436,1562,725,465,1449,891,1212,1233,749,1472,790,215,1120;47;F
5241;40,1212,680,582,998,1668,207,771,1669,1209,725,796,1039,104,255;36;F
5251;1259,790,1120,680,1668,996,769,1562,117,1440,582,987,40,976,215;36;F
5289;40,607,1449,790,891,104,796,1669,92,795,907,996,1668,749,1120;40;F
5315;155,996,215,891,1472,582,749,796,92,795,907,1668,790,1120,104;42;M
5326;255,907,516,1449,996,1501,742,582,941,1450,891,146,1259,1120,930;34;F
5358;465,1440,1235,996,680,891,749,790;42;M
5382;987,1134,1449,1436,1259,1120;52;M
5393;1449,1039,930,941,1235,255,725;36;F
5395;1134,607,796,207,795,748,907,155,1449,996,987,1450,891,1259,1120;49;F
5424;1120,1039,907,1449,1219,742,146,930;37;F
5439;748,1235,607,1449,680,1212,749,950,996,155,1443,907,1440;35;M
5453;1219,907,207,145,92,1669,1229,1668,941,146,1205,675,1120,1039,215;32;F
5488;771,748,255,456,907,1450,891,1120,40,145,607,155,146,950,1205;44;F
5525;465,117,795,1639,907,1443,582,1268,996,1501,1668,1450,891,1259,1120;34;F
5535;1713,167;52;F
5556;1449,582,749,40,796,1209,1450,891,1120,976,907,1268,1440,680,1259;43;F
5564;607,255,155,582,1212,1259,465,1562,907,1443,1449,996,891,749,1120;34;F
5578;930,1259,950,1120,40,1039,1562,907,1229,1324;35;F
5673;891,1212,749,1259,790,907,725,796,1669,92,1440,607,1668,930,1120;30;F
5685;1120,1668,465,1436,92,207,748,607,907,516,1449,155,950,675,104;31;F
5702;907,996,680,941,1450,1212,1259,1120,891,976,215;52;M
5708;207,465,1449,996,1219,1668,1186,582,1450,891,1212,1259,1205,790,1120;70;F
5722;104,1120,40,1039,796,207,748,255,1235,1449,582,680,1205,1472,790;38;F
5725;607;45;M
5730;1669,1713,1268,795,40,215;46;M
5746;465,748,795,607,907,1450,1212,1259,950,1472,1120,1449,996,891,1233;42;M
5754;795,950,1120,607;34;F
5768;907,104,1134,742,1039,1235,582,1205,1120,255,748,465,996,790,1449;40;F
5780;1450,1449,996,1668,1197,465,1669,1713,607,255,907,155,1186,950,1120;49;F
5792;104;58;M
5869;1449,155,1212,1472,215,92,607,907,1668,891,749,950,790,1120,1197;35;F
5876;1669,92,1440,795,996,1668,987,1450,1212,1259,1120,976;43;F
5914;1562,1268,795,155,950,40;65;F
5979;92,796,465,1669,1440,207,1668,680,749,40,215;65;M
6025;92,907,516,1443,941,1450,891,1259,1120,1039;39;F
6044;1713,40,465,790,796,1440,607,1235,1449,996,680,891,749,1120,976;45;F
6060;795,907,1449,1219,1668,891,1120,40,976,796,748,1235,680,749,92;47;M
6066;1324,1229;43;F
6068;1450,1259,1219,155,907,255,725,941,1120;32;F
6084;1669,92,795,215,1449,996,1501,1668,998,680,987,1212,749,675,1120;49;F
6121;1209,769,1669,1268,516,155,1219,1450,891,215,1197,1164,255,1186,675;41;F
6141;465,1440,748,255,907,1235,996,987,891,749,1120,40,215,680,675;36;F
6149;1324,1120,1039,796;32;F
6157;207,145,92,1324,1669,1268,255,1562,769,742,987,146,1472,1120,1039;39;F
6160;1233,891,769,465,1562,796,1472,790,1120,40,1197,1039,976,104,215;32;M
6166;1197,1669,1670,907,516,987,1450,930,1259,1120,92,1440,1501,1668,976;33;F
6204;1197,465,1562,725,796,1209,1713,1268,207,167,1668,40,1120,146,950;46;F
6210;1713,167;30;M
6218;998,1443,1229,748,1268,796,1562,117,1713,92,769,795,167,1668,675;29;F
6232;1443,996,742,582,941,987,1450,891,1259,1120,40,1039,976,907,1501;42;M
6244;930,1259,950,1472,1197,1039,796,465,1440,1235,680,891,749,790,1120;37;M
6245;1219,1324,725,1229,742,1039,1450,891,155,680,40,1197,1259,1205,950;44;F
6262;680,996,607,795,145,207,771,1669,748,907,1235,1186,146,749,1205;40;F
6326;891,40,987,215,1259,516,1670,1120,996,976,1501,907;41;F
6337;167,1713;49;F
6339;907,1120;40;M
6345;941,1501,907,1639,92,1713,1670,465,796,1440,1669,795,516,1668,1197;29;M
6346;1120,796,680,146;41;F
6350;145,796,207,941,1212,976,516,1219,1670,255,907,1235,1501,891,930;34;M
6402;1670,748,516,1449,742,1205;35;F
6419;891,796,996,1120,976,987,1209,1669,92,1668,907,1440,1639,930,675;39;F
6440;796,1268,749,40,680;57;M
6443;996,1501,742,680,1212,1668,1450,1197,907,207,941,891,1259,1120,1039;41;M
6451;92,1670,1713,796,465,1669,907,1235,1449,996,680,891,749,1120,104;37;F
6455;1229,748,1668,996,1449,907,207,1440,92,465,796,1450,1212,1259,1120;40;M
6474;796,1501,749,1120,40,976,907,145,1440,1268,117,1669,92,1668,1197;29;F
6487;1668,891,742,1443,255,607,207,92,1324,465,748,1449,1186,1205,790;41;F
6497;145,465,1209,207,1639,742,146,1259,675,1120,215;45;F
6572;795,92,207,680,891,1212,976,1268,607,255,456,907,1450,1120,1259;38;F
6617;516,976,215,891,796,1209,1669,1120,146;37;M
6624;1639,1219,146,1039;34;F
6635;987,146,1450,976,796,1268,769,207,748,795,1229,1235,167,1212,675;44;M
6647;167,996,680,1233,749,1259,1120,40,1197,795,516,1450,976,1670,1440;52;M
6663;1669,1268,1440,207,1668,680,675,104,1209,255,456,1449,1219,1186,930;24;F
6668;255,582,680,987,1450,675,1120,215;40;F
6672;1562,1713,769,795,607,255,167,1219,998,987,950,1197,1039,215;44;F
6677;996,1219,1501,941,891,1450,1233,749,1259,1472,215,465,1669,1668,680;49;F
6679;795,117,465,907,1449,680,749,891,1212,790,1472,1120,40,976,215;48;M
6684;1668,1212,1259,675,40,215,1209,1669,92,1440,907,516,1120,1197,976;32;F
6722;1229,1449,146,1259,215,1219,1233,930,675,1120;32;M
6729;1324,1209,725,1440,207,516,1449,996,680,987,930,675,1120,1039,215;14;M
6734;516,1449,996,1668,582,941,1450,891,749,930,1259,1120,40,1197,215;19;F
6736;1229;32;F
6759;748,1501,996,1039,465,907,1449,891,1212,749,1259,1472,790,1120,40;77;M
6801;1039,104,907,748,145,1440,1268,92,1669,1209,215,725,1229,1219,1233;41;F
6804;1197,1039,215,1501,1219,1449,907,748,207,92,725,1443,996,742,1120;39;F
6818;1472,976,145,207,255,1639,516,1668,987;36;F
6838;207,92,1436,1209,725,1440,255,1233,930,675;26;F
6840;907,1443,1449,996,680,891,1212,749,930,675,1120,40,1039,976,104;43;M
6847;907,996,680,941,1450,891,1212,1259,976,215;51;F
6861;255,1639,907,516,1668,1120,40,465,725,1212,1197,1219,941,146,1039;60;F
6864;790,1639,92,796,749,996,1668,941,1450,1259,1120,907,795,891,40;46;M
6872;1143,725,796,1713,92,607,255,155,941,1212,950,1472,1120,976,215;36;M
6877;725,998,582,749,1259,1120,1669,987,155,40,976,1668,742,680,950;46;F
6895;907,996,680,941,1450,891,1212,1259,1120,976,215;19;M
6907;907,1639,207,1440,92,1449,1668,680,891,749,950,790,1120;35;F
6936;907,996,680,941,1450,891,1212,1259,1120,976,215;21;F
6941;1324;46;M
6944;1562,1669,117,1268,769,907,1120,40,92,795,1501,1668,987,976,215;69;F
6977;907,996,891,749,1259,790,1120,1039,215,104;53;F
6999;1501,742,1259,1039,950,749,146,1668,1219,155,1443,795,145,771,725;46;F
7000;1639,1501,582,941,891,749,1209,907,996,1219,1668,1450,1259,675,1120;53;M
7002;941,1324;39;F
7046;1219,1212,146,1233,1229;38;M
7064;1669,92,795,1443,1668,742,950;47;F
7070;1229;37;F
7094;1440,891,1233,146,930,1259;33;M
7163;117,40,1472,725,1324,1229,1219,215;29;M
7171;996,742,146,675,930,1039,907,92,207,1197,749,748,456,680,255;33;F
7180;796,976,1120,1259,891,1450,680,742,1668,1229;64;M
7205;1324;48;F
7222;950,749,607,795,748,1440,1268,1713,465,796,117,155,40,104,215;68;F
7225;1440,145,207,255,1219,675,790,1209,465,1713,1229,996,1134,1233;35;F
7228;1268,907,1235,1443,996,790,1197,1212,1713,795,1668,891,749,1472,1120;16;M
7244;796,1209,607,155,996,1219,1212,675,1120,1440,680;35;M
7251;987,1212,215,1120,891,582,1668,996,907,1268,92,117,1669,1562,796;69;F
7289;1209,1436,207,456,155,1186,1450,930,1120;27;F
7298;582,941,1450,1259,155,976,675,891,680,907,255,607,771,1440,1209;28;F
7308;1324,456,796,795,1235,155,1219,941,987,1164,1212,749,1039,976,215;27;M
7315;796,117,1436,1668,1212,40,976,795,607,675,1669,92,987,1039;41;F
7320;1259,891,996,1443,907,207,1450,146,950,1120,215,1324;42;M
7327;796,795,907,1219,1501,1668,987,215,1209,92,996,675,1120,1197,976;43;F
7341;1120,1197,976,1039,1449,1443,1235,907,795,796,1440,680,950;39;F
7346;465,117,1268;33;M
7364;1668,941,1450,1669,1440,907,516,680,891,930,1259,790,1120,40,1039;30;M
7385;92,207,1449,1219,1120,891,1164,749,950,675;48;M
7394;155,582,987,146,749,1259,1120,40,1197,976,1440,255,1668,680,1212;38;F
7413;516,582,1212,1259,675,1120;28;M
7418;1669,145,207,255,456,907,516,1443,742,941,1450,146,930,1259,675;34;F
7429;1440,996,950,1450,1039;49;F
7456;215,1440,155,996,1668,998,40,1120,950,680,907,92,1669,796,607;52;F
7472;1229;40;F
7489;1440,92,1324,1449,996,582,1164,1212,207,1229,1186,146,1233,1259,1120;38;F
7501;1229;39;F
7520;516;33;F
7548;675,1668,582,1501,155,907,1449,996,891,146,749,1205,1120,1197,104;34;F
7593;976,996;47;F
7595;607,907,769,1562,1713,1268,1440,680,987,950,675,1120,40,976,215;31;M
7602;998,40,749,976,1120,1668,92,1268,1562,725,796,987,215;27;M
7609;155,1443,607,1669,796,117,1436,1440,748,795,1449,1668,680,1212,40;50;F
7632;725,117,1440,1229;41;F
7637;516;25;F
7663;796,207,1440,1268,1562,1186,680,1212,795,255,1164,950,215,1713,167;53;F
7672;255,456,996,582,987,1205,790,104,92,607,1668,680,891,749,1120;47;F
7679;1229;40;F
7685;680,795,796,167,1713,891,1120;52;M
7692;1713,1669,1562,92,1268,145,795,255,516,1443,996,1219,146,749,1259;40;F
7708;1197,987,941,1668,92,907,516,996,1450,1212,1259,1120;38;F
7712;796,1436,996,891,1450,749,1259,1120,40,1197,930,680;28;F
7714;748,215,790,891,996,1235,1440,796,1120,1197,749,1668,907,207,1449;71;F
7728;207,255,1472;16;F
7738;155,607,1229,907,1449,1186,891,465,1669,1324,92,1668,950,1120,1197;47;F
7744;1668,155,1443,907,456,607,725,117,771,795,516,996,1259,950,1120;31;F
7772;1229;38;F
7778;796,1440,950,675,1120;35;M
7780;796,1436,1440,748,996,680,891,1212,1233,749;43;F
7796;1197,1212,1450,582,167,516,1268,117,465,725,996;33;M
7806;1212,215,1436,1440,1639,907,516,680,941,1450,891,1259,1120,976,1670;37;M
7808;1713,907,1501,680,941,891,1472,516;30;M
7810;907,1501,1668,1212,40,1669,1268,607,155,996,1450,1259,950,1120,1197;35;F
7811;516;30;M
7821;1134,1668,680,891,146,749,1205,1120,976,104,796,1562,1669,1713,748;32;F
7849;1259,675,1120,976;36;M
7859;255,725,1039;46;F
7881;930,1120,675,987,215,976,907,255,516;30;M
7900;1668,1120,950;44;F
7903;1229,582,680,941,891,1120,976,215,1670,725,1219,1450,950,675,1039;44;F
7911;1713,167,996,1212,796,155,742,987,215,1039,207,255;19;F
7916;907,516,680;34;F
7918;207,742,146,675,1039;37;F
7921;1501,1443,207,145,1324,1562,92,1268,769,795,907,930,1120,1039,215;43;F
7929;1669,1268,207,255,1639,907,516,1443,1668,976;23;F
7948;796,891,1669,92,907,996,1668,680,1259,1120,40,976,1450,1212,749;39;F
7983;1501,680,941,1450,891,1212,749,1120,40,976,215,1259,907,1639,516;32;F
7994;465,796,1268,255,680,1233,1259,1197,1039,215,725,1440,1668,941,1212;38;F
8008;145,748,607,1229,907,1449,996,1668,742,891,1212,146,749,1120,104;36;F
8017;1443,92,465,907,1449,996,1501,680,941,1450,891,1212,749,1259,1120;51;F
8060;1501,680,891,1120,255,996,146,1259,1039,976,1209,145,155,675,1197;41;F
8064;907,998,1450,1212,1449,996,1668,749,1259,976,1120;27;F
8065;516;28;M
8111;516,465,1268,907,998,891,790;23;F
8131;907,1668,680,987,796,1669,92,1143,996,1450,891,1164,215,1259,1120;62;F
8171;1229,1219,1450,1259,1039;64;F
8177;1268,516,1259,976,215;43;M
8178;796,1713,1440,996,1164,1259,1120,215;31;F
8184;1233,795,1501,1229;50;M
8185;465,104,92,1268,795,1143,1219,941,1186,1450,930,215,725,516,1259;35;F
8194;1670,907,976,950,1205,1450,742,996,769,92,1562,796,1259,1120,1039;35;M
8208;104,1259,749,891,1450,1186,996,907,1669,675,790,1120;34;M
8229;1449,907,1229,117,1235,1443,996,680,749,790,1120,40,1197,465,1324;41;M
8240;1039,976,104,215,92,145,607,456,907,1443,996,1501,582,1450,1120;43;F
8241;1713,167;25;M
8249;516,255,680,146,930,1120,215;40;F
8257;796,771,145,950,1120,1039,215;40;F
8258;1450,146,675,1120,117,456,516,582,1259;34;F
8259;215,796,456,1235,582,680,891,675,1268,1449,996,987,1212,790,1120;64;F
8277;117,1562,1219,680,930,976,215;38;F
8308;456;36;M
8349;92,607,1235,1134,1668,680,930,1205,675,1197,40,104,790,1186;46;M
8355;907,1668,891,1212,796,1120;51;F
8379;1229;45;F
8385;145,607,255,907,1235,155,680,146,790,1120,104;34;F
8398;1562,1324,1713,769,795,155,1668,998,950,1120,40,1039;43;F
8407;145,748,607,1229,146,1233,749,1205;34;F
8409;1219,907,996,987,891,146,1039,725,941,1450,1233,1212,950,1120,1197;18;M
8445;1209,1670,907,1219,1134,146,1450,1259,1120,1197,215,92,207,987,675;67;F
8452;465,255,680,891,790,976,796,207,748,1235,1449,996,749,1120,215;34;M
8454;941,1450,1259,1120,976,1501,680,1219,1235,1639,1268,1436,1669,891,215;36;F
8483;92,207,907,582,675,1229;38;F
8491;1143,996,1134,1186,1164,1205,790;67;F
8495;796,465,1235,1668,680,1450,891,749,930,790,1120,40,1197,215;37;F
8498;742,155,1449,1443,1143,907,456,255,607,207,1229;51;F
8501;607,1669,796,92,748,795,907,1449,1501,1668,1186,1212,749,1205,1120;53;F
8502;907,1120,1197,1039,976,215,1668,1219,155,516,1440,1268,92,1670,1669;32;M
8503;1235,680,987,146,675,40,976,215;51;F
8518;1436,145,255,1143,1450,146,1259,516;30;F
8576;1436,145,207,255,456,1143,516,155,1186,742,1450,146,1259,1197;1;F
8579;1120,796,1562,1440,748,795,1235,742,680,1450,891,1212,749,930,215;32;M
8582;516;46;M
8616;215,790,1501,92,465,1324,796,1440,907,1449,1668,891,749,1259,1120;32;M
8634;1229;56;F
8639;1670,748,941,1450,1212,1259,976,516;41;F
8667;1669,796,725,1562,1209,1268,941,987,891,146,1259,1120,976,215,516;32;M
8668;795,996,742,680,891,1212,146,930,1120,976,1268,941,1450,1259,1039;43;F
8696;1449,907,1229,1639,607,145,748,255,1235,680,1233,749,1472,976,215;30;F
8702;725,1233,1259;42;F
8716;516;31;M
8725;1440,769,795,255,1229,907,1443,1449,996,1668,891,749,1120,1039,976;59;F
8745;996,1501,749,1120,976,215,796,1209,207,795,680,1450,930,1259,675;48;F
8766;796,725,1440,941,987,1450,891,1164,146,749,1039,215;42;M
8772;207,1229,167,1668,742,1450,749,1472,40,1039,104,215,465,941,1219;26;M
8773;167;37;M
8808;1235,1449,891,790;33;M
8820;907,996,680,941,1450,891,1212,1259,1120,976;53;M
8852;1669,465,207,748,1449,996,1668,891,1164,146,1233,749,1205,790,1120;34;F
8860;769,465,796,1562,255,907,1219,1450,891,207,996,749,1259,1120,1472;32;F
8865;1713,207,255,167,1212,146,930,675,1197;58;F
8909;215,1039,1197,1472,749,1233,146,1229,207,145,465,1235,1449;31;F
8931;998,680,941,891,1233,749,1472,790,40,725,1670,795,516,167,976;38;M
8943;675,1259,1229,1450,1212,1197,1120,1233,146,1668,996,907,92,1669,255;36;F
8965;207,795,907,516,996,1501,680,1450,891,749,1259,675,1120,976,215;46;M
8971;1229;49;F
8974;1562,167;37;F
9038;1562,1713,92,771,145,795,456,155,146,950,675,1039,167;35;F
9055;207,255,907,516,1501,582,680,1450,891,749,1259,675,1120,976,215;13;F
9062;1501,1449,1120,996,891,742,907,145,1268,92,117,465,796,1039,1219;36;M
9063;976;61;F
9068;1235,907,1639,255,207,1440,92,1713,1669,465,1209,796,930,790,582;13;M
9087;1229;41;F
9108;1562,117,1440,795,907,516,1197,930,1450,1219,996,1259,950,675,1120;36;M
9127;516,1120;37;F
9143;1449,1235,1229,1450,891,146,1233,1259,1120,1039;39;F
9152;1229,516;56;F
9169;748,607,1443,1449,155,796,1212,1120,891,207,749,790,996,907,1235;35;F
9178;950;40;F
9204;1205,40,215,796,117,1713,1268,1440,907,1443,996,987,1259,976,516;27;M
9206;1668,582,987,1212,930,675,1197,796,1713,1440,950,1120,40,976,215;43;F
9212;1259,1472,790,976,215,796,465,117,1268,1449,996,941,891,1233,1120;25;M
9226;1450,891,1212,1562,1259,40,1219,996,795,1440,1268,92,117,680,215;27;M
9230;749,987,680,582,1668,155,1443,1639,1440,1268,92,1670,1669,1259,1450;37;F
9232;1449;41;F
9242;92,1440,771,145,795,255,456,1143,996,1668,987,146,1039;37;F
9248;1449,1259,1450,891,987,996,796,795,680,1212,1233,749,215,40,1472;32;M
9264;675,1669,907,930,1120,465,1440,207,255,1668,582,891,1212,749,1472;17;F
9283;1259,907,607,1713,1562,1440,769,996,680,987,749,950,40,1120;43;F
9293;117,1450,891,749,1259,1472,215;32;M
9298;987,675,976;33;M
9315;941,1450,1164,146,749,1259,1120,1039,1669,1501,1668,987,675,1197,976;35;F
9320;680,1219,907,1440,1268,465,1443,1449,996,1668,749,930,40;30;F
9330;1668,998,680,930,40,1039,1268,1440,907,215,987,891,675,1120,976;32;F
9345;1212;26;M
9351;1233,749,1449;25;M
9378;255,907,516,996,1501,742,987,40,1450,1212,146,1259,675,1120,1039;37;F
9379;1436,465,725,796,1120,1259,749,1212,891,1450,1668,748,92,1669,1209;36;M
9387;516,1443,680,941,1212,749,950,40,1259,996,155,1449,907,607,1268;35;F
9390;1197,907,1501,742,1212,1259,1120,146,1450,1668,1219,996,92,1669,725;34;F
9393;742,1212,795,769,771,1669,117,92,1229,907,1219,582,675,1120,104;32;M
9410;1669,92,795,607,1501,1668,1212,146,749,950,1120;38;F
9424;796,1209,92,795,607,907,155,1668,749,950,1120,40,976,104,215;29;F
9426;465,456,1186,1120;39;F
9428;796,465,1324,907,1449,996,680,891,1212,749,1120,1039;38;M
9445;1324,1668,742,1450,1197,1440,907,996,680,987,749,950,1120,1039,215;40;F
9454;207,907,1235,1212,215,1449;41;F
9519;907,167,1120;48;M
9526;725,117,92,930,40,1668;23;F
9552;1205,950,1259,930,907,465,1209,145,207,255,516,155,742,146,675;37;M
9554;1212,891,796,607,1450,749,976,1120,1668,92;27;F
9571;769,167,998,675;59;F
9582;1212,1668,1449,92,796,1440,145,1669,907,516,1450,1259,1120,1039,976;42;F
9605;1229;36;F
9606;976,769,117,516,1501,796,1450,1440,155,907,680,749,1120,1197,215;35;M
9608;1209,1120,1450,796,207,255,907,996,1501,941,749,930,1259,40,215;7;M
9613;680,998,1443,1235,795,117,465,1562,796,1440,769,1449,748;31;F
9643;891;46;F
9655;1120,675,1259,930,749,146,1450,1219,996,1268,92,1436,1670,40,976;37;M
9660;92,1440,795,907,1443,996,680,941,1450,891,1212,1233,749,1259,1120;41;M
9692;1229;35;M
9697;891,675,1120,976,215,516,1668,987,1450,1259;41;F
9713;92,1713,796,1562,1669,1268,145,795,907,1443,996,1668,1120,1039,104;44;F
9721;1143,996,1668,742,582,680,987,1164,1205,1039,1120,145,255,146,930;39;F
9770;680,950,1713,92,1440,795,607,1443,155,987,675,1120,40,1197,1039;50;F
9788;1713,92,167,1668,987,1259,675,1120,215;34;F
9806;1440,1713,1562,207,1443,1668,987,146,930,950,675,1120,40,1039,1324;41;F
9818;1669,607,155,930,1197,104,1562,1668,987,92,207,742,146,950,1039;38;F
9840;769,1436,1209,465,1268,1219,680,1233,675,1472,790,40,1197,1039,104;27;F
9844;976,675,930,987,1229,607,207,1449,1219,582,941,1233,1259,1039,104;35;F
9884;215,1039,1669,1713,207,907,1668,1186,950,104;28;F
9898;1259,907,207,1440,1209,255,456,675,1120,1197;27;F
9902;117,1669,1562,465,1268,1440,1219,582,987,930,950,675,790,976,215;57;F
9907;207,1449,582,891,1212,1120;33;F
9923;796,1039,976,215,1209,92,207,907,996,1668,680,1450,749,1259,1120;9;F
9933;1450,1449,796,1562,465,1235,680,987,1212,1233,749,1120,976,215;32;M
9957;1229;7;F
9959;796,1713,167,930,790,1039;23;M
9963;1501,1668,582,941,1450,891,1212,1233,749,907,987,1259,675,1120,976;45;F
9982;155,1450,976,1669,92,907,207,996,1668,582,941,1259,1120,1197,1039;46;F
9999;1219,155,1449,1443,1235,1639,207,1440,1670,117,1324,1668,1205,675,1039;42;F
10000;146,950,748,255,456,155,1219,1501,680,749,930,675,1039,1229,1233;34;F
10030;465,1443,996,790;38;M
10039;1233,675,742,987,1120,215,796,1562,1209,1713,998,680,930,950,1039;44;M
10043;907,1229,255,607,207,145,1440,1268,1670,1324,465,516,742,1259,976;34;F
10051;796,1669,117,1440,207,987,146,675,1120,40,1039,215,145,769,1324;8;F
10056;725,1668,1197,1212,976,215,796,255,941,987,1233,930,1259,1229,1039;45;F
10059;1450,1212,930,1472,1120,1197,742,1186,1134,1219,607,92,1713,1669,1233;35;F
10065;516;31;F
10071;1233;44;F
10106;796,1268,207,748,795,1235,996,987,1450,891,749,976;44;F
10113;1233,1229;9;M
10114;607,891,146,790,1039,748,1669,976,215,1668,1120;40;M
10124;796,465,92,1268,907,996,1501,941,1450,891,1259,1120;43;M
10126;465,516,987;45;F
10145;255,1268,1670,796,465,748,1449,1450,891,1233,1259,1472,1120,976,215;61;F
10205;516,155,1219,1259,1120,40,1197,976,215,796,1440,748,680,749,1212;43;F
10206;796,769,748,607,1235,1449,582,891,790;38;F
10214;1134,1668,146,465,117,207,748,1449,1186,742,891,1205,1472,790,104;59;F
10223;725,155,996,1668,987,891,146,1259,790,1120,976;34;F
10225;725,1324,1229;50;M
10231;987,996,795,1209,145,680,146,930,1039,976,771,207,907,675,1501;45;M
10246;145,255,907,516,1219,1212,146,749,1120,40,1197,976,215;36;M
10256;92,207,1212,1120,215;27;M
10272;104,155,1268,1436,796,1669,92,795,907,996,1668,891,749,790,1120;39;M
10276;796,1562,465,117,1436,1268,1639,1235,167,516;66;F
10292;1668,996,167,155,1449,907,255,1209,1440,207,607,1235,1219,680,950;53;F
10320;1229;45;F
10334;795,255,907,1449,155,996,742,680,891,749,930,790,1120,1039,976;35;M
10340;1501,1197,907,1639,255,207,1562,941,987,1450,1259,1120,40,976,516;30;F
10382;104,207,255,1143,516,155,930;31;F
10383;1669,92,771,795,907,1449,155,996,1501,1668,749,950,1120,40,215;46;F
10429;675,1120,976,930;37;M
10431;976,987,1212,40,215,796,465,1669,1713,795,1668,891,749,790,1120;37;F
10433;1233,1268,1449,796,1440,1235,907,680,891,1450,1212,749,1259,1120,215;26;M
10438;1713,1443,996,1120,1450,215,907,1219,941,891,1212,1259;45;M
10470;1440,771,145,748,255,907,1449,996,1219,582,891;43;F
10500;796,1209,207,748,255,907,1449,1668,582,891,146,930,675;30;F
10516;987,1450,1233,976,215,1562,1229,582,680,891,749,930,1259,1120,1039;43;F
10563;680,1268,1562,725,215,92,607,516,987,891,1259,1120,40,1197,976;35;M
10597;1450,1212,1259,1120,215,796,465,1436,907,1440,891,680,941,987,976;37;M
10602;1209,796,725,1669,1436,1440,145,456,907,516,930,1120,1197,976,215;32;M
10616;680,582,795,1669,796,1670,92,907,996,1668,1450,1212,1259,675,1120;30;F
10622;1713,1669,796,1562,1324,117,207,795,255,1143,167,1668,891,146,1120;37;M
10623;1713,1268,207,795,907,1443,1449,996,680,215;38;F
10628;680;36;F
10629;1219,987,215;45;M
10630;796,725,1669,92,907,996,1668,582,941,1450,891,1259,1120;24;F
10657;1209,1670,996,155,1501,1668,976,215,795,1219,891,1259,1197,1440,516;33;M
10699;207,1235,996,465,1209,796,1449,680,987,891,749,1472,790,215,675;35;M
10710;1209,748,795,607,255,987,1233,675,1039,215,1229;46;F
10734;1501,1219,1449,1443,516,1670,725,465,907,996,891,1212,1233,1259,1120;23;F
10737;155,1229,607,795,207,1440,1268,92,1670,117,1669,465,796,1668,1219;7;F
10742;1229,207,796,891,749,465,748,1449,790;36;F
10819;104,215,117,1209,1562,796,930,1205,976,465,155,1259,950,675,1120;15;F
10844;92,1440,907,996,1501,1668,582,1450,1212,796,1669,680,1259,1120,215;50;F
10848;207;40;M
10878;607,790,996,1443,465;38;F
10894;1120,891,1443,516,907,255,207,145,1670,996,1668,742,1450,1039;25;F
10904;1713,1209,465,1669,771,748,456,1449,1134,1668,582,749,790,930,675;34;F
10944;1209,146,930,1472,1120,40,1039,1639,1440,92,907,680,987,976,215;25;F
10950;607,1668,987,1212,1197,1443,104;71;F
10984;996,675,1120,215,976,40,1259,891,941,1668,1443,516,795,771,146;41;F
11003;1449,155,146,930,1205,675,1120,796,1324;34;F
11004;215,742,1443,680,1713,1440,907,996,891,1450,1259,950,1120,1039;45;F
11019;1143,582,1205,1120,1039,1562,796,255,1449,891,1233,742,725,207,1229;43;F
11022;1209,796,465,207,255,1449,1186,998,891,1233,930,1205,1472,1120,104;27;F
11029;1669,92,907,1449,996,891,1205,1120,104;49;F
11053;1449,996,891,1233,1120,40,1440,117,465,796,92,795,1668,680,749;31;F
11065;1562,1209,1669,907,996,1668,1186,1205,1120,215,749;26;M
11067;987,996,941,1259,1120,1039,255,1668;31;M
11075;891,1443,207,145,1440,796,465,795,607,1235,1449,155,680,749,790;40;F
11084;207,516,1450,104;35;F
11089;748,891,790,465,1449;41;M
11095;582,117,725,796,1669,92,907,516,1501,1668,891,1212,1259,1120,1197;38;F
11106;117,1713,1668,987,1212,749,950,675,1120,40;32;M
11119;516,680,950,675,1039,796,1562,1209,117,1268,1440,769,1212,907,167;29;F
11134;1670,796,1268,1713,117,465,1669,582,891,1205,790,1197,1120,607,1186;56;F
11135;145,1436,1669,92,155,907,996,1501,582,941,891,146,749,1259,1120;26;F
11136;675,1120,769,1562,1670,1713,795,1639,167,996,1668,1450,1259,950,976;30;M
11154;1212,1197,725,796,1669,92,795,1668;47;M
11181;725,987,1450,1120,1039;39;F
11189;607,40,1233,1450,941,680,1501,1449,796,907,1197,215;34;F
11195;40,976,215,1669,1268,795,516,1668,582,987,1212;40;F
11203;1669,117,92,1440,1668,516;35;M
11206;1562,725,796,1440,907,1449,155,1668,680,941,1233,1259,1120,40,976;46;F
11233;1268,1440,607,907,1449,996,1501,1668,680,749,1259,950,1120,1039,976;44;F
11237;516,996,1436,1268,907,1449,1259,1440,1450,891,1212,675,1120,976,215;28;M
11258;976,465,1669,1713,92,907,1449,891,796,1668,680,749,1472,790,1120;47;F
11259;40,1197,1039,1443,1449,941,1450,987,1120,725;40;F
11271;1268,996,1668,582,680,987,1450,891,1120,40,1197,1669,941,215,976;32;F
11281;796,907,1449,996,582,941,1450,891,1212,1669,92,1501,1668,1120,1197;24;F
11296;117,1440,748,255,456,1450,1259,675,1120,1197,769,771,1713,207,891;34;M
11297;771,155,907,145,92,1668,146,1450,987,1212,749,950,40,976,680;38;M
11301;1669,92,795,907,996,1501,1668,941,1450,891,1212,749,1259,1120,1197;46;F
11322;796,1669,1713,92,1268,907,1668;28;F
11340;998,950,1039;40;M
11358;1209,92,1440,907,996,1219,1668,742,941,1450,891,146,1259,1120,1039;39;F
11392;1449,907,607,145,207,255,1229,742,582,941,146,1205,675,1120,1039;31;F
11409;891;39;F
11477;998,1668,255,1562,1209,769,796,1670,1268,1440,680,950,675,976,215;47;F
11533;104,155,907,456,145,92,1501,987,146,1259,675,1472,1120,1197,976;83;F
11534;680,891,749,1186,790,1039,1668,1235,1440,1268,796,465;30;F
11537;1501,742,1212,1259,1472,675,907,92,155,987,1120,146,1197,976,215;58;F
11543;1436,92,207,255,907,996,1501,1450,891,1212,1259,675,1120,40,976;22;F
11544;92,1268,907,996,1212,1120,796,1562,465,1669,117,1440,769,1668,215;46;M
11563;1229,1443,1449,146,215;40;M
11571;465,1209,796,1669,748,907,1443,1449,996,1668,1186,582,891,749,1120;46;F
11574;207,907,1443;36;F
11585;796,465,1268,1219,1639,907,987,1450,1039,976,680,891,1259,1120,215;59;M
11605;907,607,1440,117,796,465,92,1268,1443,1449,1501,891,1120,795,1668;39;M
11643;795,987,749,796,1669,1713,92,1235,1449,167,1219,1668,680,891,1120;42;M
11725;465,145,255,1235,1219,680,1450,891,40,1197,215,941,1259,1120,1039;42;F
11729;1668,1450,891,749,1259,790,1120,40,976;38;M
11740;1229;50;F
11773;725,1209,207,1229;42;F
11789;207,255,987,950,675,1039;37;F
11801;215;28;M
11836;1229;41;M
11877;1197,1669,92,255,907,516,1501,1668,987,891,215,996,675,1120,976;29;F
11893;771,796,1039,976,117,1713,92,795,255,456,1668,891,930,790,215;37;F
11923;1229,1120,1205,146,465,255,582,950,1669,207,748,1235,1449,749,790;48;M
11926;516,1443,582,680,987,1450,930,1259,1120,976,215,1324,92,1268,1440;51;M
11938;1669,516,907,92,1668,582,680,941,987,1450,891,1259,675,1120,976;32;F
11966;907,1219,1120,1440,795,255,516,930;33;F
11968;92,1669,1562,769,145,795,155,996,1668,742,987,146,1120,40,1039;37;F
11981;207,748,795,1449,146,1233,1229;38;F
11983;795,1235,1219,680,941,1450,891,1212,146,749,1259,675,40,1120,1039;44;M
12001;771,1669,796,465,1713,92,748,795,582,680,987,749,1197,976,104;48;F
12019;930,1259,675,1472,790,1120,796,465,117,1268,1440,1449,891,1212,1233;28;M
12022;516;49;M
12100;1668,950,796,607,907,1449,155,996,582,680,146,1233,749,930,1120;40;F
12107;1229;54;F
12138;465,1670,1268,1440,907,516,1450,1212,1259,675,1120,976;43;F
12149;146,930,749,215,40,1120,675,987,996,1449,796,725,1186,941,976;34;F
12163;1229;35;M
12171;1324,996,1501,582,1450,891,1259,1120,207,255,907,516;48;F
12173;1268,748,1219,987,40,1449,996,1229,1440,207,891,749,1205,790,104;43;F
12183;891,976,1440,516;32;M
12220;92,145,1229,215;41;F
12225;891,749,675,117,795,1440,1268,1713,1209,1562,796,1212,950,40,1039;49;F
12285;742,1639,465,1669,748,907,680,1450,891,1212,749,790,1120;34;M
12299;795,207,796,117;40;F
12313;987,1120,769,1268,996,1219,680,891,749,1562,675,1472,40,976,215;30;F
12320;1197,1259,891,1450,1501,1219,155,907,1669,796,92,1449,1668,749,1120;44;F
12332;1713,516,1443,996,1501,582,215,987,941,1450,891,1212,1259,675,1120;15;M
12348;891,1259,1120;23;F
12382;92,1259,1440,941,1039;45;M
12393;907,456,516,1209,725,1440,145,255,1443,742,680,146,1259,1120,1039;39;F
12413;1039,1449,1143,1639,92,1670,1324,1669,1440,907,1668,146,1259,1120,215;37;F
12454;465,207,607,255,456,1449,742,680,987,891,146,950,675,790,1039;33;F
12467;748,607,1235,1443,1039;34;M
12528;680,1440,796,1501,1450,749,996,1259,1120,215,976,907,891,1670,516;33;M
12537;749,891,680,582,1501,92,1669,796,1562,1713,795,996,1668,1120,976;25;M
12553;145,607,155,1186,146,950,1205;44;F
12566;1562,1669,92,1440,1443,996,146,1668,987,1450,749,1120,1197,976,215;43;M
12569;996,582,742,680,1472,790,1120,1039,976,215,1268,950,1205,465,607;1;M
12618;465,796,1449,1219,680,987,749,1205,675,790,1120,40,1039,104,215;11;M
12623;796,1268,769,795,1120,1039,215;35;M
12691;987,1219,930,1229;33;M
12699;1562,1440,748,1235,155,680,1197;37;F
12703;207,1235,1449,996,680,987,749,675,1205,790,1120,40,1039,976,104;13;M
12768;1229;45;M
12783;796,996,941,1450,1259,1120,155;38;F
12812;1449,92,1436,207,748,795,907,996,1450,1233,1259,675,1120,1039,1229;47;F
12927;582,987,891,1450,1212,749,1120,40,976,215,748,795,1668,680,1259;44;F
12933;1120,146,987,1668,1186,1449,255,145,92,725,907,1205,748,749,104;35;M
12947;1259,950,891,1450,987,941,742,1668,516,907,1229,1268,92,795,255;48;F
12968;215,104,145,748,795,607,1443,1449,930,1205;36;M
12979;582,1668,1134,155,930;20;F
12986;207,465,930,1259,1039,1229;48;M
12999;1268,456,907,1639,1450,891,1212,1259,1120,976;32;F
13015;680,1212,1449,795,465,1235,1668,891,976,215,749,1472,1120,40;35;M
13037;1212,796,749,1501,1440,1259,1669,907,1668,941,1450,891,1120,976,215;30;M
13045;998,987,146,675,1120,40,1197,1039,1562,1669,1324,92,1668,950;44;F
13047;255,795,117,796,92,771,996,1668,749,675,1120,1197;33;F
13049;1235,941,1450,1197,796,465,1669,92,996,1449,680,987,891,1120,215;38;M
13085;1229,456,907,1443,1449,155,996,1501,1668,742,1450,891,516,1120,976;34;F
13101;145,207,680,146,950,1205,1039;39;F
13114;1449,996,1501,1668,1186,582,941,1450,891,749,1259,950,675,40,1120;30;F
13121;1197,1120,790,680,582,742,1443,1449,907,1229,607,748,1324,796,1440;43;M
13123;255,207,1669,725,1229;32;F
13125;1229;41;F
13127;725,92,255,1668,146,1039,1229;49;F
13132;1209,465,996,680,117,92,1440,207,748,891,1212,146,930,1259,1229;45;M
13156;1039,40,1259,930,891,987,680,1440,465,748,1449,1219,749,790,1120;65;F
13178;930,675,465,207,1440,1039;43;F
13195;1229;43;F
13206;1229,1233,1120,1039,215;43;F
13210;1669,92,1039,1120,987,582,742,1668,456;36;F
13264;92,1501,1713,1639,1449,796,907,996,941,1450,891,749,1259,1120;41;F
13297;796,1639,1449,1219,891,1212,749,1259,790,1120,40,104;47;F
13317;1669,607,255,456,155,1501,1668,891,749,930,950,675,1120,40,104;25;F
13325;941,1120,796,1562,1235,1449,996,998,680,891,1212,749,1472,1039,976;32;M
13355;465,725,1268,207,1639,1449,582,680,987,749,1259,675,1120,976,215;58;F
13379;207,930,675,104,1219,516;37;M
13417;1219,40,215,987,146,675,976;30;F
13419;207,1229,215;34;F
13435;1713,1670,117,1669,465,725,796,1229,215,1120,675,930,987,941,907;46;F
13439;215,796,1209,1669,92,907,1668,680,930,675;24;F
13495;207,255,675,930;65;M
13517;1450,891,1212,1233,749,1259,796,92,1268,607,907,1120,996,1501,1668;38;F
13522;1268,769,907,996,891,1450,941,146,1233,1259,1120,1039;41;F
13531;145,207,607,1450,146,1259,950,675;31;F
13539;207,92,1670,1669,465,1562,1713,1268,769,907,167,582,950,40,104;65;F
13541;516,1501,1668,680,987,891,1472,907,996,1450,675,215,1259,1120,976;37;M
13545;1229;11;M
13568;456,1440,465,1233,1120,1229;47;F
13580;255,907,1143,742,891,796,1229,749,930,40,976,146,790;39;F
13586;1450,996,1449,907,516;30;F
13596;1440,907,1669,456,996,146,796,749,1197,1209,795,1668,1120,1039,950;39;F
13597;907,795,796,725,1562,1713,1268,1440,769,582,680,987,950,40,1039;36;F
13607;725,996,1233,1120,1039,930;39;M
13610;907,1219,1450,891,930,1259,1120,1039,207,941;44;F
13618;987,1450,891,1259,1120,976,516;30;M
13658;104,1449;34;F
13661;891,1268,1713,1562,117,748,907,1120,40;38;F
13678;1668,742,1450,1212,930,1120,976,215,1259,1436,1639,987,146,675,1039;25;F
13686;1219,607,255,1229;45;F
13687;907,516,1450,675,1669,92,1668,1259,1120,207,255,930;49;F
13688;1713,92,607,907,1212,749,950,1120,40;33;M
13739;996,1449,1268,1669,1562,796,465,1209,1713,207,891,749,930,675,790;29;F
13753;1449,1219,680,976,215,1562,1436,1268,769,795,167,998,987,749,1197;52;M
13756;987,582,1209;40;M
13758;92,207,1449;;F
13775;1268,1440,607,255,1639,907,1235,996,1219,582,987,1450,891,930,1259;32;M
13824;907,516,1501,1668,998,987,1212,796,92,1229,996,891,146,790,1120;35;F
13825;117,907,996,1668,680,749,40,1197,92,1440,795,607,987,976,215;44;F
13834;1197,907,675;20;F
13850;92,1440,1449,1501,1668,582,680,891,1212,1233,749,1259,1472,790,1120;43;F
13854;207,1449;2;M
13859;117,92,1268,795,1668,40,1039,215;51;M
13861;725,92,1259,930,1120,1039;34;M
13873;996,987,1450,1120,796,1669,92,1440,1668,680,749,1259,40,976,215;36;F
13874;1229;51;F
13877;1233,1229;45;M
13879;1209,207,748,255,1235,1449,1186,1164,146,790,1120,40,104,891,996;43;M
13913;796,465,1449,1501,1668,742,215,1120,1259,146,891,1450,987,996,907;31;M
13924;456,1120,930,1233,987,941,582,1449,255,117,207,907,996,1501,675;42;F
13930;1039;53;F
13977;1450,891,1039;19;F
13983;1443,796,465,92,748,996,680,891,1212,749,790,1120,40,104,215;44;F
14006;1440,891,790,1120,215,1562,465,1268,1639,516,167,680,987,1472,976;31;M
14062;1472,675,1233,1186,1219,582,1212,1205,145,207,255,146,930,1229,215;71;F
14125;40,92,1449,465,104;31;M
14168;1229;68;F
14175;891,215,748,607,790;57;F
14176;255,1449,950,1562,207,795,456,516,155,680,146,1205,675,1039,891;36;F
14191;1120,790,1259,891,1450,1668,1219,907,92,465,1209,796,1235,749,1449;24;M
14193;1209,987,1039,215,255,795,748,771,207,146;63;F
14195;155,1205,207,1186,92,255,465,1449,104;42;M
14202;40,950;41;F
14214;742,749,796,465,207,748,607,1449,155,891,146,950,790,1120,215;32;F
14217;1259,1669,117,1235,1120,40,1197,790,675,749,891,1668,1449,92,465;36;M
14225;1229;60;M
14248;1039,950,987,607,145,771,1143;20;M
14291;1209;50;F
14321;1039;54;F
14354;930,1562,796,255,950,1209,1713,742,167;38;M
14380;996,1668,941,1450,891,749,1259,1120,215,40,1562,1440,769,907,1268;43;M
14393;465,796,725,1209,1440,907,680,941,1450,891,1259,675,1120,1197,215;15;M
14420;145,207,255,1039;35;F
14427;1670,465,1229,749,987,155,146,1212,950,104,1219,1501,1668,92,680;31;F
14430;1324,92,1440,207,607,1229,155,1219,1668,742,680,987,950,1039;37;F
14431;1235,795,92,465,1449,891,1440,207,748,255,680,146,749,1205,1120;36;F
14435;1219,742,1259,725,1436,771,795,607,1501,1668,582,680,1212,1472,1120;30;F
14437;1324,155,950,1039;37;M
14445;456,155,1186,950,1197,92,1268,255,907,996,1219,930,1259,1120,771;32;M
14452;1229;38;M
14460;1501,891,1259,725,1440,907,516,1219,680,987,1450,1212,749,976,215;27;M
14476;1501,987,1120,1713,117,796,1562,1669,92,1268,769,795,1668,40,1197;33;F
14499;1229;43;F
14561;207,607,907,1449,155,1668,1186,891,146,749,1259,675,1472,790,1120;38;F
14563;1268,796,1562,1324,680,987,950,1039,215;44;M
14569;1668,1450,1120,1669,1259;43;F
14605;1713,1669,465,145,1229,456,1443,1449,996,1668,582,1233,930,1472,1120;25;F
14614;1209,1268,207,255,1443,998,930,976;51;F
14615;941,1450,891,1212,749,1120,1039,976,215,1259,1668,996,907,1669,725;25;F
14631;215,891,582,465,117,92,1219,996,1668,1259,1120,941,1450,1039,725;48;M
14633;1450,749,976,215,1669,207,1219,1668,1039;23;M
14663;1443,749,1120,1229,748,207,1440,680,891,1233,790,117,1324,465,996;45;M
14683;796,1562,1324,1268,1440,769,795,907,680,891,950,1120,40,1039,976;34;M
14698;795,1443,1668,742,146,950,675,790,1197,1039;30;F
14710;207,796,725,1669,92,1668,680,146,1259,1197,1120,40,1039;38;F
14774;1229;42;F
14775;1669,1436,215,1670,1440,255,1639,907,516,1450,146,1259,1120,1039,976;34;F
14784;796,1562,1670,1440,996,582,795,987,1324,1268,92,1120,117,215,1713;27;M
14862;987,1233,40,976,1562,1713,92,1268,769,795,167,998,1212,950,215;39;M
14864;1562,796,465,1324,117,1670,1713,771,795,1449,155,680,950,976,1039;32;F
14869;907,796,1449,996,1501,582,680,941,1450,891,1212,749,1259,1120,40;37;M
14889;891,1120,92,582,749,1449,1235;40;F
14922;891,749,1669,907,1449,996,1501,1668,1450,1212,930,1259,1120,976,215;65;F
14936;1186,1443,1143,907,255,145,1669,465,92,1440,207,748,1668,146,749;36;F
14960;725,255,907,167,1212,950,1120,215;67;F
14990;1229,1443,155,92,725;23;F
14992;907,1443,996,1668,891,1212,725,796,1436,1268,941,1450,1259,1120,976;30;M
14998;1197,516,145,1268,725,1209,207,255,456,582,146,930,675,1120,1039;48;F
15004;215;31;M
15024;215,725,1562,1639,1436,907,1235,465,516,1449,1668,680;34;F
15045;582;15;M
15054;582;11;F
15064;582,680,987,891,1212,146,1233,749,930,1205,675,1120,796,1039;33;M
15122;1229;9;M
15126;796,1713,1235,516,1233,749,40,1197,976,215,1501,907,1120,941,891;24;F
15139;1713,796,1235,987,891,749,996,1449,465,1233,1472,790,1120,104,215;43;F
15157;516,1562,1209,1436,207,795,255,1639,907,1164,215,1450,749,976;63;F
15160;215,1197,1501,907,255,145,207,987,891,675,976;33;F
15188;907,1235,582,941,1259,790,796,1449,996,1450,891,1212,1233,930,1120;27;M
15198;92,1639,996,1472,790,1120,40,796,607,1235,680,891,749;41;F
15200;987,1229;42;F
15213;1443,1449,582,1450,930,1259,1120,1268,145,207,748,255,742,146,1039;36;F
15218;891,930,1120,1669,465,1259,40,1668,680,146,749,675,104,796,167;35;M
15228;255,907,207,1440,1449,1443,1268,796,1668,998,146,749,950,675,1039;37;F
15265;907,795,207,465,92,748,255,1443,1449,1668,891,1205,790,1120,104;43;F
15289;1436,1268,1440,1639,907,516,996,680,941,987,1450,891,1259,1120,976;37;M
15290;769,92,1449,1219,675,1120,976,1259;36;M
15311;1229,255,145,1440,1324,1120,1669,92,607,155,1501,1668,146,950,1197;48;F
15337;516,1219,891,976,1209,1562,796,748,680,749,675,1120,40;48;M
15365;1639,941,1233,725,1209,1440,907,1668,891,215,1450,1259,1120,92,1229;41;F
15375;92,207,748,795,255,1443,1449,996,1668,891,1212,930,790,1120,104;43;M
15379;725,976,1209,1259,907,1639,941,1450,891,1233,1120,215,1449,92,1229;44;M
15404;1039;64;F
15407;1669,92,607,1639,1219,1668,1259;51;F
15411;145,1229,146,1233;34;F
15424;1449;13;F
15441;1669,92,207,748,907,1443,996,1501,1668,582,891,1212,790,1120,104;76;F
15447;1501,1668,941,1450,891,1212,1233,749,1259,950,1120;40;M
15452;215,1440,996;27;M
15481;1259,998,607,1670,950,516,155,725,92,146;59;M
15548;465,1209,1436,907,996,1259,1120,215,607,1443,941,987,891,930,675;43;M
15553;996,749,1197,796,607,907,1449,790,92,1668,1186,891,930,1120,104;53;F
15559;146,749,1259,796,1562,92,1268,748,795,891,1120,215,907,40,1039;37;F
15565;607,1186,1212,790;36;F
15594;582,146,40,1197,1039,1209,1440,771,255,950,155,1219,1186,675,104;43;F
15637;930,795,771,725,607,255,1449,941,987,749,1259,950,675,1120,40;21;M
15638;1219,950,207,1501,146,930,1039;38;F
15643;1186,1668,1501,1219,155,907,607,207,145,771,1440,92,725,1209,255;36;F
15644;1219,742,941,1450,146,1259,1120,976;41;M
15650;996,516,795,748,1268,1670,117,465,1562,796,92,749,1039,167,1713;48;M
15678;1209;30;M
15703;796,1669,1713,92,907,996,1501,1668,1450,891,749,1259,1120,40;55;F
15725;117,465,1209,796,976,1668,941,987,1450,891,1212,1233,749,1259,1120;54;M
15751;796,680,1120,1039;34;F
15759;1039;41;M
15762;1229,215,104,607,1440,976,1197,930,907,1501,987,891,675;39;F
15790;796,725,1669,1436,907,996,1668,680,941,1450,1212,930,1259,675,1120;30;M
15804;1229;48;F
15818;725,92,1443,1668,941,1039;36;F
15857;1324,950,1039;37;F
15860;465,796,1669,92,1440,748,907,996,582,680,891,1259,1120,1197,1039;40;F
15864;155,742,680,941,987,1450,891,146,749,1259,675,1120,1039,215,976;58;F
15873;1229;41;F
15886;675,1120,104,215,725,1324,1229,146,1233,1205,1197,1039,465,1440,907;36;F
15912;1449,796,1450,1259,790,215,40,1120,749,891,1668,1235,907,1669,92;42;F
15917;215,1259,582,996,907,795,117,1669,1562,950;22;M
15924;456;6;F
15931;1268,796,1562,1669,1713,92,769,795,1668,680,1233,950,1120,40,215;53;F
15938;1120,1197,976,796,1209,92,145,207,255,1668,742,987,146,40,1039;33;F
15951;907,1449,1668,1186,742,582,1450,891,146,930,1259,207,996,1219,1039;38;M
15964;1449,907,1669,1209,607,1219,1668,582,1450,1212,1233,749,950,675,1120;27;M
15965;1039;63;F
15987;516,155,996,1212,796,1669,117,92,1440,1235,1668,680,749,1120,40;40;F
16046;1259,1197,796,1443,465,92,907,1449,996,1668,582,941,1450,891,1120;39;F
16089;796,1268,1440,516,1219,941,1212,930,1120,215;28;M
16107;516,1209,1440,795,996,1219,987,1450,1259,675;31;F
16111;1449,1443,907,92,796,1669,941,1450,891,1233,1259,1120,1197,1039;35;F
16169;1212,675,1472,215,796,465,117,92,748,1449,996,1501,1668,749,790;33;M
16180;998,941,1450,891,1212,749,1259,1120,40,976,215,92,795,907,1668;27;F
16183;891,796,1669,1440,795,582,146,1668,930,1205,790,1120,92,1449,996;37;F
16195;1440,796,465,748,680,891,749,40;37;M
16206;748,1443,1212,1205,607,255,1143,104,1164,675,1120,155,1668,1186,582;51;M
16210;796,1209,725,1713,255,907,1443,749,675,1197,976,1669,92,167,1668;40;F
16211;117,1259,1450,104,215,1324,1670,1268,907,1229,1440,516,680,987,976;45;F
16221;582,941,1450,749,1259,1472,976,725,1209,1219,987,1212,675,1120,40;23;F
16225;167;46;M
16239;1443,1668,790,104,976,215,1450,796,1120,891,680,748,465,749,92;44;M
16242;675,891,749,1449,516,1713,771,207,1219,1668,998,680,950,1120,104;21;F
16298;1229,1186,1668,146,40;52;F
16308;1219,582,1562,1713,1120,987,675,1197,1209,771,207,795,255,950,456;25;F
16353;725,207,255,996,1219,582,146,930,1205,675,1120;31;F
16392;748,907,1449,1219,1134,1501,891,1212,146,749,1205,1472,790,1120,215;72;F
16451;456;35;F
16507;465,796,725,680,891,1197,790;45;M
16575;1229;39;M
16579;1259,1197,607,1440,1713,1669,950,749,891,1501,155,92,675,1120,976;43;F
16594;1449,907,1713,1669,465,725,796,996,1501,891,1212,1233,749,1259,1120;38;M
16602;996,907,795,1440,92,1669,1209,1450,891,749,1120,976,215,680,987;41;M
16619;796,725,1209,92,1268,1440,1639,907,516,996,1450,891,930,1259,1120;29;F
16655;725,1501,1668,1186,1450,891,1212,1259,790,1120,1197,795,1449,749,1472;35;F
16676;748,795,907,996,1668,1186,582,1450,930,1259,1120,40,1197,1039,215;40;M
16688;907,1450;31;M
16706;516;57;M
16707;1229;39;F
16733;40,1039,1120,1450,742,1501,1449,907,1268,1713,1209,976,987,675;31;F
16756;1229;30;M
16761;796,465,1440,748,907,996,680,987,891,1212,749,1120,40,215;38;M
16764;930,1259,1120,795,748,771,465,1562,1713,207,255,167,950,675,104;21;F
16782;748,1440,117,725,796,1669,92,607,516,1219,1134,1668,680,146,1259;34;F
16784;725,748,742,40,1197;25;M
16808;1324,1209,1440,207,748,795,1443,680,987,146,930,675,790,40,1039;37;F
16928;790,1440,167,996,987,950,1120,976,465,117,1268,795,680,891,1039;49;M
16950;1668,749,1197,796,771,907,1501,582,941,1450,1164,1233,930,1259,1120;27;F
16976;996,1233,1259;49;F
16977;796,1440,607,907,1449,1501,680,1450,891,146,749,1259,790,1120;39;M
16981;1039,675,146,207,1436,1209,465;38;F
16982;1259,1120,40,976,796,907,1443,996,749,725,1669,92,1501,1668,215;39;F
16997;146,795,771,1436,1669,725,987,1120,1197,104,255,1668,1259,675,976;23;F
17000;1472,1120,976,215,796,207,748,255,607,1235,1449,996,582,891,790;36;F
17011;725,1259,976,215,1120,891,796,516,675,1668,987,146,930,1501;35;M
17014;1143,1443,1449,1450,1164,1233,1259,1120,1039,215,680,1229;40;F
17036;155;45;F
17079;92,891,146,950,1120;49;F
17086;891,215,1472,1259,749,996,771,1669,795,907,1219,1668,1450,1212,1120;66;F
17116;907,1713,680,996,795,748,155,1219,1668,1212,1440,1268,92,1120,40;65;F
17120;255,987,998,1229,1324,1639,795,1670,680,1668,167,790,40,215,976;31;F
17143;1449,987,930,582,255,207,117,40,1209,1039;35;F
17182;1209,465,1669,92,1235,516,1449,930;43;M
17184;1449,996,1501,1186,742,582,1212,930,1120,40,465,92,748,1668,1472;42;F
17195;117,1670,1268,769,255,1229,1501,742,891,976,215,516,996,1450,1120;35;M
17196;907,92,1669,1668,215;44;F
17204;146,891,1450,941,1219,996,516,207,145,1436,795,987,675,976,215;52;M
17206;456,1639,795,92,1436,1713,1268,117,1669,465,725,771,907,1235,1219;44;F
17207;795,1639,907,996,1219,1668,941,987,1450,891,1212,1259,1120,976,215;68;M
17208;941,1233,950,1669,92,607,907,996,1501,1668,1450,749,1259;38;M
17245;1450,1449,255,145,1713,796,996,1134,582,1259,1120,1443,891,1212,749;28;F
17281;1259,207,907,1443,996,987,930,1472,1120,516,976,725,1670,891,1450;33;M
17294;1713,1440,795,456,907,1501,1668,941,1450,891,1259,1120,1669,92,1219;32;F
17300;1143,907,1229,255,607,795,207,769,1713,796,1209,1324,92,1268,1440;24;M
17312;941,1450,891,1259,796,725,92,1440,1235,1668,680,1212,1233,749,1120;33;F
17316;1212,907;43;M
17317;796,725,1669,92,748,1639,1229,1450,749,1259,1120;23;F
17327;907,516,1443,996,1186,582,680,987,1450,891,1209,1324,1229,215,1039;36;F
17331;1443,1219,987,1212,749,215;69;M
17350;207,607,996,1219,1134,1668,941,891,1164,1233,930,1259,1472,1197,104;49;M
17355;748,996,742,987,146,1259,1120,976,215;30;F
17358;215,1562,796,1209,1324,1713,207,255,167,582,987,950,675,1039,976;37;M
17396;1209,795,456,1134,790,1120,104,215,582,771,207,607,1449,1186,146;15;F
17404;1120,907,516,996,680,941,40,976,215;25;M
17431;92,607,907,1668,1450,1259,1120,1197;63;M
17452;976,40,1212,996,1669,1562,1440,769,907,680,215,796,1120,1668,987;40;F
17463;742,1449,1324,207,748,1229,907,996,680,891,146,749,1205,1120,40;32;F
17467;465,1670,907,1440,680,1450,891,1212,796;40;M
17481;996,769,796,1562,1669,1713,92,795,680,987,1120,40,215,465,1268;40;F
17489;796,771,795,907,1449,996,1450,891,1212,1259,1120,104,1219,749,1472;25;M
17500;1669,1440,1443,996,1450,749,1472,40,976,92,795,607,1501,891,1197;38;M
17503;1670,1713,891,1212,1233,1120,40,215,796,1562,987;38;F
17505;1440,907,996,1668,891,749,1205,1039,465,748,1449,146,1472,790,1120;37;F
17506;1449,582,941,1450,891,1212,796,1669,92,996,1501,1668,749,1259,1120;30;F
17518;675,930,987,680,1668,1501,996,907,1440,92,1669,1209,976;22;F
17566;167;39;F
17572;1233,207,1229;39;M
17580;582,92,795,1039,1268,796,891,742,1713,117,167,950,1120;36;F
17612;771,456,1449,950,675,117,92,795,607,146,1120,155;25;F
17668;1235,1449;38;F
17701;996,941,1450,891,1212,1233,930,1259,675,1039,1669,1668,680,146,1120;36;F
17724;207,1449,1186,1233;44;M
17740;92,950;45;M
17754;1668,1669,796,207,255,907,996,1501,680,1450,891,1212,749,1259,1120;49;F
17765;996,1450,1562,465,1669,92,215,40,1120,748,1235,1449,1668,891,749;68;M
17811;1713,167;70;M
17819;1472,516,1501,891,790,1120,976,465,1669,92,907,1235,1449,996,1668;42;F
17824;795,456,680,987,146,930,675,1039,1268,1562,1209,207,255,1120,40;37;F
17832;790,215,976,40,987,907,748,1268,1440,92,1713,796,891,749,1120;32;M
17847;1229;38;M
17853;1134,1501,1668,582,680,987,1212,146,749,930,950,1120,40,1197,1039;38;F
17873;104,748,1039,796,749,1120,1212,680,1668,1449,907,795,1440,92,1669;38;M
18004;456,1235,1449,1186,582;18;F
18012;207,907,1443,996,1134,1668,1186,1164,146,1205,1197,748,1449,749,104;38;F
18031;1440,680;39;M
18036;795,516,996,680,987,1120,976,215;39;F
18045;1668,1219,1670,796,1235,987,1212,749,1197,215,117,465,1440,1449,680;68;M
18065;1229;40;F
18069;1229;43;M
18074;1229;6;F
18076;1229;66;F
18078;1229;70;M
18120;1229;42;F
18127;749,1120,1197,796,1562,1324,1713,1440,680,987,950,40,1039,976,215;47;M
18180;1670,1669,1668,1450,1259,1120,1197,996,1501,987,215,907,516,891,976;47;F
18243;1668,1449,771,465,796,117,207,607,255,907,996,749,930,790,1120;39;F
18311;1229;68;F
18329;796,1670,1669,92,907,996,1501,1668,987,1450,891,1259,1120,1197,976;34;F
18361;582,1668,155,907,207,117,1209,255,516,891,930,146,1259,675,1120;36;F
18378;207,145,796,215,1143,996,92,456,1233,1212,749,790,1472,1449,795;31;M
18380;117,1440,607,907,1197,104,1449,1186,790,92;48;M
18395;1212,1450,987,941,582,1501,996,1449,907,1268,680,1259,1120,976,516;41;M
18401;976,215,796,1562,1209,1713,92,1268,1440,907,680,675,1120,40,1197;28;M
18423;465,795,607,255,456,1443,1449,1668,891,749,930,1197,790,1472,1120;29;F
18424;996,1219,680,941,1450,891,1212,749,1259,1472,1120,1197,725,1229,1233;47;F
18444;1134,155,907,145,1436,1209,207,748,255,1219,146,1233,675,1197,1039;47;F
18462;987,680,1450,1259,1205,1120,40,1197,976,215,907,1639,1440,1268,155;35;M
18485;215,1449,1443,1639,465,796,1669,1713,92,795,996,1501,1668,1450,1259;27;F
18499;1229;69;M
18528;796,92,771,891,749,1259,1120;38;M
18599;516;35;M
18652;1669,795,680,891,1212,749,1259,790,796,92,1668,1120;39;F
18673;1229;36;F
18703;748,795,907,1449,996,891,1212,1120,40,465,1713;40;F
18747;1219,155,607,1713,796,1669,92,795,907,996,1501,1668,891,1120,1197;59;F
18749;748,456,1219,146,1205,675;33;M
18759;117,92,456,1120;52;F
18783;1669,1562,796,1268,1440,907,516,996,941,891,1450,1259,1120,976,215;32;F
18786;1209,1669,1670,92,1440,795,1639,1450,1259,675,748,215;42;M
18799;92,907,996,1668,582,680,941,1450,891,1212,749,1259,790,1120,104;37;M
18805;1668,987,1449,1209,1669,1713,92,1268,145,996,930,675,207,255,456;28;F
18818;1450,987,582,796,907,1443,1449,996,941,891,1212,749,1259,1120,215;22;M
18835;1143,996,1134,1186,1164,1205,790;71;M
18837;1562,582,891,1197,749,987,92,465,907,1449,1668,40,215;51;F
18848;987,207,1209,796,92,1440,769,930,675,1120,1197,1039,215,950,1713;49;F
18867;1268,92,145,207,1143,155,1134,1668,742,1164,146,675,1039,976,215;60;F
18895;795,1209,998,941,749,1212,1450,996,1713,796,1669,92,1668,1259,1120;62;F
18924;92,769,607,1501,1668,680,1120,796,117,748,907,1449,996,891,790;36;M
18940;1668,582,1120,40,215,790,1472,891,680,1449,255,795,1186,1197,104;40;F
18960;92,607,155,1668,891,1259,950,790,1120;26;F
18986;998,167,771,117,796,1209,1713,1268,769,795,907,1443,996,930,1120;42;F
19005;145,1440,796,907,155,742,582,1212,465,748,1449,749,950,1120,680;41;F
19022;456,907,1501,1164,1197,976,215,92,145,795,155,996,1668,146,1259;57;F
19033;207,255,1229,930;33;F
19046;930,1259,675,1120,1039,976,215,996,1449,907,1639,465,1209,796,725;25;F
19053;996,582,1449,1209,725,796,92,207,748,607,987,215,749,1205,675;40;F
19060;749,930,1472,1197,976,790,92,1449,215,796,465,1669,1235,1668,1120;30;F
19073;1450,675,725,941,891,1259,1120,1039;52;F
19157;1233;52;M
19162;516,1449,996,1501,1668,582,941,987,1450,891,1259,1120,215,1197,976;23;M
19164;1501,582,1197,215,1209,1669,145,1186,891,146,749,930,1259,1120,1039;32;F
19175;146,1449,907,255,748,145,1268,1670,117,1669,465,1472,790,1120,1039;39;F
19196;456,516,1219,1472,1120;30;F
19220;1436,1268,207,748,795,255,1639,1229,907,1235,1443,1449,155,996,1501;46;M
19249;1501,1450,891,1212,1259,976,215,1669,92,1668,680,987,675,1120,1197;41;M
19268;907,1436,117,796,1668,1501,1449,1268,92,465,516,1450,891,1259,1120;36;F
19274;207,1440,92,1669,725,1219,582,941,1212,146,930,1259,675,1120,1197;38;F
19287;891,155,607,1501,582,950,796,725,1669,92,1668,1233,749,1259,1120;28;F
19334;1501,1668,582,680,941,1450,891,1212,1233,749,1259,675,1120,40,1197;34;F
19345;996,748,907,749,92,465,796,1235,1449,1668,891,1205,790,1120,104;48;F
19356;795,456,907,1443,996,950;34;F
19391;155,1501,742,582,1450,1212,1233,1259,40,1120,1324,117,607,907,1229;29;F
19393;1443,1219,1501,742,582,1212,907,1449,996,941,1450,891,1233,1259,1120;37;F
19398;1219,987,680,742,996,1449,907,1562,769,146,950,675,1120,40,1039;35;F
19404;680,1440,1259,40,976,1120,1450,891,987,1668,1501,996,1219,907,92;35;F
19441;796,92,680,1450,891,749,1120,40,1039;35;M
19449;1229,255;37;F
19478;1669,117,207,167,1668,950,1120;69;F
19605;1443,516,907,92,996,941,1259,675,1120,1197,1039,976;50;F
19631;155,996,582,930,1120;41;M
19696;796,907,1449,996,1501,941,1450,891,749,930,1259,1472,1120,40,215;23;F
19699;215,675,1212,996,207,796,582,680,891;39;M
19746;1440,1639,907,155,996,1219,1501,1668,941,987,1450,749,1259,1120,215;47;M
19757;255,1449,155,996,1668,1450,1259,675,1472,1440,516,907,930,1120,976;26;F
19765;207,1639,1449,996,582,1450,215,255,907,987,146,1259,675,1120,976;36;F
19790;725,1440,907,1235,1219,941,891;42;M
19799;742,680,987,1212,930,996,1449,907,748,117,796,582,891,790,1120;46;F
19806;796,1713,1268,795,907,167,996,1668,998,987,891,1212,749,1120,215;55;F
19822;167;52;M
19845;40,891,1450,987,1501,996,516,907,117,749,1259,1472,1120,976,215;32;M
19853;1436,1450,1259;34;F
19855;796,725,1440,1235,1219,941,891,1212,1259,1120;39;F
19862;680,941,1450,749,1259,675,790,1670,1440,516,987,891,930,976,215;30;M
19889;891,40,215,1440,680;53;M
19911;117,1440,207,1219,976,215,1450,516,907,795,92;30;M
19915;891,146,749,950,1120,1197,1212,1450,1186,155,907,795,145,771,456;39;M
19922;796,117,748,1668,891,749,1120;60;M
19930;40,215;82;F
19952;790,1209,796,1713,92,1639,1235,996,891,1212,1233,749,1259,1120,215;24;M
19953;1639,456,907,145,771,92,796,1440,1134,1501,146,930,1197,976,104;53;F
20021;950,1669,207,1186,891,146,104,92,748,607,155,1668,790,1197,215;76;F
20032;771,1440,92,1669,725,255,996,1219,1668,582,941,146,1259,1120,1039;42;F
20040;987,155,907,771,92,1209,1562,1713,795,996,1668,1212,749,950,1120;45;F
20059;92,996,680,40,795;43;F
20068;456;7;M
20084;1562,1501,891,1120,1450,1259;44;F
20148;680,987,1440;28;F
20165;1440,215;30;M
20175;1268,1440,769,795,1443,996,1219,680,749,907,1501,987,1259,675,976;34;M
20179;207,255,907,680,146,930,1472,1205,465,1440,748,1235,1449,749,104;37;F
20193;255,516,1449,155,680,1212,749,930,1259,675,790,1120,104,1197,1039;23;F
20198;1436,1268,145,1229,456,996,1501,1668,742,582,146,749,1259,790,516;31;F
20201;92,1440,207,907,1219,1134,1668,582,1450,1164,1259,1120,1197,104,215;36;F
20233;255,795,465,725,1268,207,907,1219,1668,582,941,1450,1120;36;F
20238;1268,680,40,1259,1450,1436,215,987,976,1120,996,891,1501,907,516;74;F
20279;950,155,1268,1669,796,1713,92,1440,795,907,996,1668,1120;33;F
20319;255,117,1669,1209,92,207,1443,996,1668,582,987,675,1120,976,215;36;F
20347;1212,1259,976,215,92,1440,996,1668,582,941,1450,930,1120,796,891;38;F
20369;907,742,1450,1212,1120,1197,1039,1669,996,1668,987,146,675,976,215;35;F
20384;255,104,1229,1449,1219,1501,146,1233,930;38;F
20394;930,680,155,907,1324,92,771,795,1668,1120,1197,1039;46;M
20429;680,976;38;M
20431;92,1440,675,117,1235,1449,680,987,749,1120,40;44;M
20432;1209,207,907,1449,1212,146,675,790,1120,40,1197,976,117;20;F
20436;796,1449,996,680,891,742,117;54;F
20451;1197,145,1324,796,1562,1209,1440,680,987,146,930,1039,742,675,950;36;F
20493;796,1440,607,907,1449,996,1219,1186,680,987,891,1233,1205,215,790;46;F
20504;1229;35;F
20510;582;44;F
20519;255,207,145,796,465,1713,748,1235,1449,996,146,1233,749,1472,1120;34;F
20524;907,796,1669,1713,771,680,92,748,1668,1186,891,1212,749,1120,40;50;M
20529;930,1120,40,215,1259,891,998,1668,1449,748,1436,117,1669,465,749;27;M
20543;996,607,92,748,749,1235,1449;40;M
20589;1229;36;M
20599;796,40,1209,117,1668,891,680,607,1186,1120,950,1449,769,582,167;33;M
20600;582,1186,1219,607,725;59;F
20607;996,1472,1197,891,748,465;35;M
20615;255,1235,742,680,950,1449,996,930,1472,1120;46;F
20661;465,1669,1440,795,907,891,1668,796,92,1235,749,1120,607,155,950;50;F
20672;1501,996,1443,907,255,207,987,675,1120,976;29;F
20694;907,1449,155,996,1219,680,941,1450,1259,1120,215,1669,92,1668,1233;46;F
20778;1235,1668,680,891,1212,1233,1259,950,675,790,1472,1120,104,607,155;58;M
20783;795,1219,1186,1450,891;49;M
20794;1197;28;M
20799;465,748,749,255,1268,1501,1259,516,907,1440,92,725,941,1039;41;F
20805;1669,1143,996,1134,1186,1164,1205,790;87;F
20808;146,1212,891,680,742,996,1443,907,207,465,796,748,1235,1449,1205;34;F
20846;516;47;F
20900;92,1440,1443,998,680,941,950,1039;9;M
20929;796,907,1259,1120;29;M
20935;155,1450,1120,1209,1268,1440,907,996,1501,987,146,1259,675,976,215;32;F
20950;465,1440,771,1235,1449,996,680,891,1212,1233,749,1120,1039,1197,104;31;F
20957;1268,1713,796,145,769,1440,465,1449,1219,1668,891,146,930,790,1120;43;F
20991;465,92,1449,1186,680,891,1233,749,790,40;48;F
21007;1229;60;F
21021;950,1039;2;M
21030;675;26;F
21063;1229,1450,891,930,1120,40,104,117,1440,145,907,987,146,675,976;38;F
21072;1120,749,465,1449;40;F
21080;145,996,907,607,207,748,680,891,146,1205,1120,790;37;F
21136;1713,795,167;48;F
21190;930,675,1039,976;32;M
21192;907,255,607,207,117,456,516,1219,930,675,790,1120,40,1197;24;F
21193;769,1268,255,1670,1440,1450,1259,891,516,976,680,907,1501,1120,996;30;M
21203;907,996,516,582,987,1450,1259,1120;36;F
21210;1668,1501,996,155,907,255,92,1669,207,891,1212,1233,1205,675,1120;37;F
21216;749,215,1268,1562,796,117,207,795,255,996,987,1259,1120,1039,976;38;M
21232;1229,1443,1668,941,891,1259,215,1440,1449,1450,1120,1212,1233,1472,1219;58;F
21257;215,725,465,1268,1440,941;51;M
21292;40,1436,92,145,207,255,456,1668,582,941,987,891,146,675,1197;32;F
21305;92,1268,1440,769,795,907,516,1668,987,950,40,1120,1197,215,976;29;F
21324;1501,987,1120,976,796,1562,117,1440,907,996,680,749;30;M
21333;1668,987,790,1120,976,215,465,1449,996,680,1212;38;F
21354;749,40,796,1120,215;41;M
21357;1229,796,725,1440,145,207,996,680,941,1212,1233,1259,675,1120,215;55;F
21386;1713,1562,796,117,255,769;63;F
21387;796,725,465,117,1440,155,996,1501,680,1212,1450,749,1120,104,1197;24;M
21400;1229;36;F
21427;1120,1668,996,155,907,1229,1440,92,1501,987,891,146,675,1197,976;36;F
21441;255,1713,1669,1209,725,796,1440,795,907,996,941,1450,891,749,1259;34;F
21458;1229,907,1449,1120,1450,1233,1259;31;F
21462;1440,907,1235,1443,1449,996,680,1450,749,1259,1120,1229;42;M
21465;796,465,1440,748,607,907,1449;31;M
21473;117,1639,907,996,1219,998,742,1233,1472,725,930;19;F
21501;749,1120,1197,796,748,1235,1449,996,1233;35;F
21510;1713,1209,167,996,987,930,1120,1039,976,215,675,146,255,795,207;47;F
21523;796,907,1449,996,1668,680,941,1450,891,1212,1259,1120,1197,976,215;33;F
21527;1669,92,1440,255,907,996,1219,1668,1450,891,930,1259,675,1120;31;F
21570;725,1669,1713,1440,907,996,680,891,749,1259,1120,1212;28;M
21575;796,748,891,675,40,104,976,92,987,1472,215,1235,1449,680,749;46;F
21599;1268,795,907,996,1668,891,1450,930,1259,92,1219,987,1120,976,215;33;F
21601;996,1209,1713,207,795,255,167,987,146,930,675,1120,1039,976,215;50;M
21609;145,207,795,1639,516,1443,155,1219,1668,742,941,1259,1120,1039,976;45;F
21626;1229;42;F
21641;1449,1212,749,950,790,1268,1209,907,996,891,1259,675,1472,1120,40;42;M
21657;796,92,748,1235,1449,680,987,891,749,675,1472,40,976,104,215;78;F
21677;796,92,748,1235,1449,680,987,891,749,675,1472,40,976,104,215;74;M
21687;725,456,996,1219,941,92,1669,907,1668,891,930,1259,1120,976,215;28;F
21692;1669,907,1443,1449,1212,40,92,1440,1219,1668,680,1450,749,1259,1120;70;M
21708;1668,1235,795,92,796,1268,117,465,1449,891,749,1259,790,1120,40;49;M
21724;996,1233,749,215,1669,796,907,1501,1668,941,1450,891,1212,1259,1120;54;F
21747;255,145,1440,207,1449,996,680,1450,891,146,675,1472,1120,465,930;34;F
21748;255,996,215;63;F
21758;941,1450,930,976,796,907,516,680,1259,1120;40;F
21767;1440,796,725,1669,1713,907,996,1668,891,749,1212,1259,1120;27;F
21777;1449;35;M
21780;155,1713,465,725,796,1669,92,607,1668,1501,582,1450,891,749,1120;54;M
21784;1713,1501,1450,891,749,1259,465,796,725,92,607,155,1668,582,1120;52;F
21790;92,907,1443,1449,996,1501,1668,941,1450,891,1212,749,1259,1120,1197;49;F
21811;1259,1450,680,996,907,1669,796,207,1235,607,998,749,790,1120,40;45;F
21851;976,104,1436,748,1639,941,1450,891,1259,950,1120,155,987,1197;52;F
21879;891,1197,790,1120,1440,92,796,40,680,1668,516,1235,1268,117,465;30;M
21909;516,1501,582,941,891,749,1259,1120,92,748,607,1449,996,1668,1197;33;F
21917;796,996,465,207,748,1229,907,1235,1449,146,1233,749,930,1205,1120;34;F
21923;1670,1219,950,1197,1562,987,582,1443,40,907,996,1212,1259,749,1120;55;F
21940;1120,1259,749,1212,891,1450,941,1501,996,456,255;46;F
21950;725,117,769,748,607,40,215,465,1562,1268,907,516,680,987,675;31;F
21952;1440,795,607,155,987,1450,749,1259,950,1120,976,215,1562,907,516;36;F
21955;790,891,987,465,92,104,1449;65;F
22001;1212,215,976,891,1259,680,1209,92,1440,907,996,1668,987,1450,1120;34;F
22007;1259,749,891,1450,1501,1449,907,748,769,1440,92,1669,796,1713,1197;50;F
22055;1669,117,92,748,607,155,1450,1449,996,146,749,1259,950,675,1120;26;F
22078;1039,1212,950,1472,1120,40,1669,92,1440,607,907,155,1668,749,680;45;F
22079;1449,996,680,891,749,1197,725,1669,207,748,1443,1668,675,1120,1039;38;F
22112;146,1669,996,749,1668,907,725,207,255,92,465,1449,1472,1120,104;43;F
22114;930,749,146,891,1668,996,155,456,145,1440,796,465,1669,1219,1197;29;F
22121;796,1562,1668,941,1450,146,1120,1039,996,1501,1197,215,1440,987,976;37;F
22147;255,145,207,92,1324,465,1436,907,516,1668,582,1450,1259,1120,1039;26;F
22157;1197,1259,749,891,1450,1449,907,1268,976,1501;24;F
22162;1209,1440,255,907,1235,1449,1219,582,987,891,675,930,215;33;F
22165;891,930,1259,976,1669,92,1440,795,255,456,1668,941,146,1120,1039;35;F
22231;92,1669,1670,996,1450,891,1212,1259,1120;52;F
22255;891,742,145,1440,1209,796,465,1669,92,748,1235,1449,146,749,1233;34;F
22267;796,1669,92,907,996,1668,1450,1259,675,1120;40;F
22271;725,1501,40,907,749,796,795,976,1212,215,1450,680,1668,92,1669;30;M
22278;1268,769,607,907,1449,996,680,941,1450,749,1259,1120,976,1440,748;30;M
22282;516,996,1219,1501,1668,582,891,1233,1120,796,907,1450,749,1259,1472;25;F
22306;907,516,996,1219,1501,680,941,987,1450,891,930,1259,1120,40,215;50;F
22315;117,907,1449,996,104,1668,742,987,891,749,790,1120,40,976,215;35;F
22325;215,1668,1440,680;51;M
22326;582,1450,1212,1259,950,675,1120,1197,725,1669,1219,1501,1668,941,1039;42;F
22332;1668,1450,891,1212,749,1259,1120;26;F
22333;725,996,1219,1501,742,1450,1212,749,1259,1120,40,987,976,215;36;F
22343;1440,907,996,1450,749;25;F
22348;1472,1670,1440,1443,996,680,1212,749,1259,40;26;M
22353;976,1197,40,1120,675,1259,891,680,582,1668,996,907,1440,92,1670;39;F
22354;996,1449,1440,92,1669,255,907,1668,987,146,1259,1120,1197,1039,104;37;F
22374;1562,92,1440,795,680,40,725,1209,748,998,987,675,1120,1039;35;F
22377;1436,996,790,1472,675,1212,1235,680,891,749;23;M
22422;1233,930,1205,675,976,1039,1120,1259,146,891,1450,941,1449,255,145;41;F
22446;725,796,1669,1197,92,1668,795,996,1212,749,907,1450,1259,1120;43;M
22451;796,207,1443,155,1134,1668,146,1120,1197,1039;40;F
22458;1039,675,930,146,987,582,1501,725,255;39;F
22480;1450,146,930,1259,725,1436,92,207,1219,996,1668,582,1233,1120,104;27;F
22501;790,1039,207,795,748,607,907,1449,1501,742,891,1212,749,950,1120;33;F
22515;1713,796,907,1449,996,1501,941,1450,891,1212,1233,749,930,1259,1120;22;M
22516;582,1668,92,675,1039,976,1562,1324,1713,1268,1440,795,742,987,215;39;M
22517;1449,996,1501,1668,582,941,987,1450,891,1212,1233,749,1259,215,1120;21;F
22519;796,1440,1268,92,1436,1562,795,907,996,1450,1212,749,1259,1120,976;48;F
22521;1443,1449,1233,749,930,1259,1440,748,607,1205,1472,1197,1229;37;F
22530;725,582,1205,1120,1039,104,1197,1450,996,255,456,1668,146,930,675;34;F
22550;907,155,996,1668,680,941,987,1450,891,749,1120,40,1197,976,215;44;F
22563;1668,749,1120,40,976,796,1562,117,1440,795,607,155,680,950,675;33;F
22570;796,1562,1209,1268,1440,769,795,607,907,996,680,987,1120,40,215;35;M
22594;795,891,1259,607,1450,1562,907,155,996,1668,749,1120,40,976,167;52;F
22595;1440,1120,725,796,1670,907,516,987,1197,215,1669,92,1668,891,976;39;M
22608;92,1235,680,146,950,1205,1197,748,607,907,1134,987,749,790,976;37;M
22614;145,907,1450,891,749,1120,1039,1670,516,1219,941,146,930,1259,215;36;F
22618;907,92,465,1120,1449;44;M
22623;749,1259,1120,976,1268,1436,796,1209,1639,1219,987,675,40,1197,215;30;F
22664;1450,1212,749,950,796,1209,1268,1440,996,1668,987,1120,40,976,215;21;M
22685;1235,996,1668,891,1233,1259,1205,1120,465,748,1449,749,1472,790,104;50;F
22687;582,1219,1443,907,255,748,207,1440,1039,215,680,40;29;F
22709;1440,1219,930;41;F
22721;907,1440,92,1209,796,1669,145,207,255,1668,742,146,1259,675,1039;34;F
22726;1450,891,1259,976,456,145,771,1669,92,795,907,1668,987,749,1120;35;F
22738;1120,40,1197,104,1562,1209,769,456,907,1449,996,950,1205,675,1039;33;F
22741;465,748,907,1472,1120,790,1259,749,1212,891,1450,1449,1669,92,1668;53;F
22746;1669,92,1668,1450,1259,1120;42;F
22808;465,207,748,255,456,680,790,1039,104;34;F
22813;1209,465,1449,1233;37;F
22815;1209,1670,92,255,907,516,1449,996,1668,582,1212,930,1259,675,1120;36;F
22827;769,748,907,1449,155,167,996,1668,998,941,891,749,1259,1120,40;79;F
22836;607,891,749,215;43;F
22868;92,907,1039,1324,465,1449,987,207,996,1259,1233,930,1120,1197,1219;25;F
22873;1120,987,1233,207,725,465,795,1229,1449,1324,92,907,996,1259,1039;27;M
22881;1450,941,1259,1120;48;F
22902;1443,516,771,1669,92,1440,255,1639,907,996,1450,891,1212,1259,1120;36;F
22912;104,976,1039,1197,680,1501,907,255,117,207,1443,155,987,930,675;49;F
22935;516,1450,1259,675;33;F
22936;1440,92,117,1669,1209,796,1562,1713,1268,769,795,680,1212,215;34;F
22955;1212,146,40,104,92,1713,796,769,795,987,950,790,1120,1039,215;30;F
22956;1212,930,987,749,1120,1197,976,255,680,1440,167,92,1259,1450,40;37;F
22966;1120,104,167,1164;52;F
22971;996,1449,1443,907,769,1713,117,1209,796,1450,891,1212,749,1259,92;34;M
22979;795,145,1713,1235,1219,1186,742,582,987,146,1233,749,675,1120,1039;30;F
22986;215,796,1436,907,516,996,1450,1259,1120,1197,976,987;35;M
22991;215,769,907,996,1501,1668,941,1450,1259;64;F
23009;92,796,1668,1450,749,1259,976,215,907,516,996,1501,680,941,930;43;F
23039;950,1120,976,215,1562,1324,769,748,607,1143,742,987,1164,1039,155;28;F
23046;796,92,607,907,996,1668,941,1450,1212,1120,1197;25;F
23060;1713,1669,725,1668,680,941,1450,891,146,1259,675,1472,1120,1197,1039;26;F
23064;891;37;F
23067;907,1443,1449,996,1501,582,680,941,1450,891,1212,749,1259,1120,215;26;F
23072;749,1472,215,790,1205,930,582,1186,748,207,607,255,1449,1134,104;33;F
23077;465,145,891,146,749,930,675,1219,1450,1233,1259,1120;38;F
23098;255,796,725,795,996,1668,742,987,930,675,1120,1039,976;45;F
23104;1472,1440,92,465,680,1235;48;M
23111;465,117,92,1268,771,207,255,1449,680,1212,749,1197,1039,1668,104;32;F
23134;1219,725,1197,1120,950,680,1668,607,795,207,92,1713,1669,796,1209;37;F
23154;1209,1440,207,795,1143,907,516,155,996,1668,582,1450,891,1259,1120;23;F
23160;680,987,930,950,215,40,1229,748,145,1268,1713,1562,207,742,146;34;F
23171;1443,998,680,1212,950,1120,1039;36;F
23179;607,907,941,891,1259,1472,1039,796,465,1219,146,1233,675,1120;42;M
23181;1440,607,456,1501,1668,891,1197,1669,1713,748,1449,1212,749,1472,1120;33;F
23184;167;51;F
23189;1669,1443,1668,1450,1259,1120,976,1670,92,725,1440;57;F
23193;104,1039,146,1219,1443,207,145,1324;37;F
23201;996,1219,1501,1668,1186,998,582,680,941,987,891,1233,749,1259,1120;30;F
23212;1449,1205,790,1120,1197,104;34;F
23224;1443,516,907,1229,795,1670,92,1268,996,1668,1212,146,675,1197,976;35;F
23237;749,1449,907,996,680,987,941,1450,796,516,891,1233,1259,1120,976;29;M
23238;796,748,456,907,1449,1501,790,40,976,1209,1669,92,1668,680,749;36;F
23250;255,1639,996,582,1039,976;39;F
23256;796,795,891,749;43;F
23316;907,465,117,1235,1443,996,742,891,146,1233,749,1259,790,1120,40;33;F
23334;680,104,40,749,255,607,795,748,1440,92,796,891,1212,790,1120;50;F
23343;1219,1501,1668,742,891,930,1259,1472,1039,976,725,207,941,1120,215;64;F
23351;796,465,795,996,680,1450,1259,1120;41;F
23360;1268,1143,1186,680,1205,675,976,1670,456,516,1164;46;F
23368;1713,117,796,465,1669,1670,92,748,607,1639,1449,996,1668,749,215;40;M
23389;465,725,1219,1501,1259,1039,1212,996,516,907,92;38;F
23395;516,215,976,1259,907,996,1120;27;M
23406;1669,1324,207,748,607,907,1449,155,742,891,146,1205,790,1120,104;33;F
23448;456,796,725,207,255,1443,1449,996,1501,987,1120,749,1212,891,950;38;F
23461;465,1436,92,907,1668,987,749,516,891,1259,675,1120,941,1450,976;29;F
23463;465,92,207,607,907,516,1443,1668,1186,998,891,146,749,790,1120;40;F
23467;1039,215,680,1212;37;F
23478;1668,1197,976,215;45;F
23479;1449;38;F
23489;941,1450,1120;39;M
23499;255,1229,907,996,1501,987,675,976,1324,1670,1440,516,146,1120,1197;36;F
23503;1639,1212,1233,1472,1562,796,907,1450,891,749,680,1259,1120;31;F
23505;998,987,675,1197,215;33;M
23513;1219,987,891,748,1472,215,1436,1639,680,1259,941,1120;36;M
23524;1209,1440,907,1501,680,1450,930,1259,675,1120;29;F
23525;1229;49;M
23533;1713,92,795,155,996,1668,680,891,1212,749,1120,40;52;M
23537;725,1209,516,146,930,104,1472,40,1186,207,92,1669,1219,1668,1120;42;F
23542;790,1120,145,207,607,255,907,1449,996,1186,215,582;44;F
23582;465,748,1449,891,680,1233,749,1205,790,1120,104;64;M
23588;207,769,92,117,1209,1562,1713,1268,1443,998,742,950,1120,40,1039;43;F
23594;155,950;46;M
23600;1212,1259,1120,215;50;F
23611;1440,680,1259,1120,215;57;M
23612;891,950,117,1440,155,680,40,1197;60;F
23630;796,1669,1713,92,516,1449,996,987,891,749,930,1259,675,1120;24;F
23656;1501,1668,742,582,1450,749,1120,1209,1669,92,456,516,1134,146,1259;31;F
23669;1450,891,996,795,1440,92,725,796,1219,941,1259,1120;49;M
23687;456,941,1450,1039,976,92,1669,145,907,1668,891,1212,146,1259,1120;32;F
23717;796,1669,1713,92,1440,1229,907,1501,582,1450,749,1120,1324,1668,40;30;F
23729;891,1212,749,1205,675,1120,255,207,92,465,748,607,1449,1668,790;35;F
23741;145,155,1205,146,607,207,117,92,1713,167;88;F
23745;930,950,1324,207,748,1443,1449,1186,680,987,1205,675,790,40,104;43;F
23749;796,607,907,1443,155,582,680,941,1450,749,1259,950,675,1440,1120;36;F
23763;1219,742,680,987,1450,1212,930,1259,1120,976,465,725,1443,941,1039;39;F
23776;1449;34;F
23816;207,796,456,1143,1186,582,950,1472,1120,1197,987,1164,146,930,675;26;F
23829;1669,117,1268,996,1668,1039,796,1562,1713,769,795,907,215,987,680;41;F
23833;1450,680,1668,996,907,795,92,117,1669,796,749,1259,950,40,104;39;M
23834;1259,680,987,1450,891,1212,930,40,1209,1639;48;F
23839;941,987,117,1268,1440,907,996,1668,582,1450,891,1259,1120,1197,976;40;F
23846;92,1440,582,1212,796,465,748,907,680,749,675,1120,1235,1449,891;31;M
23852;92,1669,607,1449,155,1668,749,790;70;F
23877;1235,582,796,465,1324,1670,92,1440,680,1449,891,1212,749,675,1120;28;F
23884;680,748,996,987,796,92,1235,1449,1668,891,1212,749,790,1120,215;43;M
23897;1668,941,891,1212,155,1449,92,607,1219,1450,1259,1120;41;F
23898;1436,92,1268,1440,155,1668,742,987,1450,40,1197,215,1120;35;F
23911;796,1669,1324,1713,92,1440,1229,1668,582,987,1450,891,1212,1120,40;59;F
23920;1440,748,907,1449,996,582,680,941,987,1450,891,1233,749,1259,1120;37;M
23922;1449,996,1501,1668,582,680,987,1450,891,1212,1259,40,675,749,1120;23;F
23930;1229,1235,1449,1472,1120;35;M
23931;207,771,1268,92,1209,1669,155,996,1668,941,1450,1212,1259,675,1120;45;F
23951;748,1443,996,1668,1197,725,92,1440,907,582,680,1212,749,1120,40;46;M
23965;725,891,1212,1120,796,465,907,996,1219,1450,749,1259,215,1268,941;37;M
23971;92,1669,796,1562,1440,207,907,1443,1668,680,146,930,950,40,1039;39;M
23975;146,1209,748,155,941,1259,1039,1669,92,1440,207,1219,1668,891,930;41;F
23976;104,1197,1668,1501,1219,1440,941,146,1039;33;F
23977;146,976,1120,675;34;F
23996;976,215,796,1669,92,207,795,1443,1219,1668,891,1233,1259,1472,1120;74;M
24003;117,907,1443,996,1501,1668,92,796,725,941,1450,1212,749,1259,1120;38;F
24006;1440,1235,891,1205,790,215,976,40,796,92,748,607,1668,680,749;27;M
24015;40,976,1120,680,996,1449,1235,1268,1209,891,796,790,582,465,749;27;F
24029;907,1670,516,255,1440,930,891,987,996,215,1209,92,1259,675,1120;30;F
24036;1668,675,1197,976,104;31;F
24054;255,607,145,1440,92,1713,1669,1449;26;M
24067;117,465,1562,796,607,1449,891,675,790,1120;28;F
24115;1219,1501,1450,891,749,1259,104,796,207,607,456,907,1449,996,1120;17;F
24119;1120,742,1443,996,1219,146,1233,207,582;30;F
24146;255,207;73;F
24150;725,117,465,1209,796,1562,769,795,1639,516,1668,941,1450,675,1039;62;M
24159;1449,996,1501,1668,998,891,1120,976,215,117,1562,725,796,1259,790;47;M
24161;516;40;M
24182;907,996,1668,987,1450,1212,1120,40,1197,680,675,976;41;F
24193;465,1472,1229,1235;48;M
24211;796,465,92,40,976,207,748,680,1212;41;F
24216;976,1259,146,941,996,155,907,92;31;M
24226;891,996,155,1449,907,255,207,465,1209,796,1450,1212,1233,1259,1120;33;F
24234;1209,1669,92,1440,795,996,1668,987,1212,749,675,1120,40,1197,976;31;F
24244;1562,907,996,1668,582,1212,1233,104,215,790,1472,749,891,465,1449;66;F
24249;1436,1259,1120,1669,92,1268,207,907,155,996,1668,941,1450,1212,675;48;M
24255;1562,92,145,795,907,996,998,742,987,146,950,675,1120,1039,215;40;F
24283;749;35;F
24300;1209,1143,742,930,1205,790,40,1197,215,675,104;41;M
24310;725,516;31;F
24311;1668,891,976;36;M
24324;795,607,255,996,1186,582,907,749,1120,1669,92,1449,1668,891,790;33;M
24392;1229;39;M
24424;1713,167;30;M
24434;1669,117,167;58;M
24450;1713,167;28;F
24467;796,117,1713,92,1268,1440,207,748,1235,1449,996,725,680,749,790;54;F
24486;1668,1212,40,996,1443,907,795,1268,117,465,987,1259,1472,790,1120;26;F
24489;1669,771,795,607,255,996,1668,680,1450,1212,1259,1197,92,516,1120;35;F
24522;1235,1668,891,40,796,1713,207,907,1449,749,930,1120,790,725,680;55;M
24557;1197,1669,92,582,1164,1713,1501,907,516,771,795,1219,941,1259,1120;30;F
24584;796,1209,1669,1713,1268,1440,748,795,907,1449,996,1668,680,987,891;24;M
24587;725,1039;44;F
24615;796,1669,1436,769,1639,1450,1259,976;72;F
24638;465,1670,748,725,92,1268,1440,255,907,516,1501,941,749,1259,1039;45;M
24639;465,1562,145,748,207,255,1443,996,742,680,1212,146,749,1205,675;31;F
24659;1268,1436,92,907,516,1450,1197,1669,771,795,456,1668,1259,1120,976;17;F
24671;749,1120,976,1259,680,1668,1501,996,907,92,1268,117,1562,796,725;53;M
24675;907,1713,1209,207,255,987,891,675,1120;20;F
24686;92,1268,742,1713,145,207,255,155,1668,146,950,675,1039,167;62;M
24689;1450,92,1669,1209,1668,680,987,891,1440,1235,907,1501,749,1120,725;32;M
24691;907,996,1668,742,146,675,1197,215,987;37;F
24745;796,607,907,1449,996,1501,582,680,1450,891,749,1259,1120,104;45;M
24759;1143,456,1259,1120,40,976,104,92,795,255,1219,146,749,930,675;33;F
24764;796,725,1209,117,1440,795,1219,941,1259,40,215;43;F
24771;675,1197,104,1209,1668,1186,680,749,1120;32;F
24784;1669,1440,748,795,907,680,891,40,1197,215,1443,1668,749,1120,104;48;M
24790;796,725,1209,465,117,1436,1268,795,1639,907,996,1450,891,1259,1120;23;M
24810;748,207,1268,92,117,1669,796,1209,1440,1501,582,680,987,891,675;38;F
24816;796,1669,1670,1713,907,1443,1668,680,40,950,1120;59;F
24823;215,675,930,987,1219,1440,207,1450,255;68;F
24836;1450,92,1669,1209,1668,680,987,891,1440,1235,907,1501,749,1120,725;33;M
24841;987,1450,891,1164,1212,146,1259,1205,675,790,1120,1197,976,104,215;68;F
24860;92,795,1668,796,117,1209,167;38;M
24920;146,987,998,907,92,1670,796,1669,1713,748,795,1443,155,1668,749;46;M
24926;40,1212,950,104,1219,155,1449,1143,725,796,1669,92,607,907,1501;61;F
24978;215,1324,1670,145,255,456,582,1259,1120,1039,104,1440,1639,146,976;32;F
25001;907,1197,1669,92,1440,1668,680,987,146,675;48;M
25003;796,725,1669,92,1440,907,1449,1219,1668,941,1450,891,1233,1259,1120;81;F
25007;907,996,1501,582,680,941,987,1212,749,215,1450,795,1259,1120,976;36;F
25031;891,582,1186,1668,1134,1219,996,907,1639,607,92,117,1669,465,1449;52;F
25038;1440,748,1449,582,680,1039,1197,976,1209,795,456,987,749,40,215;35;F
25046;1233,1229;43;M
25073;796,1440,996,1450,749,675,1197,516;31;M
25089;516;37;M
25108;1197,1450,907,255,1268,92,725,117,795,996,1219,1668,941,1120;60;F
25110;117,465,1669,1670,1449,987,1450,1259,1120,796,1440,516,680,976,215;34;M
25116;1450,1501,680,976,215,796,1713,795,907,996,891,1212,749,1259,1120;35;F
25155;92,1668,582,891,749,1472,1120,40,796,465,680;37;F
25167;104,907,465,725,796,1268,1219,941,1450,1039,976,1120,1233,749,1259;61;M
25194;987,1186,1235,796,1669,1713,1268,1449,1668,680,891,1233,749,790,1120;47;M
25201;1669,1668,1197,215,1440,680,976;42;M
25218;1501,582,891,465,1669,92,145,1443,1668,680,146,749,1472,1120,40;9;F
25235;907,516,1449,996,1219,1501,941,1450,891,146,1259,675,1120,207,255;35;F
25240;1229;43;M
25253;987,1120,215;21;M
25258;796,582,1120,749,1259,1205,1472,146,1212,891,1668,145,92,1669,465;6;M
25273;796,725,1440,907,1449,996,680,987,215,675;35;M
25281;907,1449,742,582,941,1450,891,146,1233,749,930,1259,790,1120,104;38;F
25287;1472,796,92,907,1449,680,749,104,215,465,748,996,891,790,1120;45;M
25296;680,941,1212,1233,749,1472,40,907,1450,1259,891,1120,1039,976,215;16;M
25313;1669,1436,607,1668,1212,1259,1197;56;F
25353;680,748,1235,1039,465,749,1120,996,796;44;F
25362;516,996,1501,1668,680,1450,891,1212,930,1259,675,1120,1197,1039,976;34;F
25380;950,1120,1039,1324,1562,1713,1268,1443,1668,987,1197,976,1449,907,1669;19;M
25383;1449,1235,907,456,255,145,795,607,996,987,891,749,1120,104,930;49;F
25401;907,1120,1259,976,1440,516;30;M
25405;907,207,465,796,1449;39;M
25406;104,796,907,1449,891,1143;18;M
25432;950,1120,796,1562,1669,92,1440,795,907,1668,987,749,40,976,215;36;M
25497;92,771,255,907,1443,996,1501,582,941,1450,891,146,749,1259,1120;42;F
25500;1449,1324,1436,1501,1268,1562,907,976,680,1440,930,675,987,255,742;16;M
25506;749,1450,987,680,582,1668,1449,907,92,117,465,796,996,675,1120;53;M
25513;607,1235,1449,1134,1186,891,1164,1212,930,1259,1205,675,1472,790,215;30;M
25515;742,790,1120,1197,1039;39;F
25520;1713,92,907,1443,1449,1501,941,749,215,796,996,1450,1212,1259,1120;33;F
25529;796,1449,1713,795,907,996,1501,680,891,1212,749,1259,1120,976,215;35;M
25533;907,516,155,941,1450,891,749,950,1120,1197,976,1669,1501,1668,1259;39;M
25541;1259,40,1120,1197,996,155,1449,1443,907,1229,145,1268,1713,1668,950;82;M
25555;749,891,582,1668,456,1440,92,1209,465,1669,207,748,907,1449,680;33;F
25560;465,1268,941,891,1472,1039,215,742,1233;53;M
25593;167,117,92,907,998,950;55;M
25600;465,145,748,456,516,1219,742,891,1212,146,1205,1472,790;31;F
25604;1669,92,907,516,996,1668,1450,1259,1120,1197;32;F
25633;996,1120,1268,795,987,1039,40,769,1209,1562,1324,680,950,675,976;45;M
25657;40,1120,1259,1212,891,1450,941,1668,1501,907,1436,795,987,976,215;37;M
25675;1669,92,1268,1501,1668,1120;48;F
25677;725,771,207,907,1443,1449,582,146,104,1134,1143,996,1186,1164,1205;43;F
25694;255,145,771,1669,725,1197,104;52;F
25701;1235,1443,1219,742,1205,1197,215,725,1436,987,146,930,1259,1039,976;42;M
25724;771,255,907,1449,582,146,1120,1143,996,1134,1186,1164,1205,790,104;45;M
25733;92,1268,771,207,255,1443,996,1668,680,987,675,1324,795,950,1039;48;F
25787;92,996,1450,1212,749,1259,907,215,1440,1501,680,987,891,1120,976;35;M
25793;796,207,92,465,1440,748,607,1229,1443,1449,996,582,891,1120,1197;55;F
25795;796,607,1449,749,1120,1197,582;56;M
25796;92,1450,749,675,1501,1209,941,1212,891,1259,907,1120,996,516;29;M
25802;104,40,1039,1120,1472,1205,891,748,92,465,796,1440,207,1449,749;37;F
25803;680,987,891,1259,1120,976,675,930,749,582,1562,465,1324,950,1039;39;F
25804;92,796,155,941,465,1209,1450,675,749,1212,1268,907,891,1259,516;30;F
25856;987,582,1219,907,796,1209,465,117,748,1449,996,891,749,790,1120;31;M
25859;769,1440,1562,1209,1324,1713,1268,680,987,930,950,675,40,1039,976;44;F
25867;92,117,465,725,1713,1268,1440,145,167,998,742,1212,146,1039,215;38;F
25900;1120,790,748,749;36;M
25913;1440,255,145,516,1450,146,1259,1120,1039,976;39;M
25942;104,680,941,1120,1197,1450,891,1212,465,749,1449,1235,92,1233,1472;38;F
25949;796,725,1669,1268,1668,941,675,1120,976,215;49;F
25967;795,207,771,1268,465,1436,1713,1669,1209,117,145,456,907,516,1120;36;F
25994;795,607,1639,1449,582,950;21;M
26007;1209,117,92,1440,795,1668,680,675,40,1713,907,167,987,950,1120;50;M
26034;1501,680,941,1450,1259,40,796,1562,795,907,996,891,1120,976,215;31;M
26055;1143,725,1039,1669,769,930,40,675,1164,987,1668,456,255,207,1562;27;F
26122;1219,1259,1450,1436,976,930,1212,1440,255,516;30;M
26125;675,1197,1669,1670,92,771,795,607,996,1219,1668,1212,146,749,950;34;M
26153;145,748,1235,976,92,155,1668,104,795,1449,749;30;M
26159;725,1669,92,749,40,1039,907,996,1668,950,1120,796,1713,167,215;53;F
26183;1235,1443,146,1039,1120,207,255,907,680;34;F
26200;1229;11;F
26220;1268,1209,1562,725,950;45;F
26234;1186,1668,907,255,92,748,795,607,1449,891,146,1205,790,1120,104;28;F
26247;998,1668,748,92,1669,725,1209,607,907,1235,1449,1219,749,1472,1120;30;F
26257;1450,930,1259,675,1120,1440,145,207,255,456,680,146,1233,1197,1039;41;F
26266;1324,796,1120,1039;35;M
26271;145,207,748,1443,996,1501,1668,680,941,1450,891,146,749,1120,40;36;F
26276;1669,215;55;F
26295;796,680,1268,1235,1449,582,941,891,1233,1212,1259,1472,1120,976,1039;34;M
26299;1440,516,891;43;F
26315;207,748,1443,155,1134,1668,1212,146,930,1259,675,1120,1197,1039,104;42;F
26334;1259,207,1450,146,1205;43;F
26337;996,796,1120,104;28;M
26344;680,1235,996,748,582,749,790;39;M
26409;1259,1669,92,1440,795,155,996,1501,1668,1450,1212,950,1120,1197,215;58;F
26426;725,987,930,1259,1120,1039;2;F
26459;725,92,907,1668,1450,930,1259,675,1120,1039;39;M
26472;1259,582,92,725,1039;9;M
26483;1713,1268,1440,907,1449,996,1219,1501,1186,680,987,891,1212,749,1120;41;F
26484;1436,1440,1639,1450,1259;63;M
26491;790,749,748,996,1235,680;36;F
26514;465,1268,1639,907,680,987,1450,891,1212,1233,1259,1472,1120,976,215;25;M
26521;40,996,582,1450,749,1501,1668,891,1212,1259,1120,92,117,1669,1440;33;M
26562;1670,92,516,1443,996,1668,680,987,891,146,1120,40,976,215,907;34;M
26573;1259,1324,1268,1440,1229,907,996,891,1120,742,680,987,1039,215,976;37;M
26577;1668,1186,742,582,1450,1212,790,796,465,92,207,748,1449,891,1120;45;F
26596;607,795,796,748,1449,891,749,790,1197,104,215;66;F
26635;1450,941,996,907,92,1440,680,1197,1039;52;F
26639;1235,1120,40,976,215,796,92,907,748,1449,996,680,891,749,790;36;M
26653;941,1120,976,1235,1443,155,950;40;F
26654;117,1669,790,976,796,465,92,907,1449,996,582,891,1212,749,1120;65;M
26675;1562,255,607,1449,987,1120,976,215,1713,1268,167,680,950,675,1039;35;M
26676;215,1209,1669,92,1440,795,907,1668,891,1120,1197,987,680,976,675;48;F
26689;1440,207,748,907,1443,1449,996,680,1450,891,1212,1233,930,1120,1197;43;F
26705;987,941,680,1501,1219,996,907,1639,1268,1562,796,516,891,1120,976;32;M
26715;796,1669,117,1713,92,207,1501,1668,582,987,950,1120,215;40;F
26722;795,1562,1039,1197,1668,607,1324,950;49;M
26751;1259,930,891,582,796,1713,607,907,1449,155,996,1501,950,1039,1120;38;F
26777;40,1197,607,795,1440,92,1713,1669,725,1209,771,255,456,930,675;32;F
26786;1440,1197,104,1501,255,680,987,146,930,950,675,1120,1039,976,215;35;F
26803;795,796,456,255,1440,1120,1501,1197,996,976,907,891,680,675,215;47;M
26834;255,796,465,207,1449,891,1212,749,1259,790,1120,40,1197,976,104;64;F
26836;582,1259,930,1205,1324,207,1229,516,742,987,146,790,1120,1039,976;69;F
26842;796,1449,680,1472;34;M
26847;1259,1120,1197,796,1669,117,207,255,456,907,1449,996,1668,1233,1229;30;F
26855;795,748,117,796,465,92,907,1449,996,680,891,749,1259,1120,215;47;F
26889;907,1449,1501,941,1450,891,1259,1120;38;M
26894;1501,1449,1268,1713,796,1440,907,996,1668,582,1212,749,1259,1120,215;28;M
26897;582;39;F
26998;996,1668,742,680,941,891,1212,1259,976,1440,907,516,1450,146,1120;26;F
27001;1440,795,456,516,1501,1668,891;38;M
27022;1197,1669,1436,996,941,891,930,215,976,987,907,1440,516;24;M
27026;907,1449,1501,1668,1197,976,725,1669,92,1440,996,680,749,1259,40;33;F
27035;516,215;25;M
27058;255,607,92,1436,465,1449,155,996,1501,582,1450,891,1259,1120,516;26;F
27067;146,930,1039,1209,1324,907,675,215,680,987,1120,1268,1440,795,516;31;F
27073;796,725,1562,1669,117,795,1450,891,1212,1120,92,907,1197,1668;33;M
27091;1669,145,207,998,117,1713,795,167,1668,215,987,40;58;F
27099;1669,1436,1440,907,516,996,941,987,891,930,1197,976,215;23;F
27116;117,1436,1639,516,155,1219,742,941,987,1450,1259,675,1120,1039,215;38;F
27143;1713,1268,769,748,167,998,146,930;61;F
27154;907,771,1268,1324,207,795,255,1443,996,680,987,950,675,1039,215;9;M
27174;996,1440,92,1669,215,976,1120,675,987,680,1501,1219,516,907,1670;31;M
27182;1259,930,1450,891,987,1501,996,907,795,1268,796,1120;50;F
27187;941,987,1450,891,1212,749,790,1440,516,930,1259,675,1120,1197,104;27;F
27188;1436,1209,796,1501,1450,1259,1212,950,215,92,1669,725,1219,1668,1120;27;F
27189;1670,1450,1039,976;38;F
27209;465,796,1268,1440,748,795,607,907,1449,996,680,891,1212,790,1120;31;F
27214;1669,1268,145,207,255,1668,987,680,1120,1039,796,1562,146,40,215;39;F
27229;996,1219,941,1450,930,1259,950,1120,1197,207,742,987,146,1039,215;37;F
27230;1039;38;F
27272;796,92,1268,769,207,255,167,1668,998,680,987,1212,950,1120,1039;41;F
27274;742,1120,40,976,771,1143,950,1562,145,748,255,1443,1186,680,146;42;F
27277;40,1039,215,950,1259,749,1209,796,607,255,907,996,941,146,104;48;F
27286;1562,1324,1039,1443;44;M
27290;675,987,146,930,255,1501,1670,1440,907,516,996,891,1259,1120,976;38;F
27322;996,1219,1450,1120,1197;31;M
27332;796,465,92,1440,907,1235,996,749,1259,790,1120,1449;31;M
27357;748,907,1235,1449,996,1219,1450,215,92,1668,891,749,930,790,1120;49;F
27364;1669,92,907,1235,1449,996,1219,1668,930,1205,790,1120,1197,104,215;17;F
27371;749,465,1235;30;M
27407;1324,1440,1229,907,1443,996,1501,742,680,891,749,987,1120,976,215;44;F
27416;1324,748,1229,1233;32;M
27432;1668,1450,891,749,675,1120,1259,516,1669,907,1197,987,1229,1501,976;28;M
27446;1436,1669,465,941,1229;7;M
27460;796,1562,207,1229;5;F
27503;1324,255,146,1259,675,1120,976,215;47;F
27521;1120,796,1713,207,907,167,749,930;44;F
27535;1713,117,795,1443,996,742,891,1212,1233,749,1259,1120,40,976,215;42;M
27537;996,1501,1120,796,1440,907,1449,987,1450,891,1212,749,1259,680,215;49;M
27551;996,1668,742,582,1450,1212,1233,749,1120,40,1235,941,891,1259,1039;32;F
27577;1440,465,456,907,996,145,207,748,255,1449,1134,1186,680,1205,104;45;F
27604;92,795,996,1501,1668,680,941,1450,749,1120,725,907,1235,1233,1259;41;F
27627;680,891,749,930,675,215,796,1209,1639,907,516,1450,1259,1120,976;28;F
27638;215,987,941,1209,1670,1440,145,207,607,255,516,146,930,950,675;43;M
27639;465,748,907,1668,950,796,1449,146,1205,790,1120,207,255,1235,749;35;F
27659;749,680;45;M
27669;1450,1259,1205,996,1449,1713,456,907,891,930,950,1120,1039,796,607;56;M
27681;516,1443,1501,941,976,145,255,987,146,930,1039;41;F
27682;796,1669,92,1440,207,607,907,155,996,1668,1212,749,950,675,1120;34;F
27705;675,1120,1440,146,1259,40,1639,1668,891,1212,907,680,1450,976,215;51;M
27709;1120,117,680,465,1235,796,1209,1436,1440,1449,1501,582,987,749,976;37;M
27734;516,1268,465,891,1212,749,1259,1120,1440,907,996,680,941,930,1197;30;M
27743;1209,1436,795,1639,907,996,582,987,1450,891,1259,1120,976,1501;34;M
27751;167;67;F
27768;996,1668,582,1120,215,796,1669,1713;28;M
27789;1436;39;M
27802;1668,1562,1669,1713,92,769,987,40,680,950;42;F
27810;891,1120,976,796,771,748,1449,155,996,1668,1186,680,749,1205,104;47;M
27826;1440,1212,1472,40,1197,976,790,891,680,607,748,1436,1713,215;29;F
27866;1443,907,1324,145,1669,92,795,1668,987,146,1259,675,40,1197,104;49;F
27891;796,996,1668,117,976,145,1669,1197,1449,255,582,930,675,1440,207;24;M
27895;796,1436,1235,1449,996,1668,1450,215,1212,1259,1120,680;46;F
27909;582,941,1450,1212,930,1259,1197,1501,987,891,749,675,1120,976,215;49;F
27915;255,1120,1039,145,607,456,516,996,146,1449,207,675,930;28;F
27926;796,987,1501,941,1450,1259,675,582,891,1212,749,1669,1668,680,1120;45;F
27942;987,1450,146,930,950,1440,795,1501,1259,1120,1197,976;40;M
27945;145,207,748,795,907,1449,155,996,1134,1668,987,1164,950,40,104;27;M
27976;748,607,907,996,1449,146,40,1197,1472,749,255,145,1669,465,1562;38;F
27983;725,1440,1120,92,1668,941,987,976,215;42;M
27994;769;61;M
28005;1713,1440,207,255,996,987,146,930,675,1120,40,1039,215;64;M
28007;1670,215;68;M
28037;907,987,1259,976,1562,796,1324,680,749,950,675,1120,40,1039,215;39;F
28042;1449,996,680,1501,742,582,987,749,891,146,930,1120,675,1039,215;29;F
28098;996,1120,215,976,1259,1501,930,516,907,1670,891;38;F
28099;92,1440,769,680,675;40;F
28123;215,1450,1212,1259,1120,1669,1219;49;F
28129;907;47;F
28140;1450,146,207,145,771,456,907,996,1212,749,930,1259,1120,976,215;38;F
28150;1443,1120,40,1039,1324;38;F
28161;907,516,1668,891;44;M
28184;976,1120,1259,891,996,907,516,1440,1670,1501,255,930,146,987,675;39;M
28211;1209,92,987,930,1197,215,1669,516,1668,1450,1259,675,1120;40;F
28254;1212,749,1205,725,748,1143,1219,891,930,40,1120,104,1472;27;M
28284;1197,1205,1164,1186,516;33;M
28288;92,1440,907,996,1668,582,680,941,1450,891,1212,749,930,1259,1120;24;M
28298;92,1449,465,680,749,1120;24;M
28300;1450,891,146,40,1501,582,941,976,215,1039,1120,1259,155,516,996;44;M
28307;1670,145,607,1668,1450,790,1120,40,104,749,516,907,1229,465,1449;23;F
28334;1668,680,1450,1039,976,907,996,742,987,749,950,675,1120,40,1324;36;M
28338;1669,1670,92,1668,582,987,1212,930,675,516;27;M
28358;1443,155,680,146,891,749,1197,207,1440,1229,1219,1233,1212,1120,104;44;F
28378;725,907,996,1039,1668,1639,1670,1669,976,1120,1450,941,1219,516,92;35;F
28394;167;51;F
28406;996,976,92,207,516,1668,742,891,1450,1212,930,1259,675,1120,1039;43;F
28419;582;42;F
28450;1668,769,987,40,680,117,795;63;M
28491;1039,146,207,1324;45;F
28514;1670,92,1268,1440,207,907,516,1443,680,987,1212,1259,976,215;13;M
28536;167,1235,1713,796,1562,1440,207,907,742,680,987,675,1197,1039,215;44;M
28549;950;59;F
28558;1449,167,1440,516,1443,1212,930,215,155,582,987,1120,976,607,950;37;F
28582;456;22;F
28591;675,582,516,795,207,1209,1669,92,1440,145,1668,987,146,930,255;35;F
28595;976,1039,516,907,1639,1268,1440,255,1450,891,146,930,1259,675,1120;34;F
28631;215,255,987,146,1039,976;31;F
28636;930;38;F
28663;680,1450,749,1209,1440,607,907,516,1449,1219,891,1259,675,1120,1197;33;F
28707;1501,1219,1443,92,1449,907,725,941,1450,749,1259,1120,1197;45;F
28727;207,795,907,996,1668,941,1450,1164,675,976,92,607,255,155,950;40;F
28760;215,1120,1259,749,891,1450,582,1713,796;60;F
28779;941,1233,1443,92,907,1449,996,1501,680,1450,891,1212,749,1259,1120;28;F
28802;749,1268,1440,941,796,1436,907,1219,680,1450,891,1212,1259,1120,215;49;F
28871;1324,796,749,1233,891,1450,987,941,680,742,582;59;F
28877;92,1668,749,1197,215;39;F
28923;582,1197,104,145,1449,790,255,748,680,146,1205,1039;40;F
28959;725,1669,1670,92,607,155,516,1668,1233;47;F
28975;1450,1209,1259,1120,1219,941;40;M
28977;1229,907,516,996,1219,680,941,742,987,1450,1259,1120,1039,976,215;32;M
28982;1669,1440,675,607,987,1670,1501,1668,255,930,976,215,516,155,950;29;F
28983;255,1219,891,1197,1134,1450,1209,907,1259,1120,215,1668,680,987,976;28;F
29011;795,1229,1501,742,941,1450,1120,1259,749,891,996,796,907,1449,1668;65;F
29023;92,1668,675,1039,215,1562,1268,769,795,998,950,40;58;F
29033;907,996,1501,941,1450,1259,1669,117,1443,1668,582,680,1212,675,1120;41;F
29091;1259,796,725,1324,117,1436,748,607,456,996,582,1668,749,1197,104;29;F
29111;145,146;35;F
29120;987,1235,465,748,1449,146,749,675,1472,790,1120,40,1197,1039,215;27;F
29126;215,1669,1562,987,749,1120,40,976,796,1268,1668,742,680,950;41;M
29195;1134,1668,749,930,1205,1120,104,215,796,1186,146,465,207,607,255;68;F
29216;930,255,207;45;F
29226;1449,117,796,1235,215,976,1120,907,1268,465,996,941,1450,891,1259;51;F
29227;1668,1186,582,680,987,1212,749,1259,215,795,907,1443,891,146,930;28;M
29235;769,456,996,1450,749,796,92,907,155,1501,1668,891,1212,1259,1120;23;F
29279;1219,1235,795,465,1669,748,607,790,40,215;52;M
29286;1669,117,1670,92,1443,996,1212,215,1436,907,1450,941,891,1259,1120;51;F
29325;167;35;M
29334;92,1669,1209,796,1436,1268,907,795,582,680,1450,1259,675,1120,40;37;F
29335;92,1209,796,907,1449,996,582,680,987,1450,891,1212,1233,1120,40;32;F
29351;1668,582,1450,891,675,976,907,996,1501,941,987,1233,749,1259,1120;40;F
29369;796,907,996,1219,1450,891,749,1259,1120;24;F
29374;1562,1324,1440,769,145,795,1449,155,987,675,104,950;46;M
29419;92,1713,117,465,1209,796,215,1233,749,930,1120,1472,1562,1639,1449;35;F
29424;215,145,255,907,155,742,1197,987,749,675,1120,1039,976,146,516;31;F
29453;1562,1209,1197,215;35;F
29492;796,891,749,748,1449;42;M
29522;1669,1440,1235,996,1450,146,1259,1120,215,1668,907,1436,92,1219,1197;37;F
29526;1268,516,680,941,987,675,215;28;F
29536;930;38;M
29537;215,796,1562,1713,1268,769,795,907,996,1668,146,1259,1120,40,1039;37;M
29550;680,950,40,104,92,255,1668,582,742,146,930,790,1120,1197,1039;36;F
29552;742,907,1229,1440,1324,92,207,1449,950,1669,607,255,582,1259,104;26;M
29558;748,771,796,1669,1449,1501,1197,607,1668,950,675,1120,155,987,930;40;F
29573;1562,795,998,680,675,1039;35;F
29600;1209,796,748,1443,680,1039;41;M
29612;155,996,1668,941,1450,1259,950,1120,1039;73;F
29628;92,976,215,891,796,1562,1268,769,795,680,749,950,1120,40,1039;46;M
29630;987,1120,582,996,1443,1324,907,1039;43;F
29648;1449,998,1212,582,680,996,1443,907,796,1259,1120;49;F
29667;742,215,987,976,907,255,1440,1324,607,1229,516,155,891,1120,950;55;F
29693;769,1443,1212,1120,104,215,1669,1713,795,1668,742,680,950,40,1039;37;F
29699;796,1713,749,40,1197,146,748,1562,1324;49;F
29702;998,680,950,1197,1039,976,215,1440,607,1233,930,1259,675,1120,40;28;F
29706;680,930,1259,1120,1039;40;M
29717;1324,1669,465,1209,1562,769,795,155,680,987,146,950,1039,215,40;42;F
29744;1120,675,891,255,607,1670,145,1440,207,516,941,1219,1186,146,930;40;F
29804;215,92,1713,1268,1562,1669,1324,1668,742,987,950,675,1120,1039;36;F
29815;907,255,771,1229,1713,1440,1443,1219,1134,1501,749,146,1186,155,950;43;F
29826;771,1039;50;F
29831;907,996,891,795,1219,941;37;F
29864;582,941,1450,1212,749,1259,796,1449,907,155,996,891,1120,40,215;30;M
29871;1039,1562,680,771,1259,976,516,255,1440,146,607,155,950;47;F
29877;1259,1209,1562,907,1443,155,675,795,987,950,1197,976,1039;38;F
29878;1669;61;M
29905;1436,748,891,749,465,92,907,516,1443,996,941,1450,930,1259,1120;41;M
29954;987,1668,1669,92,742,1324,950,1039;5;F
29976;796,465,748,907,1235,1449,891,1233,749,1205,1120;32;F
30009;796,1562,1713,167,1668,987,146,950,675,1197,215;61;F
30024;742,675,930,1212,104,748,680,92,582,1259,1120,465,749,1235,1449;31;M
30025;607,796,1209,1120,891,987,255,92,749,1235,790,582,1134,1186,996;32;M
30035;1669,1209,748,742,104,1039;43;M
30067;769,748,907,996,950,987,1268,117,1562,155,40,1197,1039,976,215;66;F
30169;976,1120,1209,796;44;F
30178;675,790,1039,996,742,582,680,1212,1233,1259,1120,40,796,117,1229;14;M
30202;1639,769,607,1143,516,1219,1668,1164,950,1197;80;M
30214;1436,1268,996,680,1450,1259,976,215;54;F
30218;796,1669,92,996;34;M
30225;255,1440,516;36;M
30234;680,941,891,1212,1233,930,1259,92,1235,1449,155,996,1668,749,1120;41;M
30243;92,1268,145,1120,675,1197,215,207,748,795,255,1668,680,40,104;49;F
30251;941,675,1472,1197,215,1120,749,1212,117,465,92,748,1235,1219,1233;28;M
30297;1235,117,1670,796,1669,92,795,607,1668,891,680,749,950,1472,1120;70;F
30322;796,1639,907,1443,996,1501,582,891,1212,930,1259,1205,790,1120,1039;22;F
30340;92,117,796,1562,1713,1268,769,795,907,996,1668,987,950,1120,1039;35;F
30401;725,1209,1197,1039,976,215,1562,1713,146,950;42;F
30427;987,1039,976,1134,1562,1268,1443,582,1120,40,215,1209,680,675,1324;44;F
30437;950,607,117;54;F
30468;582,742,1562,465,1713,1268,771,769,907,1449,996,1219,1134,1668,987;36;F
30485;976,795,1268,465,796,1440,1639,1235,680,1259,1472,790,1120,1039,215;24;M
30487;1268,1440,145,907,996,742,680,987,1450,146,1259,675,1120,1039;34;F
30491;1120,675,987,1668,1669,1324,1562,1268,1713,92,215,742,950,1039;40;M
30546;155,680,891,1120,1235,1449,748,749,255,92,1134,1186,996,582,790;31;F
30549;795,255,456,1443,117;62;F
30579;725,1669,117,92,1268,769,795,516,1668,742,987,950,1120,215,1039;51;F
30591;771,145,146,1039;35;F
30600;117,456,40,769,1713,1562,1443,1449,155,680,987,950,675,1039,215;37;F
30629;680,891,1212,1259,1197,976,215,725,1668,742,582,1205,675,1120,516;23;F
30669;40,680,215,1501,907,987,976;32;M
30774;1259,1219,1120,976,795,771,1450,255,207,725,117,215,749;74;F
30781;1668,146,976,1669,40,1197,749,796,1212,742,1440,1120,582,680,748;41;F
30811;40,1197,1039,976,104,215;29;M
30830;907,795,769,1268,1713,1209,1562,1324,1440,680,987,930,675,1039,976;9;M
30831;582,790;40;F
30837;1669,748,607,790,92,796,1449,155,891,749,1205;50;F
30869;1669,1209,1436,795,1639,516,155,1668,987,1259,950,1120;39;F
30877;1209,1324,207,930,950,675,1120,1039;14;F
30917;1449,1235,907,1639,795,1440,996,1219,987,1259,675,1472,1120,976,215;29;F
30943;1440,1713,1670,1669,1436,771,795,1143,1219,1668,1186,987,1233,930,215;35;F
30955;117,92,1668,1450,749,1259,950,1120,976,742,725,1324,907,1443,1039;38;M
30972;607,748,145,1440,465,1669,1670,92,207,795,456,1668,1186,146,1039;40;F
30998;1209,465,207,748,907,1449,996,1219,675,790;46;M
31009;796,1209,1669,771,207,456,996,1668,1186,987,1212,146,1120,215;43;F
31040;1219,1212,1197,796,1440,92,907,1668,680,987,749,675,1120,40,976;30;F
31048;1324,207,255;77;F
31132;1268,207,907,1259,976,796,255,516,1443,1668,987,146,930,675,1120;34;F
31150;215,1197,1670,907,516,996,1450,1212,1259,1120;35;M
31155;1440,987,680,146,930,1259,675,1120,1197,976,104;37;M
31184;207,907,996,582,680,987,1212,749,1259,675,1120,40,1197,976,215;33;F
31196;1669,987,976,215;41;F
31201;1120,891,1450,516,742,146,930;35;F
31205;582,941,1235,1449,749,1205,790;48;M
31213;1501,795,771,1440,1268,465,796,1669,92,907,516,1449,996,1668,1120;34;F
31246;1449,1450,891,1120,1197,976,215,796,1562,1209,1713,1440,996,680,675;44;F
31255;207,145,1440,117,1209,1268,255,456,742,680,146,1233,675,1120,1039;35;F
31256;92,1440,1443,1501,1668,582,1259;20;F
31265;92,771,207,795,255,1143,1443,1164,1205,1039,104;50;F
31284;255,907,996,1668,675,1197,976,215,1268,1235,1219,146,891,1259,1120;68;F
31286;92,996,1450,1562,907,941,796,1440,1501,680,891,1212,675,1120,976;35;M
31291;1501,1668,1450,1259,1197,92,891,749,675,1120,1440,907,987,976,215;33;M
31302;92,1713,1670,796,748,907,1443,155,996,1501,1668,582,749;40;F
31309;582,941,1450,1212,1259,675,1120,1197,771,1436,725,891;27;F
31317;907,742,987,1212,1120,976,796,207,1449,582,930,215,1039,1229,167;14;M
31319;742,987,749,675,930,40,215,771,207,795,255,456,1443,950,1120;61;F
31337;976,40,1120,104,215,796,465,92,907,1143,1235,1449,1668,987,749;31;F
31341;456,215,675,987,941,742,996,1143,1639,795,1268,976,1197,1501,516;32;M
31358;1440,145,207,1219,1450,146,1233,930;41;F
31361;769;69;M
31364;749,1259,675,1197,930,891,582,996,907,796,1209,92,771,1668,1120;37;F
31376;1713,117,1669,1562,92,145,1668,998,146,930,950,675,1120,40,1039;29;F
31391;1639,907,516,1449,996,1501,680,941,1450,891,1212,749,1259,675,215;38;M
31395;92,1268,607,1212,1233,749,950,1472,1120,1039,796,155,891,976,215;32;M
31417;1233,1120,976,796,117,92,907,1449,1501,1450,891,1212,749,1259,1197;61;M
31421;1209,1713,1440,1668,930,1197,167,1229,680,675,1120,215;47;F
31434;1562,117,1713,795,996,950,1120,891,1259,255,207,930,1229,167,215;14;M
31442;1562,1669,1713,92,1268,145,155,996,1668,742,146,950,1120;66;M
31469;1120,1668,996,1443,907,795,465,92,796,255,1449,582,891,1212,749;39;F
31483;146,1219,155,796,680,582,941,1450,891,1259,1120,976;45;F
31505;1669,145,907,996,1501,987,1450,146,1259,675,1120,40,1197,976,215;40;F
31530;1450,725,1669,1436,92,1268,1219,1668,941,891,749,1259,675,1120,976;31;M
31564;680,987,749,930,675,976,796,1440,907,516,1450,1259,1120;32;F
31591;1436,1324,1669,456,907,1443,1449,996,742,582,1450,146,1259,1120,1039;34;F
31611;1197,40,790,749,891,941,582,1440,117,465,796,907,1212,950,1120;33;F
31634;996,1501,582,987,1450,891,950,1259,516,930,1120,1197,976,104,215;36;F
31643;976,1212,1501,1324,1670,1562,1713,1268,1669,1639,1443,1668,1450,1259,1120;50;F
31699;796,1324,607,516,996,941,1450,1259,1120,1039,907,155,891,675,976;42;M
31722;680,1212,930,1120,1197,796,92,155,675,1039,1209,1668,1440,207,255;38;M
31737;1268,1440,907,1668,987,1450,1212,146,1259,675,1120,40,976,516,215;32;F
31754;675,215;53;M
31759;748,607,907,1449,742,680,891,1212,146,749,790,1120,40,1039,104;37;F
31773;145,1562,796,1713,771,1233,950,104,1669,748,155,1472,1449;38;F
31782;1120,1562,1268,1440,998,742,680,987,930,675,40,1039,976;34;M
31789;1268,1670,117,1669,1209,796,725,516,680,987,1197,976;34;F
31807;582,1668,1443,1440,92,465,796,742,996,907,1449,891,749,104,1120;40;M
31809;796,92,1268,907,996,1668,1450,891,1212,749,1259,1472,1120,976,516;26;M
31850;1268,1639,907,1450,1259,976;35;F
31904;976,215,796,92,1440,907,996,582,941,1450,930,1259,795,1120,1039;33;F
31907;1668,1212,1443,680,749,1120,104,1669,465,92,771,207,748,146,1205;64;F
31925;1233,1197,40,104,1440,1443,1120,790,1268,796,996,465,749,1235,1449;31;F
31951;1209,1324,1440,207,255,1229,1449,742,582,680,987,930,675,1039;37;M
31967;1501,941,680,891,749,1259,675,1209,1669,1668,582,987,1450,1472,1120;27;F
31987;146,891,907,607,1268,725,796,92,748,795,255,996;62;F
32012;1450,1212,40,1197,796,1669,92,907,1668,680,891,1233,749,1259,1120;30;F
32018;1229,907,996,1212,1259,1120,255,1219,1668,675,1233,987,941,582;42;F
32026;976,92,117,1669,796,1268,769,516,1219,1668,742,1197,680,795,950;25;F
32035;742,1450,930,950,207,255,456,1443,1219,941,675,1039;41;F
32045;255,607,1440,1668,1472,1205,40,104,1197,725,456,941,146,1259,1039;38;F
32053;976,1501,987,950,215,996,907,795,155,941,1450,891,1259,1120;41;F
32059;145,207,795,456,155,987,930,1197,215,255,1668,146,950,1120,1039;40;F
32061;1669,92,795,155,1668,987,1233,675,1120,976,215,907,516,1450,1259;47;F
32065;207,748;62;M
32103;907,155,167,742,1120,976,796,1562,1268,769,1443,998,987,950,1039;50;F
32110;1209,146,742;44;M
32148;1219,1668,1259,1120,725;61;F
32162;1324,725,1436,1268,795,155,891,1120;26;F
32179;1436,117,976,40,1120,1259,1212,1450,582,996,795,1440,92,1501,907;38;F
32188;1209,1440,987,950,675,796,1120,891,1713,680;51;F
32230;930;36;F
32239;1209,796,215,976,1120,675,749,930,582;20;M
32246;680,941;31;F
32294;769,795,987,950,675,40,976;42;M
32313;215,1472,146,1212,742,996,795,145,1440,207,255,1259,675,104,1229;38;F
32363;1449,1440,796,117,996,582,680,749,215,1669,92,1668,891,1120,790;56;F
32366;1212,749,976,1205,1259,146,582,1186,1229,748,742,1233,1472,104,215;40;M
32369;742,1268,1670,725,1669,92,907,1443,996,1668,1450,1212,1259,1120,1039;36;F
32391;117,680,1120;34;F
32396;607,941,1450,950,1259,675,1120,1197,1209,1268,1440,907,1443,996,1501;40;F
32433;1324,207,255,907,1443,1449,742,582,941,987,891,1212,146,1259,976;39;F
32461;796,996,155,1450,891,1120,1197;34;M
32478;1259,675,40,907,1713,796,1562,92,1268,795,167,680,987,1120,215;58;M
32481;465,1669,1324,117,1670,1713,1268,1639,907,516,1449,680,675,1472,996;33;M
32498;155,1443,607,769,1268,465,725,1324,145,207,1229,516,742,146,1039;40;M
32526;1268,769,907,167,996,1450,891,1212,749,1259,950,1472,790,1120,215;21;M
32540;987,1120,930,891,155,1259,976,1450,1219,1212,40,215,680,907,1440;31;M
32546;675,1259,1219,907,771,1324,796,1209,795,155,1668,987,1120,456,996;47;F
32557;725,907,996,1501,1668,1450,891,1259,1120,1669,516;30;M
32584;1209,207,1639,1143,255,607,516,998,987,146,950,790,1039,725;23;F
32593;1562,40,976,1209,92,987,950,1039;40;M
32607;1443,748,1440,1669,796,1436,907,1668,680,891,749,1120,40,104;23;M
32610;1562,1209,907,996,582,950,675,1120,1039,215;39;F
32634;769;33;F
32635;1229,1443,996,1219,1501,1668,742,582,1212,146,950,790,40,1197,1039;36;F
32668;1440,907,516,996,680,930,1259,1120,40;30;M
32672;1668,1501,996,155,907,1440,92,796,675,1259;32;M
32701;941,1450,891,1212,1233,1259,1120,40,1039,796,1440,996,146,749,1197;34;F
32768;1039,1324,117,1268,1440,748,795,742,1472,40,1197,155,465,1229,680;39;M
32815;582,680,941,987,1450,749,1259,675,1472,1120,40,1197,976,215,1669;33;M
32817;790,1259,749,1212,891,1668,795,1268,92,725,796,117,1120,40,215;26;M
32823;1450,1443,907,1670,1669,1713,1235,1440,1449,1219,1501,1233,1120,996,1668;65;F
32825;1670,976,155,987,1668,907,1229,1639,215;66;F
32838;1039;65;F
32870;748,1235,1449,1668,1212,92,907,680,891,749,1472,1120,996,790,582;46;M
32893;796,607,907,1449,1668,582,891,749,1120,104;52;F
32916;1713,742,987,675,40,1039;41;F
32985;891,1450,582,748,145,1436,465,796,1670,207,607,255,1472,40,1197;54;F
33070;725,92,1229,1219,998,742,104;32;F
33082;1449,1501,582,680,987,1212,146,749,1205,1120,104,92,795,891,207;34;F
33145;891,1259,1120;42;F
33149;1324,92,1268,1501,1219,1668,680,987,1120,1197,976,104,725,1669,516;31;F
33156;465,1268,207,607,907,1443,1449,1219,996,1186,582,891,950,790,1120;47;F
33171;1259,790,1120,1197,976,907,255,748,207,145,117,465,1562,796,996;44;F
33191;465,255,1235,996,582,749,40,1450,680,1668,1449,748,1440,92,1669;48;M
33212;255,1443,907,1449,996,582,941,1450,891,749,1259,1120,40,1039,1324;43;F
33229;996,680,1450,891,1212,930,749,976,215,1668,907,255,1669,941,1259;30;M
33233;796,92,207,748,907,1443,1449,996,1501,1668,582,891,749,790,1120;25;F
33254;1440,117,465,1209,725,92,907,996,998,582,680,1450,1212,1259,1120;34;F
33263;582,796,1713,1639,907,996,1501,941,1450,891,1212,1233,749,1259,1120;27;F
33264;1229;46;F
33282;607,207,1440,725,675,1212,987,996,155,1443,1713,796,1562,1209,950;45;F
33283;1436,465,1450,1212,1259;51;M
33294;748,145,771,1268,1713,465,1209,207,1449,582,680,891,146,950,1039;40;F
33312;1639,891,941,40,1039,215,1440,907,680,1450,1259,1120;56;M
33344;725,1209,92,1268,1440,582,680,987,891,1259,675,1197,976;44;F
33347;1713,92,207,795,255,456,1143,1219,1186,680,675,40,104,215,155;68;F
33361;465,1186,1120,215,92,907,996,1668,680,749;63;M
33377;796,607,998,582,1197;29;M
33429;796,1713,907,1449,996,987,941,1450,891,749,1259,215,976,1120,790;40;M
33453;1713,167;38;M
33457;1449;39;F
33460;941,1120,1450,1259;34;M
33484;748,1268,92,117,796,1440,907,1219,941,1450,891,1212,1233,40,1197;34;F
33494;40,1197,976,796,465,748,891,1212,1233,1259,1472,1039;31;M
33509;941,1436,1669,1268,1440,907,516,996,1668,1450,891,1259,1120,1039,976;33;F
33511;1449;7;F
33524;749,1205,215,117,796,1713,1268,907,1443,1449,996,1134,1668,1186,1120;39;M
33532;1449;12;M
33552;40,1197,1639,1443,742,950,255,207,1268,1324,1229,155,146,1120,976;41;F
33561;907,996,1186,742,582,930,796,207,748,1449,1205,1472,790,1120,104;41;F
33578;1669,1186,1209,675,207,795,607,1449,1212,930,987,680,1233,748,92;20;M
33580;987,146,749,930,1259,976,1440,907,996,680,891,675,1120,40,215;32;M
33592;1450,1259,976,725,1209,207,907,582,680,987,146,930,675,1120,215;34;F
33593;207,255,1229,907,1449,996,1501,582,1212,1120,104,1669,92,1440,1668;32;F
33605;749,1259,790,40,1039,976,796,465,117,92,1440,996,1450,891,1120;45;F
33627;987,891,155,996,1668,742,680,1450,146,950,790,1197,215,795,607;41;F
33628;796,1669,1670,92,1440,907,1449,1219,996,1668,891,1212,749,1259,1120;34;F
33648;796,1669,1713,92,907,1668,795;32;M
33658;930,950,1259,891,1501,1449,796,1669,1713,795,907,996,1668,749,1120;43;F
33662;1233;17;F
33680;1440,748,255,1450,1212,1259,790,1120,796,607,907,1449,996,1219,891;35;F
33690;1219,675,1197,771,207,1229,907,987,1259,1205,104;46;F
33702;1268,907,996,1450,1120;75;F
33743;950,1713,607,1219,987,40,769,1212,1120,207,796,1562,155,215;63;F
33780;1324,795,1562,725,1440,155,1449,996,1668,680,1450,891,1212,950,976;30;F
33794;1219,725,255,891,930,1259,675,1120,1669,92,465,1268,1440,941,1039;44;M
33810;796,465,1209,725,1669,1713,1268,748,996,1501,1668,930,215,1120,1472;23;M
33813;891,1501,748,796,1449,1120,1669,92,907,996,1668,680,749,930,40;18;F
33822;987,950,1039;49;F
33831;987,1120,976,1440;33;M
33836;1039;41;M
33848;1324,795,215;40;F
33849;1440,1436,1669,1209,155,146,1120,976;28;F
33855;796,795,1143,1449,891,996,790;33;M
33873;1668,1324,742,950,1039;1;F
33881;930;33;M
33916;1449,891,749,1205,1472,796,465,748,996;35;M
33920;582,742,996,255,907,1449;36;F
33942;1639,516,1449,155,996,582,680,987,930,1259,950,675,1120,1039,215;41;F
33968;748,607,907,976,1235,40,1197,680,796,92,891,749,790,1120,104;39;F
33987;795,145,771,607,456,155,1134,1186,987,950,1205,1039,104,146;45;M
33989;92,907,996,1186,891,1197,1713,607,1449,1120;46;F
34002;1235,1449,891,1205,790,40,104;42;F
34004;1229,1449,582,891,1259,976,215,1713,1268,742,680,987,1120,40,1039;39;F
34016;907,1443,155,996,1501,987,1450,891,1212,1259,675,1120,976,215,1668;36;F
34024;996,1668,1186,742,680,987,146,749,950,1205,790,1120,40,1039,104;37;F
34029;1120,104,1197,1259,215,1440,1501,516,1639,1436,255,976,987,907,1670;36;M
34040;891,742,998,749,1120,790,1186,1501,725,145,1219,1212,675,1472,40;25;F
34045;907,1443,1449,1501,1186,987,941,891,1259,1197,725,1669,92,1668,104;61;M
34059;465,117,748,795,907,1235,1449,996,742,582,680,987,891,1120,1039;43;F
34096;891,941,1219,1449,1235,907,1713,1669,465,117,748,1668,987,749,976;29;F
34139;255,92,950,998,1120,40;27;F
34152;907,145,987,1259,1120,1039,976;48;M
34181;1449,582,1212,930,1205,790;44;F
34186;1562,1436,891,215,976,1197,1120,1259,146,1450,941,996,516,907,1670;37;M
34201;771,748,1669,891,1120,796,1436,92,1449,996,1668,1186,582,987,790;29;F
34215;796,1562,769,795,907,155,1668,950,675,40,215;70;M
34232;207,607,675,1039,104,215,795,1235,1205,790,40;41;F
34240;1450,891,1259,1120,1039;50;M
34241;1472,207,996,1268,748,607,1449,1668,891,146,749,930,790,1120,104;34;M
34266;796,795,1120,1668,1713,92,771,976;19;F
34294;40,790,749,891,941,1639,748,465,1268,795,1143,516,987,1164,976;66;M
34301;1120,950,207,92,1039,1259;40;F
34307;465,207,795,607,1235,1205,675,790,1120,104;13;F
34320;1324,1440,1639,1229,907,516,155,941,891,1259,950,1472,1120,1039,1219;39;F
34336;1120,40,742,998,907,92,675,769,145,680,796,1562,795,950,1039;37;M
34350;1669,92,145,207,748,795,607,155,1186,987,891,146,749,1205,215;59;F
34394;796,1209,1197,725,1440,996;25;F
34406;941,1450,1212,465,117,92,748,680,891,749,1259,1120,40,976,215;34;M
34412;1209,1669,92,516,1449,996,1501,1668,1450,891,930,1259,675,1120,215;20;F
34448;1436,92,769,1235,1449,1668,675,1120,1039,976,215,1669,907,996,987;35;F
34479;675,950,1259,1212,941,987,1668,1501,996,907,795,92,1713,1669,796;28;F
34494;146,1212,891,1450,987,941,742,1501,996,155,795,145,680,1120,976;36;F
34508;1449,1668,1186,998,742,680,891,1212,1233,1205,790,40,207,748,582;46;M
34514;155,465,1562,675,215,607,950,1197,796,1440,907,680,987,1120,40;28;F
34539;725,941,891,1450,1668,996,155,1669,92,207,950,1259,1120,1039;11;M
34540;1120,998,1440,1713,1209,796,1562,1268,769,795,907,680,987,950,675;45;F
34542;907,155,987,1450,1259;37;F
34574;117,1669,465,796,1235,1449,996,1668,680,987,891,749,1120,40,215;44;M
34577;1562,725,607,996,941,891,1212,950,1120,155,1219,1668,40;36;F
34587;1324,207,1039;50;M
34593;1562,1670,1134,1713,771,207,456,996,1219,1186,987,146,675,40,1197;78;F
34600;92,145,1229,456,516,1443,996,1501,1668,742,582,1120,1039,1197,104;28;F
34615;891,1212,1472,1197,1039,1501,1449,1268,465,1436,1639,907,1259,675,1120;36;F
34622;207,607,255,1449,155,1219,1134,1186,891,146,950,1205,790,40,104;66;F
34624;255,1639,907,516,1449,941,987,1450,1212,1259,1120,40,215,1562,1219;31;F
34643;167;56;F
34645;465,1259,725,1669,92,207,941,891,1668,155,996,950,1120,1197,1039;8;F
34664;1670,456,1120,1039,104,92,1440,207,1259,675,1197,987,146,976,215;41;F
34668;1562,1268,769,796,1440,1443,950,742;45;F
34686;796,1669,1229,1668,1186,930,1205,1197,1235,1449,1120,104;47;F
34704;92,725,1669,1668,155,996,941,891,950,1259,1197,1120,1039;38;M
34716;796,465,996,1212,1440,907,1449,1186,680,1233,1259,1120;40;F
34719;92,207,996,1219,1668,987,749,1259,1120,40,976,215;57;F
34778;207,987,749,930,950,675,1120,40,1197,215,796,1209,465,1324,255;71;F
34783;155,1501;20;F
34792;117,1449,516,1639,255,607,748,771,1436,1713,1219,1186,146,1205,1197;43;F
34798;1449,1219,742,40,215,796,769,207,748,607,1443,155,1668,680,1039;39;F
34803;465,117,516,996,1501,1668,891,1197,215,976;35;M
34813;996,1562,117,1268,795,907,1450,891,749,1259,976,680,987,1120,215;44;M
34814;796,725,1669,92,607,255,907,1443,1449,996,1501,1668,749,1120,1197;37;F
34822;40,465,92,795;37;F
34830;675,769,907,996,1212,1120,1197,796,795,456,1219,1668,998,987,950;58;F
34847;465,146,749;35;F
34860;1639,145,92,1669,1562,769,996,1668,146,976;36;F
34864;1443,92,796,207,607;36;F
34928;1440,1233,582,796,1449,907,996,1219,680,1450,891,1212,749,1259,1120;44;M
34936;215,996,456,1669,796,1209,1713,795,1639,1450,930,1440,1259,675,1120;40;F
34944;1233,1229;42;M
34946;1562,1209,255,907,680,1120,950;42;M
34977;215,976,1120,675,1259,749,146,891,987,680,1501,516,907,795,1440;42;M
34986;155,607,1713,1669,465,1562,987,950,790,1670,92,769,907,996,1668;43;F
34990;1039;41;M
34992;207,607,255,1449,1219,582,891,930,950,1120;42;F
35001;996,987,1197,215,1436,1670,907,516,1501,1268,891,1450,1259,1120,976;29;F
35007;749,930,1259,1205,104,976,1039,1197,1120,790,1472,1440,145,907,516;38;M
35012;796,465,1713,1440,748,907,1449,1668,680,891,749,930,790,1120,40;30;M
35016;987,976,796,607,1443,1449,155,516;66;F
35019;1219,1212,749,950,40,976,796,1670,92,607,1668,987,1197,1039,215;57;F
35020;255,1449,582,1164,930,675,1472,1120;37;F
35021;1209,1669,92,155,1443,516,1259,1120,104;67;M
35031;1501,582,930,1259,40,1120,891,941,1668,516,907,1440,92,1436,1669;27;M
35047;1440,796,465,1669,92,207,748,607,1443,1668,582,749,950,790,1039;33;F
35059;465,1713,996,891,749,1120,748,117,1449;42;F
35068;725,907,1449,680,1039;40;M
35102;796,1562,1209,1268,998,987;40;M
35119;1259,796,1449,996,1501,582,891,1233,725,1669,92,1668,1212,749,1120;42;F
35130;680,769,996,742,1120,40,1039,796,1562,1713,1440,1443,987,950,215;36;F
35159;1209,725,796,255,907,1219,146,1120;31;F
35167;1668,1669,1440,582;56;F
35177;207,607,255,1443,582,1205,790;47;F
35186;987,1450,891,749,930,1259,675,1440,907,155,680,1120,40,976;48;F
35212;749,1668,1501,92,1669,725,907,1235,155,996,680,1450,1233,1259,1120;41;M
35233;907,1449,996,582,987,1450,1259,1120,976,215,725,516,255;30;F
35236;1440,907,996,1450,1120,516;32;M
35243;796,1562,1440,255,907,996;60;F
35244;1449,1120,1562,1268,769,207,748,1443,742,680,987,146,950,675,1039;37;F
35270;796,92,456,907,1219,1450,1259,1120,1197;52;F
35337;907,725,996,930,516;29;F
35360;167,796,1669,1713,1268,795,769,680,987,675,1120,40,976,215;29;M
35372;1562,1209,1669,1713,1268,1440,907,996,1668,582,1212,930,1120;31;F
35382;1440,207,255,1639,456,516,1668,675,1197,145,748,155,1219,146,1039;48;F
35404;725,465,1669,92,1268,1443,1668,941,891,1039;38;F
35422;1669,92,680,987,950,976,215;47;F
35436;795,1713,796,725,1669,92,748,1449,996,1501,1668,891,749,1472,1120;34;F
35474;1562,1197,1186,976,796,795,996,907,1268,215,748,749;74;F
35486;155,516;51;F
35511;215,1562,1039,950;36;F
35518;907,1443,1449,996,1501,1668,582,941,987,891,1233,749,1259,1120,976;49;F
35521;748,1235,996,907,680,891,1212,930,1259,675,1120,40,1039,976,215;15;M
35536;1501,155,1670,907,1449,996,680,941,987,1450,891,1259,1120,976,215;50;F
35546;1039,987,680,92,465,207,748,1229,907,1449,1186,582,891,146,1324;38;F
35548;1562,92,680,1450,1120,976;34;M
35550;167,891,950,40,1670,1713,1436,1639,516,749,1259,1120,1197,976,215;37;F
35557;796,1440,1268,987,146,675,1120,215,976,907;36;F
35558;796,725,1440,607,907,1449,996,748,749,465,891,1120,1197,104;38;M
35575;749,891,987,582,1449,1143,907,207,1713,1669,465,748,255,680,40;32;F
35578;1449;33;F
35587;255,907,1449,996,1450,891,146,749,207,155,941,1259,675,1120,1039;37;F
35618;1449;36;M
35636;1449;9;M
35652;796,1449,1668,725,1669,92,1501;47;F
35659;1449;3;M
35670;1450,891,749,1259,1669,92,1440,795,1501,1668,987,675,1120,976,215;42;M
35677;1449;1;M
35680;769,207,795,907,996,998,987,891,1212,749,950,675,1120,1197,1039;17;F
35690;207,1713,1669,1209,1164,1186,1143,167;69;M
35703;1259,1197,1120,1212,987,941,675,1450,1668,891,930,104,582,1501,749;25;F
35718;1562,117,769,795,155,167,950,40;65;F
35722;891,749,930,675,1039,976,465,796,255,1639,456,680,1212,1259,1120;40;F
35729;796,465,607,1449,155,680,891,146,749,950,675,790;34;M
35738;1436,255,456,1143,155,996,1501,987,891,1164,1259,675,1120,976,215;64;F
35740;1039,104,1668,255,145,1324,1562,117,1713,1268,795,996,1120,1197;69;F
35741;795,748,769,1669,1562,1713,907,1449,1186,987,749,1120,976,215,796;26;M
35784;92,1197,207,255,930;51;F
35797;1197,40,930,891,680,1668,996,1449,907,465,1713,255,749,1120,1039;67;F
35801;207,1229,987,92,117,996,680,891,1212,146,749,1259,1120,40,976;36;M
35804;92,1562,582,1219,1449,795,771,1209,117,215;35;F
35859;1120,891,1501,1443,516,1212,1639,1562,796,1440,680,215,976;31;M
35860;1443,996,680,987,465,1268,941,1450,891,146,930,1259,675,1120,1039;32;M
35864;1039,950,1229,1324;47;M
35878;987,675,1039,725,1669,1259,167;53;F
35880;680,1443,725,796,1713,92,1440,255,1668,891,749,1120,40;49;M
35888;1212,891,680,582,1219,996,1449,907,1440,465,104;34;M
35911;465,117,1713,1501,1668,941,92,907,996,1450,891,1212,749,1259,1120;35;M
35922;155,1449,92,1713,796,907,996,1501,941,1450,891,1233,1212,1259,1120;38;F
35959;1209,516;31;M
35964;996,465,1449,891,749,1205,790,1120;41;F
35966;117,769,996,1668,680,987,1259,1120,976,749,950,40,1039,215;64;M
35993;1450,1259,1120,796,941,891,1212,749,790;36;M
36002;1229,1233;62;F
36017;1562,1268,996,1120,1450,1501,456,215,891,582,1668,1443,145,1324,1669;19;F
36029;146,891,680,742,1449,1443,907,1229,255,207,145,92,1669,1324,465;10;F
36037;1229,1233;88;F
36055;795,907,155,996,1668,998,680,987,1450,749,1259,950,1120,40,1039;64;F
36077;1449,582,1212,1450,1259,790,1039,796,748,996,680,891,749,1472,1120;39;F
36102;516,1440,796,1436,1639,1668,987,1120,255,680,215,976,891,907,1259;41;M
36119;215,976,1120,1472,749,1233,1450,987,1668,996,907,748,1440,1219,1259;70;F
36124;1039,930,146,891,987,680,1668,907,1229,207,92,1713,796,465,1324;8;M
36129;215,1450,941,996,680,1120;32;M
36139;796,516,996,1501,680;36;M
36140;145,795,1443,1501,582,941,891,1212,907,996,1668,1450,1259,1120,215;53;F
36158;1501,516,907,1670;63;F
36173;1259,1120,1450,582,1668,1501,996,907,1229,92,1436,1669,465,1233,1039;40;F
36188;907,996,1134,1186,680,1205,790;29;M
36195;1209,1562,1713,92,795,907,996,1219,582,941,987,1450,749,1259,1120;49;F
36222;146,1450,582,998,996,907,255,769,1440,1713,796,1669,1449,1668,1501;25;F
36225;40,215,742,987,675,1120,976;31;M
36231;795,1229,516,996,1219,941,1450,891,1259,1472,790,1120,40,1039,976;35;F
36238;796,998,1713,795,1443,950;50;F
36241;1713,167;65;F
36264;1209,465,255,1443,155,1186,680,1212,1259,930,1120,675;29;F
36279;1669,796,1443,998,742,950;39;F
36289;1669,92,155,1668,976;63;F
36290;1197,725,1039,215,987,1120,40,1562,1669,92,1268,795,255,907,1668;66;F
36297;1449,891,146,1120,582;42;F
36305;1562,795,907,950,1120,40,215,1268;73;F
36324;1450,1668,907,145,1713,92,996,146,1120,207,607,742,255,1443,1039;39;F
36338;145,207,255,907,1449,582,891,146;11;F
36358;1668,891,749,976,790,725,796,1669,1670,92,907,996,680,40,215;85;F
36379;1440,145,748,742,680,146,1120,207,607,255,1443,582,930,950,1205;38;F
36381;1143,1449,155,680,987,1450,749,1259,950,1205,675,40,976,1443,742;46;F
36390;680,40,255;76;M
36393;1209,1562,725,796,907,1501,680,941,987,1450,1212,930,1259,1120,1197;39;F
36407;771,795,907,155,996,950,1120,1197;52;M
36412;1670,1669,92,1440,907,516,1501,1668,987,1450,891,1212,1259,1120,976;38;F
36415;1450,749,1120,907,1235,155,1501,941,891,1259,215,976;41;M
36428;748,465,1209,1669,92,795,607,1235,1449,155,1186,582,749,1205,104;68;M
36438;92,1449,680,891;36;M
36462;207,950,1443,742;42;M
36514;930,1259,1120,1197,796,1450,996,907,1443,582,680,891,1212,749,104;39;F
36556;930,1259,1197,104,1669,675,950,1205,1039,1449,680,1324,1668,987,146;53;M
36557;1324;15;M
36563;1324;11;F
36580;725,680,1197;60;M
36586;675,930,582,1668,996,1440,1268,796;26;M
36597;1219,40,1120,996,1501,1668;26;F
36606;907,941,891,1197;38;M
36607;1449,1235,748,607,207,1713,1562,987,146,950,1205,1472,790,1120,1039;39;F
36612;987,1450,891,1259,675,1120,976,215,92,749,1233;25;M
36624;167,1713;42;F
36634;92,1450,976,749,795,155,907,996,1120,215,1259,891,941,1668,1501;50;F
36668;207,748,907,996,742,891,790;64;F
36675;207,215,1562,117,1268,255,1443,742,987,675,40,1120,1039;41;F
36680;1562,92,1440,996,1120,1197,976,215;51;F
36683;215,996,749,891,582,1449,907,255,748,207,92,465,607,1120,796;48;F
36689;465,748,907,1449,996,1668,582,1450,749;45;M
36697;207,748,795,1219,215;50;M
36699;907,155,167,1501,582,1450,749,1713,996,680,1212,1259,950,1120,40;44;F
36709;1219,976,796,725,92,795,1501,1450,891,1212,749,1259,1120,40,1197;50;F
36711;1120,996,1259,1212,907,795,92,582,1450,891,1562,1669,1440,1219,1668;73;F
36731;907,1639,941,1450,1259,1120,1197,1209,1436,1449,680,987,891,930,1039;31;F
36732;104,207,1668,1186,1120,1197;46;F
36733;1669,1324,1670,207,1229,516,1501,582,742,1472,1120,40,1039,104,976;71;M
36746;1235,907,1229,117,465,1324,207,748,1449,996,891,749,790,40,104;67;F
36750;680,92,907,996,215,1197;62;M
36798;680,40,1440,795,996,1668,796,1209,1669,907,987,675,1197,976,215;66;M
36799;1134,1450,891,1472,796,1669,1268,1449,1219,1668,1259,1120,907,941,1440;24;F
36819;92,748,155,1324;41;F
36824;796,795,748,996,749,1120,891,1449;68;F
36832;987,1450,891,146,1212,749,930,675,1120,1039,976,996,1501,680,941;49;M
36834;950,215,1039,1120,725,1562,1669,1668,92,769,907,40;58;M
36905;1562,1669,465,1449,996,680,891,749,1259,117,1450,1120,1197,976;38;F
36921;1669,748,155,146,582,749;34;M
36922;891,1212,146,749,930,1440,92,907,941,1450,1259,950,1120,40,1039;44;F
36927;40,950,930,1164,891,987,680,582,742,1449,907,748,207,1670,1324;74;F
36948;215,1186,891,40,1209,1436,92,1440,795,1219,680,941,1450,1259,1120;46;M
36955;1268,1713,465,1440,996,1668,1450,1259,1120,976;43;M
36959;769,976,1668,1450,891,749,1259,215,680,1212,996,907,1562,1120,40;45;M
36981;40,1197,215,675,749,1212,987,582,996,1443,907,771,1209,796,1120;15;F
36992;996,907,1669,796,92,1713,1440,769,795,1668,987,950,1120,40,1197;41;F
36993;1219,117,996,1501,742,582,92,748,907,1449,1668,1450,891,1259,1120;65;M
37005;1639,976,1197,1440,680,104,255,1219,1501,1186,987,1450,891,675,215;39;F
37007;1449,582,680,987,1164,891,146,749,930,1120,40,1039,1670,1324,796;75;M
37008;1229;69;M
37011;907,1212,1233,749,1259,1120,40,215,1668,1449,1235,976,680,996,1472;60;F
37024;996,1449,907,796,92,1668,1120,40,465,748,795,680,987,749,215;46;M
37034;1229;71;F
37040;996,117,891,1120,92,1324;36;M
37042;907,680,1212,1259,1205,1120,1039,104,215,1449;51;F
37050;92,1440,255,1443,680,1324,907,950,1120,40;47;F
37064;207,795,255,456,516,155,1219,1668,941,891,146,1259,1197,1039,104;38;F
37065;1229;16;M
37079;1669,92,996,1219,1501,1668,1120,40;27;M
37086;1449,155,215,40,1501,725,1562,796,1669,996,1668,1212,749,1259,1120;54;F
37114;725,1669,1436,92,1268,1440,907,996,1501,1668,941,987,1450,1259,1120;43;F
37127;790,976,1668,155,1713,465,725,796,92,1440,607,680,1212,1259,40;40;F
37144;1324;38;F
37157;749,998,1668,1713,1324,1669,1039,742,255,207,769,796,1562,1443,950;33;F
37185;1259,1450,891,796,1120,996,907;48;M
37188;215,976,1197,1120,675,1450,987,1668,1219,996,907,1268,92,1324,1669;58;F
37189;1440,146;49;M
37206;907,1443,796,1259,1212,215,725,1669,92,996,1501,1668,941,1120,1197;43;F
37207;1443,607,950;47;F
37230;996,680,1212,749,675,1120,40,215,1562,1324,1440,155,987,950,1039;39;M
37244;891,92,996,675,950,1501,1440,255,516,1668,930,907,1120,1197,976;38;M
37254;607,996,1450,950,215;37;M
37272;996,207,145,92,255,907,582,146,1120,40,1039;38;F
37278;769,795,680,1212,1197,976,796,1562,92,1268,1668,987,1120,40,215;33;F
37292;1562,725,1669,1440,607,675,40,1197,215,1670,907,516,1219,1501,976;40;F
37293;749,950,92,796,1669,1120,167,1713;36;M
37308;941,680,1186,996,1449,1443,1440,92,796,748,907,742,1450,1039,1324;40;F
37309;255,891,516,207,1440,92,950,675,1501,1668,930,1120,146,907,1197;37;F
37337;1669,1713,1268,1440,1639,1501,1668,1450,1233,1120,1219,771,930,1259,1039;30;F
37347;907,996;24;F
37352;1562,1324,1440,907,155,996,680,987,1212,749,950,675,40,1120,1039;8;F
37378;1669,117,92,1440,748,795,607,1449,891,749,1120,465,1472,104,1324;41;M
37394;1039,1197,1120,930,749,891,996,1449,1443,907,117,465,1324;42;M
37396;1639,456,1143,680,675,1120,1197,1501,996,516,907,1668,930,1259,976;25;F
37434;941,255,207,145,607,680,146,675;45;F
37449;1562,1324,1440,907,155,996,680,987,1212,749,950,675,40,1120,1039;10;F
37499;950,1713,167;47;M
37506;675,907,255,465,117,748,607,1449,155,680,891,950,1472,790,104;68;F
37535;1324;39;F
37538;1713,1639,1440,907,891,749,1212,796,680,1120,976;51;M
37595;1233;13;F
37609;996,582,1212,675,1120,215,796,1209,465,1440,207,987,749,40,680;37;F
37645;1449;63;M
37646;145,582,680,1120,215,796,771,607,1443,155,891,790,104,748,255;43;F
37656;92,1670,117,465,1562,796,1324,748,1229,516,1443,742,1120,1039,104;40;F
37667;1450,1120,996,796,987,680,976,215,748,749;34;M
37672;155,1668,680,1212,749,1472;42;M
37680;795,996,907,796,1562,1209,1268,1440,582,680,987,40,1039,976,215;32;M
37690;1562,748,1450,1212,1120,796,1449,996,891,1259,749,465,1440,907,680;40;F
37701;1450,1120,996,796,987,680,976,215,748,749;7;M
37710;891,749,1259,1197,215,796,1562,1440,680,1120,40;35;F
37713;996,1186,582,891,749,930,675,1039,1197,1669,796,92,1668,146,1120;42;F
37724;1450,1120,996,796,987,680,976,215,748,749;3;M
37738;1436,680;27;F
37765;607,516,155,1668,742,891,749,207,1449,582,930,1205,790,1120,40;39;M
37766;996,1450,1120,796,987,680,976,215,748,749;30;F
37791;1713,92,769,1443,742,987,1197,1039,976,215,465,1324,1668,1212,950;47;F
37837;215,987,1562,1713,167,1186;55;M
37852;255,950,582,891,1209,1669,1120,104,465,207,748,607,1449,749,1205;60;F
37858;207,748,255,907,1449,996,1186,742,891,1212,749,1205,1472,790,1120;47;F
37865;1324,1039;40;F
37878;582,941,215,1039,40,675,1233,1450,1186,155,907,1440,725,1219,1120;38;F
37885;1562,207,748,607,255,1443,1449,155,987,146,930,950,1205,1039,104;43;F
37899;1259,1440,1268,215,1120,146,749,891,680,1449,1235,607,748,1713,796;39;M
37918;92,117,907,1443,155,996,1668,582,680,941,1450,1259,1120,1197,1039;8;M
37927;790,907,996,1668,891,749,1472,1120;31;F
37933;1039;56;F
37937;795,1668,891,675;73;F
37939;1440,1268,1324,1562,796,155,996,582,680,1120,607,742,891,146,950;37;F
37961;796,1209,145,207,1235,1449,987,675,680;51;F
37968;1713,167;73;F
37995;795,1440,92,1713,1562,1669,1450,1259,40;35;M
38003;748,1669,796,215,1449,1229,145,1562,255,742,146,1039;29;F
38036;1440,748,607,255,1235,516,1668,742,680,146,950,40,1197,1039,104;42;F
38047;207,255,1639,1143,1164,146,1120,1197,976,215;40;F
38052;1670,1669,725,1268,1639,1668,1450,891,930,796,1440,1120,907,1259,516;37;F
38061;465,748,1235,582,749,1197,104,1143,996,1134,795,1449,1668,1205,790;65;F
38095;796,1562,1324,1268,1440,607,155,996,742,582,680,891,146,950,1120;3;F
38101;796,1324,1268,1440,207,255,907,516,582,987,146,930,1120,1039,976;48;F
38145;1713,92,207,255,456,1501,891,146,930,675,215;30;F
38146;748,1268,907,941,796,1713,607,1235,1449,891,146,749,950,1120,215;5;M
38148;1235,516,996,680,987,1259,40,907,891,1212,976;36;M
38156;742,155,907,1229,607,771,1669,255,996,1501,930,1120,1197,516,1668;44;F
38163;1713,1324,1669,1268,1449,891,1209,1440,1219,1450,1164,1233,749,930,1259;43;M
38182;987,1259,1472,1039,976,1562,117,1268,207,907,996,680,1450,215,891;36;M
38255;1229;45;F
38283;1669,1713,795,167;49;F
38290;796,155,742,675,1039,976,1197,215,40,680,1120,1472,465,749,996;32;M
38313;92,907,1668,582,1120,1197,255,987,675,976;25;F
38314;255,456,907,1443,155,1668,582,680,675,1120,215,1562,769,996,950;43;F
38318;117,1268,680,987,891,1259,1120,976,907,516;26;M
38360;1268,1219,1668,1259,1120,215,1197,1039,976,1324,92,1440,1639,680,987;44;F
38361;1562,207,795,456,996,1668,680,987,146,749,1259,950,675,1120,215;47;F
38369;145,207,255,1639,680,987,675,1324;38;F
38375;1443,742;38;M
38396;1039;10;F
38404;1205,1039;34;F
38426;1324,207,907,146,1039;8;M
38427;1039;6;M
38441;1669,987,1120,795,1562,1713,769,145,146,950,675,40,1197,1039,215;39;F
38442;40,976,215;30;F
38445;1039;5;F
38452;1039;63;F
38456;1039;42;F
38466;155;19;F
38472;215,796,680,1120,891,996;40;M
38484;796,92,607,155,1668,987,950;50;F
38489;155;49;M
38497;1440,1324,1209,796,255,207;47;M
38499;1436,1268,207,795,516,680,941,1450,1259,976;28;M
38514;769,1268,92,117,1562,1039,40,950,930,146,1668,1219,748,465,1324;43;F
38515;1562,1669,1324,1268,92,1440,748,1501,998,891,146,950,1197,1039,795;46;M
38526;907,516,996,680,941,1450,976,891,1259,1120;40;M
38559;771,1440,907,996,40,796,1235,680,941,891,1212,749,1472,976,1120;35;M
38566;1324,1639;39;F
38611;749,40,215,796,1209,771,795,907,155,930,1120;27;M
38622;1324,1639,1039,976;9;F
38630;907,1670,145,207,516,987,1450,146,930,1259,675,1120,1039,976,215;45;M
38649;891,941,1501,996,907,1670,516,1668,987,1450,146,675,1120,976,215;69;M
38654;1501,996,1268,1670,207,516,987,1450,146,930,1259,1120,1039,976,215;65;F
38655;1713,1440,1449,1186,930,1205,1120,104;19;M
38662;1440,607,907,996,680,891,1450,941,749,1259,1120,1197,92,1562;32;F
38667;1209,675;70;M
38682;1669,1219,1501,1668,941,891,749,1259,1120,1197,976,795,92,1440;66;F
38684;92,1449,987,749,675,1120,1197;33;F
38696;155,607,1713,1268,1668,145,1443,941,987,891,146,1039,976,215,950;30;F
38712;1562,1713,1268,769,996,680,891,1039,215;35;M
38729;465,92,795,907,950,790,1449,1501,582,680,891,1212,749,1120,40;27;F
38731;1501,891,146,215;44;F
38779;1229,1639,796,1562,465,1268,117,92,1436,1324,1670,1440,516,1450,1259;37;F
38828;1120,255,1229,155,891,146,1233;51;F
38841;907,680,146,930,215,1120,976,675,987;44;F
38849;456,117,465,796,941,1212,1197,104,1209,207,748,255,1449,146,1233;45;F
38888;1713,1268,1668,950,167;50;F
38906;167;56;M
38952;465,748,1443,1449,891,146,749,1205,1472,1120,790;34;M
38961;742,1501,996,1449,1229,465,796,1669,92,748,1443,1668,749,40,104;30;F
38963;1268,795,907,155,950;48;M
38982;155,907,207,92,117,1209,516,1219,1501,1668,987,146,675,976,215;35;F
39002;976,987,1501;35;F
39021;1120,1669,1562,465,1268,207,516,1449,146,976,215,1259,1670,1440,680;33;F
39063;1713,1669,795,607,907,582,146,1259,675,40,1039,891,1670,930,516;28;F
39065;1268,1324,742,117;44;M
39103;725,92,1440,987;27;M
39111;1449;33;F
39123;1209,207,582,930,104,748,1449;75;F
39146;950,607,1209,1562,1670,1713,1268,1197,1669,1440,1501,1668,1212,146,1120;35;F
39147;117,1436,1440,996,1501,987,1212,749,1259,976,907,1669,1668;34;M
39170;1120,465,92,1440;33;M
39173;1562,1324,1713,1440,207,907,1443,998,1197,790;17;F
39200;92,796,748,607,1449,155,996,1134,1668,582,680,1120,40,104,1039;41;M
39226;1501,1443,465,796,907,1449,996,1668,1450,1212,1259,749,1120,40,215;32;F
39231;1562,987,40,771,145,1268,92,1713,1440,795,996,680,1120,215,976;29;M
39241;1259,1450,987,795,1268,1209,207,255,907,680,675,215;61;F
39262;1562,1669,1668,680,950,40,1039;47;F
39271;582;45;F
39274;1713,796,1440,795,907,1449,996,680,1450,891,749,1259,1120,976,215;53;M
39299;1268,907,1120,976,215,1440,1443,742;38;F
39302;1669,1440,1639,996,1219,1501,1668,1450,1212,1259,1120;38;M
39339;941,1212,1259,1120,1197,1669,1450,1219,987,930,771,146,92,976,215;27;M
39343;675,1120,215,907,996,1501,987,930,976;38;M
39356;1449,1443,516,771,1324,1209,1197,146,1668,1143,907,1440,92,465,1669;44;M
39366;996,1440,607,255,465,1669,207,748,795,907,1668,680,749,950,40;29;F
39385;675,930,891,1186,1449,207,1440,1713,1209,255,1235,790,1197;30;F
39422;582;38;F
39448;155,1212,1120,891,796,790,769,749,680,465,675,607,516,456,255;30;F
39466;255,582,1205,675,1120,1669,907,996,1450,1212,1039,104;38;F
39471;795,987,749,1259,1197,796,1562,465,907,1449,1668,1120,456,155,104;61;M
39521;92,1440,907,996,680,1197,976;41;M
39565;607,155,680,950;35;F
39586;1670,1440,907,516,680,987,891,749,40,976;35;M
39603;1670,607,795,891,941,1268;32;F
39670;207,996,1219,1233,1120,215;60;M
39687;796,1669,92,748,607,1449,996,1668,582,891,146,749,1205,790,1120;30;F
39702;40,749,1449,748,1235,680,1233;39;M
39756;104,1669,1229,167,996,1668,742,1324,207,255,907,1443,582,950,1039;43;F
39757;907,796,891,749,1472,1120,215,1562,941,1450,976,465,117,680,1233;29;M
39849;465,795,1235,1219,582,891,749,1205,790,1120,92,207,748,607,1449;48;F
39852;92,1440,1639,155,996,1501,749,1120;54;M
39874;749,1713,1670,465,1259,40,215,1197,950,1219,607,795,1324,1562,117;56;M
39887;92,40,976,1440,907,996,680,941,987,1450,891,1212,1259,675,1120;33;F
39908;941,215,891,1212,1259,1120,1450,582,1219,996,1449,907,987,976,516;32;M
39923;996,742,1668,582,1209,1440,207,255,987,1450,891,1212,1259,675,1120;28;F
39965;117,1669,1562,1449,891,1233,790,40,976,796,465,1440,907,516,742;27;M
39969;748,582,680,891,749,675,1120,976,1324;40;M
39977;1668,941,1233,1197,796,907,996,987,1450,891,749,1259,1120,40,1440;34;M
39980;117,207,771,1268,92,465,1443,1449,1668,987,1212,1233,1259,796,215;20;M
40014;1219,1501,1668,742,582,891,1212,146,749,930,675,790,1120,40,1039;32;F
40023;215,255,1440,1259,930,1229,1472,516;34;M
40033;255,1472;23;M
40050;996,92,1440,748,907,1235,1449,1668,582,680,987,891,749,790,1120;36;F
40077;146,996,1235,207,145,1436,1670,1209,1440,907,680,1450,891,1259,1120;33;M
40113;675,1205,1212,1164,742,1186,1443,1229,255,207,465,725,987,146,1039;39;F
40122;167,1713;68;F
40129;1268,795,907,996,1219,941,1450,891,1259,675,1120,607;68;M
40133;1324,155,675,1472;44;M
40146;155;67;F
40150;796,1713,996,1501,1668,582,987,1450,749,1259,1120,976,215;35;M
40155;1713,167;95;M
40158;796,1713,907,1449,996,582,1450,749,1259,1120,215;40;M
40169;1143,950,582,1197,1039,987,1164,1259,907,1443,1219,941,1450,930,1670;39;F
40176;1209,771,456,907,1449,582,1212,930,1120,795,1443,1229,92,996,725;50;F
40180;796,1713,207,748,1443,1668,680,987,891,1212,749,1259,1120,976,215;43;F
40188;146,1233,749,1259,675,1120,40,976,1209,117,1713,255,941,987,215;27;F
40190;680,987,891,146,1120,976;50;M
40196;104,255,1670,207;66;F
40279;145,748,1449,996,742,117,582,680,207,907,796,891,1212,749,1120;38;F
40373;145,207,996,680,891,1212,146,1120,1039,742;30;F
40375;215,976,1039,40,675,950,996,145,1562,907,146;35;F
40387;1212,930,1197,1443,1669,155,1501,1668,987,1120,215,976;31;M
40395;907,1219,941,1450,891,675,215,996,582,987,1120;24;M
40451;465,795,255,907,516,1443,996,1501,1668,1186,146,1120,1449,891,790;37;F
40456;680,1235,1449;48;M
40474;1668,680,1164,1472,1669,1713,1670,1562,796,675,987,1186,1449,907,1143;31;F
40484;907,941,1450,1259,1120,1039,1501,976,215;30;F
40499;1562,1670,92,1268,769,795,155,167,998,950,40;47;M
40556;1436,117,465,796,996,680,987,1450,891,1212,749,1259,950,1120,40;34;M
40562;1713,675,996,1443,465,92,1212,749,1120,907,771,456,1449;36;F
40567;1501,1164,749,976,215,1669,92,795,1143,1443,1668,680,987,1212,40;47;F
40571;1668,1639,255,207,1324;13;F
40586;748,1186,1668,987,891,1259,1120;70;F
40587;795,607,771,456,1449,155,1186,582,950,1713,1268,255,891,1259,1120;29;F
40590;941,1668,1501,996,1449,1443,516,907,1229,1669,92,207,146,930,1259;44;F
40599;941,891,1440,516,1450,1259,1120,976;33;M
40603;742,1259,1205,1120,1039;40;F
40679;796,891,987,255,748,145,1440,1669,215,930,1450,1668,795,1670,516;35;F
40682;907,92,1669,725,796,1143,996,1668,582,1164,1259,1120,40;49;M
40704;1669,1713,92,907,996,1501,1668,941,1450,891,1233,749,1259,1120,40;29;F
40711;207,1436,255,1164,516,1443,1449,155,1134,742,987,1450,891,1259,976;27;F
40713;1235,1268,1670,1562,465,167,998,742,1436,769,748,1229,516,1472,790;38;F
40829;516,996,987,146,930,675,1197,976,215,907,456,255,1501,1120;32;F
40833;771,907,891,795,796,1668,1501,1449,1443,1197,749,1440,987,680,40;39;M
40843;1233,749,1259,215,976,1120,582,1668,996,907,795,117,92,1443,987;32;M
40898;1186,1449,145,465,207,795,907,582,930;65;F
40937;1443,907,1669,1209,104,1197,92,117;66;F
40940;1268,1212,1472,1209,725,92,769,155,1219,1233,1259,1120,40,1039,104;71;F
40968;146,771;34;F
40976;92,795,155,1668,40,1197,976,215,796,950;39;F
40990;1440,1639,907,1143,516,1134,680,987,1164,976;39;M
41015;907,996,987,1450,675,92,1501,1668,1259,146,950,1120,40,1039,976;45;F
41018;950,207,155;11;F
41021;255,907,516,155,996,1219,998,582,941,1450,891,1259,675,1120,1197;29;F
41031;207,155,950;8;M
41038;1229,1501,891,1039,92,1436,1669,1639,907,1668,987,1450,1259,976,215;36;F
41046;987,1212,675,796,92,1440,748,795,907,996,582,891,930,1259,1120;57;F
41097;907,996,1501,1668,582,941,1450,891,1212,749,1259,1120;39;F
41101;255,907,1449,996,1668,891,749,930,790,1120;16;F
41148;582,680,607,145,1268,1669,465,748,1449,146,930,950,1205,1039,104;7;F
41151;795,796,1669,1713,92,1440,607,1443,1668,742,891,1212,950,1120,1039;43;F
41161;1669,748,996,582,1450,1120,207,907,680,891,675,1039,1324,1268,1440;18;M
41167;215,465,748,795,1143,1449,680,987,891,1164,1212,749,1120,40,104;22;M
41170;1440,795,976,907,516,1501,1668,891,1120,215;42;M
41184;891,1197,215,516,1450,1120,92,996,1669,1501,1668,987,146,1259,976;43;F
41193;207,795,1229,742,680,146,1233,1039;50;M
41211;795,117,465,1209,1268,987,1259,516,1501,582,1450,891,675,976,215;57;M
41227;145,795,255,1639,516,1449,1501,987,891,146,950,1120,40,1197,976;25;F
41228;1440,1639,987,1449,1197,796,1669,1450,1259,976,215,1668,891,1120,146;37;F
41229;607,795,771,1268,117,725,1562,1713,207,1443,40,1501,582,675,1197;15;M
41232;1449,996,1501,742,582,941,1450,1164,1212,1233,749,1120,748,255,104;46;F
41239;907,1450,516,795,1268,1436,1670,680,941,987,1259,1120,40,976,215;35;F
41241;1501,1668,941,1450,891,1233,749,1120,1197,976,215,1209,1219,1259,675;32;F
41262;1501,1668,891,1212,146,749,215,1472,790,795,748,1713,117,1324,796;19;F
41282;748,796,1209,1440,1449,1186,582,146,1205,675;39;F
41285;996,1259,790,1120,215;32;M
41309;1440,1449,680,749,795,996,742,582,891,796,1669,92,1668,1120,40;43;F
41323;465,796,1669,92,748,607,255,155,1668,749,1205,1120,40,1039,104;41;F
41347;795,607,1143,1235,1449,1668,891,1164,749,790,1120,40,1197,976,104;68;M
41405;987,891,1212,146,1233,749,1259,675,1120,40,1039,976,104,215,950;53;F
41409;680,891,1259,675,1120,40,976,465,92,748,1449,155,749,950;41;M
41412;1197,930,907,1669,1713,796,92,1449,996,1219,680,891,749,675,1120;69;F
41416;930,987,1229,725,465,1440,1219,742,675,1039;36;F
41426;516;37;F
41432;796,748,1229,907,1235,1443,1449,1219,742,582,891,146,749,790,1120;37;F
41446;92,1668,680,104,1209,207,987,1205,675;40;F
41447;146,742,1233,749,907,1639,796,1562,117,1713,769,207,167,996,40;35;F
41452;207,748,255,1449,1205,675,40,976;49;F
41455;1186,1669,1259,1639,996,1443,795,1713,725,1668,1472,1212,1233,1120,215;53;F
41457;516,996,1450,1212,1259,1472,1039,976,207,907,1443,1501,987,675,1120;45;F
41460;215,976,950,891,155,516,1143,465;32;F
41469;996,1501,1668,582,680,40,976,215,796,1669,92,891,749,1120,1197;32;M
41479;930,976,675,215,796,1670,1440,795,907,996,1219,1668,1501,1450,1120;39;M
41494;92,1668,950,1120;44;F
41532;795,675,907,1235,1443,996,582,680,987,215,1449,891,749,790,1120;15;M
41558;1668,996,907,92,796,1501,680,941,1450,891,749,1259,1120,40,1197;37;M
41582;1669,987,976,215;58;M
41610;1449,996,1668,582,749,1259,1197,976,92,795,987,891,1212,1120;32;F
41624;1120,996,795,1268,1713,1562,215,1164,1143,92,796,155,1668,950,675;70;F
41632;796,92,996,1501,1668,582,941,1212,1120,976,456;30;M
41649;941,987,891,675,1120,215,1670,92,1268,1501,1668,680,1259,40,976;33;F
41655;1268,207,1443,742,680,146,930,1472,1120;44;M
41702;1440,1268,1669,465,145,1229,907,1668,146,1233,930,1259,1472,1120,1039;34;M
41789;1501,996,907,891;35;F
41792;456,155,996,1668,680,1212,1472,1120,1197,771,748,1449,146,1205,104;34;F
41807;769,748,907,1143,996,742,146,1205;39;F
41817;796,1669,748,1668,146,749,40;36;F
41846;748,207,769,465,1440,255,516,1449,749,675,1472,790,1120,1197,1039;31;F
41854;930,976,941,796,1670,1440,1639,907,1501,680,987,891,1259,1120;30;F
41855;1268,1143,1450,1164,930,1259,675,215,207,996,1219,1668,941,891,1120;77;M
41873;941,1450,1259,1120,40,1039,1436,1268,1639,1219,987,146,930,675,976;42;F
41888;680,987,996,907,795,748,796,40,1713,607,582,891,749,1120;40;F
41945;255,207,1440,92,796,146,1039;33;F
41966;1443,465,117,92,207,255,891,1212,749,1120,40,976;36;M
41973;1259,1197,1440,117,796,987,1120,40,976,215,1669,1670,92,795,1668;37;F
41977;215,976,40,1713,796,582,117,1120,1212,748,1449,790,1440,680,749;28;M
42034;516,1449,996,1501,680,987,1450,891,1212,930,1259,976,1668,1120,215;45;F
42054;1197,1501,907,1639,1670,796,930,941,1440,680,987,891,1259,1120,976;31;M
42090;145,1443,155,996,1668,742,1450,891,1472,790,1669,987,1120,1039,976;29;F
42108;1669,1713,907,996,1668,1259,675,1501,749,1450,92,1562,796,1120,40;28;F
42112;790,1668,607,465,1713,796,92,907,1449,996,582,891,749,1120,215;48;F
42170;255,207,1440,1268,1669,1209,795,582,987,675,1120,976;30;F
42171;1562,1669,1324,680,987,675,1039,215;46;F
42172;796,1562,1713,1268,769,1443,215,996,582,680,987,950,1120,976,1039;47;F
42190;1120,675,930,749,146,1450,987,1501,996,255,1268,1436,1639,976,215;67;F
42192;40,950,1449,92,1562,1669,1235,1668,680,749,790;28;M
42216;1205,1120,40,1197,1039,215,465,207,996,891,1212,1259,675,790,930;48;F
42241;145,1669,92,1639,907,996,1501,1668,680,1450,891,749,950,1259,1120;38;F
42246;1324,1440,255,1235,167,1668,582,680,950;49;F
42275;465,1440,907,1501,680,1212,790,1268,516,1450,987,891,930,976,215;18;M
42282;40,976,987,680,998,1186,155,1639,748,1324,465,725,516,950,215;46;F
42289;1713,92,1440,907,1235,996,680,987,891,749,1259,1120,215,725,976;32;F
42296;92,1268,771,255,907,1501,987,1450,1120,1197,976,1669,1668,146,675;41;F
42299;104,582,996,1669,92,748,795,1235,1449,1219,1668,891,680,749,1197;42;F
42308;215,1713,796,795;64;F
42320;1669,92,748,607,1449,996,1668,1186,582,891,146,749,1205,790,1120;36;M
42327;146,1450,996,907,1440,465,1233,1120,742,1443,795,1268,796,725,675;65;F
42361;998,941,1233,1669,1436,1229,146,1039,104,40,215,1197,748,92,1668;70;F
42370;907,1440,771,795,607,255,1443,1449,1668,104;44;F
42394;1449,1186,891;78;M
42410;748,1669,465;72;F
42423;907,1229,207,92,950,976,742,680,891,1259,1120,1197,1669,1668,941;50;F
42444;1450,1259,795,796,1209,117,1268,1440,907,996,680,987,675,1120,215;38;M
42445;796,1713,1443,1449,1501,941,891,1639,907,996,1450,1212,749,1259,1120;65;F
42452;1639,996,1450,891,1120;54;F
42472;796,465,1669,92,748,1449,1501,1668,582,891,1212,749,1472,790,1120;78;F
42487;1268,996,749,40,104,1120,891,582,1668,1449,1443,907,795,92,1669;51;F
42491;1197,891,987,941,582,1501,1235,907,607,92,1436,1670,1209,1562,796;38;M
42540;996,907,1440,465,1669,92,748,1449,1668,582,891,1212,1472,790,1120;77;M
42552;907,117,1209,465,1669,92,1440,748,1235,1449,1668,742,680,146,930;4;F
42559;1440,987,1450,891,1259,950,1120,40,1039,976,215,1562,1268,795,680;36;F
42628;796,92,907,1443,996,1668,1120;33;F
42630;1669,207,607,996,1134,1219,1668,1186,1233,930,950,1472,1197,104;34;F
42641;1450,1259,1120,1197,117,1668,680,891,1039,1268,987,675,40,976,215;35;F
42645;891,790,976,104,907,1229,796,465,1501,1668,582,680,987,1212,40;33;F
42677;1713,996,1668,1120;30;M
42697;771,145,795,155,996,675,1120,1197,1039,950;42;F
42701;117,950;55;F
42705;1440,1450,1259,976,1120,930,146,987,582,1219,996,155,456,255,145;38;F
42714;796,40,215,1212,748,680,749,976;49;F
42738;1197,996,1501,1259,749,1120,795,1436,796,1562,987,680,40,976,215;21;M
42782;891,987,680,907,1436,117,465,1268,1450,1259,675,1197,1039,976,215;68;M
42796;92,1440,996,1668,987,1450,1259,1120,215;32;M
42819;1259,675,1209,1669,92,1440,1443,996,680,146,516,1501,1668,1120,1197;36;F
42821;104,796,1562,907,1120;46;F
42825;1164,987,155,145,1209,675;34;M
42827;1450,996,907,1713,1669,725,796,1449,1668,891,1259,749,1120,1197,40;43;F
42887;795,1235,1668,796,465,117,1449,996,582,680,891,1212,749,790,40;36;F
42888;1219,1134,582,891,146,207,907,1143,1186,790,255,996,1164,1205,104;28;F
42898;465,1669,117,1713,92,1440,907,516,155,996,1501,1668,941,1450,1259;38;F
42911;145,769,771,207,465,1639,1219,891,146,1120,1197,1039,976,215;37;F
42919;1209,117,92,1219,1259,1450,941,582,996,907,1164,675,1120;31;M
42921;796,465,1713,1268,1440,907,1443,1449,996,987,891,749,1120,976,215;21;M
42952;207,155,749,796,725,1669,907,996,1668,680,987,675,1120,40,215;81;F
42967;167,891,950,1562,1440,749,465,1449,680,1235,1233,1472,790,1120,976;33;F
42976;92,117,1324,465,1562,796,155;68;F
42997;465,1440,167,680,891,749,790,1120,976,1472,1449,1235;32;M
43004;465,1670,207,1449,996,1186,1450,146,1205,1472,790,1120,1197,1039,1229;33;F
43013;795,796,1209,1669,92,1668,987,749,675,40,1120,976,215;66;M
43018;155;74;M
43050;465,117,92,907,1443,1668,582,941,1450,1212,1259,1120,1197,1039,976;42;M
43051;1209,1440,795,145,748,607,255,1449,155,1134,1186,146,1205,675,104;45;F
43091;950,675,1197,207,516;48;F
43104;725,1039;46;M
43115;1268,796,1713,907,976,40,1668,795,92,1209,1669,987,675,1120,215;64;F
43122;207,742,146;39;F
43145;146,215,1669,117,92,907,1501,1668,987,1450,891,1259,675,1120,976;57;M
43176;725,1039;12;M
43202;725,1039;14;M
43236;725,1219,996,1450,1443;38;M
43279;790,891,1449,255,607,1669,465,1209;23;F
43293;1259,1501,749,1212,796,92,795,907,1449,996,1668,891,790,1120,1197;33;M
43308;742,155,1440,941,104,1443,1219;34;F
43318;748,941,891,1212,40,796,795,907,996,1450,749,1259,1120,976,215;25;F
43368;796,465,1449,996,891,749,1205,1472,790,1120;64;F
43375;1440,607,1713,790,1268,516,465,117,725,680,215,769,167,40,1562;32;F
43382;1209,748,516,1039,891,1443,1450,465,1440,1436,769,1562,796,1268,795;29;F
43390;1039,891,1259,675,40,796,1713,907,996,680,146,749,930,950,1120;34;M
43408;1259;21;F
43411;146,930,1205,675,1472,790,1120,1039,465,748,607,255,1449,155,104;68;F
43441;907,1443,1501,1212,1259,1472,1120,1324,795,1449,996,891,749;45;F
43444;1143,255,207;78;M
43470;1197,976,749,1668,996,1449,92,1669,215,465,941,1450,891,1259,1120;66;F
43488;891,1436,769,1450,1259,465,1669,1268,907,996,1668,1120,40,976,215;27;M
43518;1268,742,1472,1197,1039,748,907,1449,1450,891,1212,146,749,1259,1120;43;F
43529;930,1472,215,1669,1670,516,680,941,987,1450,146,749,1259,1120,976;36;F
43544;748,1143,1164,207,255;78;F
43571;795,907,516,1450,1472,117,996,1212,675,1197,1120,987,891,976,215;33;M
43576;748,92,907,167,1212,1668,891;55;F
43590;987,680,1449,907,207,1440,1436,1713,796,465,795,941,215,1268,117;23;M
43638;1209,465,145,207,748,255,680,582,1449;41;F
43644;40,976,215,796,92,1440,795,255,907,1668,146,1120,1209,1443,742;40;F
43660;996,1668,987,675,1197,215;38;M
43681;680,941,1212,146,92,1268,1440,1443,930,1259,1120,40,1197,1039,215;39;F
43689;796,117,92,145,255,516,907,155;43;F
43690;907,1440,796,1443,996,680,941,1197,1039,976,1120,1259,749,891,1501;37;M
43714;749,1259,976,742,1212,891,215,1120,725,796,1443,1219,941,1039,1233;69;F
43749;987,941,146,1259,1120,976,104,215,1450,1186,207,725,1268,1219,1134;18;M
43751;1670,1268,1440,1639,907,1450,725,1436,1219,941,891,1120;27;M
43770;725,1669,92,607,1501,1668,582,987,1450,1259,950,1120,1197,976,215;25;F
43787;1440,1670,1268,1713,117,1324,465,796,207,748,1235,1443,891,1233,749;39;F
43791;796,1450,465,1212,1440,1268,1562,92,680,987,749,1120,40,976,215;42;M
43793;1164,146,1039;40;F
43807;1562,465,117,996,680,941,1450,1259,1120,1501,976;44;M
43825;996,1501,146,1259,1120;46;F
43833;796,1669,1268,456,1443,996,1668,1212,976,1562,771,930,950,1120;21;F
43836;1436,155,996,742,941,1450,891,1212,146,1233,1259,1120,1197,976,215;36;F
43840;796,255,891,1212,675,790,1120,104;49;F
43846;725,1449,907,607,1268,465,1669,92,996,1501,1668,1450,749,1259,1120;47;F
43873;930,1120,976;27;F
43876;891,1197,1669,907,1120,1450,1259,92,1668;34;F
43916;950,749,1443,907,255,796,1669,92,996,1668,941,1450,891,1259,1120;42;F
43921;146,1668,742,680,941,987,1450,1259,1120,1039,795,930,675,976,215;34;F
43922;1443,749,40,796,92,1440,1668,680,987,1212,675,1120,1197,1039,976;33;F
43927;1134,456,1639,795,1324,725,771,748,255,1443,1219,1501,941,146,1233;68;F
43946;950,907,607;42;F
43951;1440,1436,1268,907,516,155,996,1219,998,1450,1259,675,1472,1120,976;53;F
43965;1219,1668,941,1450,146,1259,1120;42;M
43981;1668,582,1197,1039,1209,1268,207,607,255,155,987,1164,950,675,1120;21;F
43987;748,207,769,92,117,465,907,1449,996,1501,1668,891,749,790,1120;49;F
43998;976,675,1259,987,1450,941,1668,516,92,1670,1669,207,1120;70;F
44044;769,1449,1501,1186,582,891,1212,1259,40,1039,215,255,456,907,1120;45;F
44047;582;38;F
44052;582;44;M
44101;987,1259,1668,1501,796,725,1669,92,996,891,1120,976,215;56;F
44106;92,1668,891,749,1197,1120;36;M
44165;92,207,748,795,255,1229,456,1143,996,1501,1668,742,146,950,215;50;F
44166;516,255,1440,748,996,796,1212,976,1713,1120,891,92,749,465,790;40;F
44173;725,1039;31;F
44217;680,1449,1235,607,795,207,145,465;40;M
44223;1713,996,987,749,40,976,215,167,1668,1212,1120,796,795,680,117;36;F
44247;907,996,1501,1450,749,1669,92,516,1668,891,1120,941,1440,1259,215;24;F
44279;215,1039,1120,950,1668,255,92,1324;43;F
44289;796,907,1449,996,1501,1668,987,891,1212,749,930,1259,675,790,1120;32;F
44301;92,907,996,1501,1668,582,941,1450,891,1212,1233,749,1259,1120,1197;30;F
44304;167;35;M
44307;1235,1449,987,891,1205,675,215;15;M
44316;456,1443,1668,941,1450,146,1259,1120,796,771,907,996,1501,891,1212;20;F
44321;796,1268,1440,996,1668,582,987,749,1259,950,1120,40,1197,976,215;30;F
44343;1235,680,1120,891,582,996,749,1449,1450,1436,1440,215,987,976,1212;34;F
44356;1259,1233,1450,1449,907,92,1209,1229;44;M
44357;749,1233,146,1668,582,796,907,1443,996,1501,941,1450,891,1212;26;M
44366;155,516,1440,1209,771,907,680,987,1450,1259,1120,40,1197,976,215;33;F
44387;1209,145,796,795,996,1219,1501,1668,1450,1212,146,1233,1259,1120,675;31;F
44390;215,771,749,790,465,92,748,1235,1449,104;67;F
44408;941,742,996,1449,907,1229,92,1713,1324,1669,1209,1501,1443,795;33;F
44425;1259,1197,207,145,771,1440,92,1209,1449,1134,582,891,146,749,1120;33;F
44478;1450,749,1197,92;46;F
44512;1440,941,1212,40,976,215,1436,1259,1039,769,1268,796,1120,749,680;28;M
44518;1669,92,1668,1450,1259;43;F
44524;1436,516,146,1501,1669,771,795,456,1668,987,1450,1259,675,1120,976;36;F
44527;930,1668,516,92,1670,1669,255,1219,891,976;45;F
44528;749,976,1120,950,987,996,1562,92,1268,1440,795,155,680,40,215;43;F
44530;145,456,1449,996,1501,1668,582,941,987,1450,1259,675;21;F
44566;1669,1436,92,1639,1229,907,1501,1668,987,1450,891,1259,1039,976,215;65;M
44581;1143,582,1212,749,92,748,1449,1668,891,146,1205,1472;35;F
44609;749,1472,117,996,582,146,1259,1120,796,92,1219,987,1450,976,215;29;F
44620;215,976,675,516,1120,907,996;24;M
44628;1209,255,1639,907,1186,680,1450,749,675,1120,1197;24;F
44629;207,1235,996,1219,742,582,1450,1212,1233,749,1259,1120,976,255,1039;34;F
44633;790,796,1562,465,255,1229,1449,996,742,582,680,1197,748,891,749;44;M
44653;891,465,92,771,748,1235,1449,749,790,104;67;M
44693;907,996,987,891,1212,1120,976,215;29;F
44701;996,680,146,749,907,255,748,207,1440,1713,1324,465,1562,1205,1039;47;M
44706;1440,987,607,155;56;M
44716;976,796,207,795,907,742,680,1212,1259,215,1440,996,1450,1120,1039;40;M
44727;769,255,907,996,215,1197,1669,1713,795,1668,680,950,675,1120,40;29;F
44746;155;70;F
44748;207,1120,996,1259;35;M
44749;456,1443,155,675,40,582,1668,92,1669,1713,145,255,1449,996,1120;26;F
44770;1713,1440,207,907,1449,996,680,1450,146,749,1259,1205,1324,1120;40;F
44775;996,1501,680,891,749,1120,1197,796,725,92,1668,987,215,1212,976;35;F
44782;1120,749,680,582,996,1449,1443,907,748,207,769,1440,92,1713,1562;8;F
44844;1669,92,1639,996,1219,1668,987,1450,891,1212,749,1259,1472,1120,215;74;F
44850;742,582,680,891,1450,987,941,996,1235,907,749,1259,1472,1120,976;37;M
44853;769,1268,465,1450,749,1259,1120,40,907,680,987,976,215;54;F
44860;155;61;F
44895;1562,1440,207,255,680,146,1039,1324,215;36;F
44910;1229,1235,155,1186,1205,1120,1449,907,255,748,465,796,145,456,146;40;M
44916;891,796,465,1268,207,1235,1443,996,742,987,1472,1120,1039,976,215;36;M
44923;891,796,1669,145,207,907,1443,1449,996,1668,1205,146,749,1120,104;34;F
44964;1219,1233,749,950,465,1440,207,907,941,1450,891,1212,1259,1120,1197;43;F
44976;1143,996,582,987,1197,1449,1668,680,891,1212,146,749,950,1120,40;41;F
45014;1229;69;M
45016;1233,891,749,796,907,950,1259,790,1120,215,1669,92,607,155,1668;62;M
45031;987,941,680,582,1443,1268,465,796,771,907,1143,996,1668,1212,1120;19;F
45045;92,907,796,516,996,1501,1668,680,941,1450,749,930,1259,976,215;44;M
45072;748,1440,1669,1205,1120;35;F
45087;1440,1501,465,996,907,1219,941,1450,891,1212,749,1233,1259,1120,1197;72;F
45110;1212,1197,907,145,996,1259,1120,1668,1229,796,1443,92,1235,749,1472;33;M
45115;1197,1120,675,1450,941,1186,1668,1501,996,907,771,92,117,1669,796;20;F
45117;907,795,1440,1268,465,1639,996,680,987,1450,1259,675,1120,976,215;44;F
45134;1668,1120,1134;37;F
45142;1209,1440,207,748,516,680,987,1450,930,1259,675,1120,1197,976,215;39;M
45144;1259,1120,40,215,465,1268,1440,255,1219,941,1039;34;F
45197;516,1219,40,1259,998,255,891,976,725,1669,92,1501,1668,930,1197;29;F
45199;907,1669,92,996,1668,891,749,1120,950,607,155;46;F
45215;582,1443,1449,155,1668,742,891,1212,146,749,1205,950,930,207,255;39;F
45245;930,1212,1449,1501,92,607,749,996;24;F
45248;1324,1440,1639,456,1449;45;M
45252;146,725,680,1259,675,1669,92,1268,795,907,1501,1668,1120,976,215;50;F
45264;1197,1669,748,1449,891,749,607,1219,1668,1233,950,92,155,215;57;F
45312;1120,749,1212,680,998,1668,996,167,1235,907,769,1268,1713,1562,796;49;M
45326;465,1209,725,207,255,907,941,1450,891,1120,1039;42;F
45334;1449,155,742,749,1120,976,680,987,146,675,1039,215,1562,769,950;33;F
45341;1120;21;F
45355;1134,582,146,92,769,1639,1501,1668,891,749,1259,790,1120,1197,976;51;M
45357;796,1669,582,930,1120,1197,795,1668,987,1259,215,976,675;39;F
45358;1669,1713,1639,907,1472,1259,1212,1450,516,92,996,998,1120,40,1197;29;F
45384;941,1212,749,796,1669,1713,92,255,907,996,1668,891,1259,950,1120;24;F
45414;255,1235,1501,996,680,465,907,1449,1120,891,749,790;42;M
45422;104,1197,40,675,680,1219,795,1440,1713;50;F
45439;40,215,976,680,1501,1449,1235,117,891,1668,996,1440,92,796,1120;28;M
45441;941,1450,1212,749,1259,1120,796,748,996,582,680,987,891,40,1197;39;F
45442;1639,1449,40,1120,930,891,255,215,976,680,996,1670,907,1440,516;34;M
45448;1209,255,1235,680,1212,675,1039;38;F
45449;1639,1259,1197,1120,996,1450,1669,456,1668,907,207,516,465,92;66;F
45467;1669,987,104,215,1449,465,92,607,1668;52;F
45476;987,1501,1670,907,516,941,675,1120,1197,976,1669,1668,1450,891,1259;57;F
45493;1713,1440,795,1668,987,675,1197,1562,950,976;31;F
45502;1259,1197,1120,987,976,675,1450,1669,1668,907,92,1501,145,146,749;61;F
45510;1197,1212,1259,1120;29;F
45516;215,796,1562,1669,117,1713,1268,769,167,1668,680,146,1120,40,1197;55;F
45534;891,1233,749,930,950,1039,215,465,1268,907,996,1450,1259,1120,976;36;F
45550;725,1209,465,1713,255,996,1219,582,680,930,675,1120,215,907,1449;30;F
45579;987,976;35;M
45594;1449,996,1501,941,987,1450,891,749,1259,675,1197,215,976,796,1120;31;M
45613;215,987,1501;32;F
45618;1440,1259,796,1209,1713,207,607,1143,907,1449,155,950,675,1120,1197;34;F
45624;796,117,255,907,950,465,1449,1205,790,1120;39;F
45625;1501,680,1259,1472,1120,40,976,987;31;F
45631;1450,749,930,1039,215,796,1440,907,996,1668,987,146,1259,1120,976;26;M
45643;1449,891,146,675,1205,790;31;F
45661;1713,1197,215;64;M
45662;1209,796,1440,907,1501,891,1259,675;27;F
45684;1268,1440,607,1235,680,891,950,675,790,1120,1197,1039,976,207,1233;45;M
45701;92,145,1501;38;F
45729;1120,215,1436,1324,796,1669,117,92,1440,516,1668,680,987,1197,976;53;F
45745;1713,1669,796,92,996,1668,582,1450,891,749,1259,950,1120,1197,1039;14;M
45747;1219,725;63;M
45766;796,907,996,1668,1120,1197;67;F
45770;215,976,1039,1450,941,742,1501,92,516,167,749,1259,1472,675,1120;66;M
45819;1501,1443,907,1229,1440,725,92,996,1668,742,891,146,749,1259,1120;41;F
45837;796,1440,1449,680;27;M
45862;796,215,1186,1235,1449;37;F
45866;1219,987,675,215,748,742,891,146,145,207,255,516,1259,1039,976;37;F
45873;907,996,1219,680,941,1450,891,1259,1120;26;F
45915;1235,907,255,92,796,680,582,1668,1501,1443,1449;38;M
45917;742;43;F
45951;771,941,680,155,1259,1120,1450,996,907;35;F
45956;976,1039,1197,1120,1259,749,1212,1450,582,1449,907,1229,456,796,1713;46;F
45970;40,1039,976,215,117,1268,795,255,907,1443,996,987,930,1259,1120;33;M
45985;104,1669,1120,987,1668,1449,1443,92,1713,891,607,1219,950;43;F
45993;117,1670,795,155,996,1668,987,1212,146,950,675,1120,1039,215,976;34;F
45994;92,1229,907,1443,1668,742,987,1450,891,1259,996,1501,146,1120,976;35;F
46009;92,795,1235,996,998,582,680,950,1669,1562,1440,907,1668,40,976;37;M
46013;996,582,941,987,1212,1205,40,1670,207,1639,1450,146,930,1259,675;37;F
46058;796,725,92,146,145,907,1443,1668,891,1259,675,215,976,1039;32;M
46133;748,1235,1449,987,891,749,1120,40,976,215;43;M
46159;742;38;F
46165;941,796,1219,207,907;42;M
46170;1324;39;F
46183;516,1562,795,996,1219,742,582,680,941,1450,1212,749,1120,976,215;31;M
46196;996,1668,582,680,987,950,1120,40,1197,976,796,725,1713,1440,795;37;F
46211;582,680,1197,796,607,1120,749,891,1143,996,1134,1186,1164,1205,790;63;F
46212;1324,207,255,680;44;M
46218;1259,675,1120,1039,207,907,516,996,1501,987,1450,146,930,976,215;88;F
46232;1501;43;F
46243;941,796,725,92,907,1449,996,1501,1668,582,891,1212,749,1259,1120;24;F
46255;255,907,1143;21;F
46271;516,996,1501,742,941,1450,891,1259,675,1120,1197,215,907,987,976;32;F
46301;1209,1669,1268,748,1668,40,796,207,1443,167,891,749,1120,215,680;16;M
46307;215,92,796,1669,1713,207,907,1449,996,1668,987,891,749,790,1120;29;F
46317;996,155,1450,1120,40,104;26;F
46340;1668,582,987,1669,117,1501,1120,1197,976,104;36;F
46352;976,1120,1259,891,582,1449,796,1669,92,255,1668,680,987;35;F
46359;207,996,790,1186,1164,1205,1134,1143;44;M
46377;155,104,1259,907;65;F
46378;1669,117,795,907,516,987,675,40,1039,976;35;M
46391;1713,146;24;F
46411;675,680,1443,795,1209,950,1324,155;66;F
46446;796,1229,1268,92,465,907,996,1501,1668,1450,891,749,1259,1120,1039;33;F
46449;1562,155,950,40,976,215;74;F
46492;1639,795,769,92,1713,796,1209,117,1440,456,1443,167,987,1197,976;26;M
46504;456;32;M
46541;1197,1120,790,950,749,891,1668,907,607,92,215,1472,1212,155,1449;35;M
46544;1562,769,456,146,1120;29;F
46548;582,749,1259,796,1669,1639,1501,1668,790,1197,1713,92,1219,950,1120;28;F
46557;155,680,950,215;67;F
46560;92,1670,1669,1209,1562,1324,1449,987,930,675,1120,40,215,1039,976;71;F
46569;1209,1668,680,987,146,675,1120,976,215;46;M
46585;891,146,930,1259,1472,796,465,680,582,790,1120,996,1449,907,1233;34;M
46593;92,907,1143,996,1668,987,675,976,215;85;M
46621;255,907,516,1449,1450,891,930,1259,1472,1120,1039;24;F
46700;1120,1259,1450,1436,987,1472,1197,976,215;55;M
46703;1268,795,996,987,1450,1039,907,1120,976,1669,1501,1668,1259,40,215;41;F
46724;255,1668,680,749,950,40,1197,976,998,769,1713,796,1562,117,795;32;M
46730;255,998,749,950,40,1197,976,1562,1669,117,1713,92,795,1668,680;29;F
46737;790,215;75;M
46759;146,1436,1197,675,891,1450,987,1668,907,456,255,795,145,92,1209;32;F
46769;1268,92,987,891,1039,215,465,1669,1436,1639,907,996,1668,1450,1259;43;F
46790;749,1120,40,976,215,1669,1440,516,996,680;66;M
46805;1229;6;M
46851;796,582,1639,675,1670,1501,907,891,1259,255,725,941;36;F
46884;749,1472,1120,40,1039,976,215,796,1440,1259,941,1233,607,582,680;20;M
46895;725,1669,255,456,907,1443,1449,996,1501,941,1212,891,1205,1120,1039;50;F
46896;1713,941,796,907,1443,1449,996,1501,1668,1450,1212,891,749,1259,1120;44;F
46935;1259,1212,891,941,996,1449,907,255,1440,1209,796,680,749,1120,104;39;F
46993;1209,1324,92,795,907,680,950,675,1120;54;F
47012;1440,748,255,907,1134,1668,1186,749,1449,146,215,207,607,987,930;14;M
47013;607,907,155,1501,1259,40,1197,104,796,1669,92,1440,1668,950,1120;29;F
47029;1449,1233,1450,891,1212,749,1259,1120,40,907,725,465,1440,1235,1039;38;M
47035;907,987,680,1235;32;F
47061;976,1120,1259,749,1233,1450,941,1501,907,795,1669,796,996,1668,987;46;F
47087;40,117,215,675,1039,725,907,1501,987,976,796,1670,1440,1668,891;27;F
47116;1229;82;F
47121;1713,796,748,907,1235,1449,996,680,1212,749,790,1120,40,976,215;;M
47135;207,748,607,255,456,582,891,790,1197,104;71;F
47157;1229;40;M
47163;146,930,1259,675,1472,1120,1197,976,104,215,796,1713,516,987,1039;31;F
47174;891,796,92,1440,145,996,1501,1120,976,1259,1668,987,146,675,215;35;M
47189;950,1324;40;F
47226;796,725,1669,207,1639,907,1449,1501,1668,582,1450,891,1259,1120,1039;14;M
47241;1669,1713,1668,1450,1212,796,996,907,749,1259,1120,40;40;M
47271;796,725,1670,92,1449,155,996,1501,1668,1450,1259,950,1669,907,1120;46;F
47285;725,207,907,456,941,1443,996,1668,1450,891,1212,749,930,1259,1120;12;F
47295;1039,1229,1501,950,1670,1209,1440,145,795,1639,1443,996,1219,891,1120;40;F
47311;796,1440,907,996,1212,1039,976,1120,675,1259,891,1450,941,680,582;50;M
47327;146,907,456,607,771,796,1669,145,795,749,790,1120,40,92,1668;38;F
47415;1039;66;F
47418;1670,117,1268,769,1229,996,1668,742,987,1450,465,1209,145,207,930;22;F
47436;976,1259,749,996,907,680,987,675,40,215;49;M
47441;907,769,1268,92,1670,796,1562,1440,996,1668,680,1120,40,976,215;52;F
47445;907,1669,92,1229,950,996,891,749,104,796,607,456,1443,1668,146;42;F
47469;790,1120,796,1209,465,92,996,891,749,930,104,582;43;M
47471;1501,1668,998,742,1450,146,1212,1259,1039,215,117,516,582,1120,976;40;F
47472;795,155,950,1039,1668,941,1450,1259,675,1120,1324,1501,987,976,215;29;F
47494;796,92,907,1449,996,1668,742,891,749,1205,790,1120;62;F
47511;255,207,771,1440,1669,465,796,907,1449,1186,891,1212,950,790,1120;44;F
47513;1450,891,146,749,1259,976,215,145,907,996,930,1120,1209,987,675;39;M
47514;40,1259,1668,582,749,796,207,255,456,516,987,891,1120,976,1197;29;F
47522;796,155,742,998,1668,1209,1562,725,907,996,987,930,40,976,215;30;M
47541;796,748,907,1449,1501,582,891,1197,1669,92,1668;47;F
47562;796,725,465,1669,748,795,907,1449,996,1668,1186,891,749,790,1120;38;F
47571;167,891,1212,675,215,1324,1440,748,1443,1449,742,680,987,749,1039;41;F
47618;1197,680,1450,1120,796,907,1449,996,582,941,891,1212,1233,749,1259;70;M
47653;92,1197,1120,1436,976,987,215,1440,941,891,1501,907,996,1259,516;35;M
47667;742,1562,92,1440,907,996,950,1197,796,1443,1668,749,207,795;38;M
47669;1436,516,941,749,950,1197,215,92,607,907,155,996,1501,1668,1450;45;M
47690;1443,742;42;F
47691;1713,795,1668,1197;34;M
47696;930,675,1120,92,1209,725,796,207,255,456,742,680,146,1233,1039;41;F
47705;1669,117,1713,92,907,996,1501,1668,987,891,1259,1120,40,976,215;34;F
47713;907,996,1501,1233,749,40,796,92,1450,1212,891,1668,941,1259,1120;34;F
47715;1209,456,907,155,996,1668,675,1669,92,1268,1501,987,1259,1120,1197;42;F
47724;796,907,1449,996,1501,582,680,941,1450,891,1212,1233,749,1259,1120;69;F
47742;1443,907,255,748,1209,796,996,987,891,749,675,1120,1039,215,1212;46;F
47762;117,1268,1229,907,1219,1501,1668,146,675,1120,1562,207,795,987,215;49;M
47769;796,907,748,207,255,1229,1219,742,582,680,146,1259,675,1120,1039;39;F
47772;1501,1668,941,1212,146,1233,790,796,725,1440,1443,1450,891,1259,1039;40;F
47778;1259,146,1212,1450,987,941,680,996,1449,907,255,748,207,1440,465;41;M
47840;796,92,1268,907,996,1668,582,987,749,1120,1197,1443,680,950,215;36;F
47877;996,1450,1259,1120;56;M
47881;155,1668,146,749,1120,976,796,1440,607,907,996,891,215,1449,680;53;F
47908;516,1449,996,1501,987,1450,891,1259,1120,215,465,1440,1212,675,976;38;F
47923;1039,795,950;40;F
47946;155,950,1197,1562,1713,92,607,456,167,1668,680,987,675,40,976;27;F
47952;891,146,749,1197,1120,675,1259,1450,582,996,1501,987,40,976,215;33;F
47956;1268,92,1440,607,1229,582,987,930,950,1039,976,1233,1449,155,742;42;F
47979;1440,145,255,1229,456,1449,1501,1668,742,1450,891,207,146,1120,1039;33;F
47984;1440,145,255,891,1233,1212,749,1259,1120,92,907,1443,996,1668,1501;31;F
47998;465,1268,769,795,1449,167,1668,680,987,891,1212,675,1120,796,1440;43;F
47999;1209,465,1235,1436,1268,907,1449,996,930,1440,1639,582,1450,1259,1120;26;F
48029;796,1268,207,907,1143,1235,742,1233,1259,976,1120,1039,771,941,1164;35;M
48081;1120,742,950,1039;39;M
48118;1668,104,1120,748,1440,92,465,796,255,1449,742,891,749,1205,675;38;F
48130;950,1120,1450,996,1443,907,1639,796,607,748,1440,117,1670,1713,465;24;M
48162;769,167,215,796,92,1268,1668,998,1212,1120,255;62;F
48183;1209,1669,92,1440,907,996,1668,680,987,891,749,930,675,1120,104;39;M
48199;1501,941,1233,749,930,1669,907,1449,996,1668,1450,891,1212,1259,1120;80;M
48205;748,795,996,1501,1668,680,1450,891,1212,1233,749,1259,675,1120,1197;49;F
48231;155,1219,987,1212,1259,950,1039,1669,92,255,907,1668,146,1120,215;52;F
48237;796,1713,607,582,1120;27;F
48259;1440,607,155,950;48;M
48261;725,1669,92,771,748,795,255,456,907,1443,155,1219,1668,1212,1120;57;F
48278;675,1443,155,987,930,950,742;43;M
48315;516,996,742,987,1450,1259,675,1120,907;41;M
48322;1233,1259,675,1209,1268,1443,1219,582,146,749,1212,1120,40,976,215;45;F
48368;1501,996,769,92,1669,1713,795,1668,998,987,1212,675,950,1120,40;40;F
48372;465,1449,680,891,930,1205,1259,790,1120,215;43;M
48380;1233,92,207,255,987,976,215,941,675,1120,1039;46;M
48387;255,1229;23;F
48413;1268,207,255,1450,907,1668,1120,92;39;F
48414;795,92,1436,1670,117,1669,725,796,907,996,1668,1212,749,1197,104;40;F
48429;907,1449,996,1450,1212,891,1164,749,1259,1120,725,1669,92,1501,1233;51;F
48444;796,1120,40,1669,465,145,207,1219,1501,742,987,891,146,930,1039;24;F
48451;675,1449,907,1259,749,891,1450,987,941,582,1668,996,748,1669,725;40;F
48452;1669,1713,907,996,1668,582,1120,1197,796;45;M
48461;950,167;72;F
48469;215,976,1039,1120,40,675,987,1668,516,907,769,1268,92,1669,1562;57;F
48507;907,516,1443,1449,996,1219,1501,582,680,941,1668,891,950,1120,1197;29;F
48521;1670,1501,795,907,1212,1120,40,796,465,748,1449,996,891,749,790;27;F
48526;465,117,1229,907,1449,155,996,742,891,749,1259,950,1472,790,1120;4;M
48532;1668,680,987,891,976,1259,104,1197,1120,675,1450,941,1219,1443,907;34;F
48581;742,996,582,1450,146,1259,1120,976,104,1268,1440,1449,680,1212,1443;41;M
48582;1209,1324,145,207,680,1205,742,146,930,1039;39;M
48584;1324,207,795,1229,1443,155,167,742,680,987,146,930,950,1039;40;F
48616;92,1268,255,1229,1562,1669,1440,795,1639,1668,742,1450,146,930,675;37;M
48647;1562,1268,680,1120,1205,1039,40,950,146,742,1443,907,145,92,1324;58;F
48705;215,907,976,1120,1197,996,675;48;F
48792;796,725,748,1443,1668,1164,146,1205,790,40;46;F
48793;1268,1562,1669,1324,92,145,1443,1668,742,680,146,950,1120,40,1039;83;F
48806;1235,1562,1670,1713,1436,92,1268,769,748,795,607,255,167,155,950;56;F
48826;1268,907,516,1449,996,987,1212,749,1259,675,1120,40,1039,976,215;40;F
48880;1212,891,1450,1668,155,907,1440,92,1669,796,725,996,1501,941,675;47;F
48966;907,1229,1639,1440,1669,1120,790,950,1259,1212,1197,1205,996,1670,92;29;F
48992;987,891,1205,675,40,215,796,145,207,255,146,930,1259,1120,1039;36;F
48996;1440,1443,742,941,1450,1259,1120,1039,607,950;42;M
48999;215,1450,1212,146,976,796,1669,1501,1668,941,891,749,1259,1472,1120;57;M
49075;1449,907,255,607,795,207,1669,796,582;46;F
49078;1443,950,742;41;F
49101;1197,976,1268,796,117,1120,891,465,1472,582,1449,1235,749,790,996;36;F
49107;1219,891,1039,104,465,1669,92,795,1235,1449,996,1668,680,749,1120;51;F
49115;1120,748,92,465,1449,996,1501,1668,1186,582,680,891,1205,675,790;70;M
49116;796,1562,907,1713,255,155,680,1212,675,1120,40,976,215;52;F
49130;907,582,1205,790,1197,215,146,748,207,145,1440,1669,796;7;F
49187;1440,907,742,680,930,1120,1039,215;40;M
49202;1268,1120,796,465,1669,1668,941,891,1233,1472;39;M
49214;1669,1562,796,117,1713,769,795,907,1443,742,680,950,40,1039,215;39;M
49231;1669,1436,92,1639,1229,907,1501,1668,987,1450,891,1259,1039,976,215;62;F
49311;1669,92,796,465,1440,207,1668,680,749,40,215;81;F
49342;795,742,725,796,1668;38;M
49362;1186,155,1143,748,92,145,1668,749,930,1259,950,976,607,907,1501;29;F
49376;1212,1639,465,1209,1440,207,748,456,907,146,1120,796,680,104,1472;38;F
49384;1440,92,117,796,255,907,680,749,215,465,950,987,607,795,155;25;F
49449;215,40,795,1268,1713,1324,796;49;F
49505;607;44;M
49519;117,996,1233,1450,215,796;30;F
49533;1669,465,1449,1212,749,1120,976,40,796,1713,1440,996,680,891,790;43;M
49567;891,1212,749,930,1259,675,1120,40,1197,215,92,1268,907,996,1668;20;M
49587;1212,145,607,155,907,1440,795,1197,976;45;F
49592;582,749,796,907,996,930,1259,987,891,1120,976,215,1501;35;M
49636;1197,1120,1259,1212,891,1450,941,680,1501,1449,1443,1639,725,907,996;42;M
49646;976,1120,1212,987,941,516,1440,255,1639,1219,891,930,1259,1205,1039;39;F
49652;950,607,582;41;F
49655;215,1669,92,907,996,1501,1668,941,987,1450,749,1259,950,675,1120;67;F
49679;907,516,996,582,987,1450,891,675,1669,92,1668,1259,1120,40,976;57;F
49703;92,996,1501,1668,941,930,255,907,891,1120,987,1450;40;F
49709;582,1443,907,1639,255,207,145,1669,92,996,1668,1212,1259,1120,1197;32;M
49729;749,1233,996,1713,907,796,92,1501,1668,680,941,1450,891,1212,1259;29;F
49733;155;68;F
49740;796,907,1501,1668;28;F
49790;1440,92,1209,207,456,155,996,1450,930,1259,1472,1120,1197,976,675;33;F
49805;1209,1670,607,907,1443,1219,1186,582,987,1450,1212,1472,104;75;F
49816;1324,1120,1039,976,996,790,675,1669,1668,155,117,582,92,749;67;F
49854;456,907,930,1120,207,1449,1219,1186,891,146,1205,1472,790,104,215;47;M
49858;456,1039,40,950,167,155,769,1713,1562;35;M
49867;1212,1233,749,1259,1639,1324,117,1472,215,907,891,976,1501;45;M
49879;725,1440,1219,1668,891,104;43;F
49903;207,255,516,987,1197,1039,976;44;F
49909;155,1197,680,1259,1450,582,907,796,996,1120,976,215,1501,941,891;36;F
49916;1440,907,1235,796,1669,92,1449,1668,680,891,1212,749,790,1120,1436;53;M
49920;104,1197,1120,950,1212,1450,1440,795,996,1219,1186,891,1259,40,1039;39;M
49947;1324;41;F
49949;255;82;F
49962;1259,996,907,255;88;M
50008;930,950,1039,1120,1259,1324,1440,748,255,1229,907,1449,680,891,1233;38;F
50030;795,1669,1713,92,769,998,40,1562,1443,155,742,1039,950;48;F
50052;1501,155,1449,1669,1209,796,92,907,996,1668,680,1450,891,1259,1120;25;F
50077;1449,215,976,1039,40,675,930,749,987,680,1268,1713,1324,1209,1562;23;M
50081;891,941,680,907,1440,117,976,92,1501;41;M
50082;207,1440,516,1450,1259,675,1120,1197,1039;42;M
50119;1449,996,1219,1501,1668,582,680,941,1450,891,749,1259,1120,976,215;52;F
50169;742,1450,1212,1259,1120,1039,1668,1219,1443,795,145,771,92,117,725;37;F
50185;1562,1235,146,582,465,1440,1268,207,255,1449,996,680,891,950,790;23;M
50221;771,582,930,891,146,1259,675,40,976,215,1440,145,516,1219,987;29;F
50261;582;35;F
50263;1669,92,748,1449,996,1212,1120,749,790;36;M
50295;207,582,1450,749,1259,1120,215,1436,941,891,1472,976,1713,907,1233;81;F
50312;1669,92,1449,1668,891,749,1120,748,996,790;32;F
50330;207,255,907,1443,1449,742,582,680,1259,950,675,1120;48;M
50333;950,742;42;F
50334;1186,771,1713,1562,796,1440,987,950,675,40,976,215,92,795,680;34;F
50345;790,1120,742,891;40;M
50365;1443,742;41;M
50382;725,987,1120,1440,907,215,748,1212,749;40;M
50393;1562,1324,907,1212,749,40,680,987,1120,1039,976,215,950,1443,742;41;M
50396;146,950,104,1134,155,1229,1669,92,607,1219,1668,675,40,1197,215;69;F
50416;1259,796,725,1209,1669,771,1443,1449,1668,582,1120,1197,104,40,92;22;F
50420;516;29;M
50429;680,996,456,607,207,145,771,796,1713,255,907,1443,146,950,1039;36;F
50451;1209,796,725,207,795,607,1639,582,987,1450,1259,675,1120,1197,215;28;F
50452;742,1443,950;45;M
50492;930,215,891,1212,996,907,976,1120,92,749,1668,680,675,40,1440;31;M
50493;146,117,950,1443,742;49;F
50495;675,796,207,748,907,1449,996,742,680,749,1120,40,976,104,215;72;F
50500;742;41;F
50503;1120,207,749,748,465;31;F
50521;1259,1235,987,1212,1197,725,796,1324,255,907,582,1120,1209,930,675;31;M
50541;796,987,1450,146,930,1039,215,1268,907,516,996,1501,1259,1120,976;34;M
50544;907,742,891;40;F
50556;104,1120,675,930,749,987,680,582,1668,907,795,92,1713,1209,796;35;F
50576;1212,742,891;10;M
50592;582,1212;4;F
50624;1212,742,891;7;M
50635;769,207,255,1443,996,742,1212,215,796,1669,1668,950,675,1120,1039;41;F
50650;1235,1443,167,996,1219,680,1212,749,1197;16;M
50676;1668,582,1212,749,675,1120,40,1039,215,1669,207,748,1443,742,950;41;F
50680;92,1440,207,255,907,996,1039,1668,582,680,1212,930,675,1120,40;63;F
50723;1450,796,1268,1440,795,907,996,1501,1668,680,987,1259,1120,976,215;33;M
50732;1209,207,255,680,987,146,950,675,976;56;F
50737;1443,742,950,1039;48;F
50746;1450,891,1472,215,1197,976,1120,796,92,1440,207,795,1449,996,1501;38;M
50764;941,1450,1212,749,1259,790,1039,1120,104,465,748,255,1449,891,1472;33;F
50801;1562,207,748,607,255,1229,907,1449,996,1668,742,891,1205,790,1120;41;F
50802;1443,930,987,742,146,950,1039;46;F
50803;1440,92,1324,1209,796,145,207,607,456,1443,1449,1219,1120,104;41;F
50810;742,1212,146,680,930,1039,1562,1669,207,795,255,155,40,976,215;67;F
50819;749,1259,1205,1472,790,1197,1039,796,465,117,92,1268,104,215,1120;35;F
50876;92,749,907,996,582,987,1259,1120,1197,1440,207,675,680,930,950;17;M
50935;1209,1669,92,255,155,996,1501,1668,987,930,1259,675,1120,40,215;32;F
50947;117,796,1562,769,207,607,1443,996,742,680,891,950,675,1039,215;51;F
50955;117,950,742,1443;52;M
50983;1443,742,950;48;F
50992;796,1713,795,1212,146,950,1039;37;F
51014;92,907,680,1197,1668,1212,1120,976;56;M
51029;1436,1268,1501,1450,1259,675,1120,215,976,1209,795,255,987,930,516;32;F
51033;742,1443,950;49;M
51034;749,215,1669,748,907,996,987,1212,1197,92,207,1668,680,675,1120;51;F
51071;207,1143,1235,996,1134,1186,1205,790;63;M
51132;1440,907,996,680,987,1212,1039,104,207,255,582,941,1450,891,1259;48;F
51161;92,907,998,742,1120,1235,1449,1205;40;F
51191;1233;49;M
51221;1443,1713,1562,1669,92,769,907,155,996,1668,1212,950,1120;62;F
51275;1440,795,516,1120,976;39;F
51287;1324,1668,987,40,976;30;M
51291;742;40;F
51295;891,207,771,930,255,1186,146,1197,1039,40,790,675,742,950,1443;49;F
51307;1212,749,1259,1120,215,796,1669,1324,117,92,748,907,1443,1668,987;70;F
51311;607,155,996,941,1450,1259,1120,1039;72;M
51369;1209,207,748,255,1449,155,1219,582,680,891,749,1259,675,1120,40;46;F
51372;1562,465,1440,996,790,1268,769,796,1669,92,1235,1219,1668,680,891;69;F
51400;1209,1669,92,255,1219,1668,930;63;F
51425;1436,117,1670,1669,465,796,104,1259,891,1450,941,1668,1219,907,1197;36;M
51433;1436,92,1440,207,255,907,516,742,1450,1259,1120,40,976,215,1669;44;M
51465;891,1259,675,1197,1219,725,255,941,987,1450,1120,1039,215;55;F
51501;996,1450,891,749,976,796,456,155,742,680,1212,1259,950,1120,1039;38;F
51512;749,1219,255,769,796,1562,891,1212,1713,1268,1449,680,950,1120,790;50;F
51536;1669,748,749,207,456,1443,1186,146,930,1205,790,104;9;F
51557;749,1259,40,215,796,92,771,769,907,996,1219,1501,1668,1186,1197;57;F
51565;795,516,1450,749,117,1268,1259,976,215,1120,907,987,1501;38;M
51572;1039,40,950,1443,742;44;F
51580;104,582,167,1501,941,987,1197,1120,796,1713,92,907,996,891,1668;49;F
51638;92,1669,725,1668,1233,1259,1120,950,1443,742;45;F
51652;907,117,1449,996,1501,1450,891,1259,1120,976;28;M
51656;796,1209,207,748,255,907,155,996,1668,582,146,675,1120,40,1197;37;F
51679;1268,742,941,1450,891,1259,1120;35;M
51714;1440,1268,1443,155,742,950;38;M
51737;1562,1713,1268,998,1212,1120;78;F
51745;1436,1268,795,607,1639,907,40,976,516,155,1501,941,891,146,950;70;M
51762;1209,607,255,907,1449,155,950,675;29;F
51809;1639,996,1501,941,1450,749,907,1259,795,92,680,1120,891,516,675;35;F
51817;207,1268,1449,1039,976,1209,465,117,1229,996,998,742,680,930,675;23;M
51821;1233,1472,1120;33;M
51833;1449,117,465,1209,207,748,795,1639,998,680,987,930,675,1197,976;24;F
51857;92,1197,1669,907,1143,1164,1259,950,1205,1039,145,742,146,1120,1472;39;F
51883;1713,167;22;M
51887;1713,167;55;F
51903;1562,1669,907,996,582,1450,1259,255,1219,1668,1212,1120,795,1197,976;56;F
51910;976,92,1501,987,1212;45;F
51943;1449,996,1450,930,1259,1205,1440,771,748,255,1212,104;25;F
51955;1209,1669,1324,1229,1443,1449,582,680,987,1212,749,930,1120,40,1039;38;M
51960;155,1440,1713,465,796,907,1449,996,1668,680,1450,891,749,1259,1120;50;M
51961;1268,725,1259,1450,1440,92,117,1669,907,1668,987,1120,976,215;45;F
51976;465,907,996,749,796,92,771,1449,790,1120,1669,207,1668,1186,891;55;F
51978;742,1443,930,1039;37;F
51983;92,795,1639,907,516,996,1501,680,941,1450,891,749,1259,675,1120;38;M
51987;1669,465,725,255,907,1219,941,1450,891,146,1259,1472,790,1120,1039;66;F
52010;996,1669,92,1443,1449,167,1668,891,1212,1233,749,1259,790,796,941;47;F
52019;1562,1669,1670,771,207,748,1219,987,1212,749,930,1205,675;44;F
52051;1501,582,976,796,92,996,891,907,941,1450,749,930,1259,1120,1039;34;F
52055;1209,1450,796,1669,1440,795,255,1639,1668,680,950,675,1120,1197,976;31;F
52060;930,675,1039,1209,207,255,1212,1443,1449,742;41;F
52061;680,950,987,155,907,795,1668,941,1450,891,749,1259,40,1120,976;59;M
52173;1501,1668,582,941,1450,891,1212,1233,749,1259,675,1120,40,1197,104;49;F
52183;1713,1440,769,748,1449,891,680,1212,749,215,742,1443,987,950,1039;45;M
52189;987,1120,104,1209,1669,607,1219,1668,950,1039,1443,742,92,795,456;39;F
52224;725,796,1669,907,996,1501,1450,1212,749,1259,1120,40,92,795,1668;32;F
52246;1212,749,1259,1120,104,145,146,255,742,987,891,1205,675,1039,976;31;F
52255;1212,749,1259,1472,1197,1039,104,1669,465,92,607,1219,1668,790,1120;62;F
52278;742,1443,1668,950,1039;39;F
52333;941,1639,1235,155,680,1450,891,749,930,950,976,1259,1670,1039,215;33;M
52348;92,907,582,1197,1209,1669,207,1219,1450,930,675,1120,1501,941,1259;31;F
52361;1259,117,465,675,1669,1440,795,1668,40,680,891,749,1120,1197,976;21;F
52375;215,1219;42;M
52376;1449,1501,1472,1669,907,516,1443,996,1668,998,749,950,1205,790,1120;46;F
52396;1143,907,795,145,771,92,1670,1209,725,796,207,607,1219,930,215;24;F
52412;1219,675,1120,1039;35;M
52413;976,1120,796,795,607,1639,907,582,1450,930,1197,215,456,996,680;33;M
52434;675,1472,790,92,207,748,607,1443,1449,1668,582,891,749,1120,104;37;F
52441;907,769,92,1713,117,796,941,1450,891,1212,1233,749,1259,1120,40;31;M
52457;907,1450,215,1039,976,92,1670,996,891,1259,1120;48;F
52461;795,998,1259,1120,1197,104,215,92;50;F
52463;215,976,607,748,1209,796,1449,996,749,40,795,987,930,675,1120;27;F
52477;907,1443,1449,996,1668,891,1259,1205,1472,790,1120,104,207,607,582;39;M
52479;1713,117,1324,465,1669,907,1235,1449,996,1668,891,749,1259,1120,976;42;F
52483;987,749,930,1197,907,92,1669,796,1449,1668,891,675,790,1120,104;29;F
52491;1450,1259,104;37;M
52523;1164,1669,92,607,907,1235,1449,996,1501,1668,582,891,930,790,1120;30;F
52528;1670,1669,465,1209,796,117,516,1219,1668,987,1450,1259,675,1120,976;28;F
52548;790;33;M
52596;796,1440,145,456,907,1449,155,996,582,1212,950,1205,1120,742,1443;32;F
52605;1268,796,1639,516,996,1501,1668,941,891,1259,1669,92,255,907,146;37;F
52618;215,1197,1120,255,207,987,930,976;46;F
52633;950;54;M
52671;1209,207,930,675,1039;41;M
52700;680,749,1668,1501,1219,996,516,987,1120,1039,976,215;29;M
52707;1440,976,1450,1209,769,796,891,1562,1268,950,117,987,215,1120,1324;48;F
52724;582,891,748,215,92,207,1443,1449,996,1212,1120,907,1259,1205,1039;38;F
52730;1669,1440,207,907,155,996,1219,891,1120;36;F
52785;255,1472;74;F
52796;92,1134,1668,790,796,117,1268,748,1449,996,891,749,1120,40,104;58;F
52840;1212,1259,1039,215,1197,40,680,1668,155,1639,607,1669,950,976,104;26;M
52841;92,796,907,1449,996,941,891,1212,1233,749,1259,1205,790,1120,582;41;M
52864;1669,92,1440,907,155,996,680,1450,891,1212,749,1259,1120,1668;33;F
52876;117,167,1120,465,930,40,907,1562,92,207,675,1197,1501,1268,1209;21;F
52882;1212,1259,1039,1120,891,1450,907,1197,1233,1501,1443,796,92,1229,582;36;F
52887;215,976;36;M
52900;907,92,1668,680,1120,1212,749,941,1669,1440;36;M
52920;1268,1669,92,1440,1639,516,996,1668,680,1450,1259,675,976,1120,215;47;F
52924;1668,998,749,1259,1197,465,1669,92,907,516;28;F
52933;1443,1501,1450,749,1259,215,796,1669,907,1219,1668,1212,950,1120,1197;32;F
52948;1713,92,456,907,1449,996,1501,1668,891,1259,675,1120,976,215,582;10;F
52975;907,582,155;49;F
52982;930,907,255,516,1219,1501,1668,1472,1120,1197,976;31;M
52995;1669,92,795,907,1443,1219,1668,1450,1212,749,1259,950,1120,1197,215;62;F
53018;796,92,1669,907,1449,996,1501,1668,582,1450,891,1212,749,1259,1120;34;F
53019;1668,941,891,1233,749,1197,976,215,92,1449,996,1450,1212,1259,1120;55;M
53035;680,1450,891,1212,749,1259,950,1205,675,790,1120,1197,1039,104,215;18;F
53072;748,207,145,769,771,1440,1268,92,1436,1713,117,725,996,582,891;24;F
53119;215,1039,950,742,1219,1443,1268,1713;40;M
53155;1120,675,1209,987,680,1668,1501,996,1449,1235,907,1440,92,725,796;34;M
53171;1443,907,1268,1436,1670,1440,516,1668,1450,1212,930,1259,1120,1039,976;32;F
53172;748,1268,1436,117,1669,465,1209,796,92,1143,1449,1668,675,1120,104;37;F
53211;748,1449,1120,1639,742,987,146,976,215;28;F
53220;987,998,1219,1209,796,1440,1443,155,1134,680,1212,950,40,1039,976;38;F
53225;1209,92,1440,255,907,1143,996,1219,1450,891,1259,675,104;28;F
53254;1440,771,207,795,1235,1449,996,1186,680,1120;42;F
53322;749,1197,40,1669,1440,790,796,891,680,907,1449,1668,996,1259,1120;55;M
53339;941,987,749,1472,976,796,465,748,1449;39;M
53374;749,1212,891,1450,1186,1501,1219,996,1449,255,1639,907,941,1259,40;65;F
53469;891,742,155,1235,1670,117,1324,465,1562,796,950,1472,790,1120,40;26;F
53480;996,891,950,1039,796,1669,92,1440,255,1449,1668,1212,749,1259,1120;26;F
53481;1235,92,1324,465,796,1209,1440,607,907,1449,996,1186,680,1212,749;26;F
53485;796,1209,465,92,907,1449,996,1668,582,680,1450,1212,749,40,1120;25;F
53493;891,465,749,748,976,941,1440,1233,1212,796,215,907,1450,1259,1120;30;M
53525;907,996,796,465,117,92,1268,795,1449,1668,891,790,1120,976,215;62;M
53543;1436,1219,215,749,950,996,40,790,891,680,155,607,117,465;34;M
53566;1668,582,891,1197,607,1669,790,1120,680,1501,1443,465;52;M
53591;795,1233;35;M
53607;1219,155,1143,1229,1324,145,207,255,516,680,987,1450,930,1259,675;36;M
53625;976,215,40,1120,891,996,465,1440,748,795,1449,582,680,749,950;54;F
53631;769,725,465,607,1449,1219,582,987,675,1120,215;25;M
53637;675;25;M
53647;465,1669,1436,1440,748,680,987,891,1212,749;26;M
53652;725;46;F
53657;92,1268,795,607,255,1639,1134,1186,582,987,1233,950,675;24;F
53661;1186,1219,255,795,207,92,796,465,1440,748,1449,680,891,790,104;43;F
53705;607,987,1205,790;65;F
53715;1209,1436,1440,207,255,1120,675;30;F
53730;1443,1713,1436,92,796,1209,465,1268,207,1235,1449,996,749,1472,790;26;F
53732;1440,92,117,1209,796,207,748,1449,680,987,146,40,1197,104,215;40;F
53800;207,255,1472;51;F
53810;1713,749,976,255,207,1669,92,1443,1668,1450,1212,146,1259,1120,1039;43;F
53811;1713,1440,748,456,907,1449,155,1501,582,891,950,675,1120;21;F
53813;1670,996,749,1259,1120;62;F
53821;1440,516,155,996,742,680,941,1450,891,675,1120,1197,1039,976,215;58;M
53826;1186,155,1143,748,92,145,1668,749,930,1259,950,976,607,907,1501;26;F
53854;582,1501,1449,1713,796,1440,907,996,680,941,1450,749,1259,675,1120;31;F
53867;996,582,941,1450,891,1212,1233,749,930,1259,1120,796,92,1501,1668;36;F
53900;117,796,465,207,748,907,1443,1449,996,742,1450,891,1212,146,790;42;F
53908;996,680,891,1259,1472,104,749,465,1669,92,795,1219,1668,1120,40;35;F
53943;680,1450,1164,749,930,950,1443,941,742,146,1259,675,1120,1039,976;39;F
53961;796,907,1449,1501,582,680,941,749,1259,1120,1450,891,1212,1233;48;F
53962;950,675,1639,607,1713,465,1669,92,1219,1501,1668,1212,1472,1259,1197;45;F
53967;1259,146,1233,749,1197,1668,996,516,255,1669,92,145,1235,790,1120;62;F
53974;92,907,996,1668,1259,1120,215;48;F
53991;516,1440,1268,976,950,1443,742;37;M
53992;996,1668,582,749,796,1669,92,1235,1449,1259,790,1120,1197;67;M
53993;725,117,92,795,1219,941,1450,891,1212,607,1120;48;F
54026;465,1713,748,907,1449,996,1472,790,1120,215;64;F
54044;117,1713,92,607,907,1668,1450,891,749,1259,1120,1197;79;F
54083;155,748,796,680,1233,749,1259,1120,1450,907,941,891,1212,976,215;44;M
54117;749,215,1197,1120,675,1186,1219,1449,907,456,255,607,207,771,1209;26;F
54118;976,1209,1143,167,1186,987,675,1472,215;66;F
54143;255,1268,1440,465,117,907,996,1259,1120,976,215;27;M
54162;1443,742,950,1039,749,930,1120,40,465,907,1449,996,987,680,891;39;F
54174;1668,155,145,1669,117,1440,207,748,1449,1186,987,749,1472,146,891;39;F
54208;582,996,607,207,796,92,907,1219,104,1120,987,1670,976,680,215;40;M
54211;795,207,145,771,1440,1436,1670,796,907,516,1501,680,930,1120,1039;42;M
54213;1449,1235,907,795,748,465,796,725,92,1219,1668,680,749,1259,1120;31;M
54216;796,607,1449,582,891,146,749,790,1120;36;F
54236;769,1268,1670,987,891,976,215;31;M
54239;1259,1120,607,1440,1324,1562,1501,796,996,742,1039,1449,155,1443,907;40;F
54247;1324,748,996,1501,1229,1449,155,742,1212,796,1209,680,891,675,1233;69;M
54256;1324,215;47;F
54260;516,907,607,771,1268,1670,117,92,155,891,1259,950,675,1197,104;56;F
54273;1450,891,1212,1233,1259,1472,790,215,976,796,117,1713,92,749,1120;35;M
54277;215,1229,92,1324,796,1669,987,155,950,742,1668,748,795,675;69;F
54313;1443,145,771,255,907,996,742,582,891,1212,146,1205,1120;56;F
54324;1669,1449,1668,680,950,1120;31;F
54332;1440,1449,996,749,1120,976,215,796,255,1235,582,680,987,675,1039;37;F
54345;796,748,907,680,941,987,1450,891,1212,749,1259,675,1120,976,215;10;M
54374;998,891,790,1197,976,1443,1449,582,1212,92,1440,1501,680,1450,675;30;F
54375;987,675,1120,215,976;41;M
54380;796,748,907,680,941,987,1450,891,1212,749,1259,675,1120,976,215;43;F
54404;146,987,582,1186,155,1449,607,795,207,1268,92,1324,891,1120,1197;59;F
54426;1449,1219,1259,1120,1197,1039,215,255,907,516;36;F
54481;465,92,1449,1233,1205,1472;35;M
54486;1562,117,907,987,891,976,215,790,1186,996,1449,1235,795,1713,796;41;M
54495;891;44;F
54524;1259,1120,907,516;31;F
54527;675,1268,1440,907,1501,795,456,950,1120,1668,796,1197,976,215;52;F
54542;748,117;48;F
54553;1443,1449,155,996,1501,742,680,941,1212,749,1259,950,976,725,1039;48;F
54569;748,117;50;M
54575;941,1197,1669,92,1440,1639,907,516,996,1668,1450,1259,40,1120,976;26;F
54579;92,1443,1449,1501,1668,941,1233,907,996,1450,891,1212,749,1259,1120;39;F
54587;907,725,1443,996,1501,742,680,941,1450,1212,749,1259,1120,1039,976;12;F
54589;1713,1268,1440,255,1450,749,950,675,1120,40,1209,207,795,1668,1197;33;M
54594;1209,796,907,516,1501,742,725,771,255,456,1219,1450,675,1120,1039;35;F
54610;771,255,790;49;F
54618;941,680,742,996,155,1449,1443,1235,907,748,117,725,1120,1039,976;16;M
54657;1205,675,1120,1209,145,207,1229,907,1449,996,742,582,1212,146,790;33;F
54665;167,1713;68;F
54674;796,1212,1120,1197,749,891,1219,996,907,92;48;F
54688;104,1219,1235,607,795,1209,790;38;M
54708;465,516;34;M
54711;1669,796,607,255,891,749,92,748,1449,1186,582,1205,790,1120,104;46;F
54729;680,907,796,465,1669,1713,1449,996,1668,1212,749,950,1120,976,215;16;F
54731;215,749,582,996,92,796,725,1669,1713,795,907,1668,1212,1120,1197;35;F
54735;1669,907,996,1259,1120;27;M
54742;117,907,1443,996,941,891,749,1259,1120;34;M
54746;987,1501,516,1713,1562,1268,771,769,795,255,907,1235,996,1120,976;63;F
54753;1713,1440,1443,950,742;48;M
54754;891,749,1669,1670,907,155,1668,987,1450,146,1259,1120,1197,1039,976;60;F
54774;796,795,1186,1212,1233,1197,748,607,1449,996,790,1120;62;F
54793;1212,1259,40,749,680,1668,996,907,796,92,465,155,1197,1039,104;35;F
54794;748,996,1668,680,582,1669,891,117,749,215,1713,92,796,1120;32;M
54804;771,907,1449,680,987,891,930,675,790,1197,215,725,796,1209,1120;34;F
54806;976,215,907,987,891,1212,749,1259,1197;31;M
54821;680,582,1668,1501,1449,1443,516,1440,1268,1713,117,465,1209,1562,987;32;F
54842;40,215,795,1209,207,607,255,1449,996,1134,1186,582,749,1205,104;35;F
54846;255,1235,1443,1449,1186,891,146,749,950,1205,675,1039,215,104,582;90;F
54851;1120,146,1668,1562,1324,1229,907,516,155,742,941,1450,1259,1197,976;33;M
54858;207,680,1450,976,748,1259,1120,40,1039;43;F
54861;1233,215;30;F
54862;987,40,680,1562,1324;46;M
54868;1670,1669,1713,1449,891,1212,1120,976,215,996,1472,790,749,465,796;22;F
54917;996,1501,987,675,1120,1197,976,215;49;F
54923;146,996,907,145,1670,796,1713,771,795,155,891,749,790,1120,215;30;F
54931;795,1197,207,607,1143,1668,1186,582,1164,790;48;F
54966;1436,907,996,1668,941,1450,891,749,930,1259,675,1120,976;22;F
54988;1120,790,891,680,996,1235,907,1229,1268,1449,1668,742,1212,1039,104;42;F
54999;725,1670,1268,996,1219,1501,907,1449,1668,941,1450,891,1259,1120;70;F
55017;145,930,516,987,976,1120,907,146,255;30;F
55020;215,680,907,795,1440,1268,92,117,1450,1259,987,675,891,1120,976;31;M
55051;117,1670,1639,516,680,1268,941,1472,40,891,465,1440,907,1259,1120;45;F
55052;1501,1143,1440,1562,1670,117,465,1268,907,516,680,1450,1212,146,1259;46;M
55087;996,1449,1670,1450,1668,795,1440,1268,1436,1713,1219,941,1212,1259,1120;38;F
55102;769,1669,796,1212,1233,749,976,907,996,1501,941,1450,891,1259,1120;42;F
55116;40,996;31;F
55121;771,145,891,146,1120,1197;23;M
55128;795,1440,1669,796,1562,769,1324,1668,680,749,1120,976,215,987,950;51;F
55132;1443,950;36;F
55135;1669,725,891,207,1186,771,795,1197,215,1268,1639,907,1450,1259,1120;36;M
55146;987,941,1450,146,930,1259,675,1120,976,1209,1670,1436,907,516,1219;32;F
55169;465,796,117,907,1235,1449,998,1450,891,1212,749,1259,790,1120,40;51;M
55178;92,1268,1219,1120,976,1209,465,795,1449,996,680,891,749,40,215;52;F
55213;1501,1212,749,1259,1120,40,796,1669,92,207,996,1668,891,146,1205;34;F
55228;1440,465,796,1713,771,1443,996,582,891,1212,749,1259,790,1120,215;20;F
55229;1259,1472,1120,1440,92,1669,725,155,1219,1501,941,1450,1233,749,40;38;F
55245;582,987,1472,790,1197,145,207,748,1449,891,146,749,1205,104,1120;43;F
55264;1440,680,941,1450,891,930,1259,1120,40,976,215;36;M
55272;607,1449,1212,215,40,1120,582,996,1443,907,796,1440,891,749,1197;25;M
55298;796,1324,1449;18;M
55308;1669,742,1450,1259,1120,1039,215;37;F
55333;907,891,1501,680,987,976,215;38;M
55335;796,1562,1209,117,907,1443,1449,742,680,987,675,1120,40,1197,976;17;M
55370;92,1472,1639,907,1449,996,680,1450,891,1212,749,1120;45;M
55379;1219,1668,742,675,1562,92,1268,930,1120,40,215,987,146,950,1039;43;F
55410;465,1669,748,795,1449,996,1668,680,891,749,1259,790,1120,40,1197;27;M
55419;796,1562,1324,117,1440,769,207,748,255,680,950,215,40;49;M
55447;771,907,516,996,1501,941,987,1450,891,1212,1233,749,930,1259,1120;38;M
55466;891,1233,796,1669,1713,92,255,456,1143,1668,1186,998,987,1039,104;27;F
55471;1212,749,1120,40,1197,1039,987,996,1229,1440,1268,1324,1668,146,950;38;F
55507;1440,92,1669,145,207,795,1501,987,1450,146,930,675,1120,976;40;F
55522;456,742,1450,1164,146,1259,1120,1039,92,795,996,1501,941,987,675;32;F
55559;1669,1268,607,1143,996,1450,1219,1668,891,1120,1197;40;F
55573;146,1450,987,145,1039,1670,207,255,976,516,996,891,930,1259,675;44;F
55576;950,1443,742;58;F
55581;1233;50;M
55588;725,92,1668,941,1212,146,1233,749,1259,1120;50;F
55589;1233,1259,1039,215,796,1268,1440,748,255,907,1235,1449,680,146,1120;38;F
55607;1450,680,516,1670,1440;40;M
55622;1143,1443,742,950;47;M
55624;207,1235,1443,996,1219,742,950,1120;43;F
55630;795,907,749,675,1120,1197,796,1562,1324,680,987,950,40,976,215;56;M
55631;1443,796,996,582,941,1212,907,1668,1450,891,749,1259,1120,1197,104;32;M
55642;725,1669,117,92,1268,769,795,1639,516,1233,167;28;M
55648;92,748,891,1120,1449,996;32;F
55657;1713,796,92,1268,607,456,1443,1449,1668,582,891,146,790,1197,104;56;M
55659;1443,742,795,950,1120,1039;9;F
55681;950,1443,742;40;M
55693;92,1212,1233,749,1501,1449,796,907,996,941,1450,891,1259,1120,976;45;F
55709;1197,1449,675;23;M
55727;930,1440,1668,987,1212,1120,215;45;F
55739;1197,790,749,1212,1501,795,92,117,796,465,907,1449,996,891,1120;39;M
55753;1268,680,987,1120,976,215;37;F
55764;1436,92,516,1450,1212,930,907,1259,1120;56;F
55793;725,465,1669,92,1440,516,1443,1668,680,941,1450,1259,1120,40,1197;40;F
55834;40,987,1668,92;19;F
55841;1443,742,950;40;F
55844;1268,907,1143,1443,1219,1197,1562,769,996,987,749,1259,1120,1039,976;29;M
55859;941,1501,1449,1443,1713,796,795,907,996,891,1212,749,1259,1450,1120;31;M
55876;1436,1259,1120,1197;39;F
55878;516;46;F
55890;891,255,796,1669,92,1440,907,996,1219,1501,1668,941,1450,1259,1120;66;F
55899;796,465,748,607,1449,1668,582,680,891,1212,749,790,1120,40,215;14;M
55908;1713,796,1450,749,117,795,907,1449,996,1668,941,891,1212,1259,1120;30;F
55922;1501,742,1450,891,1212,146,749,1259,1205,1120,40,1039,976,215,582;3;F
55934;1120,1450,1259,749,1212,891,996,907,795,796,1713,1443,1449,1501,941;53;M
55939;1668,1120,1197,215,796,769,907,891,749,582,155,950,1669,92,795;49;F
55948;1562,1440,155,680,146,749,1120,1197;52;M
55951;796,1039,795,1501,1668,987,891,675,1120,1197,976,1450,92,215,1259;41;M
55960;987,996,1120,796,790,748,1668,1449,582,465,607,104,680,749,40;45;M
55979;748,1229,167,1186,987,950,675,742,215,1324,796,1713,1443,1120,1039;48;M
55987;675;36;F
56009;117,215,996;37;M
56012;796,1501,1668,1450,891,1212,749,1259,1205,1120,40,1039,976,215,582;2;F
56015;465,167,891,1120,215;35;M
56020;769,748,607,950,749,1120,1039,976,215,1259,1212,891,1450,996,907;34;M
56028;725;46;F
56100;796,1713,1440,795,607,1449,1668,987,891,1120,104;27;M
56113;749,795,680,1212;63;M
56122;1209,1713,1440,769,891,1120,207,748,795,607,907,1449,996,1501,582;39;F
56159;1449,1668,1501,1450,1713,796,1209,1669,996,92,795,1212,749,1259,1120;63;M
56181;1501,465,996,941,1440,1449,891,1212,1436,1229,680,1472,1233,976,215;19;M
56200;1713,117,465,1669,92,748,907,1449,996,1668,742,582,680,146,1120;34;F
56205;749,465,748,795,680,891,950,1120,40,976,215;49;M
56210;1209,1440,795,749,92,1713,1268,680,675,582,207,987,891,104,215;17;M
56234;92,748,1235,1443,1449,996,1668,891,146,749,1205,1472,790,1197,104;34;F
56282;796,607,996,582;41;F
56304;117,907,1668,742,941,1501,987,1120,976,215;43;M
56305;987,996,1235,255,92,1713,796,1472,1197,907,1440,1449,680,1212,1120;42;F
56308;907,1443,155,680,749,1120,796,1669,92,795,1668,998,1212;62;F
56341;607,796,996,582;7;M
56357;725;35;F
56378;1668,950,675,976;39;M
56380;1229,92,1713,796,1669,795,907,996,1501,1668,1450,891,1233,1259,1120;37;F
56424;1713,167;30;M
56428;207,1449,996,1186,1205,790;61;F
56459;1562,465;37;M
56464;167;55;F
56468;725,1669,92,155,1668,1259;40;F
56485;1449,996,1501,1668,998,582,1450,1233,1259,1120,725,941,675,1197,1039;30;F
56496;155,742,146,950,1205,1120,1197,1039;41;F
56524;1212,1259,675,1197;84;F
56543;1501,1259,1120;34;F
56546;796,1669,207,748,1449,749,930,1205,1472;44;F
56549;725,1669,92,155,1668;10;F
56629;907,1668,1039,215,796,207,255,155,941,891,930;43;M
56635;680,1450,1233,1120,1197,1039,255,1219,1186,582,891,1212,930,1259,675;24;F
56637;582,1449,255,207,145,771,1713,1324,465,930,1120;14;F
56669;1209,1713,749,40,748,145,796,1186,146,1259,675,92,1668,1205,104;45;F
56676;796,1562,1209,117,1713,255,891,749,675,790,1120,1197,40,104;30;M
56743;1443,1449,891,40,1268,742,1669,255,1450,749,1259,950,1120,215,104;51;F
56748;1259,40,215,976,1120,987,582,996,907,1639,795,117,1324,1670,516;38;M
56759;207,996,1219,1450,1259,1209,1440,907,680,987,675,976;38;M
56769;749,950,790,215,92,207,748,607,1449,1120;46;F
56779;987,749,796,1669,748,1143,1668,1450,1259,92,516,1164,40,976;60;M
56800;725;49;M
56810;215,976,907,1443,680,1450,930,1259,1120,742;46;F
56814;145,1713,1209,255,1449,1186,680,987,891,930,950,1205,675,790,215;35;F
56833;465,996,1259,1472,790,104,456,255,1268,607,907,516,1450,891,1120;24;F
56843;1713,907,1449,749,950,1209,1440,680,675;33;F
56849;1669,1120,1501;36;M
56850;749,1259,725,1436,907,516,1219,1668,680,146,1120,1039,976,215;38;M
56881;582,950,1120,675,1205,930,891,987,1186,1449,255,145,1713,1209,215;42;M
56887;1449,907,795,748,92,1669,796;44;M
56894;1212,1205,215,145,465,725,796,207,1235,1449,680,891,146,749,1120;34;F
56896;104,1472,749,891,996,465,117,748,907,1449,1120;46;M
56931;796,1209,255,907,941,1450,1259,675,1120;37;F
56943;207,1120,1669,117,891,92,796,607,795,1039,1713,1443,1668,742,950;12;M
56954;987,680,1501,996,907,117,1212,1120,976,215;30;M
56975;796,92,891,1120,976,215,155,1501,987;50;M
57004;996,907,680,749,1039,795,155;40;F
57008;907,1450,796,465,1713,1440,996,680,891,1212,749,1259,790,1120;23;M
57009;1669,725;64;M
57027;207,748,255,1501,1219,1668,742,941,930,675,1120,1039;34;F
57032;1440,145,207,456,146,749,255;45;F
57052;92,796,1669,1713,907,996,1668,582,941,1450,891,1212,749,1259,1120;34;F
57060;771,92,255,907,1143,996,1219,1668,1450,1164,1259,1120,215,582;76;F
57068;996,1120,465,92,1440,748,255,907,1143,1449,1668,680,987,749,675;40;F
57069;516,907,1436,1219;45;F
57084;1668,92,725,1440,748,255,155,680,891,930,790,1120,1197,40;34;F
57085;796,465,1669,117,92,1440,207,255,1449,155,1219,680,1259,950,1120;48;F
57102;796,1562,117,1668,987,790,891,1212,749,1120,40,1197,976,215;32;M
57180;1268,907,996,1450,146,976;35;F
57182;1443,742,950,1120,1039,1562,1209,1268,1440,769,996,1668,749,1259,748;38;F
57200;1450,749,1259,996,1562,796,1268,891,675,1120,40,976,215;39;M
57224;891,1039,1120,1259,749,1212,1450,941,1668,996,1443,907,92,1669,796;37;F
57225;92,207,255,907,1449,996,167,1219,1668,1186,987,891,749,790,1197;33;F
57232;771;24;M
57235;1440,796,1669,1713,92,907,996,1668,987,146,930,950,675,1120,40;28;F
57247;516,1668,987,675,1197,1120,92,976;54;F
57252;1562,795,255,907,996,1668,950,1120,215;18;F
57256;1212,1233,749,1259,1120,215,92,891,675,1197,976,907,1501,1668,987;43;F
57284;1450,941,950,742,1039;40;F
57352;1259,675,1120,1039,996,1449,1443,907,1209,92,748,987,976,215,1212;34;F
57355;1209,1669,1713,1268,1440,207,1668,1186,1212,146,1120,675,1197;51;M
57363;725,796,92,907,1443,996,1501,582,987,891,1212,1120,1197,976,215;4;F
57377;1562,465,907,1449,1440,996,998,1450,749,1120,40,1197,215,680,1268;28;M
57381;680,1501,155,516,1669,1209,1219,1197,907,996,1668,675,987,976;31;F
57392;941,1450,891,1212,749,1259,1120,1197,1669,92,907,996,1501,1668,987;11;M
57429;1229,1440,1233,1120,1039;45;F
57439;1443,582,680,941,1450,749,1259,1120,1039,725;34;M
57440;950,1472,465,1670,607,255,155,1197,215,207,748,680;46;F
57442;742,941,1450,1259,950,1039;10;F
57445;215,725,1669,1235,1443,1501,1668,930,941,1233,92;30;F
57459;516;36;M
57466;1440,996,1219,1668,1450,1120;28;F
57469;92,748,1436,1440,1235,680;55;M
57470;1209,1713,255,907,582,1039,207;9;F
57475;796,117,1670,1436,1268,1440,1562,1669,92,207,795,255,1501,1212,215;65;F
57483;796,1324,748,456,907,1449,155,996,1668,680,146,749,1205,1120,40;39;F
57485;795,907,1443,996,1501,1668,582,987,1450,749,675,1120,1197,976,104;12;M
57507;92,795,907,1449,996,1501,1668,582,1450,891,930,1259,1120,976,215;17;M
57524;1268,1440,891,987,40,790,680,465,1212,1259,1120,1436,941,1472,1233;31;M
57527;1186,1668,907,795,1669,1562,796,1197,950,155,1449,607,1268,92,117;40;M
57555;795,92,117,1669,465,796,1639,516,155,1668,987,146,1259,1120,976;32;F
57559;725,215;20;F
57562;907,1235,996,1219,1501,987,1450,891,749,1259,1120,1039,976,215,941;32;M
57571;891,1668,996,207,465,941,742,1186,1440,146,1197,1436,607,155,950;18;F
57573;1209,207,795,987,1197,976,680,1440,1259;45;M
57574;255,795,456,907,1449,996,1501,987,1212,930,1259,675,1120,1197,976;36;F
57645;796,1669,1670,1268,1440,145,207,516,987,1450,146,930,1259,215;37;F
57662;996,680,941,987,1450,749,1472,1120,976,215,516,891,930,1259,1501;37;M
57672;987,1212,749,930,1039,907,996,1219,582,941,1450,891,1259,1120,1197;28;F
57675;1440,748,907,1449,996,1668,1450,891,1212,749,1259,790,1120,1039,104;37;F
57677;725,796,1209,92,1449,1219,1668,998,680,987,675,1120,1197,215,104;42;F
57684;1436,92,1440,748,1235,680;59;F
57685;582,680,987,891,976,907,516,1219,1450,1259,1120;43;F
57686;907,1670,117,92,748,607,255,1449,1186,680,891,749,1120,40,1197;64;F
57698;516,907,255,207,796,1669,145,1229,1668,742,146,1205,1197,104,456;34;F
57754;1440,207,742,680,1450,1259,950,675,1120,1039,976,215;43;M
57756;1205,40,104,1197,1120,790,1472,930,749,891,1186,1134,996,1449,207;38;M
57789;976,1472,941,465,907,1668,215,796,1436,1268,1450,891,1212,1259,1120;20;M
57805;795,987,1450,1259,1120,749,680,1501,907,1669,796,1562,92,1440,771;34;F
57820;1209;43;F
57833;796,255,907,582,1450,1212,1259,996,1669,92,207,1501,1668,680,1120;29;F
57837;796,1449,996,1668,1186,742,582,987,891,1212,749,950,1205,790,1120;41;F
57850;1235,996,680,1450,891,1212,930,1259,1233,1120;34;M
57851;796,1668,1450,891,749,1233,607,907,1229,1440,155,996,680,1259,1120;37;M
57860;1209,1268,795,1259,1212,1450,907,987,675,1120,976;38;F
57884;795,907,996,1668,582,1450,675,1259,1120,1197;32;F
57896;796,1324,207,255,1143,1449,680,1164,1212,1197,1039,104;14;F
57898;1440,725,1562,465,117,1669,1436,92,1268,795,1219,1668,1233,1259,1197;57;F
57901;796,1186,1205,92,748,1449;34;F
57908;680,40,1324;39;M
57909;92,907,1235,996,1668,891,1233;33;M
57914;1209,1324,1713,771,795,680,941,1212,790,1120,255,1259,950;32;M
57939;1639,1668,941,987,1259,1120,976;30;M
57952;1501;36;M
57964;516,607,92,117,796,1562,1209,1440,255,1501,1668,675,1120,1197;29;F
57990;680,40,1324;43;F
57991;1440,1324,795,255,680,1120,1209,215,796,1562,1143,1039;37;M
58011;749,1562,117,1713,92,1268,769,155,950,40,976,215,1669,795,1668;42;F
58013;92,795,607,907,1443,996,1219,1501,1668,998,987,1120,40,1197,104;24;M
58028;680,1324;14;M
58030;1669,907,1501,987,1120,976;35;M
58036;1501,941,1450,1259,1120,1039,1443,1235,456,1668,1212,749,1472,215,465;25;F
58053;996,1668,1450,1219,891;20;M
58079;1669,117,1268,748,607,456,1235,516,1501,1668,680,749,950,40;34;M
58086;941,1450,930,796,1209,1449,155,1219,987,891,749,1259,675,1120,104;29;F
58089;1212;67;F
58119;795,907,987,950,1197,215,465,1268,607,1449,891,749,930,1120,790;36;F
58124;1668,1039,40,950;53;F
58126;465,725,796,117,1268,907,516,996,1668,1450,891,1212,1259,1120,976;35;M
58140;1268,680,215,675,1562,1713,92,769,795,907,996,1668,749,1197,40;72;F
58145;725,516;52;F
58154;1440,207,255,891,1669,1436,607,155,996,1259,1120,1197,1039,215,516;33;F
58165;725,796,92,1440,1501,950,1197,1668,795,1209,1669,1670,1713;34;F
58166;680,675,976,1209,117,748,207,1443,998,742,950,40,1039;41;F
58188;950,255,1209,1562,796,1268,795,155,987,675,1120,215;70;F
58190;749,465,1436,1268,1235,996,680,1450,891,1212,146,1259,1120,976,215;34;F
58210;1668,465,1501,891,1259,1669,215,92,1440,1229,680,950,1120,1039,976;37;F
58217;996,1440,1670,1669,1562,92,771,795,1668,582,987,1212,950,675,1120;50;F
58235;92,930,950,1039,1443;43;F
58245;1268,1669,1443,996,207,92,796,1197,1562,907,1668,987,675,976,215;64;F
58258;1668,40,215,680,987,976;48;F
58272;1259,1120,1039,675,215;21;M
58275;1268,1670,465,1562,1440,1639,1235,516,167,998,680,1233,1472,790,976;30;M
58297;1501,891,92,941,1259,1120,1197,976;37;F
58333;1209,92,607,907,996,1668,680,941,1450,891,1233,749,1259,675,1120;30;F
58343;795,207,1440,1268,1562,1143,516,680,1164,146,930,675,40,976,215;36;M
58396;1259,1233,891;40;F
58397;1324,891,1120,92,582,749,1449,1235;35;M
58416;1669,1209,796,907,1449,996,1450,749,1259,675;34;F
58422;1120,1324;47;M
58426;92,1440,207,907,582,891,749,1472,790,40,796,748,1235,1449,1120;41;M
58441;207,117,796,1209,1562,1436,1440,795,996,987,1259,675,1120,40,976;44;M
58443;1324,891,1120,92,582,749,1449,1235;1;M
58485;1562,796,1713,907,996,1501,742,1450,891,749,1259,1039,1212,1472,1120;36;M
58489;680,1259,1324,1120;40;F
58493;725,1713,907,996,1668,941,891,1212,146,1259,1120,1039;32;M
58525;1449,1235,1120,891,680,796,749;67;M
58528;1713,749,1197,1120,1259,1212,891,1450,941,1501,996,1443,907,92,796;75;F
58532;796,582,117;66;F
58572;1668,92,796,1713,907,1443,996,1501,941,1450,891,1212,749,1259,1120;79;M
58578;790,1197,796,465,771,1449,155,891,749,748,996,582,680,1120,104;41;M
58580;1197,796,771,748,155,996,582,680,104,465,1449,891,146,930,1120;40;F
58599;796,1562,207,680,987,146,950,675,40,1039,976,215;36;F
58625;1235,796,1209,1669,1713,748,607,1449,1219,1501,1668,749,930,790,1120;34;M
58629;725,796,465,1440,1639,907,1235,1449,996,1501,1212,749,930,1120,1039;27;M
58642;680,996,796,1562,1440,950,40;37;M
58677;1235,1501,1668,680,987,930,1120,748,1449,1186,146,749,1205,675,976;35;F
58703;1209,1436,516,1443,987,1120,976;40;F
58709;907,1501,1668,1450,976,796,465,1669,680,891,749,930,1259,1120,40;37;F
58715;1259,930,1450,941,582,996,516,907,1670,92,1219,987,675,1197,976;30;F
58718;1186,795,748,207,1268,1669,1143,516,680,1164,146,930,40,976,215;32;F
58719;1450,749,950,790,40,1324,465,1205,1669,1449,996,1668,891,1120,1197;67;F
58723;941,907,796,255,976,749,1668,1443,40,1120,92,146,607,1436,1670;45;F
58729;1440,1259,1472,891,907,796,1212,92,749,941,1668,795,1669,465,1233;29;M
58780;1209;44;F
58787;1259,790,1669,1440,1436,1235,1120,996,941,907,891,749,680,465,92;35;M
58791;749,1668,1669,92,1639,907,996,1259,1120;47;M
58792;796,92,907,1449,996,891,749,790,1120;53;M
58816;1670,1440,516,680,891;32;M
58870;1670,92,1205,675,1472,1120,146,749,996,1449,607,748,207,891,790;44;F
58928;516,155,930,1259,104,1440,255,907,1443,582,987,675,1039,976;46;F
58958;1443,1668,680,987,675,1197,40,215,1209,92,748,1449,891,749,790;39;F
58960;1268,795,907,516,996,1501,941,987,1450,891,930,1259,1120,976,215;62;F
58990;907,1219,582,1450,930,1120;27;F
58991;155,1197,1669,92,1668,987,675,976;41;F
59031;1669,92,795,907,155,996,1501,1668,680,582,987,1120,1197,215,40;28;F
59037;1562,607,1443,1449,155,996,582,1440,769,255,680,950,675,40,1039;30;F
59039;40,1324,1205,1197,104,255,516,1449,155,1450,146,1229,1233,1259,1039;38;F
59048;976,891,796,465,92,1235,1449,996,680,987,1212,749,790,1120,215;44;M
59076;769,1440,92,1209,796,1443,998,987,941,976,104,1562,1268,950,1039;41;F
59083;1229,1440,1713,1450,1233,749,1259,976,796,1669,907,1449,1501,941,891;30;M
59095;1120,1443,742,1229,748,1713,1039,255,145,769,1268,1324,1562,771,950;42;F
59128;796,795,907,516,1259,1120;39;M
59134;795,1219,1259,675,1120,1039,215;42;F
59159;795,769,1670,465,725,796,1713,92,748,1443,996,1668,742,146,749;29;F
59164;1268,748,255,516,996,1219,1668,941,1450,1259,1120,1039,1440,1443,742;42;F
59172;215,1039,1120,1668,996,1440,1268,1669;24;M
59261;725,796,1668,167,155,1449,1143,255,92,207,607,996,680,891,104;42;F
59271;796,725,1562,1669,1268,1440,769,907,1219,1668,998,930,675,1120,40;26;M
59276;1197;31;F
59281;1039,941,1219,996,795,771,1436,1669,92,1443,1501,1668,582,891,1120;36;F
59286;1562,92,769,795;39;F
59287;92,1501,742,891,1039,1670,941,1450,1440,976,907,1120,40,1259,215;36;M
59299;155,582,680,1443,1120,796,891;28;F
59325;92,607,996,1668,1212,749,675,1120,976,215;28;F
59335;996,1668,1197,976,1143,907,1440,725,1219,1450,891,930,1259,1120,215;43;F
59354;680,941,1450,891,1259,1120,976,1670,1268,255,456,1668,987,675,215;33;F
59358;1268,92,1562,465,1669,795,1501,1668,749,1120,40,1197,1039,976,215;31;F
59448;796,1562,1268,769,795,907,1668,987,1164,146,1120,1039,215;66;M
59508;996,1268,1562,207,1219,941,1450,1120,1197;29;F
59533;167;61;F
59539;996,1450,1259,1268,1436,1562,1440,907,1668,987,1120,976,215;49;F
59540;465,1209,145,255,1164,1120,1259,207,742,680,987,146,930,675,976;31;M
59551;1562,465,987,790,1212,749,92,1268,680,1450,891,1259,1120,215,976;42;M
59581;1670,1268,907,1443,1134,1205,40,790,1212,891,1668,796,465,117,1120;42;M
59584;1713,1440,1639,1229,1235,1501,1668,742,582,680,987,891,146,1039,976;47;M
59591;1669,1209,796,92,207,748,607,907,1449,1219,1668,1186,582,790,215;44;F
59623;996,456,1268,1713,117,796,1669,92,907,1668,998,749,1120,1197;56;F
59635;92,796,907,996,516,1501,987,1450,891,1212,749,215,1259,1120,976;40;F
59657;92,1212,215,1668,40,680,976;42;M
59662;465,1713,607,155,1450,1039,976,796,907,891,1212,749,1259,950,1120;52;F
59689;465,675,1472,907,1143,1449,1219,1186,1120;47;F
59691;207,907,1039,255,941;22;F
59696;891,1197,796,907,930,255,145,92,1669,1209,725,941,1039,1120,104;41;F
59699;1440,1219,742,749,1197,1039;51;M
59728;207,255,1639,907,996,582,680,987,1450,1212,1259,675,1120,1039,976;45;F
59732;117,1670,907,516,998,742,680,891,930,675,40,1440,996,1197,725;27;F
59737;796,725,1259,1450,675,1120,680,1501,907,1440,92,1669,1668,987,976;35;F
59750;465,1209,725,796,104,976,1197,40,1259,1450,1219,1440,987,891,950;37;F
59754;1443,907,92,1669,1562,1134,941,1164,1259,1219,795,1268,465,725,215;49;F
59782;1212,749,1039,215,255,1436,1120,796,795,1639,155,680,146,1205,40;35;M
59783;145,1268,1440,795,607,255,456,1197,104,155,680,987,146,1039,950;41;F
59796;607,155,950;42;M
59808;215,582,976,748,465,1443,1668,1501,790,796,1449,680,891,749,1120;31;M
59819;465,1440,771,1229,1443,155,941,1450,1233,749,1259,675,1120,40;40;F
59846;92,145,1443,146,1259,771,796,795,1668,891,1212,749,40,1197,976;38;M
59856;145,207,795,907,1668,680,1212,146,930,675,976,1669,1443,950,742;38;F
59857;796,1268,145,795,607,255,456,155,680,146,1205,1197,1039,104,950;11;M
59866;92,465,1562,1268,516,987,1120,1713,167;29;F
59898;255,1449,1219,582,891,749,104,790;26;F
59901;796,725,1209,145,207,795,607,456,1449,155,680,987,146,950,1197;7;F
59917;1039,796,145,207,456,907,1449,607,255,996,1186,146,950,1120,104;35;F
59922;1669,1209,145,207,1668,146,675,1120,1197,104,769;29;F
59931;117,465,1268,1440,748,255,907,1449,996,680,930,1120,675,790,40;26;F
59935;207,1440,796,465,795,1235,996,40,790,1472,749,891,987,680,1449;43;M
59944;1668,769,117,907,996,680,891,1233,749,1259,40,725,796,1120,215;20;F
59978;1268,675,40,976,215,795,155,996,950,1669,1324,92,1668,1259,1120;55;F
59995;465,117,1713,1268,748,907,516,680,749,1120,1197,1449,891,790,40;48;M
60019;796,930,456,907,1449,516,996,1219,582,987,749,675,1120,40,104;51;F
60038;1713,1324,1562,748,795,516,1668,987,930,215,796,742,1120,976,996;28;M
60053;456,1449,145,748,255,907,1443,1219,891,146,1120,941,675,1039,215;34;F
60070;1209,1440,155,680,987,675,40,1197,976,215;47;F
60077;950,1443,742;43;F
60078;1668,891,1120,1713,167;62;M
60111;748,795,155,1440,92,796,1562,1324,207,1443,1668,950,1120,40,1039;39;F
60122;907,215,987,796,1562,1268,680,950,1120,1039;47;M
60130;996,742,1212,749,1205,796,748,907,891,790,1120,465;43;F
60140;725,465,117,1440,207,255,907,987,930,675,976,215;21;F
60149;1669,1324,1449,155,167,1219,1186,1212,749,950,1205,1120,40,976,215;32;F
60161;749,104,1669,92,607,255,456,907,1235,1449,1134,1668,680,891,790;62;F
60177;456,680,146,950;37;F
60183;1440,749,1669,145,1449,1212,996,1668,941,891,1259,456,1501,1120,1039;35;M
60193;907,996,582,680,1450,1212,1259,675,1120;62;M
60196;749,146,1450,680,582,1186,1501,1449,907,145,92,796,1713,167;50;F
60227;1501,1449,1235,1229,207,796,465,255,907,996,742,891,675,1120;6;F
60249;1562,1669,92,795,1443,1668,950;45;F
60255;796,1259,891,1501,907;35;M
60265;1233,891,941,742,1186,456,796,1501,1219,1669,92,907,996,725,1668;50;F
60273;1212,40,1209,207,167,742,680,950,891,1443,1268,1713,796,1562,117;46;F
60275;145,207,1443,996,1219,1501,582,987,1450,146,1259,675,1120,1039;38;F
60277;1443,950,742;45;F
60285;950;47;M
60304;950,155,1440,1436,1668,987,976;36;F
60312;465,207,255,1443,680,146,1259,675,1120;36;F
60325;1186,146,1205;59;F
60332;950,1713,1669,92,1440,207,907,996,998,987,146,1212,1120,40,1039;45;M
60346;145,207,748,255,1443,1501,1668,742,582,987,891,1205,790,1120,1039;28;F
60367;796,725,1436,92,1443,996,1501,1668,1212,1259,950,1669,117,155,1120;44;F
60412;215,796,1440,996;48;F
60430;1669,92,907,996,1501,1668,582,680,1450,891,1212,749,1259,1120,40;67;F
60446;748,40,1668,996,907,771,1713,207,255,1449,582,891,1205,790,104;48;F
60471;907,1501,941,1669,117,92,1268,795,996,1668,582,680,675,1120,1197;35;F
60481;1562,92,145,795,907,155,1219,1668,742,987,146,950,1120,40,1039;4;M
60490;796,1562,1669,92,1268,769,795,1443,1668,987,1212,675,40,1039,950;55;M
60491;987,516,215;28;M
60494;167,1713;67;M
60497;998,1259,1120,40,215,1324,725,796,1562,465,769,1229,167,742,976;42;F
60513;92,680,1212,1233,215,1669,996,1501,1668,941,891,1450,749,1259,1120;30;M
60515;1668,155,1449,255,607,145,207,771;19;F
60520;987,742,1668,1143,1229,607,1324,155,1669,1443,950;45;F
60522;907,996,891,1120,1562,1669,92,207,255,1668,987,146,930,950,215;50;F
60523;1443,795,1039,742;49;F
60546;92,771,996,891,1212,749;29;F
60567;207,1443,155,950,1039;71;F
60604;465,92,996,1450,891,1449,1440,1235,1668,1186,680,749,1472,1120;56;F
60613;215,145,92,1268,255,996,1219,1668,1233,1120,1259,516,146,976,891;34;F
60625;725,1713,795,1449,155,680,941,1450,891,749,1259,675,1120,976,215;34;F
60628;582,680,987,1450,891,749,1259,950,1120,976,215,796,795,907,1219;24;M
60634;1450,1259,215,1197,1120,675,930,1209,145,207,255,907,1134,987,146;53;F
60652;1449,996,1219,582,146,1205,1472,155,941,1450,891,1212,1259,1120,104;31;F
60659;1233;43;F
60667;1268,1440,771,795,582,1197,92,146,950,117,1120,1668,996,1669,796;34;M
60677;207,255,930,1197,1440,1186,742,680,1212,146,950,675,1120,40,976;45;F
60701;749;65;F
60702;941,907,582,680,1450,891,1212,1233,749,1259,950,1120,987,675,976;33;M
60704;1209;36;F
60735;1235,155,996,1219,1501,998,582,680,987,891,1212,104,675,950,607;54;F
60766;1440,907,516,680,987,930,675,1120,40,976,215;31;M
60770;680,790,749;43;M
60784;996,1450,1233,930,976,725,1562,1669,92,255,1443,1219,1668,1259,1120;55;F
60817;40,92,1212,146,1219,456,1209,207,255,1449,930,675,790,1039,976;38;F
60831;1219,40,215,104,1436,607,255,516,155,1450,1259,950,1120;53;F
60840;1449,748,145,1440,1268,465,1209,1562,1324,207,255,987,146,1197,1039;44;F
60841;1143,1134,680,749,145,1440,207,748,607,155,1186,1205,1120,1197,104;50;F
60864;145,987,1450,146,1259,675,1197,976;31;F
60867;1259,1197,976,796,1324,117,1713,92,607,1449,155,987,1450,749,950;49;F
60871;92,1562,796,1209,104,907,1440,725,996,1668,680,950,675,1120,40;34;F
60876;987,680,582,1501,996,1219,155,1449,1443,1235,907,255,748,207,607;53;F
60885;1449,1443,907,1639,255,1713,1669,1209,725,796,92,1668,987,675,104;27;F
60903;796,1669,92,1440,907,976,215;29;F
60933;796,1562,1209,795,680,987,930,950,675;48;F
60986;796,1501,516,1670,117,1669,465,1268,1143,891,976,215;70;M
60991;607,155,950;50;F
60994;987,749,796,465,907,996,941,1450,891,1259,675,1472,1120,215,976;20;M
61001;1209,1440,987,930,675,215,1120,976;33;M
61014;1668,996,145,1120,1259,749,891,1450,907,456,748,795,1209,796;34;M
61023;1324,1440,207,1668,1450,891,1212,146,749,790,1120,40,1197,1039,976;32;M
61044;1268,796,145,207,1639,456,907,516,996,1501,742,1450,146,1259,1120;33;F
61061;1450,891,155,996,1436,941;31;F
61062;1440,907,996,680,941,1450,1259,675,1120;30;F
61068;1639,748,749,796,1209,891,680,1197,976,255,215,1259,1450,1440,1219;37;M
61106;1440,1229,987,146,675,976,215;36;F
61109;255,92,675,1450,1259,891,1120,680,215,907,976,987,1197,1440,1668;40;F
61115;950,582,941,1450,1212,1259,1120,215,207,607,155,146;38;F
61119;1450,891,1259,950,1440,465,1235,155,680,1212,749,1472,1120,1670,1233;35;F
61138;516,907,795,207,1268,1436,92,117,465,996,941,1450,891,1259,1120;54;M
61141;167,1440,117,1713,1268,742,680,749,675,1120,40,976,215;51;F
61160;516,907,1562,725,796,1501,1450,749,1259,1120,976,1669,92;47;F
61161;1212,930,796,117,1713,255,907,1449,167,92,207,1443,996,790,1120;40;M
61184;976,1259,996,987,891,1436,1450,1440,1639,1324,907,146,255,1039,215;38;F
61206;725,1713,1436,795,1639,907,996,742,680,941,1450,891,1212,1259,1120;61;F
61226;941,1450,891,1212,749,675,1120,1039,207,1436,465,748,725,1233,215;47;F
61243;155,725,1501,790,1669,92,607,907,1235,1449,996,1668,891,749,1120;76;F
61256;907,996,1668,582,680,941,1450,1212,1233,749,1259,1120,40,976,215;29;M
61279;1450;42;F
61283;1449,516,907,795,92,1669,796,1501,1450,891,1259,1120,40,1197,215;34;F
61286;1219,941,1212,1233,1259,1039,976,215;33;M
61313;748,1235,1443,1219,582,146,675,1197,104;54;F
61319;1212,146,950,40,976,796,725,1209,1670,207,748,155,996,1197,104;39;F
61328;1440,92,1669,465,796,769,748,907,1449,996,1668,891,1212,950,1120;41;F
61334;1219,749,1562,1670,516,1268,996,987,1450,1259,675,1120,1197,976,215;33;M
61348;1197,996,155,907,607,117,1259,1233,1450,941,1186,1449,465,771,456;50;M
61352;907,1501,1668,987,891,1212,930,675,1120,1197,976,215,796,1669,92;23;M
61371;891,950,607;29;F
61392;1440,996,1233,1212,749,1259,1120,1450,941,1668,1501,907,92,1669,725;18;F
61451;742,1449,907,1229,607,1440,1324,465,796,207,255,996,891,790,1120;39;M
61467;1120,1670,1436,1440,1639,907,1449,996,1450,891,1212,1233,1259,1472,215;43;M
61470;1639,987,1233,680,40,215,796,1197,976,907,996,941,891,1450,1212;46;F
61483;1324,255;46;F
61499;1713,1324,1562,92,907,1501,680,987,1259,1120,976;38;F
61500;796,92,1449,582,891;46;F
61505;1209,680,930,40,1120,725,1324,92,207,996,1668,1164,950,675,1039;10;M
61521;1268,1562,1324,1670,1713,207,255,1219,680,146,930,675,40,1039,976;48;F
61534;907,996,1197,976,1209,1669,1440,255,1219,1668,1450,891,1259,1120,1039;37;F
61536;749,1212,1668,996,92,40;36;F
61547;976,675,1259,1450,941,1668,1443,516,907,1639,795,145,1268,1670,1669;69;F
61549;215,907,465,207,1235,996,582,680,1233,749,1205,675,1472,790,104;40;F
61561;1209,930,1259,675,1120,1039,255,1639,516,582,987,891,215,1212,976;35;F
61591;145,748,1212,40,104,92,1209,1669,607,155,1134,1668,987,749,1197;35;M
61604;117,92,1268,907,996,1501,1668,582,987,1450,1212,1259,1120,40,976;39;F
61607;725,255,1233,930,1120,104;47;F
61627;796,1669,1713,92,1440,456,1501,1668,582,1212,1259,950,1120,607,155;23;M
61631;998,1268,1562,769,1436,891,976,465,996,1472;25;M
61669;1143,92,255,996,1668,582,680,941,1450,1212,749,930,1259,1120,976;52;F
61691;215,976,796,907,1449,996,1501,891,749,1259,790,1120,1039,1713,167;37;M
61693;795,145,1440,117,1669,796,725,92,207,907,1219,1668,941,1120,1039;40;F
61705;680,891,930,1259,950,1120,976,215,207,607,255,456,907,155,1039;41;F
61709;996,930,582,516,675,976,215;37;M
61710;996,891,215,1120,742,1235,907,748,207,465,796,1449,749,1472,790;43;F
61712;930,146,987,582,456,1713,725,1209,92,795,1501,1668,675,1197,104;52;F
61723;1449,996,680,1450,749,796,207,516,582,987,1259,675,1120,976,215;28;F
61731;987,749,1440,145,146;36;F
61732;1562,117,207,1235,516,987,1120,40,104,796,465,1324,1449,930,1501;29;M
61738;891,1501,987,941,1450,92,255,1219,1668,1259,675,1120,976,104,215;68;F
61746;796,1713,607,1449,996,1501,1212,675,1197,725,907,1668,749,1120,1669;30;F
61753;1039,748,146,215;44;F
61756;1259,1120,215,1562,1268,907,1472,465,1639,516,680,941,987,891,976;49;F
61757;465,680,891,1212,749,1259,1472,1120;34;M
61763;1120,790,1197,976,796,465,907,1449,891,1233,749,1472,1205,104,215;11;M
61784;117;74;M
61785;215,796,1268,255,996,582,1450,1212,1259,675,1120;33;F
61792;987,891,1205,950,155,1668,742,941,146,1259,1120,1197,1039,104,1669;46;F
61807;987,907,795,1440,796,680,1450,1259,1120,215,941,976;20;M
61817;1324,117,1670,675,1562,1268,145,795,1639,215,680,987,976;38;F
61827;1443,1449,1186,891;47;F
61828;950,1120,1039,976,1440,1670,1324,1669,465,796,1209,748,1197,215,675;36;F
61833;1449;39;F
61845;1562,1669,1639,796,92,1668,680,976,40,215,1440,907,516,1450,1120;29;F
61875;796,1639,996,1219,941,891,749,930,1259,1120,40,215;25;M
61898;1449;44;F
61902;1669,796,207,907,1449,996,891,930,675,1039,1120;18;M
61917;1120,996,1449,907,725,255;22;F
61920;1209,465,1268,907,582,891,1212,749,930,215,1449,680,675,790,1120;27;F
61928;1668,680,987,891,1212,749,1205,790,1120,40,976,215,796,92,1449;78;M
61940;796,725,465,1669,795,607,1501,1668,582,749,1472,1120,1197;31;F
61945;1233,1259,1268,465,725,996,1219,941;35;M
61947;1668,998,582,40,748,680,1440,207,996,749,930,675,1197;27;F
61967;795,1668,680,749,1120,796,1436,1440,996,1219,941,1450,891,1259,1197;20;F
61982;907,1235,1449,1668,104,749,790,1120;35;F
62002;1440,207,748,795,907,1449,996,1668,582,891,749,790,1120,104,215;37;F
62017;996,941,1120,1450,1259,1440,1670,987,516,680,891,907,976,215;37;M
62019;1259,1197,1039,976,795,675,1440,1669,1670,456,516,582,92,40;54;M
62025;1449;44;M
62037;891,1120,1039,104,215,465,1562,796,1324,907,1229,516,1443,742,950;33;M
62044;675,1120,1259,749,891,1450,941,1668,1501,996,1449,907,92,1669,725;58;F
62059;796,215,1562,1440,795,117,167,742,680,1120,155,1713,607,950;35;M
62068;1197,675,987,1219,796,1669,92,907,996,1501,1668,941,1450,1259,1120;49;F
62075;1440,117,465,1449,1120,207,255;44;F
62084;795,1639,516,155,146,1120,976,215;38;M
62093;582;46;M
62110;1235,1449,930,950,680,891,1197,255,987,1259,675;49;F
62154;907,1501,996,1219,255,976,1039,1120,1443,215,92,1562,796,725,941;17;M
62172;930,1205,790,207,907,996,1501,742,987,1450,891,1259,1120,976,215;32;F
62173;1212;42;F
62186;941,1668,1501,1219,795,1440,725,907,680,987,930,675,1120,1039,976;51;M
62189;996,987,796,1562,1713,795,1443,998,680,891,950,1120,40,1039,215;34;M
62196;907,996,1219,1501,1450,675,1120,976,1440,987;36;F
62198;891,907,996;43;F
62265;976,1268,104,92,1143,1449,582,680,891,749,1259,1205,675,1120,40;38;F
62267;1197,996,1209,907,1501,987,675,976,215;38;M
62297;1713,167,725,1669,92,907,155,996,1501,1668,1450,1212,749,1259,1120;50;F
62300;1235,1449,749;31;F
62301;1212,675,1120,215,796,465,1440,748,1229,1235,1449,891,749,1472,790;42;M
62339;145,1205,1209,996,582,749,796,1669,92,607,1668,891,1212,1259,1120;31;F
62340;1197,40,1501,155,1443,1235,1209,1436,1440,796,748,795,1229,1668,582;9;M
62347;1440,748,795,907,1449,996,1186,582,891,749,790,1120;30;F
62352;1443,796,1324,155,582,987,976,1197;39;F
62378;1472,795,607,907,1440,92,465,1669,796,941,1668,680,1259,1120,976;49;M
62392;1669,796,1440,795,607,907,891,749,790;31;M
62429;1205,104,465,255,456,907,1143,1134,1186,891,1164,790,1120,207,1449;67;F
62457;255,146,675,1443,1219,207,742,1039;33;F
62494;1669,1670,748,907,1449,155,996,1668,891,749,950,1120,675,790,1197;29;F
62508;1449,1443,1235,795,748,1440,92,907,996,1668,987,1450,1120,976,1259;37;F
62519;1562,1324,769,987,146,950;40;F
62529;207,907,996,582,987,1120,1197,976,1669,1501,1668,1450,146,1259,675;45;F
62541;92,1209,215,1449,1219,1501,582,680,1450,891,1212,749,1259,1120,1197;15;M
62577;725,1436,907,1449,996,1501,582,891,790,465,748,1668,1212,749,1120;35;F
62579;941,987,891,1212,1233,1268,255,1219,215,1120;32;F
62581;207,1209,215,1120,790,1472,891,1186,996,1449,1235,1229,748,465,796;63;F
62593;1449,996,1501,1450,891,1212,1233,1259,465,1669,92,771,795,1668,1120;52;F
62614;891,1450,941,1668,1501,996,1449,907,1440,92,1209,796,675,1120,1197;24;F
62641;1212,1259,675,1120,40,1039,976,215,796,1562,1440,795,155,1668,680;34;F
62644;1235,1449,1233,749;46;F
62663;996;41;F
62678;1449,996,675;41;F
62713;725,796,1713,907,1449,1501,996,680,1450,891,1259,1120,1197,1219,1039;27;M
62725;1324,145,1229,1143,1219,742,1450,1164,1233,790,976;33;M
62729;891,516;29;F
62731;207,1259,930,907,456;39;M
62764;1669,92,607,1449,1668,1212,1259,1120,215;64;M
62771;907,456,769,1713,796,725,92,607,516,1501,1668,582,891,1205,1120;30;F
62779;1501,1668,680,987,1450,891,1212,1233,749,930,1259,1120,40,976,215;31;M
62834;725,465,769,145,1229,1219,742,146,1233;66;F
62846;790,1501,987,1450,1669,796,465,748,1449,996,1668,891,1212,749,1120;46;F
62861;1669,92,1268,207,795,907,1443,1668,941,987,675,40,1039,976,215;69;F
62865;117,1639,516,1668,996,1134,582,1450,680,941,891,790,40,976,907;35;M
62868;155,255,207,145,1440,1436,465,796,92,1668,742,987,675,1039,976;31;F
62872;516,1670,680,987,790,40,1562,907,796,891,930,675,1120,1197,976;33;F
62878;92,748,1443,1449,996,1668,582,891,930,146,749,675,1120,40;36;F
62893;1186,987,1205,675,1472,790,104,215,1562,1440,748,1443,1449,680,749;38;M
62906;796,1440,748,1235,1449,996,1134,582,680,987,891,1212,950,1039,976;38;F
62914;907,1443,796,117,1268,996,680,891,749,675,790,1120,40,976,215;30;F
62915;1639,795,145,1440,1670,117,1143,1235,516,1259,1120,40,1039,976,215;67;F
62924;92,1440,680,1450,749,1259,1120,675,40,1197,976,215,1209,1669,1668;51;F
62932;1268,769,795,255,907,1443,742,1562,996,1668,680,891,950,1120,1039;35;M
62963;1668,996,155,1449,1443,907,456,1229,607,207,1440,92,1324,725,1120;31;F
62966;1713,795,456,907,1443,1219,1668,987,146,1197,1039,1562,1440,155,950;61;F
62970;796,1562,1436,255,907,1449,996,1186,680,1212,675;23;F
62989;1197,465,907,155,996,1186,582,987,1164,146,1233,1259,950,976,215;47;F
63000;207,1229,146,1233,1205,675,1472,1039,104;41;F
63004;795,1639,456,516,1449,996,1668,582,987,146,675,1120,1197,976,215;39;F
63009;796,255,1143,1219,582,941,1450,891,1164,146,1233,930,1259,675,1120;48;F
63023;516,771,1268,92,1713,1669,1562,795,1501,1668,998,215;30;F
63044;769,1209,207,795,1235,1443,155,1668,742,680,987,930,950,675,1039;42;F
63053;255,465,92,725,1669,145,207,907,996,941,1450,146,1259,1120,675;38;F
63058;215,1450,987,516,1235,1639,1268,117,1669,907,1668,891,1212,749,1259;53;F
63066;1120,1143,1449,1134,1186,891,1164,1205,790,104;49;F
63079;907,516,996,1668,1450,891,1259,1120,976;38;M
63081;795,207,117,1669,1562,1268,769,1668,998,950,215;47;F
63083;1501,891,1212,749,907,1164,1120,1450,92,207,996,146,930,1259,1205;42;M
63084;465,1235,941,891,1449;33;F
63089;1713,255,1324,1669,796,1209,92,207,748,1668,987,675,1120,1197,215;55;F
63098;1212,1120,1039,1562,207,255,907,1443,1449,996,998,742,891,930,950;42;M
63108;796,725,1209,465,92,255,907,1449,996,1668;40;F
63110;1669,1670,771,207,907,1449,582,1259,1120,1039;70;F
63113;748,907,1143,1449,996,1219,1134,891,1164,930,1205,790,104;15;F
63121;1324,145,207,1449,146,1205,675,1120,1039;34;F
63122;1668,987,941,795,1713,1209,1440,769,1639,1219,680,891,675,1039,976;58;M
63171;145,207,607,255,1229,1443,742,1450,146,1233,1205,1197,1120,1039,104;34;F
63180;1713,167;17;F
63196;1713,167;58;M
63214;1669,92,996,1259,1120,1268,907,1668,40,1197,976,215,1440,680,941;34;M
63221;796,1669,117,92,1440,907,996,1668,146,40;28;M
63230;680,1120,215;48;F
63241;796,907,92,155,1219,941,987,675,1120,976,215,1670,1440,516,255;33;M
63243;1443,907,207,1440,1268,215,1219,941,987,1450,891,1212,930,1259,1120;44;M
63248;1443,155,996,1668,742,582,941,1450,1212,1259,1120,1197,1039,725,146;36;F
63252;891,725,145,907,1186,146,1205,1197,1669,255,1143,1449,1668,1120,104;51;F
63255;996,1219,742,987,1212,146,749,930,675,790,40,1197,976,104,215;46;F
63290;1449,582,680,987,1212,790,1039,976,215,92,465,749,1120,117,891;44;M
63302;748,255,1449,1668,742,1120,1039,976;35;F
63318;996,1443,907,607,796,117,1668,749,950,1120,1440,795,680,891,40;39;F
63335;1143,1443,1219,742,1450,1259,1120,976,1324,907,155,996,950,1197,215;27;F
63342;255,456,516,1134,1668,680,146,1205,1197;23;F
63349;725,796,465,1324,1440,207,255,996,680,987,930,1259,950,1120,1039;15;M
63369;742,582,941,987,1450,891,1205,1039,145,748,907,1449,1501,146,215;38;M
63371;1120,675,987,1219,1562,1324,117,1443,680,950;42;F
63379;582,680,1443,976,215,1449,987,796,1713,207,996,891,749,1120,790;24;M
63388;996,117,1562,742,891,146,1205,1197,215,1669,207,1668,1120,1713,167;61;M
63391;1713,167;17;F
63392;117,465,796,607,1235,1449,996,891,1212,146,749,930,1259,1205,1120;34;F
63397;1120,40,1039,215,1562,92,1268,769,795,255,1134,680,987,950,675;57;F
63409;92,1440,976,1197,40,1120,675,1259,1450,680,582,1668,907,1501;39;M
63430;987,1450,976,749,215,1669,1668,748,1235,1449,996,680,1205,1120,104;45;F
63449;1670,92,1668,1259,1120,1197,976,215;70;F
63459;1670,1436,516,996,1668,941,1450,1259;44;F
63460;1449,1186,680,891,40,465;45;M
63462;215,1039,1143,1440,1669,1209,796,1436,1268,795,155,680,1164,950,40;25;M
63464;215,1259,675,941,987,1120,976;31;M
63475;1440,1713,117,465,1562,891,1472,790;23;M
63479;891,796,1209,1436,1440,907,1235,996,680,1212,749,1259,1120,40,1039;34;F
63506;1449,582,941,1450,1212,1233,790,796,907,996,891,749,1259,1120,215;21;M
63514;465,92,748,255,456,907,1449,996,1186,749;24;F
63520;996,1197,516,907,1501,998,749,796,1713,92,1668,987,1259,950,1120;42;M
63522;1212,796,465,1669,92,1449,996,1668,749;43;F
63546;167,207,1440,1669,117,1713,1268,795,907,891,950,1120,1197,1039;46;F
63560;941,1134,907,456,1639,607,1440,1436,1670,1669,1209,207,1219,930,1197;21;M
63568;607,582,950,40,1209,1669,207,456,1668,987,930,675,1197,976,215;22;F
63569;675,976,215;56;F
63577;996,1669,795,1268,92,117,796,1440,680,1436,1639,987,1259,976,215;43;F
63580;145,255,1450,891,1212,930,1209,771,907,996,582,146,1259,675,1120;39;F
63586;1713,92,769,907,987,1212,1197,976,215,796,1562,1268,996,1120,1039;31;F
63592;1669,92,1268,207,255,456,1449,1219,1668,1450,930,1259,675,215,1120;19;F
63596;941,891,1501,155,1450,1668,996,907,1713,1669,725,796,749,1259,1120;52;F
63613;40,92,1268,795,907,1668,987,1120,215,1562;34;M
63650;1219,1134,1186,950,1120,104,1209,1449,930,675;30;M
63651;1450,891,1212,749,1259,950,1713,117,1209,796,92,155,1668,1120,1197;34;M
63665;1209,771,145,207,255,456,1219,1186,146,930,1205,675;1;F
63701;1669,92,1440,795,1235,796,215,1120,749,891,680,1668,996,1449,1209;37;M
63708;1209,1669,207,607,456,155,1501,1668,987,930,950,675,1197,976,215;28;F
63710;1235,1449,941,891,1472,104;37;M
63739;996,1668,987,930,1713,771,795,582,146,749,950,1120,1197,1039,215;33;F
63754;456,215,1197,749,1212,1450,117,92,1268,1440,795,1668,680,987,976;56;F
63766;1229,976,1324,1268,207,456,1143,1209,255,1449,155,582,987,749,930;36;F
63776;796,1436,748,155,680,1212,40,1197;41;M
63785;155,1164,749,40;35;M
63786;725,796,1562,1669,1670,1713,92,255,907,167,996,1134,1668,987,1120;39;F
63787;748,255,907,1449,996,582,680,1212,749,950,675,1120,40,1039,215;40;F
63792;795,607,907,155,987,1259,1120,104;51;F
63796;146,996,607,255,1212,748,1450,1259,1120,465,92,1440,215,941,930;32;F
63800;1639,1450,1259,465,92,941,1324,255,907,1219,891,1212,930,1120,1039;33;M
63809;1501,941,987,1212,146,1259,675,1120,40,104,215,725,1669,907,996;51;M
63813;607,996,891,1120,104,748,255,1449,1186,930,1205,146,675,465,790;37;F
63839;1259,40,1197,215,1668,1440,92,1562,796,996,891,1120,987,976,907;33;M
63847;950,155,675,1209,207,255,1449,1039,1713,1120,796,907,996,891,930;40;F
63854;1450,987,465,92,1440,40,1669,1668,796,907,996,891,749,790,1120;36;F
63862;1669,92,1440,996,941,1450,891,749,1259,1197,795,742,907,987,976;33;F
63868;1562,769,155,998,976,215,1039,1259,749,891,1450,987,680,1501,795;40;M
63886;1268,907,516,1450,976;32;M
63893;725,1668,796,607,1449,1219,891,146,749,1205,1120,1197,790,104,1186;51;F
63900;1197,976,987,941,680,742,907,796,1440,795,155,996,1668,582,1450;27;F
63903;950,255,769,1440,1669,1562,207,795,1219,1186,680,987,675,40,976;46;F
63908;1501,796,1562,1713,92,1268,987,891,749,1259,1120,40,976,104,215;63;F
63913;976,1668,155,207,145,92,796,1209,1669,1268,795,907,987,1120,215;40;M
63928;92,795,907,950,40,796,1562,1669,1713,1668,1120;60;F
63951;1713,167;64;F
63963;1229,255,796,145,748,1501,1668,582,680,749,1205,1120,1039;53;F
63977;742,1212,976,215,996,749,1120,941,465,796,516,155,891,1440,950;31;F
63982;1668,680,950,40,1120,215,92;50;F
63985;976,1212,1668,155,92,1669,117,907,987,1120,215;63;F
63996;987,891,796,465,1713,1268,907,1235,680,749,675,1120,40,976,215;40;M
63998;1443,1197,1039,907,987,976;46;F
64005;40,976,1120,1197,215,796,1562,1268,1440,769,795,998,987,950,1039;47;F
64021;1669,117,907,167,996,1668,680,987,146,749,950,40,1039,976,215;22;F
64022;796,1562,465,117,1713,92,748,1229,1443,998,987,1120,976;34;M
64026;1229,1235,1501,1259,796,1562,1669,1713,1670,1440,1449,1212,1039,1120,1197;22;M
64037;1670,92,117,1669,796,1713,1440,795,680,1120,1197,1039,976,215,167;34;M
64042;1209,465,1670,117,907,996,680,987,1450,1120,40,215,891,675,976;35;M
64047;796,465,1268,145,748,1235,1449,1219,104;39;F
64060;1668,795,1324,1209,1440,607,456,155,680,1212,930,950,675,1197,1039;32;F
64066;1670,1440,516,155,1219,1259,1120;30;F
64074;1450,950,1120,976,92,1324,1440,771,607,1229,1212,1259,1197,796,907;40;M
64085;930,255,1120,1668,1268,796,1233,891,1450,996,516,1670,680,987,976;31;M
64092;769,1440,92,1209,796,1562,1268;51;M
64096;1449,456,795,207,145,1440,92,255,907,996,742,146,675,1120,1039;29;F
64101;796,1562,1209,1713,1440,771,795,907,996,1668,680,1212,1120,215;45;F
64105;1259,796,1268,996,680,1450,1233,255,930,891,976,987,1120,516,1670;30;F
64107;1669,465,207,748,607,155,749,930,1472,215;41;F
64108;930,1259,950,1205,1472,40,976,215,1229,1219,742,146,675,1197,1039;37;F
64142;907,1449,996,680,891,215,1209,207,748,255,987,930,1205,675,1120;43;F
64152;145,1501,907,987,976;33;F
64155;465,796,145,207,748,795,1449,998,680,987,891,749,675,40,104;40;M
64159;1713,92,1268,769,607,155,1668,998,680,987,1212,146,950,40,1039;36;F
64177;976,215,1713,607,1268,92,675,1120,1197,104,1562,1440,769,155,1039;39;F
64192;1233,1669,725,796,1440,907,1668,987,146,749,1259,1472,1120,215,976;38;F
64195;930,950,790,976,1670,1639,907,516,996,941,1450,891,1259,1472,1120;37;M
64201;465,1449,749,790,1120;44;F
64222;795,155,1039,950;58;M
64235;680,1120;46;F
64242;1229,907,987,1197,104,215,1562,796,725,465,92,1639,1120,1039,976;38;M
64261;930,950,1120,749,92,748,1449,1668,607,1134,1205,996,790,207,255;36;F
64265;1443,1235,907,607,117,1669,92,1440,996,1668,1212,1472,790,1120;40;F
64284;1501,167,1235,1639,795,1713,796,465,117,1449,998,582,1212,749,40;36;F
64301;680,996,1449,907,795,1440,92,1669,796,1212,1205,790,1120,40,1197;38;M
64302;1440,930;60;M
64305;1669,1639,1259,675,104,1039,930,146,1668,92,795,1219;68;F
64323;796,675,680,1268,771,1440,1562,1209,207,795,987,950,1197,1039;40;F
64342;1668,582,456,998,742,769,1440,516,1562,1713,795,1443,987,950,215;37;F
64346;582,941,1450,1212,930,796,465,1449,996,680,891,1233,749,1259,1120;34;M
64350;465,1670,117,92,1268,255,1449,1668,998,1259,790,1120,40,1212,725;33;F
64376;1669,907,1668,1120,215,104,976,790,1472,891,680,582,996,1449,465;27;F
64383;941,987,1450,891,1259,1120,215,976,516,930;44;F
64386;907,155,1205,790,1472,1120,1197,215,145,207,748,255,1443,1449,146;38;F
64402;1449,1443,456,207,145,1436,1209,607,255,1229,1219,146,1233,675,215;35;F
64433;996,1219,987,1472,1324,1229,742,941,1450,891,1259,1120,215,1449,1233;36;M
64479;795,1668,930,675,1197;24;M
64498;465,996,1134,749,1259,790,1120,1039,207,255,907,1449,1450,891,1233;40;F
64516;582,891,104,215,680,987,1212,146,950,675,1120,40,1039,1440,207;62;F
64533;1669,516,1668,582,941,987,1450,930,1259,976;45;M
64538;796,1668,987,146,1197,207,145,1669,675,976;39;F
64540;796,215,255,1713,40,675,950,1120,1039,1562,769,1268;36;M
64546;92,1235,1449,891,749;67;F
64551;996,1443,516,907,1229,207,1669,796,742,891,1450,930,1259,1120,976;34;F
64557;996,117,582,891,104,465,748,607,680,1212,749,1259,950,1120,40;35;F
64573;891,1668,795,748,92,1669,465,749,1205,790,1120;67;F
64593;92,1324,465,1209,1562,796,1669,145,207,1449,996,1668,146,1472,1120;38;F
64594;1440,145,255,146,1205,790,104,748,680,749,1120,207,607,456,1449;41;F
64598;1440,255,1669,92,145,795,1501,1668,1164,1205,1233,930,675,1197,1039;68;F
64601;976,680,1259,1120,1197,215,1209,1268,207,516,155,996,1668,941,987;50;F
64604;790,1039,795,1268,92,117,465,1259,907,1449,749,1120;53;F
64605;582;25;F
64613;796,1669,255,1443,155,1668,680,146,1713,145,795,607,1120,1197;31;F
64622;255,207,1268,92,1209,1562,796,1669,1324,1713,795,607,155,1668,950;33;F
64624;255,907,1449,1186,582,891,1205,675,790;45;F
64638;1713,1440,1501,215,987,976;19;M
64642;1324,607,145,1669,1562,796,950,987,1668,769,1713,92,1268,795,255;68;F
64657;769;68;M
64662;1668,1197,1713,167;63;F
64667;796,465,92,1440,907,1449,996,749,1120;40;M
64671;215,1562,1669,1670,1713,92,771,748,795,907,996,1501,1668,146,1120;51;F
64707;465,1324,996,1450,930,1120,40,1039,1562,1443,742,950;39;F
64716;680,987,950,1120,1039,1562,1669,1713,92,795,998,1212,930,40,215;47;F
64719;769,1443,996,680,1120,1713,92,1440,795,907,1668;49;F
64723;1259,40,1197,104,1639,907,516,996,117,1670,92,675,976,987,215;46;M
64724;1440,92,117,1669,1562,907,742,987,1039,215;36;F
64748;1713,907,1443,996,1501,680,941,1450,891,1212,1233,749,1259,1120,1197;35;F
64759;1501,155,1440,1639,907,1449,996,941,1450,891,1212,930,1259,675,1120;32;F
64760;1450,1197,1120,1259,1212,155,907,1440,725,795,255,930,675;29;F
64775;155,891,749,950,1440,907,1443,742,680,1450,1212,1259,1205,1120,1039;39;F
64785;675,1668,145,1268,1324,796,92,207,795,255,456,987,215,40,1039;51;M
64789;976,1120,675,1259,749,1212,891,1450,987,941,1668,1501,996,907,795;35;M
64790;907,1268,465,1562,1440,680,891,790,40,976,215,795;46;M
64795;1120,1039,976,215,1209,1669,92,907,996,1668,742,680,987,891,675;38;F
64799;891,1450,987,1501,1219,92,771,795,907,155,996,1668,1120,1197,215;42;F
64809;1501,1219,796,725,1669,1440,907,996,680,987,1450,891,1259,1472,1120;36;F
64816;92,1440,795,907,1449,996,1668,582,1450,891,1212,1259,1120,1197,215;52;F
64819;680,987,749,1120,1443,742,40,1039;38;F
64820;950;72;F
64833;950;34;M
64846;92,796,725,1669,771,795,516,155,1219,1501,1668,930,675,1197,976;30;M
64847;516,1120,796,155,146,1669,92,1229,907,1443,1219,582,1259,1197,1039;38;F
64851;907,145,1440,1268,92,1669,796,680,941,891,675,1120,976,1197,987;38;F
64853;1039,1197,1120,1259,1450,987,941,1668,1443,907,1440,1219,1669,465,725;43;F
64869;987,456,795,748,207,771,1268,1713,465,1209,796,930,1259,675,976;28;M
64870;1443,941,1212,1668,1713,1450,1501,582,1259,1197,796,92,996,749,1120;40;M
64900;1443,1501,582,1120,1197,104,796,145,1229,907,1449,996,987,146,675;34;F
64903;117,1713,92,907,516,1449,996,1501,1668,742,1233,749,1120,40,1039;37;M
64937;675,1229,92,1324,1120,1197,104,1501,907,1669,725,1562,1436,891,1668;39;F
64984;1212,1120,104,1197,996,907,796,1669,92,1449,1501,1668,891,749,215;35;F
64992;1186,1259,976,796,748,907,1450,941,1120,255,680,996,516,1440,930;27;M
65000;1440,92,725,796,1668,1259,675,1120,1197,1436,607,907,1449,146,1639;28;F
65011;1440,1259,976;42;M
65019;1039,976,215,1449,907,1268,117,465,1324,1450,891,1212,1120,1229,1233;62;F
65021;796,748,607,167,1186,891,146,749,1205,1472,790,1120,104;37;M
65024;465,796,1669,92,207,748,607,1449,996,1668,891,1205,790,1120,104;34;F
65056;1669,117,1268,680,1120,40,1562,1440,607,1219,1668,987,1197,215,795;32;F
65064;976,1562,1440,795,155,742,987,950,1039;47;F
65073;1669,996,680,987,1259,1472,1120,40,976,215;70;F
65081;1120;40;M
65133;1562,1668,146,40,950;50;F
65135;1443,987,1668,998,1562,1669,1324,1713,769,167,950;49;F
65137;1713,1209,92,207,748,1443,1668,891,146,1205,790,1120,40,104,215;49;F
65142;207,1669,92,255,516,996,1259,1120,1039;16;M
65145;1212,1472,1197,1219,1501,1668,941,976,907,1449,996,1450,891,1259,1120;42;F
65148;1669,92,907,996,1501,1668,941,1450,891,749,1259,675,790,1120,40;31;F
65195;1501,1668,582,987,1212,1197,1120,1268,769,607,907,998,950,215,40;32;F
65196;92,207,1235,1449;29;F
65213;1436,1450,930,1259,675;38;M
65219;795,950;46;F
65223;92,1440,1235,1449;7;M
65225;255,950,976,796,680,987,675,215;57;F
65236;907,456,207,145,117,1324,1209,465,255,1449,891,1205,790,1120,104;45;F
65243;796,1562,1209,1713,92,907,1449,167,998,1212,749,1259,675,1120;46;F
65291;1669,1670,92,255,1639,907,146,1259,675;28;F
65292;796,1209,1668,1219,996,907,1440,92,1713,1450,891,1233,749,1259,1120;48;F
65301;145,255,976,1501,907;35;F
65331;456,996,1143,207,145,1324,907,1134,987,1450,146,1259,675,1197,215;51;F
65339;582,749,1197,1324,1209,255,1443,1669,1440,996,891,790,1120,1668,1212;36;F
65361;795,1219,941,1450,891,1259,1120;30;F
65373;207,255,146,930,1205,1039,215;38;F
65401;582,987,146,1259,1120,1197,795,255,996;35;F
65410;771,1436,1669,725,207,795,1219,941,1259,675;31;F
65427;1669,117,1440,1450,1259,92,680,907,996,1219,1501,987,1120,1197,976;34;M
65460;749,1259,1212,1450,1501,1449,907,796,1669,996,1668,891,1120,790,215;18;F
65502;456,769,1440,1268,1562,796,1669,1713,795,907,155,996,1668,1120,215;48;F
65504;465,1669,92,1449,1219,1668,1186,987,891,749,1259,675,1472,215,1120;48;F
65520;907,1449,996,680,1212,749,790,1120;50;F
65538;796,907,155,996,1501,1668,582,891,1450,1212,749,1259,950,1120,40;30;F
65539;680;34;M
65559;1209,255,769,1670,1562,725,215,675,987,742,998,516,1440,950,1039;48;F
65566;1450,891,1259,1120,1039;36;F
65569;1143,145,1440,1268,1562,1209,207,795,255,987,146,930,675,1039,215;33;F
65572;1668,680,1212,930,1259,1209,907,516,987,1450,146,675,1120,1039,976;37;F
65585;1713,796,907,1443,996,1668,680,891,1450,1212,1233,749,1259,1120,1197;36;M
65609;215,675,1235,1639,1670,117,207;47;F
65617;1197,215;59;F
65625;155,1668,1324,1209,725,680,749,930,675,1120,40,976,104,92,987;37;M
65643;92,1440,907,1443,1668,950,1120,40,1197,1669,117,1713,145,795,104;47;F
65646;1669,92,996,1668,680,941,1212,749,1259,1120;44;F
65676;1669,1209,207,1668,1436,92,1440,996,1501,941,1450,891,1259,1120,1039;34;M
65688;1713,167;50;F
65708;907,795,117,1669,582,1450,1259,675,40,215,92,146,930,1120,976;40;F
65730;1436,1669,1209,796,465,207,456,1235,1443,1449,1186,146,1472,790,104;42;F
65750;796,1669,207,795,907,1235,155,680,987,1120,40,215;69;F
65756;796,92,748,907,1235,1443,1449,996,582,891,1233,1120,215,1713;40;F
65763;465,117,748,795,1229,1235,1449,1668,1233,930,1205,1472,1120;60;M
65791;941,1259,675,1120,104,1268,976,1212,1233,1219,1440,255,1039;33;F
65801;207,1449,996,1186,146,1233,1205;44;F
65808;1450,930,1120,795,1268,1324,1501,1443,1668,1212,1259,1205,950,1197,215;24;M
65819;117,1268,749,1197,215,796,1562,92,795,155,680,987,675,40,976;32;M
65834;891,1212,146,930,1259,675,1120,40,1440,92,207,725,1233,255,1039;40;F
65854;1450,1120,1440,145,907,1219,146,1197,255,1443,1472,941,1233,930,1039;36;F
65871;996,1233,1197,796,725,1440,607,907,1449,891,1212,749,1259,1120;53;F
65872;796,1443,941,987,1450,891,1212,1259,675,1120,1039;48;M
65885;1501,976,215,1259,117,796,891,749,104,92,155,1197,996,790,680;45;F
65886;941,1233,1259,790,1120,796,465,748,749,1472,1039,1449,1440,1235,146;30;F
65913;1440,607,155,680,675,40,976;53;M
65918;950;36;F
65958;1668,998,582,941,987,1450,891,1212,1233,749,1259,1120,40,976,215;28;F
65967;1268,891,1212,976,680,996,1259,675,1120,1197,1449,255,207,796,1209;44;F
65971;1212,1039,771,795,607,1639,155;43;F
65976;1120;69;M
65983;987,1562,117,795,40,1197,1039,976,215;37;M
65995;1186,582,941,1212,749,40,1450,1669,725,117,907,1219,1668,1259,1197;45;F
66001;1440,607,1229,907,1449,155,996,1219,680,1450,891,1212,1259,950,1039;25;M
66007;725,1501,891,1450,749,1259,1562,1713,1268,998,987,1212,976,215,1039;39;M
66064;1449;35;M
66078;1443,930;46;F
66081;146,795,155,950,607,976,680,987,675,1197,215;41;M
66094;907,1164,1259,950,207,255,1219,1205;42;F
66109;1235,996,976,749,891,680,1449,1324,215,1668,92,1669,930,675,1120;29;F
66151;941,1219,1443,1639,207,1562,796,907,1449,996,680,1450,891,1259,1120;29;M
66153;1440,92,1713,117,465,796,795,680,987,891,749,1472,790,1120,976;28;F
66163;1639,1450,907,1229,607,1670,725,1324,92,1440,516,680,891,1120,976;27;F
66166;996,1501,998,742,582,1212,1120,40,976,215,796,1449,680,891,749;37;M
66175;40,104,796,516,215,976,1212,907,996,941,1450,891,749,1259,1120;39;M
66199;1562,465,117,1268,146,725,1670,607,516,155,998,950,790,1039;47;F
66206;92,749,40,1197,725,1436,155,742,146,675,215,1440,941,1259,976;23;F
66248;1449,1205,1197,1039,207,255,742,146,145,950;36;M
66275;146,207,1197,796,1209,1443,675,1120,1039,215,1562,769,742,987,950;44;F
66277;675,976,796,1713,92,1440,255,907,1443,1668,742,987,950,1120,1039;36;F
66279;907,1443,1668,950,1039,215,796,1562,1713,769,795,998,680,987,40;34;M
66283;92,1268,795,1668,146,1197,950;57;F
66285;1670,516,680,146,749,1259,675,1120,976,215;52;F
66314;796,950,1205,1209,795,255,1229,146,1233,675,1120,1197,104;50;F
66335;92,1440,255,456,907,1219,680,1450,1259,215,987,891,675,1120,976;45;M
66355;104,1436,680,795,607,1668,950,40;33;M
66364;1259,1197,215,976,796,725,1562,117,92,907,996,891,1449;27;F
66367;456,1450,146,771,907,1186,215,104,795,1259,607,1639,1134,950,1197;38;F
66396;796,891,907,1450,1639,1197,1120,987,976,1259,1212,40,215,1440;71;F
66405;742,255,748,207,145,1268,1713,1449,891,146,1205,1472,790,1120,104;45;F
66407;1713,167;22;M
66409;207,748,795,607,1229,907,1449,1668,1186,582,891,215;46;F
66415;795,582,1120,1562,1209,769,1443,742,987,146,950,675,1039,976,215;8;M
66458;1436,92,1440,207,907,996,1219,680,941,987,930,675,1039,215,725;35;M
66465;907,996,941,1450,891,146,1259,1120,1669,92,1668,1472,1039;41;M
66478;465,1229,516,742,1450,891,1259,1120,1039,976,796,1670,92,907,146;44;M
66482;987,146,675;36;M
66497;1197,1668,749,1449,1443,1235,907,255,607,795,748,1440,1268,92,796;21;F
66511;796,748,907,1235,1449,680,987,891,1212,749,1259,790,1120,976,215;34;F
66524;795,1324,1562,725,1209,465,1713,582,1440,207,255,1143,680,675,104;38;F
66525;907,582,1233,749,930,1472,769,795,1449,996,1668,1450,1259,1197,1120;22;M
66533;1670,207,1229,1212,749,996,1219,1134,1668,1186,987,1259,675,1197,104;74;F
66555;1713,92,607,1235,680,790,40,104,996;32;F
66561;1197,40,1120,1205,1259,891,1450,941,742,1668,1219,996,1449,907,1229;44;M
66564;1449,1501,996,742,1212,1259,1120,1039,796,725,1229,891,1233,675,976;37;F
66575;1324;52;M
66576;1443,1120,796,1670,1713,748,795,1449,1668,582,891,950,790,1039,215;75;F
66598;907,996,1259,1197,1324,92,795,1668,680,987,1212,675,1120,40,1039;50;M
66606;1219,1120,1197,1039,725,907,1668,996;49;F
66614;1449,996,1219,1501,582,680,941,1450,891,1212,1233,749,930,1259,1120;27;M
66620;1713,117,465,1324,92,207,516,742,1450,1120,907,987,1259,1197;34;F
66622;796,516,996,1501,1212,1120,215,1440,1639,1436,1235,680,941,987,976;31;M
66625;1229,516,1443,930,1039,1235,1233,675,1472,465;34;F
66636;516,907,795,1268,117,1440,1443,996,1668,1212,1259,1120,976,104,215;39;F
66642;1039,1449,1324;43;F
66643;465,1440,748,1449,996,582,680,1212,749,930,1205,675,1120;22;M
66645;1235,907,465,796,1562,748,1449,680,891,1233,749;41;M
66649;145,1229,1668,891,790,582,207,748,607,1449,155,146,749,1205,1120;42;F
66662;516,1235,907,996,891,40,1120,1436,725,1449,748,749,790,1197,104;32;F
66682;976,987,1268,1713,796,1669,92,795,907,996,1668,582,749,1120,40;39;F
66688;675,1268,92,795,907,1501,1668,1450,1120,40,1440,680,987,976,215;40;M
66700;1259,1472,1120,1197,796,465,748,795,907,742,790,40,1039,215,117;35;M
66712;215,675,891,941,1668,996,1219,255,207,1436,1440,976,1209,725,680;31;M
66728;1205,40,1324,145,1229,155,941,987,1450,891,146,675,976,1039,215;3;F
66738;749,1120,976,1450,1669,92,795,907,996,1501,1668,680,891,941,1259;43;F
66742;1472,465,749,1235,1449,680;38;F
66768;987,795,155;61;F
66780;1205,1219,104,1197,1134,1164,795,1449,1186,996;30;M
66793;582,1259,1120,976,104,1440,145,207,607,255,155,680,987,146,675;36;F
66815;796,465,92,207,748,795,607,456,1219,1668,987,891,749,1197,104;61;F
66823;1268,1450,1259,1440,1209,907,742,680,987,891,1120,1039,976,215;32;M
66838;771,1440,1713,117,1324,465,1209,907,1501,742,680,987,675,1120,976;37;F
66842;796,1562,1268,155,1668,987,950;38;F
66867;92,1449,1668,1501,1212,749,1639,796,907,996,941,1450,891,1259,1120;35;F
66895;1212,749,796,465,207,907,891,1205,1472,1120,104,748,456,1449,790;37;F
66898;996,1134,1668,742,1205,790,40,1197,607,1229,155,891,749,1259,950;48;F
66922;207,255,907,1668,742,582,146,1259,1120,1039,215;34;F
66928;1440,675,976;40;M
66938;725,1669,1443,155,1219,146,207,92,516,1668,941,1233,1259,1039;37;F
66959;155,146,1233,749,1197,976,92,516,1501,1668,941,987,891,1259,1120;36;F
66973;1562,1324,117,1440,795,907,516,680,987,146,950,1120,40,1039,215;41;M
66979;1562,769,795,167,998,146,950,1039,215;69;F
66981;796,1450,1212,1259,907,891,790,207,1449,680,930,675;28;M
66982;976;28;M
66987;796,1268,795,907,1443,167,1219,742,941,1450,891,1212,749,1120,215;28;M
66993;465,796,748,907,996,1219,680,1259,675,1120,976,987,891,790;33;M
67015;941,1450,891,1212,1259,215,1562,796,1669,795,1120,907,1668,92,1197;35;M
67017;907,1449,725,92,996,1501,1219,1668,941,1450,891,1212,749,1259,1120;31;F
67023;92,456,1449,996,582,941,1450,1259,675,215,907,1501,987,1039;34;F
67045;1229,1443,742,215,930,1259,1039,976;73;F
67053;1713,1324,1259,1120,1039,976,941,795,996,1436,1669,1668,117,92,1235;69;F
67056;607,1134,117,104,1219,1197,215,796,92,795,155,1668,987,1120,950;40;F
67065;1668,1449,207,92,907,255,1501,675,215,1209,1440,996,987,1120,1197;26;F
67068;516,907,255,145,680,987,1450,891,146,930,1259,1120,1039,976,215;43;F
67094;987,675,976;36;M
67107;1713,771,769,516,1443,1120,40,1039,796,1209,145,207,456,987,950;48;F
67124;117,1324,1669,1562,796,907,1443,582,215;11;M
67133;796,1324,92,1268,1440,207,795,1449,891,950,675,1120,40,1197,1039;21;M
67142;771,1134,1186,742,941,891,749,790,1039,1436,207,255,1450,146,1259;39;F
67144;1440,1670,1669,92,207,155,1668,1186,680,1212,930,950,1205,1197,1039;44;M
67148;950,1450,891,987,742,1668,1219,155,907,795,1440,1670,145,516,146;38;F
67153;145,92,146,1197,1039,1440,795,907,516,155,1501,1668,941,1259;36;F
67159;1450,1120,996;40;M
67172;1670,1713,1440,207,748,795,92,1268,998,1120,1039,796,1562,769,680;23;M
67173;796,907,996,1668,1212,749,1259,1120,92,465,1449,104;61;M
67205;255,1449,996,1212,930,675,1120,1039,796,1209,1713,92;21;F
67224;1219,582,987,1450,1259,725,1669,92,1668,675,1120,1197;32;F
67227;1229;42;M
67285;207,145,255,1229,907,996,742,582,941,891,1450,146,1259,1120,1039;37;F
67296;891,1472,796,725,1449,465,1669,92,795,1668,950,1120,1197,104;58;F
67311;1669,92,1501,1668;36;M
67321;1562,1212,907,1229,795,748,207,1440,117,1324,996,987,749,675,1120;50;F
67326;255,92,1669,207,607,907,465,1268,1440,749,680,891,675,40,1039;16;M
67338;680,215,987,675,976;36;M
67346;117,92,1268,1440,795,907,996,1501,1668,987,675,1120,976,215;21;M
67353;1209,796,1440,207,748,607,155,1186,680,891,1164,749,1472,675,790;43;M
67362;891,582,996,1443,907,795,1440,1268,1324,1209,1562,930,1120,1039,976;14;F
67365;680;41;M
67369;996,680,941,987,1450,1212,930,1259,950,1205,790,1472,1120,215,582;13;M
67370;996,795,465,607,907,155,1668,680,1259,950,790,40,1120,1197,104;35;F
67414;145,255,456,155,996,891,976,207,907,1450,987,146,1259,675,1120;38;F
67440;1668,582,987,215,1209,1713,607,907,1449,891,1212,749,1120,1235,996;42;F
67444;796,92,907,1443,996,1450,891,1212;35;F
67456;1501,907,207,1440,145,255,941,680,987,891,146,675,40,976,215;37;F
67461;725,796,1669,92,1443,1449,996,1501,1668,680,941,1450,1212,1259,1120;39;F
67463;1436,796,465,207,748,1134,1668,1186,891,146,749,1205,675,1120,104;34;M
67466;465,748,749;28;M
67478;145,207,607,255,907,1449,1186,1120,790,1205,930,749,146,891,582;36;F
67502;796,1120,1197,456,907,255;28;F
67509;1259,1268,749,465,1212,1039,1233,796,1209,1669,1219,1668,941;42;M
67554;950,1443,742;43;F
67573;1562,92,987,215;68;F
67577;1501,1212,749,1259,40,796,1268,1440,907,1449,996,680,891,1120,215;28;F
67590;1501,941,215;32;M
67623;795,907,155,996,1501,941,1450,891,749,1259,1120,1436,1440,1219,680;36;F
67631;117,1670,1440,145,167,1219,680,1212,1039,1197,795,1229,146,1233;38;M
67643;255,1143,1443,996,1120,1197,796,907,1449,582;46;F
67658;1669,1209,1120,790,1259,749,891,1450,1668,1501,1449,907,92,465,796;33;M
67673;92,795,1449,749,1197,1669,1268,907,1143,1219,582,941,1450,1259,1120;32;M
67676;742,930,1205,1120,465,1440,1449,582,891,1472,790;36;M
67700;1668,790,996,1449,1235,1440,1436,796,680,1450,891,1212,749,1259,1120;49;M
67702;1450,1212,675,1669,207,1219,1668,987,1233,749,930,1259,950,1120,976;35;F
67710;907,1443,1449,996,742,582,891,1212,146,749,930,1205,675,1120,1039;45;F
67717;465,117,907,1450,1259,1120,215;32;M
67745;1209,796,1669,145,748,907,996,1219,742,146,749,1259,1120,215,1039;43;M
67752;907,749,790,1039,215,104;34;M
67754;1039,742,950;40;M
67756;1120,1639,907,516,996,891;41;M
67758;996,1268,117,795,1450,749,1259,796,680,987,1120,976,1562,40,215;41;M
67763;1501,1219,155,1449,1443,907,748,207,1440,92,1209,796,996,582,680;31;F
67765;1562,465,117,1436,1639,516,155,996,941,987,1450,1233,1259,976,215;67;M
67767;769;61;M
67784;1440,748,607,255,1235,1449,1186,891,749,930,1205,790,1120,1197,104;38;F
67787;1209,796,207,1440,996,92,1235,1449,891,146,790;34;M
67802;725,607,907,996,680,941,1450,891,1259,950,1120;50;F
67804;92,1668,146,675,215,976,1120,1259,891,1450,987,996,907,1440,1501;41;F
67807;255,145,92,1669,117,1713,748,607,795,1443,742,146,950,40,1039;38;F
67824;1212,1197,1668,1501,996,92,796,907,1449,1259,1450,1233,1120,749;32;F
67849;1450,582,1713,796,1669,465,1259,1436,92,941,725,215,891,680,976;48;M
67891;907,680,1212,1268,996,941,1450,891,1233,749,1259,1120,976,725,215;25;M
67897;749,1259,796,1562,1268,1440,795,907,680,891,950,40,1039,215,976;40;M
67899;1259,1472,796,725,1436,1268,1440,1235,941,987,1450,976,215,1229,1233;30;M
67929;941,1668,996,1443,255,1440,92,796,907,1501,680,675,1120,1197,976;32;F
67940;255,1501,1668,987,725,1209,1268,1440,907,516,675,1120,996,976,215;29;F
67963;92,1449,790,465,207,748,891;44;M
67999;1669,796,1436,795,907,1668,582,1450,891,1120,941,1259,104,92,1219;53;F
68010;976,465,796,795,1235,1449,749,255,1120,891,582,1205,790,207,996;40;M
68011;607,255,748,725,145,456,516,1443,146,930,1259,1120,1039,976,215;39;F
68022;582,996,796,465,117,1440,748,795,907,1449,155,1668,749,950,40;58;F
68042;1436,1669,1268,1440,795,907,1501,987,675,40,1120,1197,1039,976,215;44;F
68066;725,1450,1259,675,1472;16;F
68078;1670,725,146,1450,987,1186,996,907,255,117,1209,465,516,891,215;32;F
68092;1440,207,748,1449,1186,146,1205,1120;39;F
68102;465,607,1235,680,749,790;45;M
68104;1669,1713,92,907,1668,582,680,891,749,1120;35;F
68109;976,749,998,40,1039,796,1562,1713,1268,769,795,215,680,950,1120;65;F
68135;680,146,1120,976;36;M
68149;996,1668,1186,582,987,1212,146,749,930,1259,675,1120,40,1197,1039;23;M
68171;976,1120,1259,996,907,1197,215;37;F
68173;796,1669,92,795,516,1501,1668,1259,1120,1197,976;34;F
68181;155,1668,582,749,675,1197,145,207,748,1449,742,891,146,790,1120;47;F
68187;950,675,40,1039,215,1324;64;M
68196;749,1668,1669,92,1440,795,607,155,1501,680,987,950,675,976,215;42;F
68198;465,748,1449,749,930,1205,675,1472,790,104;33;M
68209;1713,582,1668,146,1197,1039,1259,790,976,104,749,680,92,891,117;28;F
68220;1713,167;41;F
68250;1209,1669,92,930,749,146,680,1443,207,117,1324,950,675,40,1039;11;M
68257;742,1205,607;37;F
68265;1669,987,675,215,1219,1268,1668,941,1197,976,725,92,1440,255,680;46;F
68273;976,1039,1197,40,1120,891,1450,987,155,1639,145,725,1324,146,742;29;M
68312;1268,748,907,1219,1501,998,582,987,1233,749,930,950,40,976,215;31;F
68331;680,1440,215,976,907,1501,255,1120,996;33;M
68336;1120,891,117,92,1440,748,607,907,1449,155,1219,1186,680,1205,104;68;F
68352;941,950,675,1039,976,215,796,1324,92,207,1443,1450,891,1259,1120;24;F
68355;1209,907,1443,941,987,1212,1120,1039;40;M
68360;207,1443,1219,1668,146,1120,1039,976,215,725,255,941;33;F
68379;795,987,146,1120,1197,976;37;M
68385;1562,680,930,215,796,465,907,1449,996,891,749,1472,790,1120,104;34;M
68386;1472,725,796,1209,907,996,941,1450,891,1212,749,1259,1120;30;M
68394;796,1209,92,907,1501,996,1219,582,941,987,1450,891,1212,1259,1120;67;F
68397;207,796,725,145,255,516,1219,941,891,146,1233,1205,1120,1039,215;39;F
68398;796,891,582,456,795,748,790,40,1440,771,607,1449,1219,675,1197;58;F
68402;950,749,680,1134,167,795,1440,1501,941,1039,987;26;M
68406;796,1562,92,207,748,790,582;43;F
68422;1209,145,1229,907,996,742,582,680,987,146,930,1259,675,1120;37;F
68423;215,976,675,987;69;M
68436;907,1443,742,1450,1205,1039,1120,1259,207,748,255,1449,582,146,749;43;F
68442;796,1562,1324,1039,976,215;40;M
68471;1120,1259,1212,891,1450,987,941,582,1219,1501,996,907,92,1209,796;81;M
68496;1229,516,1449,1219,742,215,907,1443,996,582,1450,1212,1259,1120,1039;37;F
68503;1209,215,941;30;F
68524;998,891,749,1259,790,796,1209,795,907,516,996,1668,680,1212,1120;29;F
68534;1143,1219,146,950,40,607,795,155;45;F
68591;465,795,582,1449,1268,796,987,40,976;53;F
68615;987,941,582,996,516,907,1639,1268,465,796,1450,891,1259,1120,976;32;F
68658;1440,907,155,996,1668,742,941,1450,146,1120;34;M
68692;749,1212,891,941,680,582,795,1440,796,907,996,1450,930,1120,1259;27;M
68700;987,40,215;26;M
68719;1450,891,146,749,1259,1472,790,1120,215,796,207,1229,1233,1235,1449;34;M
68720;1039,607,891,950,1205,790,998,1501,1449,1229,748,207,1324,465,725;41;F
68723;1639,1324,1219,987,1039,976,941,795,790,680,465,215,117,1212,104;17;M
68732;1669,1670,207,1219,749,790,40,215,1039,891,987,680,1440,1436,976;36;F
68740;1668,790,215,976,1197,40,891,117,1713,92,795,155,996,987,1120;60;F
68755;1639,1235,516,1164,941,680,1443,1668,987,1450,1259,675,1120,1197,976;40;M
68775;1562,1324,1713,92,1268,769,795,146,950,1039,976,215;42;F
68792;1670,1713,1443,40,1668,998,950;44;F
68796;1713,167;71;F
68820;907,795,207,145,771,92,1669,796,465,748,1449,1668,891,790,1120;40;M
68828;976,1120,1259,891,1450,941,680,996,1449,1443,907,1440,1670,465,796;43;F
68835;1268,607,255,907,516,1212,1259,1120,1197,215,1443,155,207,1219,1039;40;F
68855;1259,1472,104,796,92,607,255,1668,215,117,1670,1268,1639,891,1120;41;M
68857;1443,255,1268,117,1669,1440,907,996,941,675,1120,976,725,1219,1233;37;M
68873;255,456,1143,1449,891,1164,749,1205,1120,1197,748,996,1186,146,790;44;F
68885;1668,117,996,516,1186,1450,1212,1259,1120,1197;40;F
68897;1450,1219,1212,146,1259,1120;29;M
68905;907,1120;35;F
68947;1324;51;M
68964;582,796,1713,92,795,907,996,987,1268,1259,1120,1209,1669,1440,1668;41;F
68967;796,1562,456,1233,1205,155,92,1324,742,680,749,950,1443;34;F
68972;749,1450,941,1219,996,1449,1268,907,516,987,215;25;F
68986;1440,207,255,976,1450,1197,456,155,1120,1259,675,1209;38;F
68989;1120,1197,976,795,92,1436,725,1443,996,1668,1219,907,1669,891,1039;43;M
68994;950;16;F
69019;680,675,255;37;F
69032;1209,465,1669,92,207,748,795,1449,996,1668,146,930,749,1120,40;44;M
69049;996,1268,1436,1120,40,987,891,1639,1450,1501,907,215,675,976,1259;32;M
69054;748,1229,907,996,742,941,1450,891,749,1259,1120,1039;49;M
69057;1120,1450,742,1134,516,1639,145,92,1670,1562,1440,795,1259,950,1039;41;F
69060;145,1440,1268,117,465,796,92,207,749,1259;35;F
69062;796,1713,92,771,582,680,987,675,1120,40,1197,976,215;36;F
69072;748,1229,1443,155,891,1449,146,1120;37;F
69077;582;51;M
69099;1639,1259,1120,907;41;F
69123;987,1449,1450,1259,675,1197,1669,907,996,1501,941,891,1120,976,215;48;F
69132;941,987,1450,891,1212,1233,749,1259,1120,976,215,1472,1440,516,680;33;M
69133;1450,891,1212,1259,950,1197,796,92,795,907,1219,675,1120,40,976;25;F
69139;155,996,1668,987,1450,976,215,1669,1440,607,255,1639,1259,950,675;60;F
69143;907,1450,146,1259,1120,207,742,1039;40;F
69150;1562,92,769,795,907,1143,996,1668,680,950,40,1120,1197,1039,155;37;F
69156;1668,1443,1219,1212,1120,996,891,796,790,749,748,607,582,465,104;32;F
69161;976,1197,1450,582,516,1440,796,725,1669,92,795,1501,1668,987,1120;40;F
69170;987,1120,976,215;35;F
69182;215,950,987,1668,155,207,145,795,1501,725,255,1443,1449,941,1039;49;F
69226;146,987,996,1449,907,1669,92,795,1668,1186,582,749,1120,1197,104;38;M
69238;796,749,950,40,1440,748,1639,680,1039;13;M
69257;1562,1713,1268,795,907,680,749,950,675,1120,40,1039,215;33;M
69259;1562,796,456,1668,680,987,146,749,930,950,675,40,1039,976,215;34;F
69262;1668,1212,749,675,796,117,207,748,795,907,996,1450,146,1259,1120;42;M
69266;796,465,1440,207,907,1449,1186,1212,749,675,1120,215;27;F
69272;117,907,1197;25;M
69288;1039,1670,1259,1120,1440,1268,941,516,117,465,725;56;M
69289;725,1219,891,1259;38;F
69292;796,907,1449,996,1501,1450,891,1212,146,749,1259,1205,675,1120;37;F
69298;1713,796,1440,907,996,1501,680,941,1450,891,1212,749,1259,1120,976;33;F
69302;1669,92,145,255,516,1501,1668,742,987,146,675,1197,1039,976;35;F
69308;796,1713,1268,680,987,1120,1197,215;61;M
69312;582,1450,891,1259,1472,215,465,748,907,1443,155,1212,146,1233,1120;39;F
69325;996,1668,680,941,987,1450,891,1212,749,1259,1120,104,1443,907,725;48;F
69341;1209,795,1235,1449,1219,1186,987,1233,930,675,1472;30;M
69352;255,1143,1235,582,680,1212,675,104,796,207,456,1449,155,1186,749;41;F
69367;996,1501,1668,907,92,1669,941,987,1450,891,1212,749,1259,1120,976;50;F
69382;675,1039,215;40;M
69385;92,771,769,145,456,1713,1268,795,255,907,996,1668,950,1120,215;59;F
69397;725,207,1639,987,215;36;F
69402;976,796,1668,987,1450,891,749,1259,1120,1209,92,207,680,40,215;45;M
69412;796,1713,92,748,1668,790,1120,215;73;M
69418;1669,92,1443,742,1668,680,950,1039;37;F
69440;1209,996,987,146,1259,675,1120,1197;37;F
69471;950;45;F
69477;117,907,155,950,1120;48;F
69479;1669,1713,1268,769,207,795,155,167,1219,1668,987,891,146,950,675;65;F
69503;1436,92,996,582,1450,1259;37;F
69513;907,1562,987,1120,976,215;31;M
69518;796,1209,1669,1268,769,795,998,1212,146,675,1120,1197,215;71;M
69531;675,930,146,891,987,941,1668,1219,516,907,1229,748,207,92,725;32;F
69536;725,465,117,1670,1268,1440,1229,907,516,941,1259,1039,215;48;F
69550;215,465,582,891,748,1235,680,790;46;M
69559;1562,1440,1268,92,117,1324,1669,748,996,987,40,215;25;M
69569;582,941,1450,1039,675,907,795,1440,92,725,1212,1233,749,1259,1120;17;M
69621;675,146,987,941,1668,1449,795,1440,92,1669,465,1209,1268,255,1039;38;M
69650;996,907,795,1268,1669,465,680,941,1450,891,749,790,1120,1197,1259;27;M
69665;1713,167;43;M
69685;1235,795,748,769,1440,1268,1713,1670,117,907,680,1450,1259,675,1120;39;M
69694;1120,92,255,996,987,146,675,1197,976,215;46;F
69705;582,1212,1205,796,1669,207,255,1449,146,907,1440,465,749,930,1120;14;M
69725;1212;94;F
69728;976,1039,795,748,1209,1669,1670,1713,92,167;48;F
69760;1668,1443,1219,1212,1120,996,891,796,790,749,748,607,582,465,104;4;F
69767;1713,796,1209,207,996,941,1212,930,675,976,725,1235,1219,1233,1197;48;F
69785;1440,516,1501,1668,891,749,1259,675,1120,40,1039,976,92,987,1197;38;F
69805;1324,465,1120,1039,117,145,207,907,1443,996,742,1197,1233,950;44;F
69806;465,748,1235,680,582,891,790,215;12;M
69808;1120,1186,1449,907,255,1268,40,675,749,748,207,1440,465,796,680;31;M
69813;607,1443,790,215,796,92,1235,996,891,582,680,749,1120,40,976;39;F
69818;1450,742,1443,1229,255,145,1440,207,907,516,1219,146,1259,1472,1120;32;F
69820;1209,92,771,996,1219,1668,582,987,1450,1233,930,1259,675,1120,104;35;M
69832;465,748,1235,582,680,891,790,215;10;M
69839;796,1449,987,891,749,465,92,1639,680,40;37;M
69853;796,1268,795,907,996,941,1450,891,1120,1197,976,215,1440,987,1259;37;F
69861;725,1209,1449,996,742,582,796,1229,907,155,1668,998,950,1120,1197;31;F
69871;742,976,796,1562,1669,1440,907,996,680,950,1120,40,1197,215,155;36;M
69897;465,748,1235,582,680,891,790,215;43;F
69908;1669,92,795,1639,996,1450,749,1668,987,1259,1120,40,976,104,215;30;F
69914;92,207,795,907,1443,1668,742,950,1120,104,215;48;F
69931;1668,1443,1219,1212,1120,996,891,796,790,749,748,607,582,465,104;1;F
69942;950,1443,742;47;F
69946;987,1669,795,1668;51;M
69962;607,996,742,950,796,1669,92,795,1235,1501,1668,680,987,891,1205;44;M
69987;1668,1449,1669,92,907,996,941,1450,891,749,930,1259,675,1120,1039;22;F
69990;1713,1197,1668,1443,1324;54;M
69993;1436,1229,996,987,1450,930,1259,1039,215,1324;35;M
69998;725,516,1668,987,1450,1233,749,1259,950,976,1669,92,155,680,1197;33;F
70009;1219,1668,941;43;F
70015;725,1219,941,891,1259,675,1120;39;M
70031;1450,1501,996,456,771,1436,1713,1669,725,92,1219,1668,987,1120,976;57;F
70037;155,987,930;39;M
70042;950,1668,907,255,607,207,1440,92,1713,1669,1562,725,796,742,1443;38;F
70054;1039;47;M
70088;1164,1440,92,1212,146,1233,1669,1209,725,675,1197,1039,104,987,1120;46;F
70102;1449,1668,582,680,891,1212,930,790,1120,725,1209,92,207;26;F
70108;1668,795,1440,92,1669,465,1268,907,996,1219,941,1450,891,1259,1120;23;F
70117;1197,1120,1450,996,1443,907,255,207,725,146,930,675,1039;38;F
70133;1669,145,1186,1120,92,207,748,255,1449,1668,582,146,749;32;F
70151;749,146,582,1668,1449,255,748,207,92,1120,1186,145,1669;35;M
70168;146,1501,155,1670,1440,675;39;F
70172;215;53;M
70174;1669,1436,1440,680;48;F
70206;215,790,1205,891,987,748,1449,796,749;37;F
70215;742,790,465,1562,1443,1449,155,1219,930,215,607,146,1324,1472,104;35;M
70229;769;66;M
70234;1450,1639,1501,516,465,92,907,996,941,976,796,725,1670,680,675;30;F
70238;749,1197,1039,950,1440,795,607,976,907,1443,155,987,891,1259,1120;46;F
70242;1120,1197,104,215,907,255,1713,1209,1562,796,1268,167,1501,1219,996;36;F
70248;1450,1120,1259,987,941,1668,1501,1219,996,907,1436,1209,92,1440,1669;40;M
70249;207,1436,1670,1324,1209,1562,516,1449,742,891,675,255,987,1039,146;29;F
70261;1443,1212,950,1039,1197,40,749,582,155,1669,725,92,795,1668,146;29;F
70270;1205,145,1713,117,950;65;M
70273;996,582,680,987,1450,1212,749,796,1669,92,769,950,1120,1197,1039;41;M
70275;680,1501,941,1450,891,146,1259,675,907,1443,996,1668,1212,1120,215;35;F
70276;1186,795,748,145,1268,117,1449,146,1472,675,1205,950;63;F
70290;255,40,976,104,1501,1668,582,680,987,1259,790,1120,996,1197,675;30;F
70304;796,117,465,92,907,1440,748,1449,941,1450,930,1472,790,1120,215;25;M
70305;255,1443,582;31;F
70307;795,1669,996,1668,582,941,891,1450,930,1259,675,1120,1039,725,255;19;F
70318;680,891,1501,996,1268,907,941,1450,1212,1233,1259,1120,40,976,215;49;M
70319;155,996,891;75;F
70322;748,1120,1449;34;M
70327;987,1219,996,796,1324,1440,1639,907,742,1450,891,1259,675,1120,1039;40;F
70328;1324,1209,725,796,1713,996,680,987,950,1562,1229,742,976,1039,215;28;F
70362;907,996,1450,1259,1120;35;F
70388;207,607,255,1143,582,675,1197;39;M
70389;207,607,255,582,930;13;M
70390;1670,907,1449,996,680,987,1450,749,930,1259,1120,976,104,215,1143;30;F
70396;465,1669,92,748,907,1668,749,1120;38;F
70432;725,155,1219,1233,1197;47;F
70438;1440,748,1639,907,1449,996,742,582,680,941,1212,749,1259,1120,1197;35;F
70451;1562,1440,207,155,582,680,950,675,215;54;F
70465;795,155,987,675,976;23;M
70477;769,207,950,215;65;F
70484;1501,996,907,749,1259,976,1120;43;M
70508;907,996,1501,582,680,941,987,1450,891,930,1259,675,1120,1039,976;35;F
70512;976;62;F
70546;1713,1670,796,1209,465,117,1235,167,987,749,930,675,1120,40,215;42;M
70548;742,207,795,117,996,907,1440,92,1259,675,1120,40,1039,976;45;M
70551;742,680,987,891,146,749,950,1205,675,976,40,155,1668,1039,1324;43;F
70552;1259,907,1443,1235,1440,1436,748,1449,996,1668,1450,891,749,790,1120;36;F
70553;1436,1268,1639,40,976,215,790,1472,167,1670,117,1562,465,748,516;25;M
70565;795,907,996,1212,146,1120,117,680,40;40;F
70589;1670,1669,1436,92,771,795,607,456,907,516,1219,1668,146,1120,1197;25;F
70604;725,976,1197,1259,1212,1219,516,1235,607,1268,891,1668,1713,1670,796;27;F
70624;907,996,1501,680,1450,891,1212,1233,749,1259,1472,790,1120,1197,976;53;M
70625;795,1440,1436,1209,725,516,1501,987,1450,891,1259,675,1120,976,215;26;M
70626;1669,465,1268,771,607,907,1143,1668,790,1450,996,1219,1259,1120,40;49;F
70628;1324,516,987,1259,1039;37;F
70641;795,516,998,987,146,930,40,1039,215,1562,1670,769,607,155,950;64;F
70661;155,215,1209,891,675,987,255,1197,996,1120,930,976,907,1501;27;F
70667;465,1449,1668,891,1233,749,1205,790,1120;32;F
70676;456,607,207,1449,1120,749,680,748,104,790,1205,146,255,145,1440;5;F
70680;796,1324,748,907,1443,1449,996,1501,742,680,987,891,146,749,1039;37;F
70681;92,907,996,1668,1450,891,1259,1120,796,1268,1440,1562,795,1039,1501;35;M
70685;215,1268,92,255,607,1209,796,117,1120,891,941,749,582,790,996;42;F
70686;465,748,1229,1235,1449,155,680,891,749,1259,675,40,1039;33;M
70687;40,675,930,92,987,680;33;F
70713;1501,1219,1668,582,891,1212,749,1120,40,1197,796,92,907,1449,996;44;F
70714;795,907,1443,996,1668,582,680,941,1450,1212,1120,891,1259,516,255;35;F
70740;796,465,1449,891,146,749,1205;35;F
70759;1501,976,907,891,680,117,1324,1713,795,950,1120;44;F
70771;675,796,1440,680,987,146,215,891,907,516,930;36;F
70775;987,1212,40,1562,907,680,1450,1259,215,1669,92,996,1668,1120,976;66;M
70777;215,1440,796,795,1229,907,1235,996,680,987,1212,1233,1120,40,976;46;M
70783;1209,207,996,1134,1186,1205,790,1120;38;M
70784;996,891,1233,1449,907,749,796,1670,1713,1212,1120,1450,1259,1501,941;35;M
70785;907,1235,1443,1668,582,941,987,891,1212,749,1259,976,1450,675,1120;54;F
70786;1668,680,1233,1205,1197,104,976,215,1209,1440,145,742,987,146,675;39;F
70793;796,725,1669,1440,748,607,516,1449,1668,998,987,976;39;M
70801;1259,907,1120,215,796,1669,117,769,1197,1562,1713,92,795,167,1668;26;F
70827;92,795,607,1449,996,1668,582,987,891,146,930,950,1205,790,1120;43;F
70846;771,456,907,996,1259,1450,950,675,607,155,1219,941,930,1120,1197;46;F
70851;1562,1268,769,1219,1450,1259,1039;58;M
70860;146,215,104,1197,1120,987,1501,1143,907,1639,255,771,1440,92,1670;36;F
70872;796,1440,771,1639,996,1219,987,930,976,104,1209,516,675,1120,1197;26;F
70873;1039,255,1268,207,907,1449,996,1219,1501,742,941,1450,1212,930,1259;38;F
70878;891,907,796,117;82;F
70889;907,1669,1436,996,680,891,1450,1212,146,1259,1205,1120,40,1039,976;43;M
70899;1670,1436,92,1268,1440,1259,1120,1669,907,516,996,1501,1668,891,976;30;M
70903;255,907,1449,1186,680,1450,1120,1209,516,1219,987,930,675,1197,104;27;M
70924;215,1268,1212;60;M
70929;796,92,675,1449,1668,680,987,1120,607,795,1713,1669,1209,1197,104;43;F
70933;1669,145,207,1501,987,146,675,907,976;33;M
70947;1219,1197,907,1449,996,1668,680,941,1450,891,749,930,1259,1120,976;50;F
70952;742,950,145,255,456,907,516,1668,1501,680,987,930,1259,1039,976;38;F
70953;998,941,1450,1259,1472,1120,1197,1562,1639,516,976,92,1668,680,891;34;F
70960;796,1440,795,680,1259,1120,1197,976;40;M
70977;796,92,1668,987,1212,675,976,725,1209,907,155,996,1259,1120,1197;59;F
71004;1443,1450,1205,796,1713,1268,748,907,1668,891,749,1259,790,1449,1120;57;F
71010;1197,1039,987,146;40;M
71053;1197,987,680,742,907,1229,207,145,1440,92,1669,465,1235,1449,146;34;M
71075;1450,1164,1259,215,987,1668,207,941,1229,1233,930,675,1472,1039,976;63;M
71082;146,749,1639,907,996,680,1450,1212,1259,1205,1120,40,1039,976,215;43;F
71086;796,1324,145,255,907,996,987,891,675,1120,1670,516,1501,725,976;30;F
71087;725,1669,92,145,207,255,907,1668,941,1450,146,1259,1120;36;F
71093;1443,771,465,976,92,1324,1669,1562,1668,1501,998,1212,749,1120,40;28;M
71114;998,891,1472,1120,92,725,465,1440,1443,680,941,1212,1233,1259,215;36;M
71139;748,1229,907,1449,1668,941,1450,891,1212,146,1233,1259,1205,1120,1039;31;M
71142;1501,907,976;31;M
71147;930,1259,1120,1039;39;M
71163;1501,996,1443,1229,1440,907,1668,680,987,1450,749,146,1259,1120;35;F
71176;582,1450,1212,749,1259,465,92,996,1501,891,146,930,1205,1120,1039;33;M
71177;1186,987,891,790,465,1440,255,907,996,680,146,749,1120,40;42;F
71196;771,145,207,795,748,1219,1039,255,1229,456,155,742,146,1205,1197;58;F
71207;907,680,1450,1039,976;53;M
71220;92,117,1713,1324,1209,796,1562,1268,769,680,987,1120,40,215;66;F
71245;1229;19;M
71255;155,680,950,976,40,1039;36;F
71260;1259,950,1120,976;44;M
71261;941,1449,769,1562,1450,680,1259,1713,1440,907,996,1501,790,1120,796;20;M
71269;516,1212,996,40,155,1324,1120,1039,1268,215,950;25;M
71277;796,1562,1209,769,456,582,987,1212,950,215;59;F
71285;516;32;M
71305;215,996,907,1501,891,1120;32;F
71308;1450,215,796,155,795,987,907,996,891,1212,1120,1713,1668,1501,582;25;F
71319;582,1212,749,790,1039,1219,1449,456,795,1120,1197,1562,1209,92,769;35;M
71328;117,1268,907,680,987,976;33;F
71335;796,1713,92,1268,1440,795,607,456,1443,987,930,1259,950,675,1120;15;M
71350;976,1436,117,1669,1562,725,796,516;41;M
71363;145,748,255,675,215,1440,907,516,996,1450,146,1259,1120,1039,976;36;F
71375;1440,607,742,1259,976,1120,1212,891,1450,987,996,907,941,1233,215;24;F
71386;1713,1268,907,1443,996,1501,891,749,680,987,950,1120,976;43;F
71387;465,207,255,742,1233;41;M
71434;987;31;M
71437;215,146,1450,987,941,1668,516,907,92,117,1669,795;43;F
71450;1212,146,930,1120,1039,976,1440;41;M
71455;465,117,1670,891,1669,1436,1268,795,996,1219,1668,1450,1233,749,1472;64;F
71460;1669,465,1209,207,255,1449,1668,1186,582,891,749,930,675,790,1120;26;F
71461;1669,1670,1713,92,207,255,907,996,582,941,1450,749,930,1120,516;37;M
71474;987,950,675,976,215,1562,796,1669,607,1443,1668,680,146,749,1120;32;F
71476;1449,1219,742,582,1205,1039,255,1324;40;F
71498;1120,907,996,1212,749,465,891,1233,1440,255,1449,680,987,675;48;F
71550;976,796,516,1449,930;27;F
71554;796,1562,1440,795,907,996,941,1450,891,1212,1233,749,1259,1120,1501;25;M
71579;1449,907,1120;43;F
71581;1450,891,749,725,92,1440,680,976,1259,675,1120,1669,907,996,1668;40;F
71582;215,796,725,465,1669,607,749;49;F
71592;1562,465,1440,907,795,996,1501,941,1450,891,1233,1212,749,1259,1120;81;M
71597;1440,207,255,907,1219,680,1450,891,1259,1120,1197;44;F
71645;796,516,1443,1039;42;M
71664;1235,907,456,255,795,207,1440,1268,92,1436,117,1669,465,1209,796;28;M
71678;1233,1235,92,1449,749;34;M
71685;796,907,996,941,1450,891,1212,749,1259,1120;29;M
71706;996,1562,1501,1668,582,891,1212,1120,796,1268,40,976,215,1713,987;61;F
71707;40,516,207,1268,1324,1562,1209,1440,680,987,146,465,675,215,930;43;M
71720;987,930,675,996;33;F
71722;117,1235,155,749,40,796,1562,1669,996,790,1120,1668,891;34;F
71728;1229,582,1450,891,976,742,1209,796,117,748,907,1219,1233;34;F
71733;680;37;F
71744;1219,996,1449,1443,255,207,1436,1440,907,680;44;F
71751;795,167;47;F
71757;1212,255,465,92,207,748,1235,742;35;F
71777;996,145,1436,987,1501,155,907,795,1440,1669,92,1668,675,1197,976;38;F
71791;92,607,1449,1668,1164,996,1212,1120,104,1186,582,891,146,1205,790;43;F
71795;1562,769,207,795,742,987,1197,1039,215;41;M
71814;1668,742,891,1212,146,790,1120,1197,796,456,907,1449,996,680,749;32;F
71815;1669,92,255,1443,1668,941,1039,907,996,1450,891,146,749,1259,1120;44;F
71826;215,1120,891,795,92,1713,117,796,680,749,950,40;37;M
71827;1668,1449,1212,891,40,1120,1259,907,1440,92,1669,796,748,749,680;57;M
71831;1209,207,146,675,255,941,748,1039;38;M
71841;40,1197,215,796,1669,1324,1713,92,1268,1440,749,950,675,1039,976;25;F
71848;1440,891,907,516,1443,1670,1669,1233,941,1197,1120,1668,456,92,1039;29;M
71851;1268,1713,117,796,1562,987,907,996,1668,582,950,1120,215,941;51;M
71858;796,465,748,907,1449,996,742,1212,1233,749,1472,790,1120;40;F
71869;1209,465,1449,1501,1186,582,930,1120;26;F
71882;742,582,987,675,1120,1039,976,215,1209,1669,1670,1668;30;F
71892;92,1669,748,795,1219,742,1212,796,465,1449,1668,680,891,790,1120;41;M
71909;1120,907,941;34;F
71910;1120,790,891,582,155,465,92,207,255,1443,1449,1668,1186,1233,749;41;F
71921;950,1324;47;F
71951;907,465,145,207,255,456,1449,1186,742,582,891,146,749,930,1205;42;F
71968;145,1268,92,1562,795,155,1668,742,987,146,950,1120,40,1039,215;1;F
71975;1669,1440,907,996,1501,1668,680,987,1450,891,1259,675,1120,1197,976;37;F
71976;795,1501,104,40,1259,891,1450,987,1668,996,907,1268,796,1120;53;F
71992;1449,1259,1120,1039,771,996,456,907,891,146;64;F
72003;795,1440,680,465;36;F
72014;40,104,1197,1120,1450,996,1669,92,607,155,1668,950;30;F
72016;1713,167;72;F
72022;1324,771,1219,146,930,1197,1039,976,215;26;M
72050;1713,117,465,796,1669,92,1440,795,907,516,996,1668,1450,1259,1120;30;F
72071;976,40,1120,950,1259,907,1669,1324;50;F
72087;796,1449,1668,891,1212,749,1259,1120;32;F
72142;790,796,1669,1324,92,1440,1229,1143,516,1219,680,941,891,1259,1120;45;M
72155;1472,790,215,1668,748,92,465,725,1120,1197;62;F
72176;1669,1562,1713,92,40,582,117,796,907,996,1668,680,950,215,1120;30;F
72181;582,941,1212,749,950,1120,1209,1669,117,92,795,1668,891,675,40;46;F
72195;1212,1039,1472,749,796,1436,1268,907,1443,996,582,1259,1440,207,146;37;F
72198;207,748,255,1449,1219,1134,582,1164,146,1197,104,742,1229,1233,1205;31;F
72204;1120,1259,930,1501,1668,516;21;F
72213;796,465,1324,907,1186,891,749,607,255,1449,930,146,950,742,1443;68;M
72232;207,1449,680,146,930,1120,215,725,748;31;F
72233;582,680,1450,749,1259,40,796,92,255,941,891,1212,1233,1120,1039;37;M
72237;1209,1449;21;M
72249;1668,742,950,1229,1562,155,1440,1324,1669,796,1212,1197,1039,976,680;34;M
72261;742;47;M
72262;1235,749,680,987,675,891;29;M
72267;1713,92,255,456,907,1134,1501,1668,582,987,891,930,1259,675,1120;37;F
72269;1450,749,976,215,796,1436,1440,207,1639,1668,1472,680,930,1120,1039;37;M
72280;742,680,749,1259,1197,207,255,907,1449,987,891,146,1205,790,1120;65;F
72286;1449,996,680,1205,1120,40,1197,207,1440,1324,742,987,930,675,1039;40;F
72288;1450,680,996,145,771,1440,1449;43;M
72293;92,795,456,1219,1501,1668,941,1233,1259,1197,1039,725,215;46;F
72306;215,1120,950,987,155,1440,117;48;M
72307;907,607,1440,1436,1669,987,1259,1120;18;M
72319;145,976,1268,1440,769,255,155,996,680,146,950,1120,40,1039,215;38;F
72349;155,1450,987,146,1259,1205,976,104,725,996,998,675,1120,40,1197;34;F
72362;456,996,1668,987,891,1259,976,215,725,1669,92,1440,675,1120,1197;35;F
72366;1668,742,941,1450,891,749,1259,796,748,1501,1449,996,1233,930,1120;8;M
72367;255,748,207,145,907,1229,1219,1134,742,680,1233,1205,1120,1197,104;35;M
72369;1120,1134,207,582,675,1039,104,255,1219,146,930;39;F
72375;1669,255,1449,891,749,1472;31;F
72377;607,907,1443,1449,680,1212,749,1259,725,1209,1669,92,1668,1472,1120;28;F
72397;796,255,1219,987,1212,40,1197,976;41;F
72398;1205,104,456,1443,155,215,1197,976,1039,675,146,987,255,795,145;47;F
72406;771,725,1669,92,145,207,607,255,582,155,1668,146,1205,675,1039;38;F
72414;1501,742,941,1450,145,582,1259,215,680,987,891,146,1120,1039,976;35;F
72461;1120,40,1197,976,796,92,1268,1440,795,1668,680,987,950,1039,215;32;F
72464;1472,790,215,796,465,1713,92,207,1449,1668,680,987,749,950,1197;43;F
72481;1039,255,725;25;F
72482;465,117,1039,516;35;M
72484;796,1449,1197,1120,749,1668,1501,456,1440,1209,255,987,215,976,155;27;F
72512;1501,1449,891,749,1259,796,987,1212,907,1440,92,680,1120,104,215;28;F
72551;1229,1440,1268,1713,1324,1562,950,1668,1186,987;23;F
72570;1670,1440,207,255,1229,516,1501,675,976;46;F
72596;1668,996,907,795,155,941,1259,1120;44;F
72648;465,796,207,748,996,680,891,146,950,1120;40;F
72669;1134,987,1259,950,1120,40,1039,104,1669,907,1668,582,976,215,155;57;F
72723;582,1259,790,1120,215,976,987,749,1713,92,1440,1501,680,725,796;33;F
72724;104,795,146,92,456;70;F
72753;1670,516,1120;30;F
72759;145,1668,146,950,675;36;F
72767;1120,796,907,996,941,1450,891,1212,749,1259,725,1669,92,255,1668;36;F
72768;725,1259,1120,1197;38;F
72771;749,796,1209,1440,207,1229,907,930,680,1259,675,941,891,1120,215;51;F
72778;1235,167,769,1639,680,104,1562,1713,40,1669,607,907,1219,987,950;56;F
72798;1562,1268,769,1449,996,998,680,987,1212,950,1120,40,1039,976,215;3;F
72799;465,1449;44;M
72808;996,907,255,92,1436,1669,725,215;45;M
72896;795,255,907,516,1449,680,891,1259,1212,749,1120,40,987,950,1039;44;M
72914;930,1039,104,215,255,1229,907,516,1443,1668,1450,146,675,1120,1259;35;F
72921;907,456,255,207,748,771,1713,1669,725,1440,145,680,1668,1259,1120;24;F
72922;907,516,987,40,976,465,748,456,1449;31;M
72926;1436,1440,996,1450,891,675,92,1268,795,907,680,1259,1120,976,215;41;F
72929;1212,749,1205,1443,907,255,582,92,207,1449,996,1668,891,930,1120;63;F
72968;749,104,1209,796,725,117,92,582,207,748,1668,891,930,790,1120;60;M
72987;1436,941,1450,891,1164,749,1259,1120,215;42;M
72997;155,1324,92,207,795,1668,680,950,1039,976;54;M
73003;1209,1562,796,92,1440,769,950,675,40;65;M
73004;1713,1440,725,796,1669,92,1639,1668,1450,891,749,1259,1120,40,1197;32;F
73028;117,1713,907,1197,465,1268,1440,1449,582,680,941,1450,1212,1259,1120;31;M
73062;796,1436,1268,771,145,1212,1259,976,1670,92,748,795,996,1668,1197;24;F
73064;1443,1229,748,92,1324,145,207,255,1639,1501,987,907,516,930,675;47;F
73080;796,1562,1669,1713,92,1268,771,795,907,1219,1668,582,987,976,215;42;F
73092;790,891,1219,996,465,748;44;F
73126;941,987,796,1670,748,795,1639,1449,1450,891,1259,1120,40,976,215;59;M
73139;1669,582,987,796,92,1440,748,1449,680,891,749,1120,40,976,215;53;F
73142;796,1501,941,987,1268,907,996,1450,1259,1120,40,516,891,215,976;31;M
73147;749,680,1670,117,465,1562,950,796,92,891,675,790,1120,1039,907;39;M
73155;1209,891,749,40,796,1669,1670,92,907,996,1501,1450,1259,1120,1668;32;F
73162;92,1440,607,1134,1186,104;54;F
73181;155;38;M
73182;146,1670,516;40;M
73184;996,680,941,675,749,146,1668,1235,725,1229,1450,1233,1259,1120,1039;36;F
73248;796,725,1209,1669,207,255,907,1443,155,1134,1668,987,749,675,1120;32;F
73259;748,1639,155,1562,1669,1670,92,769,795,1143,998,167,1164,40,1197;64;F
73261;725,1268,1443,1668,941,1259,1039;40;M
73271;907,742,1450,1259,1669,207,996,1668,987,146,675,1120,1197,215,976;30;F
73283;769,145,996,796,1562,1436,255,907,680,987,146,1120,1039,976,215;41;F
73285;1450,749,40,976;35;M
73329;930,675,996,1668,987,1450,1212,146,1120,1259,891,1670,255,1440,516;30;F
73330;1450,749,1259,950,1120,1440,1268,117,465,607,1639,987,675,976,215;33;F
73343;1212,1562,1268;21;M
73348;1212,215,465,1235,1449,1233,749,1120;34;F
73356;1668,675,1197,215,1440,1235,680,1212,749;31;F
73370;1562;58;F
73375;465,92,582,680,891,749,1259,790,1120,976,907,987,950,675,1197;19;F
73388;516,748,92,117,465,1668,998,680,749;29;M
73397;996,1501,941,891,1212,749,1259,40,1197,1120;41;M
73401;1668,1268,1562,255,976,987,675,207,749,1212,1259,795,1120,1324,680;29;M
73420;1209,607,1449,996,155,1501,941,987,1450,891,749,1259,675,1120,40;42;F
73444;796,1562,1713,1268,769,907,998,680,987,1212,950,1120,40,1039,215;;M
73455;996,1449,907,795,1440,456,987,675,976,215;42;F
73458;255,907,996,582,930,1259,1120,976,215;36;M
73462;1324;48;M
73491;1259,1120,748,987,215;31;M
73513;996,907,465,680,941,1450,891,796,1209,1440,748,749,1120,40,976;38;M
73530;680,146,1259,1443,516,255,930,1120,976,1209,1440,145,207,987,675;42;F
73576;1268,1440,907,996,1219,680,891,1212,749,950,675,790,1120,1197,215;42;F
73587;796,207,907,516,1443,987,1212,749,930,1120,215;44;M
73607;1669,1440,907,1443,1668,891,796,1219,742,1450,930,1259,675,1120,1039;43;M
73613;907,1501,941,1450,40,725,1669,92,1668,987,1259,675,1120,1197,976;37;F
73619;1562,1669,92,907,987,1120,40,1440,1668,1212,950,1039,215;33;F
73635;1120,996,998,941,1450,891,1212,749,1259,790,1209,465,92,907,1668;31;F
73641;1219,996,1186,582,941,987,1212,146,1259,1205,675,790,1120,1197,1039;46;F
73647;996,1668,1186,998,742,891,675,749,930,1205,1472,790,1120,215,1039;42;F
73690;1229,680,1039,976,215,1670,1440,907,891,516,996,987,1450,1259,1120;37;F
73697;1268,795,1443,742,950,1039;38;F
73710;796,907,996,742,680,891,1450,749,1259,1120,1219,941,1039,976,215;30;M
73722;215,795,1449,742,1450,1233,1259,1120;35;M
73734;891,146,930,1205,1120,796,1443,950,790,207,607,1449,742,582,255;40;F
73744;725,941,215,1197,1120,1259,749,1212,891,1450,1668,795,907,607,996;19;F
73745;680,1197,976;45;F
73746;145,1639,1449,680,987,146,930,675,1209,1440,207,255,907,1443,516;10;M
73766;1443,1449,930,976,680,987,146,748,1713,1669;65;F
73796;941,92,1443,987,1212,1233,749,675,1501;53;F
73801;1668,1440,255,907,996,1219,987,891,749,950,1120,1039,1209,1443,742;49;F
73811;1669,145,207,255,907,516,1443,1449,1668,1450,146,749,1259,1120;36;F
73851;1713,1120,907,167,92;65;F
73860;742,976,675,930,1450,987,680,582,1443,516,1639,255,207,1440,1209;5;M
73861;255,456,582,680,675;32;F
73880;790;70;F
73890;167;54;F
73899;215,749,891,796,795,1212;35;M
73921;582,680,941,1450,1259,675,215,796,725,907,1443,146,1233,1120,1039;41;F
73924;1668,680,907,582,891,1450,1205,1233,1212,1120,749,1259,1440,941,1501;34;F
74029;215,976;34;M
74042;1668,680,1450,891,1212,749,1259,976,907,92,1440,996,941,1120,1039;47;M
74053;1639,795,207,145,92,1669,796,465,1268,1449,996,1219,1233,1259,1120;30;F
74055;607,1449,795,748,1143,996,1134,1186,465,1205,1120,891,1164,749,790;37;M
74058;1669,92,1440,907,1449,996,1668,582,680,987,891,1120,40,976,215;62;M
74092;796,795,155,1501,950,92,607,1668;73;F
74102;1233,1259,790,796,1440,907,516,996,891,749,950,1120,680,40,155;45;M
74106;1670,1440,1229,907,516,996,680,987,1450,891,1259,1120,1039,976,215;10;F
74132;582,987,1450,1205,675,1039,1440,207,996,680,941,891,146,1259,1120;31;F
74171;907,941,1450,891,1259,1120;45;M
74186;1259,1212,795,582,1450,749,1120,796,1713,907,996,1501,891,950,40;65;F
74189;1670,1440,1229,907,516,996,680,987,1450,891,1259,1120,1039,976,215;7;M
74192;40,155,1449,725,1669,92,907,996,1501,1668,891,790,1120,1197,104;44;F
74211;1209,1669,907,1450,930,1259,675,1120,40,1039,215,1443,987,976;38;F
74215;987,675,976;27;M
74232;516,1120,215,1039,976;3;M
74280;907,996,1450,516,1039,1259,1120;42;M
74283;582;41;M
74285;930,749,1186,1143,675,1134,1449,907,1440,796,1209,207,607,255,987;12;F
74289;725,907,1450;30;F
74349;796,465,891,1235,1449,749,790;68;M
74359;1668,1501,1450,1440,1268,1259,1120,987,907,796,680,92,1197,976,215;35;M
74394;796,1209,1440,748,456,1449,1472,40,749,1039;49;F
74405;1197,976,795,796,769,907,1449,996,941,1450,891,749,1259,1120,1039;35;M
74437;1212,146,749,950,1120,1197,796,92,1440,680,998,40,215,1668,987;28;F
74448;1450,1197,1669,92,1668,725,1440,456,907,996,1501,941,891,1120;37;F
74450;996,582,146,1197,891,930,950,1120,1449,1235,607,796,215,749,790;19;M
74458;255,1143,1134,1186,742,1212,1205,1472,1120,748,1449,749,930,675,790;52;F
74531;92,145,456,146,40,104,255,1443,742,675;37;F
74554;255,607,207,1268,1669,680,987,40,1039,92,907,155,1668,950,1120;66;F
74568;516,725,465,1669,1670,92,1268,1443,1219,1668,941,675,40,1197,1039;34;F
74579;1668,941,1450,891,749,1259,675,1120,1039,976,215,1440,748,680,930;35;F
74586;145,795,1233,796,1713,950,1443,742;40;F
74639;725,1449,1219,941,1233,1259;29;F
74658;146,145,1440,255;42;F
74677;930,1259,1120,215;67;F
74699;1205,92,1669,1562,1229,1449,742,930,255,155,680,146,675,1197,1039;36;F
74728;748,1713,1669,796,725,465,92,907,1449,996,582,891,950,1472,1120;41;F
74735;1501,1197,215,796,680,976;48;M
74759;771,607,255,907,996,1219,1668,1186,582,749,1259,950,1120,1197,104;25;F
74764;1120,976,215,1669,1197,1039,104;37;F
74788;725,795,976,675,1259,987,582,996,1440,1713;27;F
74794;941,1450,796,1209,987,1212,1233,749,1259,675,207,1449,996,891,1120;40;M
74815;582,930,796,92,907,1443,996,1501,1450,891,1212,1233,1259,1120,104;16;F
74823;1197,40,1120,675,950,987,680,582,1668,1440,1268,92,1669,1562,796;37;F
74872;1324,795,1039,40,1120,1233,950;54;M
74878;790,1186,167,1443,1639,796,1562,748,1440,680,749,465,1472,1235,1449;34;F
74888;607,255,907,996,1186,1450,891,1233,1259,950,675,790,1120,1039,976;22;F
74889;1713,748,795,1639,1449,725,1669,1268,907,996,1668,891,749,790,1120;24;F
74946;1669,145,1324,941,1450,146,1212,1120,1197;63;F
74949;987,930,950,675,790,976,92,146,40,1197,1039;33;F
74953;891,1450,941,1668,1501,996,155,516,907,607,146,1259,675,1120,40;35;F
74959;771,795,155,950;56;F
74975;456,796,1443,680,1450,1120,1212,749,1197,104,907,996,1668,891,1259;23;F
74995;92,1209,796,1713,769,795,907,1235,1443,996,998,582,680,950,215;50;F
74997;749,950,1197,1669,796,1670,987,40,104,748,1713,92,1440,1668,675;38;F
75025;1562,1324,1259,1212,675,1039,976,796,465,1268,748,680,987,40,104;47;M
75033;1259,675,1120,976;26;F
75086;92,1501,1668,1450,891,146,749,930,1259,675,790,1120,40,1197,1039;9;F
75126;680,941,1450,987,891,950,675,1120,1039,1436,1268,907,516,725,215;47;F
75143;582,1229,769,1436,1324,465,1164,146,1205,790,215,207,748,1235,1449;69;F
75146;769,1229,1235,680,987,1197,976;36;F
75176;796,117,1668,1450,1259;52;M
75185;1235,516,1449,996,1501,1668,680,891,1212,1233,749,1259,1472,1120,976;64;F
75191;950,1039,104,1197,1120,1134,996,516,907,255,207,145,769,1440,1670;19;F
75201;1669,907,1668,1212,1472,1197,1235,1449,996,104,891,749,790,1120,40;51;F
75214;725,796,1639,907,996,941,1450,891,749,1259,1120,1669,1501,1668,215;44;F
75220;1440,92,1669,1209,996,1501,1668,680,1450,891,146,930,675,1120,1039;42;M
75231;1259,1120,941,796,996,675,1440,1450,1669,1668,907,891,92,1501,749;67;M
75241;996,1209,987,976,1501,675,215;30;M
75242;1209,1669,92,207,255,996,1668,582,987,1212,930,950,675,1120,1197;64;F
75258;795,907,749,987,891,1450,1212,1259,1472,1120,465,1440,1219,1668,680;35;F
75280;1436,795,907,996,1219,582,1450,891,104,976,1039,725,1120,1233,215;28;F
75305;1219,996,1449,1443,516,1235,907,255,207,769,1440,1268,1436,1713,465;34;M
75318;950,1259,92,771,207,607,255,907,1443,1039;34;F
75321;92,255,907,155,1668,1450,941,950,1120,1039;37;F
75348;1219,1120,1197,796,907,941,987,1450,675,215;27;F
75367;796,976,1120,1259,749,1212,891,1450,680,1668,1501,996,907,92,1669;36;F
75388;796,1669,987,1324,1212,146,950,1039,215;65;F
75453;145,976,1324,987,1668,680,1669,92,255,675,1197,1229,725,930,516;34;F
75461;742,725,1209,1669,1324,92,255,516,1668,680,987,930,675,1197,976;34;M
75464;725,771,92,255,1501,987,146,930,104,1669,207,1219,675,1120,1197;27;F
75466;680,1449,1229,1324,748,155,1472,40,1039,907,516,1219,1212,749,607;33;F
75482;1268,255,582,1450,1212,146,930,1259,675,1120;25;F
75488;1209,996,742,582,680,987,930,675,1120;25;F
75504;796,769,742,891,215,795,1268,998,1713,1443,680,950,1120,1039;47;M
75506;40,891,987,680,117,1268;78;F
75518;1713,207,742,146,950,1039;34;F
75534;907,516,996,1668,987,1259,675,1197,976;29;M
75537;1713,796,1669,92,907,996,1501,1668,1450,891,1212,749,1259,1120,976;36;M
75554;117,769,456,796,92,1440,907,1219,996,1501,1668,1259,1120,40,1197;22;F
75572;92,465,1639,1668,680,941,215,796,1440,907,996,1450,891,1259,1120;38;F
75582;1668,582,941,1450,1212,146,1120,1197,104,607,255,155,680,1259,950;15;F
75594;117,907,996,582,987;46;F
75664;1324,1669,1209,725,796,907,1443,155,950,675,976,104,215;15;F
75667;1562,1669,1268,769,907,996,742,998,680,987,1212,950,1120,40,1039;46;F
75716;1143,1449,749,255,215;44;F
75718;145,1229,941,582,1668,1501,516,907,1443,680,950,1039,796,996,998;11;F
75729;1440,92,1713,1670,117,1562,725,1209,1669,996,1668,987,675,1197,976;47;F
75752;796,465,1268,1440,907,1212,996,891,941,1450,795,680,749,1259,1120;38;M
75762;255,907,996;37;F
75788;1039;44;F
75793;996,1668,998,941,987,891,749,1039,1670,516,1501,1450,1259,1120,1197;34;F
75798;1440,1186,92,155;34;M
75799;1670,941,891,907,1259,516;36;F
75845;748,1449,996,1501,1186,891,1212,1472,790,1120;52;F
75864;207,987;30;F
75881;1450,891,1212,749,675,40,1669,92,907,1501,930,1259,1120,976,215;43;F
75890;1501,104,1669,1713,607,456,1235,680,976,215,1324,92,1668,987,950;36;M
75902;607,680,996,1443,907,456,1212,255,796,1233,930,749,1235,1209,1449;24;F
75907;796,465,907,1449,996,1501,1450,891,1212,749,930;32;M
75910;104,1472,1229,607,582,215,207,146,1205,1120,465,769,748,1449,987;33;F
75913;1472,749,1450,941,155,117,1668,40,976;39;F
75951;1450,950,1120,1562,1324,795,1639,907,155,680,987,891,675,1039,976;37;F
75972;92,1268,907,516,996,1668,680,941,987,1450,891,146,749,1259,1120;37;F
75973;796,1562,1713,769,40,998,950;37;M
75985;1324,1668,1562,1268,769,1443,987,146,930,950,675,1197,1039;55;F
76002;155,255,1120,1039,987,92,907,891,941;60;F
76003;1669,796,725,92,907,996,1501,1668,941,1450,891,1212,749,1259,1120;25;F
76007;1039,950,680,1324,92,1440,155,996,1501,1668,987,1259,1120,40,976;38;M
76011;796,1669,92,1440,1443,996,1668,1450,1259,1197,215,907,516,1219,1120;46;F
76016;1268,1449,891,790,1120,40,1039,748;39;F
76018;155,582,790,1713,1669,1562,796,92,1268,795,1668,998,950,40,1197;61;F
76023;796,1669,996,1259,40,1197,1562,92,1440,795,1668,1120;30;M
76035;1713,675,215,996;35;F
76046;582,680,1472,1197,1039,1669,996,1668,987,1450,1212,1259,1120,976,215;37;M
76051;1668,1562,1440,1268,795,155,987,146,950,675,1120,1197,1039,976,1324;9;F
76063;1669,92,907,996,1501,1668,742,680,941,1450,891,146,749,1259,1120;5;M
76070;675,950,215,796,1669,207,907,1449,996,1668,749,930,1443,742;12;M
76071;987,104,1324,92,207,795,155,1668,680,950,1039,976;42;F
76092;1205,790,104,680,1209,796,748,92,749,891,1134,930,207,255,996;44;M
76097;725,1209,465,1669,92,907,996,1668,742,680,941,1450,891,1259,1120;4;M
76099;1440,255,1229,907,1449,996,582,680,987,1212,1259,675,1120,1039,976;47;F
76102;215,796,1669,92,795,516,996,1668,680,987,146,1259,1120,675,1197;27;F
76106;215,796,1669,92,771,516,996,1668,680,987,146,1259,675,1120,1197;28;M
76117;1324,1562,1209,1713,92,795,40,1039,796,998,907,1268,769,1120,104;26;M
76129;1219,1134,1501,1668,680,891,749,675,790,1120,1039,1669,1440,1449,1197;30;F
76131;907,1324,1669,996,1668,582,987,1450,749,1259,675,1120,1039,976,215;41;F
76132;796,1268,795;75;F
76138;1440,465,1259,996,1235,907,1436,1450,891,790,1120,40,104,215,976;29;F
76168;795,680;38;M
76172;996,1450,1259,950,40,796,465,1669,1713,92,795,607,1668,749,1120;67;F
76178;1209,207,607,255,987,930;33;F
76187;1713,167;73;M
76203;104,1324,92,207,795,155,1668,680,146,950,1039,976;11;F
76209;1233,1120,1212,891,1501,607,215;39;F
76216;1209,1668,1450,1259,1197,996,582,675,1120,976;21;F
76232;1436,607,987,1259,976,1197,40,1120,891,1450,1501,725,1669,92,1668;28;F
76237;1197,976,215,1209,1324,1268,1219,987,950,675,1039;41;F
76250;748,1449,891,146,104,40;58;M
76271;1713,167;43;M
76276;1324,748,996,749,796,465,795,1235,1449,680,1450,891,1212,1120,215;38;M
76277;1235,748,117,1670,1562,795,207,1268,1436,465,796,516,1443,1212,675;33;M
76284;516,996,1219,1668,582,1450,891,1164,1212,930,1259,675,1120,40,215;29;F
76303;1197,255,675,1120,1501,1259,950,1669,1668;25;F
76320;92,1186,582,1212,1205,748,907,1443,1449,996,987,891,749,930,1120;43;F
76332;907,516,1449,996,582,941,1450,891,1212,749,40,680,1259,1120,976;32;F
76394;117,1436,516,1501,987;29;M
76411;1449,155,1501,930,790,40,1120,465,796,680,675,976,215,749,996;28;M
76424;996,680,1212,1259,1120;42;M
76426;930,215;25;F
76461;950;77;F
76501;1440,795,255,907,1235,1449,996,987,1450,891,1233,749,1259,1120,215;32;F
76516;1212;48;F
76517;1205,146,1219,1449,907,255,145,1440,1713,207,1186,891,749,790,104;36;F
76522;516;54;F
76528;207,516,1501,1668,146,930,1120;35;F
76566;1229,465,796,207,607,907,1443,1449,891,749,675,790,1120,1197,215;33;F
76582;1449,1668,1186,749,930,675,1120;29;F
76602;516,1440,930,675,1197;34;M
76609;976,1120,891,1450,1668,1501,996,907;35;F
76628;1670,725,104,930,1212,891,941,742,582,1450,146,1259,675,1120,1039;32;F
76637;996,941,1450,749,1120;54;M
76702;907,1443,155,1668,742,582,941,1450,146,930,1205,675,40,1039,104;28;F
76715;1670,516,1668,1450,749,1259,1120;55;F
76720;1268,1219,987,215;27;M
76724;516,1639,1440,465,796,1268,907,996,1219,941,1450,891,1259,1120;29;F
76725;167,582,987,930,675,1197,1562,1713,1268,769,795,742,146,1120,1039;45;F
76734;680,1501,1219,92,1436,117,465,1209,796,907,996,987,675,976,215;38;F
76743;1449;30;M
76755;907,996,742,891,215,1268,1639,516,155,1450,1259;42;M
76781;1449;33;F
76798;1229,1443,1449,155,950,1120,1197,748,607,456,1668,891,146,1205,790;40;F
76811;465,1669,92,748,795,607,907,996,1668,1450,749,1259,950,1120,40;66;M
76822;607,255,215,976,1669,1324,1436,92,1440,795,1229,155,1668,987,950;38;F
76834;1120,1259,891,1450,941,1670,1268,748,215,516;38;F
76836;145,456,680,987,1212,146,675,40,1039,215,1562,1713,207,255,950;38;F
76839;1443,941,987,1450,1212,1259,1120,976,92,1268,907,996,1501,1668,1197;25;F
76844;1268,1039,742,950;64;M
76861;92,907,996,1501,1668,582,941,1450,891,1212,1233,1259,950,675,1120;22;F
76862;1219,1562,92,680,907,891,976;36;M
76879;748,675,215,976,987,907,996,891,1670,1440,516,930;34;M
76881;92,795,1668,749,1120,40;39;M
76889;1436,1639,1235,907,996,1501,742,680,987,1450,1259,675,1120,976,215;70;M
76899;748,145,207,146,1259,675;39;F
76910;1562,796,465,117,769,1235,516,1449,998,680,891,1472,790,40,976;38;M
76957;1235,1449;43;F
76959;796,675,749,1212,891,1450,941,465,907,40,996,680,1259,1120,976;36;F
76970;1713,1259,749,582,1501,1449,907,769,796,1440,996,680,1450,1120,976;28;F
76971;92,987,976,215;40;M
76972;1449;34;M
76987;255,907,516,996,582,680,941,987,1450,891,1212,675,1120,1197,1259;50;F
76997;1233,930,1259,1205,215,796,1209,465,1713,92,996,146,749,950,1120;48;M
77006;207,1440,941,891,749,1259,1197,215,1713,796,92,907,167,996,1120;24;F
77038;1186,255,607,795,748,207,92,465,930,1205,675,790,1120,1197,104;50;M
77053;796,92,1443,998,1212,40,1197,117,1713,1268,1440,907,155,167,950;24;M
77061;1436,1268,795,907,1443,996,1219,1668,941,1212,1450,891,1259,1120,725;48;F
77079;1449,996,1501,1450,1212,1259,1120,795,92,1713,1668,987,749,40,976;67;M
77085;795,1450,146,930,1259,1120;24;F
77090;146,796,1713,795,167,680,891,1120;49;F
77094;167,996,40,796,117,1713,92,1668,998,582,680,950,675,1120,1039;28;M
77109;1670,1209,1669,92,456,155,1668,582,680,749,930,950,675,790,1120;28;F
77125;771,456,1501,582,1212,907,92,725,145,255,1186,146,675,1120,1197;26;F
77128;941;20;M
77141;145,207,1229,456,1443,582,987,146,675,907,1259,1039;33;F
77164;1670,92,1639,907,1501,1668,680,891,976,215;66;M
77170;1449,1186,680,749;30;M
77191;1440,255,1472,1120,465,92,207,1143,1443,748,1449,891,1205,790,104;37;F
77193;1562,117,987,796,748,167,1668,40,976;36;M
77206;1669,1440,907,1219,1668,941,987,891,1212,1197,976,92,1450,1259,1120;45;F
77208;155,996,582,987,891,1450,1212,930,1472,796,516,1259,950,675,1120;36;F
77229;92,771,146,749,1205,1120,1197;37;F
77231;92,207,456,907,1219,1501,1668,582,941,891,1212,930,1259,1120,1039;38;F
77235;796,1562,117,92,795,1668,987,950,675,1120,40,215;55;M
77240;1324,1713,1670,1669,92,1268,215,255,907,1443,1501,1668,582,146,1197;23;M
77255;516,680,941,891,117,92,748,1449,996,1450,1259,749,1120,40,1039;36;M
77285;1669,795,907,996,1450,1233,1039,796,725,117,92,1668,146,1259,1120;58;F
77298;1134,1501,1668,582,987,891,749,1259,675,1120,40,1197,255,1233,941;32;F
77303;1440,680,950,1268,795,1235,891,215,769,1449,1197;63;M
77309;1562,92,795,907,996,1668,680,146,1120,40,1197;28;F
77320;976,215,1268,1669,92,795,907,996,1668,1501,680,1450,891,1259,1120;20;F
77334;207,255,516;29;F
77362;1501,1668,582,987,941,1450,930,1259,1219,996,1443,145,1670,516,146;36;F
77367;795,748,117,796,1713,207,255,907,996,582,987,891,1120,40,215;52;F
77370;465,92,1440,207,748,255,1143,1443,1449,891,1205,1472,790,1120,104;40;M
77372;749,769,167,117,1212,790,1120,891,40,998,795,92,796,1268,1713;31;M
77404;976,1562,795,769,155,215,680,1669,1120,255,117,796,950,1268,1209;26;F
77411;465,92,1440,207,748,255,1143,1443,1449,891,1205,1472,790,1120,104;8;F
77416;1440,516,40,215,1669,92,1668,907,1501,987,891,976;38;F
77417;1669,92,769,516,996,749,790,976,1259,987,680,1668,1501,907,1436;53;F
77418;1449,456,796,1669,907,996,1668,582,941,1450,891,749,1259,1120,976;30;F
77431;1450,941,1668,996;51;M
77437;1639,582,680,891,749,215,1501,1235,907,1713,1562,1209,167,675,1472;28;M
77448;1197,749,1450,987,1668,907,1670,796,1669,92,516,1259,1120,40,976;39;F
77454;769,1639,996,987,675,1472,796,1562,1713,1436,1235,167,680,891,790;25;M
77456;1713,167;48;M
77459;465,92,1440,207,748,255,1143,1443,1449,891,1205,1472,790,1120,104;5;M
77488;1669,725,796,1209,465,1324,1449,996,891,1212,930,1259,790,1120,40;30;M
77493;1501,1669,1562,976,795,1668,680;61;M
77498;1212;45;M
77508;1209,1164,950,104,465,207,607,1143,1235,1449,1668,742,930,790,1039;35;M
77514;796,996,749,40,976,92,1450,1259,1197,680;57;M
77535;1670,92,1639,907,1501,1668,680,891,976,215;61;F
77577;1440,1668,1450,1259,1039,1669,1501,1436,680,1212,1197;43;M
77605;796,891,749,790,1449;41;M
77610;796,907,996,1501,742,891,749,950,1205,1120,104,155,1186,146,675;45;M
77643;516;60;M
77644;796,582,1669,92,996,1668,891,790,1120;49;F
77646;1449,891,1205,1120,790;35;F
77684;1713,145,1443,1449,891,1259,1120,796,1669,795,907,996,1668,146,749;51;M
77697;976,891,680,1501,907,795,207;28;M
77708;680,987,675,976;67;F
77724;796,117,1268,769,987,215;76;M
77725;40,1120,215,675,950,1197,976,1669,92,1668,1039,796,1268,795,987;34;F
77770;1134,1186,998,582,1450,749,1259,104,796,117,1443,1449,680,1120,40;32;F
77775;215;41;F
77797;1235,1639,1268,1324,1669,1436,92,748,516,742,1450,749,1259,976,215;32;F
77807;771,155,976,92,1668,1212,104,987,146,950,1205,1713,1440,680,1197;42;F
77825;891,1212;40;F
77838;1443,998,680,950,1039;25;M
77855;1449,1164,790,996,1235,749;36;M
77869;795,1639,1219,930,725,1268,516,1449,996,1501,582,1450,891,1259,1120;42;F
77891;907,1443,996,1219,1501,1668,582,941,987,1450,891,1212,146,1259,1120;37;M
77898;1120,1219,795,146,1449,1668,1259,607,996,582,1450,1472,465,907,1212;46;F
77902;725,680,976;38;M
77913;950,207,607,155,749,675,1440,907,516;39;M
77922;796,725,465,1669,92,907,1449,1501,941,1450,1259,1120,1197,1039,104;35;F
77947;796,1713,92,907,1443,1449,996,1501,891,1212,749,950,1120,40,976;22;F
77957;907,1639,1324,1229,1443,996,742,675,1120,215,1501,941,987,1472,976;67;F
77982;891,167,1235,907,1639,769,1268,117,465,1562,796,1440,516,680,215;31;F
77983;1233,749,1259,675,725,796,1713,1440,907,996,1668,998,930,1120,40;27;F
78006;1669,1440,1219,1668,680,1120,1197,104;35;F
78007;516,930,1450,582,1668,996,1449,1143,907,117,725;24;M
78012;516,1668,1501,941,680,742,987,891,1212,1259,790,40,1120,976,215;56;F
78014;465,607,255,1449,996,582,891,1164,930,950,1205,675,790,1120,104;46;F
78015;255,907,516,1450,891,1259,1120,92,1668,680,976;40;F
78016;1668,1039,941,987,907,1450,1259,1120,976,215,891,1501,795,1440,680;32;M
78026;215,1039,1235,582,92,907,1501,1450,749,1259,1120;15;M
78039;725,117,145,607,1229,155,1134,742,1164,146,1039,976;35;M
78067;465,1669,117,92,1268,1440,907,1450,891,749,1259,1120,215,1449,680;35;M
78086;950,1039,680,1324;49;F
78091;1668,996,155,1449,907,255,748,207,1440,92,117,1669,465,1209,104;16;F
78096;1639,1440,1268,92,155,1219,582,680,1450,891,1212,1233,749,1120,1197;26;F
78098;891,790;44;M
78105;725,796,1669,255,607,456,155,1219,998,582,1164,146,675,1197,104;31;F
78148;1668,582,941,749,40,1197,1209,92,1440,516,680,1259,1120,976,215;41;F
78156;1440,1639,680,930,675,1197,146,215,891,907,1501,1668,987,976;37;F
78160;987,1450,891,1259,1120,1197,1039,104,725,1669,92,1229,516,1668,976;35;F
78181;998,582,950,675,1219,145,1440,1669,796,795,607;32;M
78206;1669,1120,1212;38;F
78216;891,1450,1197,40,795,1440,92,1713,796,1668,987,1259,1120,976,215;50;M
78218;1197,1039,1562,1669,1670,1713,92,1268,795,1443,1668,742,1212,950,1120;32;F
78232;1233;36;M
78242;1670,607,516,155,996,1219,1120,215,976;22;F
78255;1212,1259,1120;16;F
78258;215,987;30;F
78263;1501,998,582,987,1450,1212,1259,796,1669,1668,680,941,891,675,1120;24;F
78264;1120,1039,215,1440,1713,796,1562,1268,769,748,607,998,680,40,976;32;F
78285;795,456,1668,941,1259,907,516,155,891,146,675,1120,976,1039,104;41;M
78297;1472,1197,1205,930,749,1229,255,607,795,748,207,1449,891,790,1120;51;F
78345;1440,907,1668,680,146,930,675,1197,92,1501,987,891,976,215,155;36;M
78349;255,1449,1501,1219,1668,891,796,465,1268,680,941,1259,1120,1039,976;46;F
78356;1197,790,1205,146,1186,1134,1219,607,255,1449,104;64;F
78367;207,255,516,1219,146,930,1259,1120;34;F
78370;1120,1212,891,1449,907,92,796;35;M
78383;1120,1259,749,1212,891,1450,941,40,996,907,796,976,1233,1668,1501;37;M
78394;1436,796,1268,1713,725,1209,1440,145,207,795,255,907,996,680,950;25;F
78413;1639,1209,796,1713,92,907,1449,996,582,941,1450,891,1259,215,1120;32;F
78442;92,907,1443,1219,1668,582,930,1259,1120,1669,725;22;F
78448;1713,146,1233,1039,725,1669;51;F
78455;1668,998,742,987,1450,146,749,1259,1205,675,1120,1197,1039,976,215;36;F
78457;117,725,516,1443,941,1212,749,675,1197,1039,215;43;F
78465;891,1212,749,1259,1120;74;F
78473;92,907,516,996,1668,582,1450,891,1212,930,1259,675,976,40,1120;25;M
78475;1259,930,1233,1450,1669,1212;42;F
78488;1562,215,950,155,795,207,769;44;M
78489;725,1713,1268,1440,769,1235,1443,582,675,795,516,680,987,976,215;34;F
78527;796,725,1669,255,907,996,1501,1668,941,749,1259,950,1120,1212,675;24;F
78536;790,1235,725,1562,1440,795,907,996,1668,998,680,1259,950,1120,976;26;F
78552;680,215,1440,1268,1436,1670,465,796,516,987,1450,891,1259,1120,976;37;M
78594;675,1501,1219,1669,795,1668;28;F
78612;1450,1440,1670,907,891,1668,1501,996,1639,795,92,516,976,1259,1120;38;F
78632;1120;35;M
78634;1120,215,92,207,795,1639,456;54;F
78662;1259,1120,996,1450,907,92;25;F
78689;725,1440,145,207,155,582,1197,1039,1669,1713,607;18;F
78710;796,1205,146,1443,1229,907,996,742,1450,891,749,1259,1120,1039,215;31;F
78711;1324,92,907,742,891,1212,1472,1562,465,255,1229,1449,996,1668,790;35;F
78712;40,215,1233,987,680,1219,167,1235,748,1440,1713,465,1562,796;58;M
78714;891,742,117,1440,749,1120,215,796,1713,92,748,795,1443,1668,987;46;M
78733;1039,748,941,255,675,146,207,1209;38;F
78737;675,976;71;M
78750;465,92,1440,748,1501,1668,749,1197,796,1449,742,1472,790,104;37;M
78757;1212,1472,215,1197,1120,675,1440,725;45;F
78761;1713,1670,117,1324,1562,796,725,465,1436,92,1449,215,104,1120,790;30;F
78777;1713,795,1443,167,1668,742,680,987,1212,146,749,950,1120,1039,976;89;F
78781;1562,92,1324,907,996,680,987,1120,40;10;F
78818;950,215,796,725,607,255,1449,1501,1668,582,987,1212,146,1259,1120;30;F
78820;92,1440,795,1450,1259,1120,907,996,1501,680,941,891,1039,976;29;M
78830;1670,891,1259,1120,976;34;M
78846;1436,1501,941,1259,725,1669,92,996,1668,582,987,675,1120,976,215;30;F
78855;117,1268,742,941,987,1450,891,146,1233,1259,1120,516,996,1501,976;38;M
78858;996,1449,1443,207,1268,748,795,1229,907,1219,749,1120,725,1212,1233;69;F
78869;907,996,680,941,1450,891,1259,1120;34;M
78878;1669,1259,675,40,1197;36;M
78879;1639,725,1562,976,1501,1268,996,941,1450,891,1212,1233,1259,1120,1039;49;M
78914;680,976,796,795,996,1450,1120,907,950,104,215,40,1562,1324,675;16;M
78930;1501,742,1450,1259,1120,145,987,146,930,255,907,1039,215,675,976;46;M
78937;465,255,516,675;30;F
78942;1324;51;M
78962;930,146,987,456,607,1562,1669,92,207,795,1668,680,950,40,1324;44;F
78996;1562,795,996,680,987,40;36;M
79053;891,1120,1209,1669,1670,1440,145,516,1443,155,1501,1668,987,1197,976;36;F
79081;976,749,1212,891,1450,941,996,907,1669,92,1501,1668,1259,1120,215;35;M
79100;795,1449,582,891,1205,790,1120;49;M
79111;796,907,1443,996,1501,941,1450,891,1212,749,1259,675,1120;23;F
79137;680,749,215;55;F
79146;465,1324,145,796,207,748,607,907,1449,155,891,146,950,790,1120;42;F
79152;1668,996,155,1443,907,1229,1669,725;63;M
79156;1324,255,907,1259,1039;35;F
79171;796,1209,145,456,987,930,675,976,215,907,996,582,1450,1259,1120;43;F
79180;607,255,907,155,1501,1668,1450,891,950,1259,749,675,1120,976,40;69;F
79187;1440,1501,1668,987,1120,749,607,1235,1449,155,680,950,675,1472,215;37;F
79190;1324;45;F
79191;1562,92,1440,680,987,1120,1039,1450,891,907,516,930,1259,215,976;41;M
79192;987,742,516,1229,255,748,207,145,1440,1268,1436,117,1324,1669,465;35;M
79199;1669,769,1668;35;M
79217;1324;43;F
79244;1235,907,1639,207,1440,465,117,92,1449,996,1668,1450,749,790,1120;30;M
79257;1713,167;68;F
79262;1219,146,1205,104,1449,255,207,145,465,1324;48;F
79268;215,145,1440,941,117,796,1436,1268,907,155,996,1450,891,1259,1120;35;F
79278;941,987,1450,1205,1449,796,725,465,117,1668,891,749,1259,790,1120;29;M
79284;104,796,92,1268,795,456,996,1219,1668,582,1450,146,1259,790,1120;34;F
79289;1209,1134,1668,1205,207,607,255,456,1443,1449,155,582,146,930,104;44;F
79295;796,607,1449,996,1186,891,790;40;F
79328;769,748,907,1449,996,998,987,1212,930,950,675,1120,40,1039;55;M
79337;1668,950,215;36;F
79346;1436,907,996,1501,582,987,891,146,749,930,1259,675,1120,1039,976;39;F
79364;1450,155,255,456,796,117,92,1259,675,1120,976,215,1669,1668,987;27;F
79387;1039,465,1501,941,907,987,146,930,104,215,255,516,1450,1259,1120;34;F
79396;1472,215;45;M
79401;465,1324,145,796,207,748,607,907,1449,155,891,146,950,790,1120;37;M
79410;987,930,976,215;33;M
79411;1440,1268,796,1713,145,907,1443,996,680,582,146,749,1259,675,1120;20;F
79425;771,255,907,1443,1449,675,1501,1668,582,1259,1120,1197,996,795,1669;29;F
79439;465,796,1324,145,207,748,607,907,1449,155,891,146,950,790,1120;69;F
79461;725,680,40,1197,215,1562,607,155,1440,950;32;M
79468;1440,1443,748,207,607,255,742,680,891,146,930,950,1205,1039;38;M
79486;1039,167,907,795,1268,1713,1669,950,769,92,1324,1562,796,1668,998;60;M
79491;1669,1440,207,1449,1501,1668,582,987,1450,891,930,1259,1120,1039,215;23;F
79543;215,1450,1219,996,748,795,1436,1562,796;22;M
79553;987,1450,749,40,976,796,1669,92,795,516,996,1668,1259,1120,1197;28;M
79554;996,907,1440,92,1436,675,1120,725,465,1443,941,1212;42;F
79559;1443,1562,1670,1713,1440,207,1639,1235,155,998,1212,1197,1209,987,675;25;F
79568;891,796,1209,1669,1713,92,207,255,456,1134,1668,146,930,1197,215;38;F
79578;796,725,145,748,607,255,907,1449,155,1186,146,1205,104;43;F
79588;1450,1713,1443,1259,796,92,907,1449,996,1501,582,891,1212,749,1120;22;F
79648;1670,1268,1639,907,1443,996,1219,1501,1668,941,1450,891,1259,1120,976;66;M
79668;1120;35;F
79675;795,769,1268,1562,796;34;M
79716;465,1324,1670,1235,1449,1219,1668,998,1186,950,215;46;F
79728;725,1219,1120,1039,976,987,1668,769,1268,1669,1562,796;63;F
79748;1669,769,748,1443,1449,1219,1668,680,987,749,1039,976;49;M
79755;582,680,941,146,749,1259,675,1197,1039,207,795,255,987,976,215;47;F
79780;987,1212,1039,680,1229,1205,40,976,104,795,155,607,1235,1259,950;36;M
79789;582,680,891,976,1120,215,1259,1450,987,516,1639,748,1268,1440,1436;44;F
79796;725,145,255,907,516,996,742,680,941,1450,891,146,1259,675,1120;37;F
79800;1197,1039,998,749,742,1120,117,465,1562,1443,680,1235,891,950,215;70;M
79811;748,891,1212,104;36;M
79816;1668,1713,1670,1562,1209,607,255,1143,516,155,996;23;F
79829;996,1450,1259,1120,976,215,117,987;37;F
79831;255,207,1324;36;F
79838;1450,1233,749,1259,976,1713,907,998,987,146,1120,40,1039,215,680;32;M
79845;1324;12;F
79868;749,891,987,996,1324;46;F
79913;1440,680,987,976,215;35;M
79915;795,1268,1562,796,465,1713,769,748,907,987,891,1212,749,976,215;65;F
79939;145,92,1669,1562,1670,748,255,155,1219,1668,146,1259,1120,215;35;F
79975;725,1669,92,1440,795,607,907,1449,1219,1501,1668,1186,1120,1197,104;33;F
79976;1670,1669,725,1229,907,516,1443,996,1668,582,987,1450,891,1259,1120;41;F
79978;796,1324,1436,1440,1639,516,155,996,1501,987,749,1259,950,675,976;41;F
79993;516,1197,1039,1120,1450,987,941,1219,1449,1443,907,1639,92,1669,1668;52;F
80000;1259,1120,976,796,748,795,1449,680,941,987,1450,891,1212,749,790;44;M
80002;1670,1440,255,907,516,1443,996,1219,987,1450,1259,1120;25;F
80009;1212,680,796,465,1713,1440,891,749,790,1120,155;40;F
80010;607,155,950,117,207,1219,941,146,1039;37;F
80015;1450,1212,1259,1669,92,1440,145,1639,1443,742,146,930,1205,1120,1039;36;F
80036;1449,1713,92,1501,1668,582,1450,1259,1120,215;29;F
80037;1449,255,1450,749,1259,215,725,1268,907,1501,987,891,1120,1197,976;24;F
80053;907,1233;35;M
80054;516,680,987,930,950,675,1039,1209,1324,207,748,255,1229,1443,742;39;F
80056;941;20;M
80059;1209,1562,796,465,769,907,1164,104,1212,1120,1197,582,1449,675,1440;31;F
80080;749,40,215,796,1562,92,1268,907,996,1668,582,987,1212,950,1120;48;F
80103;155,891,1212;50;F
80109;950,1039,1324;50;F
80125;941,1562,1713,1443,742,907,1212,1120,996,891,117,749,215,1449,790;46;F
80129;92,725,516,1219,1668,941,987,1450,1233,749,1259,675,1120,40,976;28;M
80146;907,516,155,996,680,1450,891,215,1668,582,987,1120,976,607,1501;35;F
80158;1324,215,1669,1562,92,795,1668;45;F
80168;1259,941,92,1440,255,907,516,996,1233,1120,976;51;F
80174;1450,1268,796,1670,92,1440,516,1668,680,987,675,1120,1039,976,215;42;M
80198;465,1440,1443,1449,1186,582,1212,749,930,1120,104;42;F
80208;1669,1501,1668,1259,1120;30;F
80223;607,1235,92,1668,255,1449,582,104,465,207,1443,996,891,749,790;36;F
80237;582,891,1212,1120,1209,92,1443,155,950,40,1197,104,607,1449,790;36;F
80241;1440,516,1449,40,996,891,1212,1233,749,1259,1120,796,92,1219,1668;25;F
80256;1143,146,675,1209,1324,207,1449,680,987,930,950,1120,40,1197,1039;40;M
80290;1449;32;F
80309;891,1259,215,976;28;M
80316;1450,1501,1443,1268,1713,1209,796,1440,795,1639,907,941,891,930,1259;33;M
80323;1668,996,1229,1324,1669,907,1501,1450,146,1259,725,207,255,930,675;25;F
80324;1219,1501,1449,907,795,1440,92,1669,1212,749,1259,790,1120,40,1197;28;F
80327;117,1670,907,1449,996,998,582,680,941,146,1233,749,1259,1120,104;31;F
80330;725,1669,255,1219,680,987,1450,1259,675,1120;29;F
80331;40,1039,1562,1259,1324;43;F
80347;465,748,1449,155,749,1472;43;M
80349;796,465,1668,996,1235,907,1449;40;F
80360;1324,465,255,1229,1449,680,1450,891,146,1259,1472,1120,976;42;F
80372;790,1713,1562,1449,1443,1212,1120,996,941,907,891,749,742,215,117;12;F
80397;465,1472,1501,907,117,1562,255,1440,1639,1235,1219,680,987,930,976;38;M
80417;92,1235,1449,1668,749,104;35;F
80431;795,255,907,996,742,582,987,930,950,675,1120,1197,207,456,155;24;F
80446;117,1449,1501,1668,675,790,1120,215;31;M
80463;607,1668,1209,92,907,996,1219,749,1259,675,1120;20;F
80498;1324;46;M
80529;215,104,255,795,748,1268,465;47;F
80531;1324,1039;8;F
80543;907,1449,996,1501,1668,582,941,1450,891,1212,930,1259,1120,40,215;46;M
80565;155,1229,607,207,1440,92,1669,465,1039,215,145,255,907,146,516;37;M
80574;117,92,987,976;51;F
80577;1039,1324;9;M
80578;155,1501,1668,680,891,1212,146,930,1259,950,675,1120,40,1039,976;12;F
80582;1120,1197,976,117;49;M
80592;996,1450,1472,976,215,795,907,516,680,891,1259,1120;25;M
80626;117,465,1669,92,748,1235,996,1668,998,680,1212,749,675,1120,40;29;M
80688;1324,1039;40;M
80712;465,987,1669,725,516,941,1450,891,1259,1120;49;M
80734;795,1639,215,1219,771,769,1268,145,907,930,1197,1562,987,146,976;43;M
80736;1440,1436,207,255,907,155,1450,891,146,930,1259,675,1120,1039,976;44;M
80746;207,749,1205,1120,1197,1039,1324;38;M
80751;255,907,1501,1668,987,1450,1259,465,92,1449,891,749,1120,976,104;32;F
80759;155,1639,725,607,1450,749,1259,950,1120,1197,976,1669,796,1668,1440;37;F
80780;1209,987,675;;F
80786;92,1235,1449,1668,749,104;2;F
80822;1209,456,996,1668,891,1259,675,1120;18;F
80824;92,1235,1449,1668,749,104;;F
80838;465,1219,1039,796,117,92,1268,145,907,742,891,1120,1449,996,1501;36;F
80865;1197,996,796,1669,1713,92,1440,907,1449,1668,1186,680,891,749,1120;57;F
80877;1669,215,976,1120,1259,891,1450,941,1668,907,92;30;F
80882;1259,1450,907,117,996,146,1197,1039,976;10;F
80929;1449;13;M
80939;795,680,215;39;M
80940;1235,796,1713,1120,748,891,92,582,749,680,950;40;M
80946;40,749,1440,117,1562,796,1039,680,976,215,1669,92,987,950,675;48;F
80970;796,1209,795,987;24;F
80974;582,996,255,117,1209,930,1259,1039,215,1212;36;F
80979;930,1472,40,976,796,1562,465,1669,795,1235,1668,987,891,790,215;38;M
80983;1440,907,1443,1449,996,582,680,891,1212,1233,749,930,1259,1120,40;20;M
80987;255,725,117,941,1450,891,1233,1259,1039,976,215;35;M
81002;1669,1562,996,1501,941,1450,891,1259,40,796,1639,680,1120,215,976;31;M
81008;155,996,1186,582,675,930,1449,465,1440,607,907,891,146,790;23;F
81018;998,1449,1229,255,725;39;F
81031;1669,117,92,1268,1501,1668,987,749,1120,1197,1443,680,1212,675,40;39;F
81061;1233;26;M
81100;516,771,155,1670,92,255,907,891,146,675,1120,1197;32;F
81125;796,1209,1713,207,607,907,1449,996,987,891,749,930,1259,675,1120;21;F
81177;976,215;52;M
81184;796,748,607,907,1143,1449,996,1186,680,987,1164,790,215;74;M
81188;582,996,907,1235,930,725,207,255,456,1449,1668,891,749,790,1120;18;F
81194;1235,1449,680,749,790;30;F
81205;1212,675,1668,749,976,1450,1436,725,1259,92,891,907,1501,1120,516;23;F
81210;1212,1472,1668,1440,748,1197,582,790,891,104,465,92,996,749,1120;35;M
81217;1449,167,1219,582,941,146,930,1259,1205,675,1120,40,1197,1039,976;57;M
81222;1440,516,1443,1219,987,1450,1259,1120;49;F
81232;749,1197,1639,1324,1562,996,1259,104,907,207,92,1669,796;66;F
81240;582,155,1443,907,1440,92,1669,796,255,1501,987,891,146,1120,976;35;F
81247;1440,1449,1212,1259,675,1120;23;M
81249;1443,1450,40,1562,1669,117,92,1268,907,996,1668,987,1259,1120,215;71;F
81312;976,680,1436;33;M
81314;996,465,145,456,146,117,92,907,941,1450,1233,749,1259,675,1120;33;M
81325;1039,1197,1120,1668,907,1229,795,92,1713,1669,950,215;33;F
81330;996;40;F
81333;675,1209,987;64;M
81350;941,1501,996,1268,92,1440,907,1668,1450,891,1259,1120,40,976,215;34;F
81375;725,1443,215,675,1120,996,1501,907,145,1670,1440,930,255,516;35;M
81385;1186,1449;34;F
81423;1229,516,1449,996,1501,1668,680,1450,930,1259,1120,976,907,891,1039;37;M
81431;1669,92,1235,1449,1668,1186,1450,1212,1233,749,930,1259,675,1120;23;F
81436;680,1209,1039,92,1440,1449,996,1668,1450,891,749,1120,1259,941,1219;29;M
81447;1501,92,795,607,907,1219,1668,1212,1197,1209,987,891,675,1120,976;32;F
81474;907,1219,1450,891,1233,749,1259,1472,1120,215,1713,742,1324;39;M
81480;1197,1120,675,1259,891,1450,1186,1501,1449;19;F
81487;1670,1436,1268,582,987,930,117;32;F
81494;1449;26;M
81502;987,675,1209;33;M
81515;1669,1268,92,207,456,1219,1668,1186,941,146,1259,1205,1120,104;78;M
81516;215;49;M
81531;1324,1443,950,40,1039;11;M
81534;796,1235,1449,680,891,749,1120,790,40,976;33;M
81538;1120,1219,607,117,465,725,104,1669,92,1440,155,1668,941,1197,1039;48;F
81581;796,725,907,1235,1449,996,1501,998,941,891,1120,1197,40,104,215;26;M
81600;1268,1562,796,725,748,1668,1472,790,1120,976,465,1449,1501,749,215;36;F
81603;1501,891,1197,1669,92,1668,1450,1212,749,1259,1120;32;F
81606;1324,207,748,1443,155,1668,40,1039;53;M
81632;1450,742,996,516,907,1639,748,207,769,92,1209,796,1668,1472,1449;30;F
81645;1501,907,987,146,675,976;39;F
81657;796,92,907,996,1501,1668,1450,891,1233,749,1259,1472,1120;59;M
81676;92,607,146,749,1197,795,996,1501,1668,987,1259,1120;62;F
81708;1039;73;M
81719;1209,255,456,907,996,1219,1501,1668,1450,930,1259,675;26;F
81735;1669,92,1668,941,40,796,1440,907,1501,680,891,1259,1120,1197,976;43;M
81759;1259,891,1450,1212,146,1197,215,1209,795,255,456,155,1501,675,1120;48;F
81765;748,891,725,1669,1501,92,1449,1668,796,941,1450,1233,1120,907,996;33;F
81766;1670,1268,1639,907,1443,996,1219,1501,1668,941,1450,891,1259,1120,976;67;F
81785;891,1450,941,1219,996,1235,795,1440,1268,1669,465,907,1449,749,1120;56;F
81852;117,907,1449,996,1668,987,891,146,749,1259,675,1120,1197,976,215;66;F
81876;104,748,1143,1449,1219,1164;50;M
81890;1669,907,1668,987,976,215,1197;35;F
81937;907,255,795,748,796,1562,1324,1268,1443,1668,742,987,1120,976,215;72;F
81940;907,516;36;F
81952;725,1436,1440,1219,1501,891,1259,1197,215,907,1668,987,1450,1120,976;46;F
81960;1212,1259,1472,40,215,1436,795,907,516,1219,680,941,1450,1120,976;58;M
81962;607,582,1449;36;F
81980;1562,795,907,1668,998,1120,1197;36;F
81982;1324,207,1039;10;M
81984;976,1259,907,930;34;M
81992;795,1134,1186,987,1205,465,117,1440,607,748,680,1212,749,675,40;30;M
81998;795,456,1039,950;39;F
82020;725,465,996,1219;53;F
82022;1324,1443,1449,996,1668,742,582,680,987,1450,1212,1259,1120,976,215;15;M
82034;987,582,742,1501,1668,996,1443,907,207,92,1268,117,1324,1562,796;47;F
82047;1209,1436,1268,255,155,1186,1120,40,891,675,976,215,680,987;30;F
82054;1212,1501,1668,907,1229,255,795,207,1669,725,465,92,1268,1440,941;51;M
82061;1268,748,891,215,941,1443,465,907,516,996,1450,1212,930,1259;7;M
82098;255,1186,1197;46;F
82103;607,1219,680,771,207,996,1501,1668,582,987,749,930,675,1120,790;36;F
82109;1039,941,725,207,255,145,950;39;F
82115;582;7;F
82128;1669,92,1268,1440,907,1668,987,891,1259,1120,976;26;F
82132;790,891,771,465,748,456,1449,680,1120;52;F
82137;1324,907,1449,996,1501,1668,680,987,1450,1212,1259,1120,1039,976,215;49;M
82138;104,748,1449;43;F
82150;582;1;F
82151;1449;39;M
82152;1449,1450,1669,1668,40,1197,795,607,456,155,950,104;45;F
82154;1450,987,941,680,742,1501,1449,1235,907,1229,748,796,465,996,749;30;F
82156;155,950,1120,215,1670,1501,930,976;39;F
82166;891,987,680,795,769,1268,92,1669,465,1562,725,1449,996,930,675;38;M
82172;796,1449,155,790,1120,104;61;F
82184;891,976,1268,907,516,1443,1501,941,1450,1212,930,749,1259,1120,215;4;F
82192;1197,92,1669,1668,941,987,1233,1039;38;F
82202;582;35;M
82213;749,1233,891,1450,680,742,1668,1501,996,1449,907,1229,795,92,987;25;M
82231;1324,1443,1229,1449,1450,891,941,1039;30;M
82260;771,748,255,456,907,1449,749,104;11;F
82263;1436,1501,1670,907,516,1443,996,941,1450,891,1212,930,1120,976,215;74;M
82264;771,145,1143,1134,1186,146,675,976,215,748,795,987,40;47;M
82268;607,456,1443,1219,891,1212,1120,1713,155,996,1450,1259,1197;64;F
82277;976,680,749,1449;36;M
82292;742,1668,1443,1440,92,465,796,907,1449,891,1212,749,1120;35;M
82300;465,117,748,907,996,1668,1212,146,1259,1120,1197;54;M
82311;891,987,1186,996,1443,907,1639,255,1268,1209,749,465,207,1235,976;37;F
82313;1219,996,1449,748,907,255,795,1713,465,1209,1268,891,1259,790,1120;59;F
82320;996,1219,987,675,1120,1209;43;F
82338;1501,1219,1449,516,1713,725,145,907,996,1668,680,1259,675,790,1120;29;F
82353;1713,1440,607,255,582,987,930,215;24;F
82358;207,255,930,1197,742,1449,1259,1120,1205,1039,104,1713,1501,941,891;23;F
82363;215,92,1440,1562,796,1669,1713,748,1668,680,1233,749,675,40;28;M
82365;1436,1440,1450,891;48;M
82370;941,680,1450,1212,1472,796,725,92,1440,607,1443,996,891,749,1120;36;M
82375;796,465,1669,1670,92,207,607,1449,155,996,1219,1668,749,1259;66;F
82388;167,680,1212,146,117,1713,145,1668,155,950,1120,796,1039,1443;43;F
82389;1501,1443,796,907,1449,996,1668,941,1450,891,1212,749,1259,1472,1120;24;M
82390;907,516,996,1219,941,891,1450,1212,1259,1120;20;F
82392;1233,680;34;M
82398;1197,790,749,1235,907,607,748,465,1449,891;47;F
82403;607,456,1219,1668,1450,1212;47;F
82432;907,996,891,1259,1120,465,941;38;F
82446;1259,1233,891,1450,941,742,996,207,1639,907,680,987,1120,976,215;34;F
82454;771,207,607,907,1449,996,1501,1668,582,680,987,749,675,790,1120;6;F
82463;1669,92,725,215,104,146,680,1668,1501,516,907,795,771,1120,976;38;M
82466;996,516,907,1713,1670,1669,1209,725,796,167,1668,680,891,950,1120;32;M
82489;796,1713,748,907,996,1120,40,891,749,675;28;F
82496;1639,795,145,796,907,255,748,1669,465,92,207,607,891,749,1120;35;F
82500;167,749,1120,215,796,1562,742,680,987,1212,675,40,1197,1039,976;48;M
82520;891,930,950,215,976,1197,987,680,582,1668,1501,1219,155,907,1209;40;M
82521;1668,1186,998,582,987,1164,1212,146,930,675,1197,1039,976,607,215;33;F
82535;117,465,1562,796,1669,748,1235,996,1668,680,749,950,675,1120,215;28;F
82570;790,582;40;M
82592;996,891,1212,1120,40,215,796,465,92,795,907,680,1450,749,1259;25;M
82599;1235,465,1449,104;32;F
82611;1440,207;44;M
82625;92,1669,796,1219,1668,891,1233,1472,1120,1197,207,790,104,465,749;28;M
82629;1324,1229,582,742,680,1039,465;37;M
82670;582,790;12;F
82683;996,1235,1229,680,1450,749,1259,1120,40,1039,976,725,771,1443,941;63;F
82717;582,790;8;M
82743;795,1219,92,771,207,748,1449,996,1668,680,891,1039,1120,1197,1669;64;F
82754;40,680,725,1668,1120,1197,1669;41;F
82784;465,796,117,1268,907,516,1668,582,680,941,1450,891,930,1259,976;46;M
82792;796,1209,92,1268,1440,907,941,680,987,1450,749,1259,1120,976,891;38;M
82798;987,40,976,1562,1669,117,1713,1440,207,907,996,742,215,1120,950;14;M
82802;796,1209,748,607,255,680,987,891,749,790;32;F
82831;1668,891;72;M
82838;1209,771,207,456,155,675;25;F
82856;1450,941,680,582,1501,996,907,1639,795,92,1669,155,1219,1668,1197;26;F
82859;1668;60;F
82865;1449,907,1209,796,996,1501,582;26;M
82875;796,1449,891,1212,749;33;F
82897;796,465,1669,92,607,1235,1449,996,582,680,930,675,790;74;M
82927;1713,92,998,582,1450,796,1669,1268,1668,987,891,749,1259,950,1120;35;M
82932;907,1229,207,1440,1562,742,680,987,146,930,675,1120,40,1039,976;30;F
82934;987,950,40;35;F
82941;1039,725;78;F
82954;1164,1209,987,675;34;F
82957;207,255;30;F
82982;117;50;F
83032;465,167,996,1501,40,1039,1669,748,907,1443,1668,582,749,1120,891;21;F
83034;907,1443,1219,680,749,675,40,104,748,1235,1449,891,790,1472,1120;42;M
83100;465,1235,1449,996,680,891,749;36;M
83107;1209,987,675;62;M
83111;1229;45;M
83115;930,92,1669,796,907,996,1501,1668,941,1450,891,1212,749,1259,1120;33;F
83143;1039,215,675,146,1212,987,680,582,742,1186,1443,907,255,145,1440;36;F
83151;146,891,987,1209,796,1259,1212,675,1120,976;37;F
83167;725,1039;79;M
83171;742;45;F
83178;1197,1670,92,1440,516,996,1668,680,1450,891,1212,1259,1120,40,976;64;F
83211;1443,516,607,1669,796,465,1713,907,1449,996,1501,1668,998,891,749;37;F
83231;92,795,607,1212,675,215;26;F
83255;796,748,907,1449,996,1219,941,891,749,40;44;M
83330;742,215,1562,680,987,950,40,1039;39;M
83352;725,1324,1259,1472,1120,40,215;32;M
83361;1669,92,795,255,456,155,1668,987,146,930,950,675,1120,1197,1039;24;F
83362;1259,1212,1205,146,1668,1501,155,1449,1229,607,748,92,1713,1324,465;37;F
83422;996,1212,40,1039,104,796,1268,769,795,1668,987,146,1120,1197,215;30;F
83424;465,1436,1440,742,1450,891,1039;39;M
83435;1669,795,1143,155,1668,950,675,40,1197,215;31;F
83449;748,255,749,1229,1233,675;36;M
83455;1268,1501,1668,987,1450,675,976;29;F
83469;607,748,207,1440,92,1669,796,1443,1449,996,1668,1186,680,749,1120;43;F
83472;1562,742,680,987,950,40,1039,215;39;F
83489;1562,742,680,987,950,40,1039,215;7;M
83506;1268,145,769,748,795,1449,998,742,987,146,749,1120,40,1039,215;70;F
83507;1562,742,680,987,950,40,1039,215;4;M
83511;1324,1713,92,1440,769,748,607,907,1443,1449,155,996,742,1039,215;9;F
83517;1259,976,796,1669,92,795,907,1235,1443,996,1668,680,950,1120,1197;24;M
83518;796,1562,1209,1268,92,1440,769,607,1443,1501,1668,582,680,1212;31;F
83523;1443,742,950,1039;36;M
83538;1449,1668,1197,790,40,680,796,92,907,996,1450,891,749,1120,215;41;M
83544;795,1443,996,1134,40;57;F
83565;92,1668,582;80;F
83584;1562,92,1268,748,742,680,987,1120,40,796,1669,1713,1443,1668,950;36;F
83592;1562,1669,1713,1219,680,1120,976,1440,1668,950;43;F
83614;465,891,1449;34;F
83630;1501,1668,680,987,146,976;38;M
83633;1713,769,748,795,998,742,987,891,146,749,40,1039,976,215;73;M
83638;465,117,907,155,1668,987,891;30;M
83652;207,748,117,1670,725,1669,92,795,907,941,987,1450,1120,1197,215;54;F
83659;92,907,1443,996,1219,1501,1668,742,1450,1212,1259,1120;42;F
83661;996,907;38;M
83699;1229,996,998,742,987,891,146,749,1205,675,1120,40,1039,976,215;47;F
83701;465,1449;5;F
83706;907,1235,1443,1449,996,1219,1501,1668,1450,891,1259,675,1120,1039,1212;41;F
83743;465,1449;2;F
83760;104,1472,1449,1443,1235,742;40;M
83765;996,1449,1443,516,795,465,796,1450,117,907;49;M
83789;1259,1219,742,1443;43;F
83794;1449;34;M
83804;748,1670,1440,907,516,996,987,891,930,675,976,215;34;F
83849;1440,1268,1197,1120,1259,891,941,1450,1501,680,996,907,92,1669,1668;49;F
83862;117,465,796,1209,1669,1268,1440,255,996,582,987,930,1259,675,1120;27;F
83866;680,1450,1212,749,930,1259,1120,1039,907,516,1501,987,891,976,215;40;F
83874;1268,795,742,950,215;36;F
83910;1668,891,146,749,1120,1209,1669,1449,582,930,675;31;F
83932;104,1039,1449,1443,742;43;M
83950;1440,1449,1219,996,1186,680,891,1233,1120,1197;44;F
83954;465,255,771,607,456,790,1120,104;61;F
83966;1259,749,1212,891,1450,987,680,996,907,796,1120,976;24;M
83967;891,1472,1120,941,1450,1212,749,1259,796,1670,1639,996,1501,215,795;28;M
83971;582,891,1472,996,1449,1639,795,1268,1670,516,1501,1259,1120,104,976;38;F
83973;1212;63;F
83993;796,907,987,1450,891,749,1259,790,1120;24;F
84002;1436,92,1268,771,1219,941,1450,1259,1120,1039;47;M
84043;996;46;M
84045;976,1440,1669,907,996,680,1212,749,1120,40,1209,465,207,748,1668;34;M
84056;1120,907,1501,976,1197,255;37;M
84073;725,996,941,795,1443,155,987,1235,1668,680,1450,891,1233,1259,1120;56;F
84074;1449,996,1501,680,941,987,1450,891,749,1259,675,1472,790,1120,582;29;M
84079;996,941,1212,1233,749,40,92,1639,155,1501,1668,1450,891,1120,1259;30;F
84095;607,907;31;M
84123;907,748,1229,1440,465,725,950,742,1443,1450,891,1233,930,1120,104;44;F
84142;1259,930,749,1212,907,1209,1440,207,255,1443,1449,742,680,950,675;11;M
84145;795,907,1443,996,1668,1501,582,987,1450,891,950,1120,215,104,1039;33;F
84157;465,117,1440,769,907,1449,996,1219,1501,998,680,987,749,1259,1120;27;M
84168;796,1268,1668,1212,1120,1039,795,987,950;57;M
84172;1440,987,907,215,976;40;M
84173;207,907,1443,1449,996,1219,1186,742,941,1450,146,930,1259,1205,1039;44;F
84223;465,725,92,795,907,996,1668,941,1450,891,1259,1120,1197,976,215;36;M
84232;796,465,680,891,1120,1449,749,748,1472,996;56;F
84236;742,680,1450,146,749,1259,790,1039,215,976,1197,1120,987,907,1440;1;F
84245;1039,215,1562,1324,40;34;F
84260;976,1120,749,795,1670,1209,725,1268,1440,1235,1450,1259,40;29;M
84262;795,607,996,891,749,1120,1197;58;F
84272;950;72;M
84310;1639,749,930,1259,950,1120,40,1197;20;F
84337;465,145,1449,930,1205,40,104,1443,680,146,950,207,255,1219,742;44;F
84353;796,907,996,680,1120;32;F
84374;1235,1449,1501,891,1212,146,930,790,1120,1039,749,987,582,996,796;33;M
84377;155,1501,1259,749,1449,1639,607,795,1209,907,996,1668,950,1120,976;37;F
84389;155,146,1233,1120,1197,215;31;F
84397;1669,92,1268,996,976,215,795,907,516,1668,941,930,1259,1440,680;25;M
84457;607,1212,1233,749,930,1259,675,215,104,976,1039,1197,40,1120,950;83;F
84500;582,1186,1134,907,748,145,796,207,255,1449,996,1205,1120;40;F
84513;255,215,1268,795,607,456,907,155,996,582,987,675,1472,1120,976;33;M
84524;1562,117,1713,1268,1440,907,1235,1501,998,680,941,987,891,40,976;43;M
84526;1669,465,92,795,1449,996,1501,1668,1186,891,749,1259,1205,790,1120;63;M
84551;465,1562,996,1233,790,748,167,92,1449,749,1235;35;M
84582;1713,167;27;F
84612;769;65;F
84622;582,796,725,1209,1669,92,907,996,1668,941,1450,1212,1233,1259,1120;34;F
84626;255,680,941,987,675,1472,215,976;47;F
84628;1324,1268,769,516,1235,155,146,950,1039;38;F
84631;607,582,891,1440,92,1669,465,1443,155,996,790,1120,998,1668,680;38;M
84634;1669,1209,796,92,771,145,907,1235,1443,996,1186,1212,749,1120,1449;41;F
84636;748,607,255,582,1039,145,207,155,146;36;F
84637;907,1639,1440,92,117,1324,1268,748,795,680,987,1120,40,976,215;46;F
84645;1039,40,1562,1219,1197,950;40;F
84646;582,996,680,749,1259,950,1120,215,117,769,207,1443,146,1197,1039;36;F
84650;1212,891,1450,680,582,1713,1639,987,930,1259,976,215;21;F
84652;145,771,456,607,1143,996,104,1668,255,92,1669,582,1186,1164,790;69;M
84662;891,1120,465,795,749;20;M
84672;1562,796,92,1440,748,1449,680,891,1205,790,1039,1143,996,1134,1164;39;M
84690;680,1450,749,1259,796,725,795,607,582,146,1120,1197,1039,155,950;71;F
84724;907,1449,996,1501,1668,582,680,987,1450,891,749,930,1259,675,1120;30;F
84744;167;26;M
84749;987,1450,1212,675,1120,976,104,215,1669,1436,1440,907,996,1219,1668;39;M
84751;1259,1233,1212,1450,1120,941,1668,996,907,92,1669,1209,725,796,582;33;M
84756;1449,1259,1472,976,104,725,1209,92,207,456,1219,1668,987,675,1197;27;F
84766;1669,796,795,607,907,1449,1219,1668,891,1212,749,1259,1120,1039,215;20;M
84769;1324;44;F
84792;987;70;M
84803;516,1449,976,749,742,1229,255,117,155,680,987,1450,146,675,1039;41;F
84808;104,92,145,790,796,207,748,795,607,1449,1186,891,146,930,1205;41;F
84826;749,891,680,987,941,996,907,1440,1268,1501,1450,1259,1197,215,1670;39;M
84829;1449,996,1472,749,1120,891,680,465,796;59;M
84883;725,796,1501,1450,891,749,1472,1212,1259,996,1120,941,92,1449,907;31;F
84889;941,1501,907,1209,92,1449,1219,1668,680,891,749,1259,790,1120,1197;58;M
84891;742,582,1450,891,790,1259,1120,1669,1668,987,146,1205,1039,976,215;37;F
84895;1212,1668,1197,1259;47;F
84911;891,1235,725,215,92,1639,1219,1501,796,907,996,941,1450,1259,1120;25;M
84922;255,1449,1501,1668,891,1212,146,749,950,675,1205,790,1120,104,1039;35;F
84926;1436,1268,795,907,996,987,1450,891,1233,1259,1120,976,215;61;F
84950;1209,92,1268,1440,907,996,891,1450,930,1259,675,1120;36;M
84957;907,1443,582,40,215,1209,1268,516,996,987,1450,930,1259,1120,1039;30;M
84960;796,1669,92,1268,769,795,607,456,167,1219,1668,987,950,1197,40;43;F
84965;155,1501,950,1143,1440,1324,1472,1449,1134,1186,1164,1205,1120,790;39;F
84984;155,749,930,1120,40,1197,1259,1212,987,680,1501,907,92,976,215;30;F
84987;1668,796,1562,92,1324,680,987,146,930,950,675,1120,40,1039,976;50;F
84993;950,1443,742;50;M
85030;1212,1120,976,1562,1268,1440,769,795,456,680,987,950,40,1197,1039;36;F
85061;582,742,1501,1449,456,145,796,725,207,255,907,1443,146,104,1120;20;F
85066;1449,40,748,680,749;31;M
85077;930,104,796,1669,207,255,1219,891,1120,215,987,146,675,1039,976;36;F
85078;796,749,1259,950,675,1120,40,1197,92;18;F
85092;1501,1668,1233,976,796,907,996,680,941,1450,891,1212,749,1259,1120;69;F
85108;1639,891,1259,1449,742,1120,1186,1164,1205,790;33;F
85124;796,1440,92,207,607,255,456,1235,1443,1449,1186,146,749,1205,104;44;F
85125;1562,1268,769,907,1235,996,1501,680,891,1212,749,1259,790,1120,40;28;F
85134;749,1562,465,1235,167,1120,40,1197,104,1268,796,1713,1440,795,680;60;F
85143;790,1120,796,1209,465,92,795,1449,1501,1186,104,1134,749,996,255;39;F
85153;1562,907,155,996,987,1259,675,40,1039,1443,742;41;F
85156;725,1039;49;F
85158;675;20;M
85164;891,1449,748,1670,725,465,207,907,104;74;F
85177;1668,1449,1443,255,145,92,207,748,146,1233,930,1205,675;42;M
85185;516,1669,1212,92,771,907,996,1501,1668,1186,582,1450,891,1259,1120;16;F
85208;907,996,680,941,1450,1212,1233,1259,675,1120;31;F
85215;92,1436,1639,1229,907,1449,680,1259,1472,1120,215,976,749,1212,1233;64;F
85216;215,1668,680,987,1120;46;F
85240;769,680,749,796,1562,1669,92,1268,795,907,1668,998,987,950,1120;45;M
85247;1229,1501,1668,1186,998,742,1259,790,1120,40,146,1205,675,104,215;42;F
85282;1324,1713,1440,748,255,907,1443,155,1450,749,1259,1120,40,1039,742;42;M
85283;795,907,680,1186,1212,976,1440,516,1668,987,1450,891,1259,1120,1197;51;F
85285;1562,92,1268,1440,1235,1668,680,987,1450,950,1120,40,1197;44;F
85295;1324,1669,465,104,215,976,1197,40,1120,1259,891,1668,907,771,796;32;M
85299;1639,795,1209,1669,1436,1268,996,1668,742,987,1450,1164,1259,675,1120;36;M
85300;742,1233;42;M
85304;1501,950,796,92,1440,795,907,996,1668,680,1212,1120,40,1197;33;F
85311;891,1436,1440,1450;48;F
85312;1436,1324,1713,748,795,607,1229,1449,155,1501,941,1205,1212,1259,976;36;M
85319;796,117,1440,1443,996,582,941,1450,891,1259,1120;35;M
85329;796,907,996,1209,1669,1501,1668,987,1450,930,1120,976;37;F
85331;749,907,795,1440,1268,1713,1209,1562,796,1501,680,930,675,1120,1197;23;M
85337;1668,950,790,40,976,215,1669,1713,748,607,1219,1186,1472,1197,104;33;F
85352;725,1639,155,1219,1233;44;F
85362;582,92;50;F
85367;1212,950,1120,1039;40;F
85375;1713,907,1449,996,1501,582,680,1450,891,146,1120;26;M
85387;1219,976;61;F
85390;1450,1212,1259,950,976,104,1669,92,1197,907,155,996,1668,941,1120;37;F
85392;465,725,1436,795,907,516,941,215,145,1669,1268,207,996,1219,1120;38;M
85396;465,92,769,795,582,891,1205,1472,790,796,1440,207,748,1449,749;34;M
85410;795,1449,465,748,1143,1235,996,1134,1668,582,749,1205,790,1197,104;69;M
85434;1562,769,795,1443,1449,950,215,1209,1324,1268,1440,207,155,680,987;44;F
85441;795,907,996,1501,582,941,1450,1669,92,207,255,1668,1259,1120,976;69;F
85454;145,607,987,207,1669,465,742,582,891,1212,146,1205,1197,215,104;56;F
85509;1197,215,145,1669,796,92,1440,907,996,1668,941,1450,749,1259,1120;38;F
85551;1562,117,1268,795,255,907,155,987,950,675,1120,40,215;73;F
85554;1205,1197,795,907,1668,987,1120,1229,680,950,976;52;F
85588;1440,145,207,255,456,1443,155,1668,987,146,950,675,1120,1197,1039;37;F
85606;255,207,92,1669,1668,582,987,1450,749,1259,950,1205,675,1120,976;39;F
85612;749,1259,1120,40;18;F
85614;998,680,749,1120,1472;50;M
85624;749,1212,742,796,207,907,1235,1449,950,1205,790,1120,1039,976,215;47;F
85627;891;42;M
85636;796,1440,1212,749,516,907,1639,941,891,40,1501,748,1436,790,976;40;M
85648;680,996,516,907,795,92,796,1440,1501,987,1259,930,1120,976,215;34;F
85667;748,907,987,40,790,976;65;M
85680;1669,207,255,907,1501,1668,582,987,146,930,675,1120,1039,215,950;8;F
85690;1562,1440,1268,1443,680,987,891,950,1120,215,1324,607,155,996;15;F
85711;207,255,456,1443,1449,996,1186,1668,582,680,146,749,1205,1120,40;40;F
85722;117,680,1450,1713,1440,907,1443,996,742,1259,950,1120,1039;4;F
85736;796,1562,465,1670,769,907,1235,1449,680,790;43;M
85756;104,796,1669,117,1713,92,1440,1219,1668,1120,725,680,950,1197,1039;50;F
85762;950;47;F
85766;1324,742,1039,950;39;M
85788;1713,1209,1669,907,996,1219,1668,1450,891,749,1259,675,1120,976,215;26;F
85789;1713,1324,1209,1562,796,1268,1440,155,996,987,1212,950,675,1120,1197;38;F
85794;1472,1120,215,675,1259,891,1450,941,1501,907,1268,1440,987,516,680;24;M
85815;996,907,1209,796,215,92,1440,1120,1669;49;F
85817;1324;38;F
85819;215,675,1450,907,255,1219,987;64;F
85821;680,941,987,749,1120,40,215,1562,907,996;45;F
85827;1164,1669,92,145,607,255,1143,456,996,1668,1186,582,891,790,104;65;F
85833;796,1440,1235,891,749,675,1197,207,795,1449,680;56;F
85835;1713,607,907,1219,891;20;M
85843;117,1713,748,907,987,1212,40,976,215;64;M
85847;987,680,1668,907,207,117,796,1713,92,1268,950,675,1197,215,1039;52;M
85867;987,675,104,145,207,748,255,456,1443,146,930,1120,1197,976,1039;33;F
85871;950,742,1562,92,907,1443,1668,1120,1039;39;M
85874;1209,769,1039,976,796,795,998,987,950,40,1562,117,1713,1268,215;45;F
85881;790,748,907,1235,996,1219,1212,1233,749,1472,1120,40,465,1449,1186;48;F
85885;748,1501,1668,582,941,1450,891,1212,1233,749,1259,1472,1120,976,215;81;F
85888;950;39;F
85901;92,1669,795,607,516,1668,941,1450,891,675,1039;46;F
85930;1440,749,465,1449,215;25;M
85934;1449,675,790,215,207,1713,796,1440,1120,1197,104,907,1443,582,891;18;M
85939;582,680,155,987,1039,215,207,748,1443,1449,996,1668,930,1205,976;41;F
85943;941,1440,1268,465,725,215;51;F
85952;907,1120,790,675,950,891,1450,1668,996,167,796,1713,92,795;77;M
85987;1209,207,255,742,680,1212,1205,675;33;F
85996;92,1713,1268,145,1186,930,1120,40,1197,976,1443,680,950,675,1039;49;F
85998;607,742,155,950,1039;43;F
86014;1449,1212,1450,1120,941,930,1669,1501,675,1209,907,996,891,1259,1668;23;F
86026;465,1449;22;M
86036;1669,1268,1668,1209,907,1449,996,1501,941,891,1450,930,1259,675,1120;28;M
86044;40,215,796,907,1449,996,1668,582,680,941,1450,749,930,1268,1120;13;F
86047;1268,795,907,996,1501,1668,987,1450,891,1259,1120,215,680,1197,976;45;F
86062;92,907,1449,996,1219,987,1450,1212,1233,1259,950,1120,104;46;F
86069;1268,1450,215,516,996,680,941,907,1440,987,1259,675,1120,1039,976;43;M
86073;1268,795,1443,987,976,998,891,1212,796,1562,769,40,1120,1039,950;43;M
86078;790,976,104,1197,675,117,1668;24;F
86084;1120,1668,207,796,1440,145,907,1449,146,749,1205,790,92,891,582;36;F
86087;1449,795,1324,725,1669,1440,207,748,1235,1443,996,680,930,950,1039;9;F
86095;1209,1669,255,907,1449,1501,1668,1186,1212,749,1259,675,1120,104,215;20;M
86098;146,675,1197,976;48;M
86101;796,465,1449,996,749,1120,1472;37;M
86111;1449,1233;34;M
86114;1039,1120,1205,930,996,155,1449,1443,1235,1229,795,748,207,1440,1324;11;F
86128;516,771,1440,1668,117,1268,795,607,1501,1450,891,1259,1120,1197,976;16;M
86137;941;37;F
86139;92,749,465,748,607;46;F
86150;167,1562,1324,1639,1443,1668,998,582,742,146,950,1039;42;F
86203;1562,92,207,255,907,1212,146,1120,950,215;29;F
86226;1268,456,516,167,996,680,950,1120,1039,1562,117,769,795,1668,1197;38;F
86247;1120,950,1209,748,795,907,1449,1501,1668,998,582,987,749,675,1197;32;M
86315;976,1562,796,1209,117,1713,1268,769,795,998,987,950,40,1039,215;45;M
86327;795;71;F
86330;1440,1197,146,145,104,92;44;M
86341;796,1436,907,1235,1449,996,680,987,1450,891,749,675,790,976,215;32;M
86351;891,1212,1233,749,1259,1205,675,1472,790,1120,40,1197,976,104,215;31;M
86369;117,1436,1235,516,1450,749,1120,976;29;M
86393;907,1450,215,796,996,891,1212,1259,1120;53;M
86402;1209,1669,92,255,456,907,996,1668,987,1450,146,1259,675,1120,976;41;F
86403;1186,1501,456,907,996,582,680,987,1197;34;F
86425;145,155,607,950,1039;53;F
86428;1450,891,1212,1233,749,40,607,255,1449,582,930,1259,675,1120,1197;25;F
86434;725,92,1268,907,516,1501,1668,941,987,1259,675,1120,1197,976,215;35;F
86441;1120,790,1472,996,92,465,1669,1440,748,907,1449,1668,680,891,749;34;F
86472;749,796,1209,1669,1268,1440,795,1639,1668,1450,891,1259,1120,215,976;36;M
86482;796,607,749,1501;23;F
86483;1039;41;M
86484;1324,1449,996;37;F
86487;215;26;M
86508;1120,117,92,795,607,456,907,516,1668,941,987,1450,1259,1197,976;49;F
86516;1450,987,582,1209,1440,795,255,680,930,1259,675,1120,40,1039,976;63;F
86525;1039,725;73;F
86535;795;74;M
86554;907,1449,1186,582,987,891,146,749,930,1205,675,790,1120,1039,104;42;M
86578;40,1668,680,987,675,976;66;M
86582;996,941,891,950,1120,795,1268,796,1450,1212,749,215,1713,907,1259;28;M
86588;92,1440,795,907,1449,155,996,680,941,1450,891,1212,749,1259,976;44;M
86616;465,1562,117,1670,795,1229,1235,1219,1668,742,941,1259,790,1120,976;69;M
86619;1209,796,1669,92,907,1501,1668,582,941,1450,891,1212,1259,996,1120;35;F
86631;1229,907,1449,996,742,891,1212,146,749,930,1205,790,1120,40,215;40;M
86663;1259,1197,215,796,1713,1639,907,996,941,987,1450,891,950,1120,976;55;M
86666;996,749,607,907,155,1668,1120,1197,1669,1268,795,1450,1259,950,1039;55;F
86699;796,1562,1669,92,769,795,996,1668,749,1120,40,215;35;F
86709;680,255,207,1209,725;39;F
86710;1440,769,930,1259,1219,1039;31;M
86720;155,748,771,1670,92,255,516,146,749,1259,1205,1120,40,104,1197;60;M
86788;1209,907,1449,1120,1259,1233;25;F
86803;215,976,92,1713,1669,1562,796,795,1443,155,1668,680,891,749,950;32;F
86813;725,1668,796,1209,207,255,582,987,675,1120,1197,1039,976,215,104;26;F
86834;748,907,1668,1212,950,1443,742;43;F
86835;749,1259,1120,215,976,796,1562,1268,1440,769,907,680,1212,950,1039;33;F
86836;987,996,167,907,795,769,1440,1669,1562,1268,1668,998,680,1120,215;38;M
86845;907,796,725,1669,117,1670,1436,92,1268,516,680,987,1120,1197,976;41;M
86865;465,1268,748,996,1212,749,907,998,891,1233,1472,790,1235,1449,680;44;M
86869;891,1205,215,725,465,117,1713,255,1449,1134,146,104,796,167,790;58;M
86873;1668,1134,996,907,1713,1209,930,675,1472,1120,1197,215;34;M
86877;207,1039,796,1324,1268,907,987,1143,996,1164,146,1259,675,976,215;27;M
86885;207,1209,1713,145,255,1639,1143,155,1164,675,1039,976,146,930,795;43;F
86887;1668,680,891,1120,1562,796,1713,907,1501,987,749,40,1197,1039,976;39;M
86888;1562,749,930,950,1039,796,1209,255,1235,680,987,675,40,976,215;39;M
86909;1501,117,1443,941,987,1450,891,1212,930,1259,1120,1197,907,996,976;41;F
86912;1436,1209,207,1668,582,680,987,930,1259,675,976;40;M
86929;725;39;F
86939;40,215,1562,92,748,1668,950,207,680,987,1197,1039;46;F
86941;976,996,1501,907;34;M
86952;748,1713,117,796,725,1669,92,1668,680,987,891,749,1120,976,215;26;F
86973;1120,215,1039,1229,207,769,92,1436,1713,1324,1562,742,146,950,1197;38;F
86974;796,1324,950,1120,40,1039;46;F
86989;795,255,607,1268,92,1436,1713,725,796,1669,1440,987,1259,215,976;43;F
87009;907,1562,1268,769,207,996,987,146,950,675,1120,1039;37;F
87021;998,796,465,92,795,1235,1449,996,1186,680,891,790,1120,1197,104;55;F
87023;1120,1668,1501,907,748,92,1209,725;52;F
87032;155,950,146,215;41;M
87036;771,1229,155,582,680,950,1039,255,748,145,1440,1639,146,675,215;34;F
87047;465,998,795,907,1449,996,1501,1039,976,1197,1120,675,987,1668,1209;43;F
87057;215,1268,255,582,680,796,465,92,891,1212,1120,907,1449,996,790;36;F
87062;891,1713;32;F
87064;1235,996;34;M
87065;1440,1268,92,1669,725,771,1219,1186,1212,1259,1120,1197,976,155,516;51;M
87077;1436,795,1639,155,1668,146,675,1120;36;F
87083;1268,1639,1668,891,1212,796,1450,92,207,255,930,742,1120,1443,1259;38;F
87108;1219,996,795,207,1268,1436,1670,255,907,516,1443,742,146,1259,950;40;F
87121;795,607,255,1229,1443,155,1668,742,987,146,749,950,1205,40,1039;7;F
87133;1039,215,675,1443,516,1143,255,607,207,771,1440,1268,1324,1209,742;42;F
87134;976,215,796,465,1268,907,996,941,891,1440,1639,680,1450,1259,1120;45;M
87155;207,771,1440,117,796,215,976,1197,1120,1450,1669,1268,795,1668,987;58;F
87160;1440,92,796,1669,1713,771,795,456,1501,1668,680,891,950,1120,1039;30;F
87168;907,1449,1501,680,941,987,1450,891,749,1259,1120,976,1440,996,215;31;M
87169;1324,145,255,1229,155,1186,987,146,104,1039,675,1205,950,742,1209;47;M
87172;976,40,749,1212,1668,1501,1669,1436,145,1450,1120,1259,92,1440,516;29;M
87217;104,1259,146,950,675,1324,1436,1639,930,976,1219,1205,255,207,1039;40;F
87221;1713,207,748,582,680,987,675;29;F
87228;907,1668,1669,92,987,1259,675,976,215;45;M
87248;1268,725,1713,167,1219,742,582,987,675,40,1197;30;F
87250;748,795,255,1443,167,996,1668,742,146,1212,749,950,40,1197,1039;40;M
87260;796,1324,1229,907,1235,1443,1186,742,996;35;F
87265;1197,796,1562,117,1713,1440,748,907,1501,1668,987,749,1120,1039,976;12;F
87267;465,1669,92,1440,795,1449,996,891,1212,749,675,1120,1197,1039,215;37;F
87268;1120,996,92;27;M
87271;1449;49;F
87303;1639,1440,1259,1501,1219,1436,891,680,930,987,675,215,976,1209,941;34;M
87304;1562,1268,155,987,215;42;F
87318;92,1669,465,796,907,1449,996,1501,1668,891,1212,749,1259,1120,40;31;F
87332;92,1440,207,748,255,987,1268,907,1443,996,742,582,930,950,1120;12;M
87361;996,146,1205,675,976,215,1436,1268,795,680,749,950,1120,40,1039;39;M
87363;1669,907,996,1501,1668,941,1450,891,1259,1120,1197,976;42;M
87365;607,1440,1268,1562,1209,1669,1713,748,1235,1449,1219,1668,680,749,1120;65;M
87367;1120,796,1039,675,1501,465,907,680,941,891,976,1197,987,1440,215;32;M
87384;1440,516,465,996,1120,907,1268,941;31;M
87386;930,1472,215,104,976,1120,1205,146,891,987,941,1219,748,207,145;37;M
87392;907,1443,167,1450,891,146,742,1562,1669,1713,749,1259,950;42;M
87393;155,996,941,1450,891,976,215,1120,607,1440,1436;30;F
87422;891,749,1259,1472,1229,907,516,1449,996,987,1233,790,1120,976,215;69;F
87423;1209,1324,1436,1268,1440,907,1501,1669,1449,1668,675,1120,40;17;F
87445;1443,996,1219,1668,1212,749,950,790,1120,1209,771,207,1449,1186,104;33;M
87460;742,1443,1562,987,930,950,1039,1120,40,976,215;50;F
87464;607,255,907,155,1668,1186,582,680,987,891,950,675,790,1120,40;37;F
87471;465,771,207,987,1197,117,1219,582,1668,1259,215,1120;64;F
87476;976,987,1450,146,1120,796,725,1669,92,1668,749,1259,1039,941,1501;40;M
87478;771,1235,1134,1219,1669,465,796,680,749,1120,215,996,891,790,1197;55;F
87479;104,976;64;M
87492;795,1449,996,1668,987,1450,891,1233,1259,1120,1197,1669,92,907,1501;44;M
87596;976,1197,1120,675,1259,891,1450,941,987,1501,996,907,1268,465,796;32;F
87599;675,1120,40,976,1235,907,795,1440,92,1713,796,1562,769,680,987;31;M
87601;92,1268,907,996,1668,941,1450,891,1259,1120,1039;39;M
87602;1143,1197,1472,465,1212,104,790,796,748,907,1235,1449,582,1233,1120;33;F
87613;769,998,1197,1668,987,1212,950,1039,1268,1501,1120,796,1562,1713,1440;40;F
87653;207,1120,976,1669,92,1501,1668,582,1450,146,1259;71;F
87665;941,796,680,1450,891,749,1259,40,215,1562,1268,1639,907,987,976;40;M
87666;1039,950;82;F
87689;1219,996,207,796,1562,1669,1713,769,748,907,1143,1450,891,790,1120;37;F
87693;1212,930,675,1120,796,1209,207,255,907,1449,146,1205,790,104;38;F
87736;950,1039;88;M
87746;987,1164,155;51;M
87764;92,748,907,1143,930,1443,607,145,1669,516,155,1501,1259,1120,976;38;F
87772;796,1713,167,155,1259,1120,1039,1562,1324,92,769,987,950;43;M
87775;1233,40,1197,907,456,607,92,1713,1562,725,996,930,1259,675,1120;28;M
87826;1668,680,1449,155,748,92,1669,465,796,891,749,930,675,790,1120;42;F
87843;1501,1670,92,907,996,1668,941,1450,1120,680,987,891,976,215;32;M
87863;1259,941,1039;35;M
87865;987,215,1209,1449,891,930,675,1120;35;M
87873;725,1143,790,607,1669,1668,996,1219,582,255,155,104;43;F
87878;891,207,1039;33;F
87892;1039;34;F
87895;1472,1668,1212,1120,790,40,891,998,1501,907,1440,1713,1669,725,680;57;F
87900;465,1324,207,748,1449,996,680,987,749,675,1120,40,976;53;M
87905;1259,465,796,907,1449,996,742,680,987,891,749,675,790,1120,40;44;F
87923;675,1197,1039,976,215,1209,725,1669,92,255,907,1219,1668,941,1120;47;F
87925;725,1268,907,155,1219,1472,215,255,996,680,1120,104,207,1440,1197;24;M
87930;996,1449,1229,796,725,1324,1713,92,145,748,255,456,742,146,1120;28;F
87954;1501,996,1449,255,207,145,1440,1324,465,725,1229,891,146,1233,1039;29;M
87960;796,907,1450,891,1259,675,1120,215,742,1212,950;48;F
87976;1268,516,996,1259;26;F
87980;1039,1324,795,607,907,1219,680,950,215,1562,1669,92,155,1668,40;77;M
87996;1235;27;M
87997;725,255,907,1219,1039,215;39;F
88025;950,117,1670,1436,92,1268,1449,996,1668,680,987,1472,1120,976,215;14;M
88042;92,465,145,207,255,996,742,582,941,146,749,1205,675,1120,1039;33;F
88061;145,92,1669,1268,255,1219,582,941,1450,891,146,930,1259,1120,1039;46;M
88062;796,1440,155,1668,1120,1713,795,1443,167,680,987,950,1039,976;93;M
88068;891,941,1501,996,1639,1440,907,1449,1450,146,749,1259,675,1120,215;43;F
88084;1209,907,996,582,680,1450,891,1233,749,1259,1120;36;M
88090;104,907,795,207,769,1440,117,1669,92,1233;46;F
88094;725,92,1450,1197,1120,1259,1668,1501,996,155,1449,1669,1713;26;F
88108;145,255,1229,742,146,1233,1197,104;42;F
88129;1143,907,1639,795,675,1197,976,215;52;F
88133;456,207,769,1268,1713,1562,1164,1212,950,1120;27;F
88139;796,1268,1440,1233,907,996,1501,582,941,1450,891,1212,749,1259,1120;41;F
88141;795,1039,1268,796,950,1197,215,146;45;F
88174;907,796,465,92,795,1443,1449,155,996,1668,742,582,891,1212,1197;35;F
88199;987,675,1268,976;38;M
88209;987,675,516,207,155,146,92,950;33;M
88216;1205,582;36;F
88225;1209,465,748,607,255,1449,1233,749,1205,675,1472,790,1120,1197,104;34;F
88232;1450,941,582,907,795,92,1440,1639,996,1219,749,930,1259,1472,1120;31;F
88256;1197,1670,92,907,996,1501,1668,680,941,987,1450,891,1120,976,215;33;F
88259;1669,796,1324,987,1120,1039,976,117,465,1443,742,680,749,950,40;42;F
88262;1449;4;M
88264;790;8;M
88274;207,607,255,1229,987,1212,1120,92,907,1443,742,950;43;F
88296;1436,748,255,996,680,891,930,950,1120,1039,1324,516,1450,146,1259;39;F
88304;790;40;F
88311;1212,1440,1120,796,742,1713,795,1443,167,1668,680,987,950,1039,976;65;F
88324;891,1669,92,1668,1259,1120,1197;53;F
88366;1562,117,1324,1669,465,748,255;23;M
88375;725,255,1443,1450,1212,891,1233,207,742,941,930,1259,1120,1039,215;45;F
88380;1268,771,255,456,987,675,1120,1039,976,215;43;F
88382;1669,748,92,465,796,795,155,1668,582,680,749,790,40,1197,215;67;F
88411;1501,891,146,1039,255,582,145,1120,996,1449,907,796,1669,92,1668;39;F
88413;796,1562,1268,1639,907,680,941,987,1450,891,749,1259,40,976,215;38;F
88429;1120,146,1212,742,1668,996,1449,1443,907,607,771,92,1669,465,796;4;F
88441;1143,465,795,1120,891,1164,749,1669,92,748,607,1449,1668,582,790;46;F
88486;1639,1212,40,215,1436,255,796,1440,795,1235,680;61;F
88495;255,907,582,1212,1120;36;F
88518;207,907,1501,891,1450,146,1120,1219,1039,941,930,255,1670,1440,1259;33;F
88533;771,907,996,1472,1120,748,795,1449,1219,1668,742,582,1212,146,1197;7;F
88554;950,1668,907,795,92,796,465,1443,996,680,891,749,1259,1120,742;49;M
88561;1443,742,950,207,996,1219,146,40,1039,1120;38;F
88565;1186,891,146,930,950,1205,790,907,456,255,607,207,145,117,465;27;F
88569;1669,92,1268,907,998,749,675,1197;36;F
88571;1501,996,1449,155,907,255,607,748,207,771,1713,1436,117,465,796;67;F
88594;795,907,1449,996,1668,749,790,1120,976,465,1436,92,748,680;72;M
88598;1324,145,207,1229,1219,1205,146,675,1039;52;F
88613;680,796,725,465,92,1268,1440,795,1219,1668,941,1450,1259,1120,1197;39;F
88627;1039,725,1219;41;F
88628;941,742,996,255,1324,1436,748,516,1450,146,930,1259,950,1039,1120;39;M
88629;1440,104,40,749,155,795,117,1669,796,92,748,1668,680,675,1039;40;F
88635;155,680,987,675,40,1039,215;35;M
88660;725,255;41;M
88667;1450,1436,1440,941;26;M
88668;1212,1039,950,675,930,749,146,891,680,796,1209,771,255,907,742;42;F
88673;680,891;34;M
88678;1668,1186,582,941,891,1212,1259,1120,40,1197,215,117,1713,907,155;25;M
88679;1713,1669,92,769,795,907,1449,996,1501,1668,891,1212,749,1120;39;F
88699;1268;49;F
88700;1212;38;M
88704;1713,117,1268,92,1562,796,748,795,167,1668,680,891,950,1120,40;38;M
88705;1209,680,675,1120,976;50;M
88717;582;42;M
88721;748,1235,976,680,1233;40;M
88747;104,1669,92,748,795,1443,1449,1186,1668,891,146,749,1205,675,1197;37;F
88748;145,582,1436,1440,907,516,987,1450,891,146,930,1259,1120,1039,976;34;F
88749;742,1443,907,456,1268,769,207,987,675,1039;46;M
88763;117,1670,1713,996,1450,749,582,1668,907,92,1669,1259,675,1120,1197;31;F
88766;1324;43;M
88769;1209,725,1449,996,1219,1501,742,941,1212,1233,1259,1205,1120,215,795;44;M
88774;891,40,1713,1259,582,907,1443,1186,1669,92,795,1668,680,749,1120;32;M
88788;907,145,1440,1324,680,146,1120,976,207,1259,675,255,1229,987,1039;39;F
88792;582,1501,1259,1209,930,907,1324,996,680,941,1450,891,950,1120,1039;9;F
88820;607,255,582,1233,1039,1120,1440,771,748,456,907,1449,146,749,1205;40;F
88827;1669,92,941,891,749,117,1501,1668,987,1450,1259,1120,1197,976,215;60;M
88838;1670,92,516,1219,1668,987,1120,1197;33;M
88841;1205,1134,987,1120,104,1039,456,1449,582,1197,255,607,207,1209,675;45;F
88855;1668,742,146,1197,796,1235,155,996,891,749,790,1120;33;F
88904;117,796,1209,465,1324,1713,1449,996,891,1259,950,1120,1039,749,215;41;M
88910;796,92,1668,1713;66;F
88914;742,207,891;35;M
88928;1120,675,1259,930,680,465,1209,907,996,941,1450,891,950,1324,1039;4;F
88930;796,725,1669,117,907,1219,1501,1668,941,987,1450,1259,675,1120,976;88;M
88931;1229,582,891,749,950,1197,725,92,1039,1440,795,607,155,1668,790;26;F
88935;456,1669,796,1209,1713,92,255,1668,1197,117,1440,987,675,1120,215;59;F
88939;725,1209,987,146,675,1039;39;M
88940;1639,145,769,92,117,1562,725,1440,748,795,1235,1134,1668,40,1197;47;M
88941;749,207,1713,117,748,796,1669,92,996,1668,891;42;M
88942;215,1443,1209,1670,907,996,1450,891,1259,1120;33;M
88967;749,930,1197,796,465,607,907,92,795,207,1443,1449,996,790,1120;39;F
88969;796,725,1669,1713,92,1268,1449,1668,1186,582,680,987,1259,1120,1197;27;F
88978;749,891,1668,996,907,796,1669,1472,1440,607,1120,465,155,1449,950;47;F
88993;155,607,255,215,1209,795,907,996,680,749,950,675,1120,40,1039;40;F
88999;1669,92,1501,1668,1259,1120;30;F
89029;1209,987,675;61;F
89037;1120,215;47;M
89044;1120,40,1197,1669,92,769,795,1668;33;F
89052;796,1449,1668,40,1562,92,891,976,1120,742,1713,207,987,950,1039;36;F
89056;1212,40,1440,1501,976,215,1669,907,996,1668,680,987,891,1120;28;F
89062;92,207,795,907,1449,996,1501,1668,749,1259,1039,976,742,1443,950;12;F
89063;516,1443,1668,1120,1039,1669,1324,748,1229,1143,742,891,146,749,1205;32;M
89064;907,456,255,207,145,1440,92,1669,1209,725,987,675,1472,1120;27;F
89067;987,215,117,1562,796,167,1268,1713,92,1440,1668,891,1120,40,680;38;M
89079;1501,1668,680,930,976,92,1120;40;M
89098;1668,742,582,941,1212,930,92,1268,155,1450,1259,1120,1039,976,215;41;F
89105;1134,582,987,146,1197,1039,796,1324,996,742,1443,155,1212,950,1120;49;F
89112;950;50;F
89114;465,907,1443,742;65;M
89152;796,117,92,1440,795,516,1450,891,1259,976;18;F
89155;796,92,907,1668,680,941,1450,891,749,1259,675,1120,1197,215,976;26;M
89161;790,1450,582,996,1235,748,465,1449,680,1233,749,675,1472,1120,215;34;M
89167;207,255,215,675;63;F
89169;987,976,215;42;M
89177;1669,996,796,907,516,1501,1668,680,941,1450,987,891,1120,976,215;28;F
89189;742,1039,207,891;67;M
89194;1440,771,748,607,255,456,907,1449,582,146,1233,749,1205,1120,1039;41;M
89210;1668,1186,680,1212,749,790,1120,104,215,796,748,607,582,891,1205;40;F
89212;1120,1669,748,795,749;47;F
89215;1440,795,1120,1472,749,891,1219,996,1449,907;28;F
89218;1668,1186,680,1212,749,790,1120,104,215,796,748,607,891,1205,582;42;M
89227;1205,891,255,748,465,207,456,1235,1449,996,146,749,790;35;F
89234;796,725,92,145,207,607,255,907,1443,1449,996,891,930,790,1120;11;F
89237;1120,40,1197,1668,1501,1219,996,155,1449,907,145,1440,92,1669,725;24;F
89238;104,950,675,1713,255,1143,1443,167,1219,941,987,891,1164;56;F
89245;1212,891,680,998,1501,996,907,1440,1268,796,1209,1669,1120,92,1668;32;F
89248;796,725,1669,117,907,1219,1501,1668,941,987,1450,1259,675,1120,976;88;F
89265;907,1449,996,582,941,891,1212,1233,749,790,976,1229,742,1450,1120;27;F
89267;516;31;F
89282;891;65;F
89300;725,465,1669,117,92,207,748,155,1668,680,146,749,1120,40,1039;9;F
89313;1259,1120,215,742,996,907,1440,1324,976,145,987,146,950,1039;39;F
89325;749,950,1197,796,1440,907,748,607,1449,155,582,680,891,675,1120;41;F
89339;146,675,790,1120,1268,725,1669,145,207,1229,1205,1039,1668,742,1259;30;F
89344;145,769,1268,92,1436,1670,1669,796,907,996,1450,1259,1120,1039,976;32;F
89345;790,40,215,796,725,1209,907,1449,996,1501,582,680,891,1233,1120;41;F
89358;465,748,1449,680,1205;48;F
89359;456,987,1259,675;25;F
89386;1120,1197,976,987,675;37;M
89397;891;5;F
89430;1436,1212,92,796,891,1268,465,680,1233,749,675,1472,1120,976,215;34;F
89434;891;2;M
89447;516;51;F
89463;771,795,891,40,215;45;F
89481;92,1209,207,748,255,456,1443,996,582,987,891,930,1205,675,1197;11;F
89483;1039;38;F
89490;1443,742,950;39;F
89506;1440,907,1219,1197,725,1669,92,996,1501,1668,582,987,1450,1259,1120;43;F
89507;1449;36;F
89509;92,1669,465,1668,680,146,930,40,1039,976;42;F
89529;1039,796,1268,950,40,976,215;39;M
89530;1670,1440,607,907,155,680,987,749,950,1120,1562,1324;46;M
89531;1562,117,1268,996,1212,950,1120,215,795;58;F
89554;1501,1212,1233,790,976,1669,1713,92,1639,907,1668,941,891,1259,1120;31;F
89566;516;17;F
89571;796,907,1443,996,680,941,1450,891,1212,1233,749,1259,1120,40,976;32;F
89574;725,1669,207,1449,1219,1668,582,987,675,215;22;F
89592;891;45;M
89594;675,1039,1436,255,146,930,976;33;M
89628;1713,117,1562,1436,92,1440,255,1235,996,1219,680,1212,930,40,976;47;M
89644;796,1713,92,1268,795,1212,1197,40,987,1120,950,1668,1669,117,215;51;F
89652;675,1039;42;F
89655;1235,749,1449;46;M
89656;145,607,907,1443,155,996,582,146,749,950,1197,796,1120;50;M
89668;796,930,1440,1639,996,1120,1039,1562,907,516,680,749,1259,40,976;33;F
89670;1235,456,1639,1209,796,1440,769,255,907,1449,996,1668,680,749,725;27;F
89673;795,215,582,796,907,996,987,1450,1259,1120,976;46;F
89684;1669,725,1562,207,582,987,950,675,1120,40,1039;42;F
89693;1229,795,92,465,1562,725,1436,1268,1440,516,155,996,680,146,1197;49;F
89698;1440,907,1449,996,1120,1233,1197,1229;38;M
89706;891;14;M
89720;891;3;M
89724;976,1120,1209,796;47;M
89739;1039,215,1120,796,1713,1440,769,795,907,167,1668,742,680,987,950;46;M
89752;796,907,1212,1233,1120;44;F
89765;465,680,796,1436,1450,749,516,1212;36;M
89771;1039;12;F
89798;796,1268,1443,155,987,1212,950,675,1120,1039;42;F
89801;1039;8;M
89818;796,1562,465,1669,117,1268,769,255,907,1668,987,950,1120,1039,215;72;F
89820;941,1219;39;F
89847;1134,92,987,930,1259,1120,104,1209,1669,207,255,456,675,1039,891;42;M
89848;1186,582,1212,749,930,1205,675,1120,40,1197,1039,215,1449,1233;25;M
89881;1205,891,1219,1449,1443,1324,725,207,748,1229,146,1472,1120,104;36;F
89886;1186,998,796,1713,1143,1235,1449,1668,891,146,675,790,1120,40,215;58;F
89887;1450,749,1259,215,92,207,907,976,996,1120,145,1039,1197,950,146;35;F
89889;1449;33;M
89895;1501,582,1449,907,1120,1669,1713,92,1229,1443,1668,749,1259,1197,215;51;F
89897;1713,1669,92,1501,1259,749,582,1668,1449,1443,907,1229,1120,1197,215;50;M
89902;92,1443,1668,941,215,796,907,1501,680,891,749,1259,1120,40,976;40;M
89921;1039,215;42;F
89922;207,255,146,1229,1449,996,742,582;37;F
89939;796,207,748,607,255,1449,996,1219,1186,742,987,891,146,790;58;M
89945;907,516,987,891,930,675,1120,976;39;M
89946;1209,145,207,255,1443,742,582,987,146,930,675,790,1120,1039,104;36;F
89955;941,1259,1120,1039;44;F
89967;742,680,987,891,1197,748,607,155,146,950,1205,675,1120,40,1039;40;F
89971;1209,1501,215,976,796,92,748,795,1449,996,987,1259,675;27;F
89973;1501,907,92,1713,796,1670,1443,1449,996,582,891,1120,1197,104,1212;14;F
89981;1669,1219,680,987,1440,907,516,1450,891,930,1259,1120,1039,976,215;1;F
89996;796,907,996,1219,941,1450,891,749,1259,1472,1120,976,215;27;F
90004;907,607,1440,207,255,996,1219,1668,680,941,891,675,1120,1197,215;33;M
90020;941,796,907,1501,1212,891,1233,749,215,1450,516,1639,1259,1120,976;36;F
90033;215,1668,891,1669,1324,1562,1268,769,1443,742,987,1259,950,1120,1039;40;F
90047;117,1713,796,1436,748,607,907,582,680,891,749,950,675,1120,1197;47;M
90048;1209,1436,92,207,987,1120,255,1143,1668,582,680,675,1197,215;60;F
90058;1120,1324,950,40,1039;9;M
90062;1212,796,145,748,255,907,1449,582,680,891,146,749,1205,675,1120;42;M
90065;207,1449,1186,742,891,1164,146,749,930,1205,790,1120,1197,1039,104;32;F
90083;987,790,1472,215,976,1120,950,1259,891,1450,941,1501,907,465,1268;25;M
90094;255,1039,215;35;F
90097;996,1449,907,795,1324,465,1268,796,1443,582,680,987,891,1259,1120;57;F
90098;1324,215;41;F
90112;796,1324,771,996,465,92,607,907,1449,155,1668,891,950,1120;45;F
90121;1668,749,1259,1120,976;70;M
90146;1324;6;F
90148;117,1713,1268,769,207,795,255,907,996,1668,582,987,1259,675,40;75;F
90157;1669,907,516,1501,987,1212,725,1324,92,607,155,1219,1668,941,950;47;M
90159;1440,1713,996,1219,1134,680,1205,795,607,1120,1436,104,1197,1639,146;37;M
90165;1039;45;M
90184;92,1449,996,1219,1668,582,680,987,1450,891,1259,1120,40,907,976;31;F
90192;607,255,456,907,516,155,1668,1450,92,771,1670,1669,146,1259,1197;35;F
90196;796,1562,1209,465,1713,1268,1440,769,795,907,167,996,1668,680;33;F
90203;1443,1449,1668,742,749,215,987,1212,950,976,748,146,1259,675,1120;39;F
90207;891,796,1562,465,207,907,516,1449,1120,748,749,582,607,996,790;43;M
90211;790,1472,891,1233,987,941,1562,465,1713,1268,907,1639,769,1440,207;35;F
90223;215,796,1562,1669,769,1443,1668,742,950,1120,1039;8;M
90256;607,155,582,790,1120;40;F
90257;207,607,255,1235,1443,1449,1668,891,749,950,1205,675,1120,40,1039;40;F
90280;1209,1669,796,92,907,996,1501,1668,941,1450,891,1212,749,1259,1120;36;F
90296;1120,796,465,1713,1440,1449,680,891,749,790;28;M
90305;796,1669,1713,92,795,907,155,996,1501,1668,891,749,950,1120;53;F
90316;1440,680,146,675,40,1443,1039;45;F
90350;582,742,1186,1668,1443,769,92,117,1669,1562;12;F
90366;1440;50;M
90377;1205,749,146,155,1669,1562,725,1713,207,748,795,1143,1449,742,215;45;F
90381;996;33;M
90384;930,976,215,104,796,1143,1449,1186,582,987,891,1164,950,1205,790;41;M
90386;1440,950,215,104,207,748,907,1449,996,1186,582,146,930,1205,790;40;F
90410;950,796,1562,207,748,607,907,516,1449,996,582,891,749,790,1120;;F
90416;92,748,1235,155,996,1668,680,891,749,1205,1120,907,1443,146,790;42;F
90421;1562,725,1209,675,1472,976,215,1713,207,255,996,1501,930,1259,1120;29;F
90422;117,1670,1436,92,145,1440,1713,207,456,255,146,1259,675,790,1039;36;F
90430;145,255,907,1443,996,1501,146,930,1259,1120;39;F
90494;796,1713,795,907,1443,996,1501,680,941,891,1212,749,1259,1120,976;27;M
90495;117,1324,1669,465,796,1436,1440,145,207,255,516,742,1450,146,930;35;F
90512;104,891,796,748,1668,749,790,207,607,1235,1134,582,146,1205,1120;38;F
90525;1713,1039,976,1197,749,907,1440,796,1562,215,1268,795,680,987,1120;33;M
90568;92,1669,1209,725,255,1229,456,1449,1219,1233,104;32;F
90575;465,1562,1670,1436,769,907,516,996,1219,1668,680,891,1212,1472,790;27;F
90605;582,92,748,907,1235,1443,1449,996,1668,680,891,146,749,790,1120;43;M
90615;1219,891,749,796,117,795,996,1501,1668,680,1450,1197,1120,1440,907;21;M
90624;1443,92,748,907,1235,1449,996,1668,582,680,891,146,749,790,1120;12;F
90636;92,748,907,1235,1443,1449,996,1668,582,680,891,146,749,790,1120;6;F
90649;1443,1449,1259,1120,976,1324,725,465,907,996,1450,891,1039,950,742;47;M
90652;987;30;M
90661;1669,1436,92,1440,1639,1668,1450,1259;64;F
90672;1436,1639,456,907,891,1197,1670,516,680,1450,1259,950,675,1120,976;37;M
90682;1669,1436,92,1440,748,1639,1450,1259;30;M
90693;796,907,996,1501,891,749,1259,1669,1713,92,795,1668,790,1120,215;30;F
90700;1440,1449,891,1450,1212,749,976,796,92,907,1219,1668,987,1259,1669;25;M
90705;1449,941,1259,1120,215,1669,92,155,675,1197,255,907,1668,680,976;35;F
90708;907,1639,1472,1436,749,155;16;F
90717;1668,1440,680,1450,1259,976;44;M
90729;987,675,1039,104,1120,146,742,1668,1501,1219,996,795,207,1440,796;48;F
90732;607,1440,1669,796,465,1324,1713,1229,907,996,891,749,1472,790,1449;41;F
90767;1134,891,1164,146,749,1205,790;39;F
90771;771,516,1219,1450,1164,146,1205,790,104,1197,1186,1134,1143,145,996;32;F
90783;907,1235,1668,987,891,790,40,796,1440,255,1449,680,1120,1197;32;F
90793;1713,941,1450,1212,146,1259,950,1120,1039;47;F
90813;1669,92,795,255,907,996,1501,1668,582,941,1450,1212,749,1259,1120;36;F
90830;1562,1440,1713,769,207,1443,742,680,950,40;8;M
90843;1259,976,40,1450,996,516,1235,748,891,1120,907,1443,1449,749,790;54;F
90851;207,795,1120,1259,1039;33;F
90852;207,748,795,907,742,987,146,1120,1197,1039,976,950,675,40,215;37;F
90918;1449,1219,1668,1259,1039;35;M
90940;607,748,207,1449;34;F
90943;996,1449,1443,907,607,795,207,1209,796,1235,1219,680,675,40,976;37;M
90963;1449;8;M
90974;930,950,796,1440,207,607,1449,582,891,1212,749,1120,1197,104,215;23;M
90994;1562,796,1440,1268,748,1235,1449,1219,1186,146,104,790,680,987,891;35;M
91016;950,1443,742;39;F
91022;796,891,950,1472,790;56;F
91044;996,987,1259,1120,1197,976;36;M
91058;1669,1713,92,1440,769,907,998,680,1212,950,40,1039,742,1443;11;F
91082;796,1324,1235,1449,996,1186,680,146,1233,749,675,1120,1197,104,215;31;F
91091;680,748,1209,1449,582;40;M
91114;1268,207,255,582,987,675,215;45;F
91115;796,1268,795,1449,996,582,742,1450,146,950,1120,215,1436,1639;38;M
91118;1209,796,1562,1713,1268,769,207,255,907,582,987,891,930,675,215;32;F
91127;92,748,795,976,1120,891,996,1449,1713,1268,607,155,749,950,1197;61;F
91135;950,255,145,1440,465,207,748,1449,1186,891,146,930,1205,1120;41;F
91141;742,941,891,1440,907,1450,987,1259,1120,1197,976;50;M
91142;1449;33;M
91165;1324,1259,950,1039;74;F
91183;1268,1713,117,796,748,907,996,680,1212,40,215,1562,976,769,795;44;M
91187;465,92,1449,104;40;F
91191;1501,996,742,907,748,1713,465,796,607,1449,891,749,790,1120,1039;44;F
91195;796,1134,790;34;F
91199;1233;47;F
91221;987,749,930,1197,215,796,1209,996,1501,1450,891,1212,1259,675,1120;40;F
91235;976,795,907,996,1501,1450,891,146,1259,675,1120;40;F
91237;1039,215;31;F
91243;769,771,1440,92,117,1670,796,1562,1668,680,987,1120,40,1197,215;37;F
91246;950,1443,742;43;M
91270;465,92,1449,104;14;M
91271;207,795,607,456,907,1668,582,680;41;F
91272;1120,1197,92,987,976,215;24;F
91277;1120,796,1562,92,1443,167,582,680,987,1197,1669,1713,795,1668,950;34;F
91301;790,891,996,907,796,465,1449,1120;30;M
91314;1450,1212,749,930,1120,215,796,92,1440,795,1639,907,1259,675,40;35;M
91318;1713,1449,582,675;30;F
91367;1449,996,1501,680,941,1450,891,1212,215,465,92,1440,1668,1472,1120;32;F
91386;987,891,749,1259,1120,976,215,145,207,255,456,516,1450,146,1039;41;F
91390;1212,749,950,1205,976,796,92,1449,941,891,146,1259,675,1120,1197;61;M
91409;1209,675,1039;41;F
91429;790,796,1449,996,582,930,675,1120;33;F
91446;1450,891,1233,1212,1259,1120,215,1324,941,976,1229,742,680,987,1039;45;M
91467;465,1324,1668,742,1472,790,1197,1039,40,680,155,1449,607,1235,582;39;F
91484;582,987,1450,1259,1472,215;31;M
91485;1219,1186,1450,891,1212,1259,1120;45;F
91495;680,1205,675,907,1259,1120,1197,1039,104,1209,1669,92,1440,1668,1233;43;F
91503;215,976,675,1209,796,680,40,582,255,207,1235,607,748,996,749;29;F
91516;207,255,1449,996,1450,146,749,1259,1120,1039;32;F
91518;582,987,891,1669,1670,1440,771,795,1219,976,1713,92,1209,1501,680;50;F
91545;996,1186,1212,749,1259,1205,1120;25;M
91551;1449,582,1039;41;F
91593;748,255,907,1449,1186,742,891,146,930,1205,950,1472,675,790,104;25;F
91612;796,907,1449,891,790;27;F
91616;1450,1212,1233,749,1259,1209,92,996,891,796,907,1120,215,675,976;25;F
91633;582,145,725,207,255,941,146,1039;34;F
91634;796,1562,117,1268,795,1668,891,146,976,104,1501,516,145,465,40;34;F
91649;1450,891,40,215,907,1259,1120,976;30;M
91679;1449,1235,996;46;M
91681;987,1212,749,976,1120,950,582,1501,155,1449,607,1440,92,1713,680;40;F
91687;1713,1268,607,155,1120,215,1039;13;F
91688;1443,742,950,1039;42;M
91724;145,207,987,146,675;37;F
91726;582,907,456,795,92,1669,1209,1449,1219,987,891,1259,675,1120,976;29;F
91736;1259,1436,749,155,607,1472,1639;44;M
91782;1669,996,1501,1668,680,749,1259,1120,40;62;M
91790;725;48;M
91803;941,582,1668,996,795,92,796,465,117,907,680,1450,891,749,40;43;F
91808;941,996,907,117,465,796,1639,680,987,1450,891,1259,1120,976,215;26;M
91822;1639,1235,941,40,1440,907,516,996,1668,680,1450,1259,1120,976,215;31;F
91831;675,987,907,748,1268,1209,117,1440,207,1235,1449,1668,104,749,680;48;M
91832;796,1669,255,996,1219,1450,891,1212,749,1259,1120;31;M
91833;987,1669,145,907;31;F
91844;207,145,1268,1436,465,796,769,795,607,155,742,146,749,1039,950;63;M
91846;796,1713,92,769,907,1443,996,1668,941,1450,891,1233,749,1259,215;29;M
91855;1134,1186,92,1120,1197,976,771,1670,1219,1668,680,1450,1205,1669;38;M
91865;1259,1436,749,155,607,1472,1639;41;F
91880;207,748,607,1134,987,1212,930,104,907,996,675,1120,1450,1235,796;32;F
91918;92,1440,748,907,1235,742,582,680,891,930,1205,675,790,40;25;M
91942;516,1450,1259,1120;42;M
91943;607,1186,1440,795,907,996,582,891,92,104,748,255,1449,749,1120;50;F
91944;996,1501,1668,582,941,891,1212,749,1259,675,1120,40,796,725,92;24;F
91947;796,1209,1440,748,1668,941,146,1259,1120;35;M
91951;92,1713,1670,1324,796,1669,725,207,1668,790,1120;47;F
91952;950,155,1443,207,742;52;F
91955;742,146,950,1039,40;30;F
91982;1186,680,976,215,146,742;48;M
91985;680,996,907,796,976,1233,1668,1501,941,1450,891,1212,749,1259,1120;49;F
92027;255,1440,92,1713,1209,725,907,1449,996,1219,1450,930,1259,675,1120;37;F
92029;891,1450,155,255,145,1268,92,725,1440,1443,1219,742,941,1259,1120;42;F
92036;680,891,1212,930,675,1472,1120;36;F
92062;1235,1229,1440,1713,1209,796,1562,907,1443,987,749,1324,680,1120,1039;45;M
92073;92,1324,117,725,796,1259,1450,1235,1209,1669,1713,1440,1668,680,987;38;F
92090;1436,907,1219,145,207,255,1039;40;F
92095;1449,891,1209,796,996;31;M
92103;1440,795,976,215,1670;41;M
92116;749,1472;31;F
92205;1197,907,1235,516,998,1668,725,796,1268,795,607,742,891,1120,976;23;F
92217;1268,1120,1668,1450,725,1440,742,1039,1669;32;F
92236;950,1197,215,207,996,1219,1501,1186,680,1450,891,146,749,1259,675;28;F
92243;725,1324,146,1233,1259,104,1670,1713,1436,1639,996,1450,950,1120,215;44;F
92248;465,796,680,891,1120,215,582,607,207,749,1134,1164,996,790,1639;32;M
92251;1229,607,145,769,1670,790,104,255,117,725,92,207,996,1472,1233;29;F
92262;950,215,769,167;60;M
92274;796,1440,1443,1668,582,987,1120,1197,1219;35;M
92278;769,1259,1120,465,117,1440,607,907,996,749,680,987,1212,1472,215;22;M
92308;907,1212,796,92,1268,1450,1120,1197,215,1219,1259,987,1440,748,1668;42;M
92318;1209,465,1268,907,996,941,1450,1212,1259,675,1120;28;F
92334;1219,1450,1212,1039,104,215,516,146,675,1120,1670,207,255,907,1259;47;F
92340;207,1449,996,1668,1186,742,987,891,749,930,1205,1472,790,1120,1039;39;M
92358;795,1713,92,1669,1562,796,1436,1440,1668,680,987,675,40,1039,976;55;M
92374;930,117,1670,207,255,516,987,941,1450,1233,1259,1120,1039,976,215;40;M
92384;795,796,92,1268,907,1449,996,1668,582,891,749,1205,790,1120,104;27;M
92404;996,1219,582,749,1120,1562,92,1440,769,1668,987,40,1197,976,215;31;F
92427;1324,1670,1713,1436,1440,907,1449,996,1501,742,1450,950,1205,1120,1039;11;M
92452;742,1443,950;43;F
92463;255,987,1039;37;F
92475;1120,891,941,1501,1219,1449,1443,796,907,996,1450,1212,749,1259;51;M
92508;907,1639,891,749,1259,1120;35;M
92523;582,680,941,987,1259,675,1472,1120;40;M
92551;796,145,748,907,996,1186,582,1212,607,255,456,1449,146,1120,1039;34;F
92590;891,941,92,1669,465,907,1449,996,1668,1450,1212,749,1259,790,1120;37;F
92608;1440,907,1443,680,1039;39;M
92621;680,1219;43;M
92661;1324,1670,1229,1443,1449,155,987,1120,40,1562,117,1268,907,1668,1197;43;M
92667;1229,796,1440,207,907,941,1212,987,1450,891,146,1259,675,1120,976;46;F
92670;891,749,675,1197,215,1669,1268,207,907,1668,1450,1259,1120,1039,976;34;F
92674;1197,795,769,215;64;M
92684;769,795,215;65;F
92702;1670,725,92,1440,456,155,1219,680,987,1450,891,950,675,976,215;42;M
92744;516;6;F
92746;1212,1233,1259,40,976,796,1440,996,1668,582,680,930,1120,1197,1501;36;F
92761;1443,456,1143,255,771,1268,1670,1324,1440,145,207,516,155,1450,146;36;F
92769;891,1449,255,748,145,465,1324,907,996,1668,146,930,790,1120,1039;39;F
92786;207,607,1143,1443,155,1219,742,941,1450,891,950,1120,40,1039,215;63;F
92788;725,1229,155,1219,941,987,891,146,1233,1205,675,1120,1039;7;M
92793;1443,950,742;49;M
92808;680,1669,1668,987,1120,976,996,1501,907;37;F
92821;516;4;F
92839;1229,1668,680,987,675,1039,976,1324,1443,582,930,950;38;F
92850;92,215,40,1668,680,1219,1197,996,987,907,891,796,795,771,749;24;F
92859;465,1669,92,907,1449,996,1668,941,1450,891,1212,749,930,1259,1120;78;F
92860;796,725,1669,907,996,1501,1668,1233,749,1259,1120;25;F
92865;796,1669,207,1229,1443,996,891,1450,1212,1233,749,1205,675,1120;37;F
92880;40,749,891,771,1209,104,796,92,907,996,582,675,1120;34;F
92915;907,1501,582,1143,987,976,215,516;25;F
92953;117,1268,907,516,1449,996,1219,1186,891,1212,749,790,1120,976,215;35;M
92972;941,1212,92,725,1669,1229,907,1501,1668,1450,1233,749,1259,1120,976;45;F
92975;996,675,907,987,891,976,1039,796,1450,1212,1259,950,749,215,1120;36;M
92977;725,1229,1235,1449,155,1219,941,987,146,1233,950,675,1120;39;F
92984;1450,1259,1440,607,456,1449,742,155,891,675,1120,582,1209,92,1219;35;F
93058;1443,907,795,1440,92,1669,582,1450,1164,1259,1120,1197,215;23;F
93061;167,996;39;M
93065;725,1197,1039;45;M
93067;1233,950,742,1443;45;M
93075;1669,907,1443,1501,1668,1450,1212,1259,749,1440,40,1120,1039,976,215;29;M
93089;796,465,117,92,607,907,1449,996,1668,891,749,790;27;M
93094;796,92,907,1449,996,1668,680,749,40,1197,1039,117,1268,255;40;F
93132;1449,680,987,950,1120,40,1197,976,215,1209,796,1713,748,1212,1259;32;F
93143;1670,1713,607,155,996,1219,1668,1212,675,1120,40,1197,1039;68;F
93157;1233;46;F
93175;907,1501,92,1440,1639,1449,1450,987,1668,1259,675,1120,1039,976;40;F
93201;796,92,1440,1639,907,1449,1501,1668,987,1450,1259,675,1120,1039,976;9;M
93214;1669,40,749,1639,907,996,680,1212,1440,795,1668,941,1259,1450,1120;46;M
93230;1268,465,1212,1039,1440,207,255,1449,680,582,996,607,748,749;40;M
93300;996,1450,891,1120,1472;33;M
93316;1120,675,1259,891,1450,941,1501,1219,1235,907,456,1209,1669,930,771;34;F
93324;1501,987;41;M
93342;1440,795,607,456,155,1219,998,742,680,40,1197,215,117,1235,930;53;F
93345;907,1639,795,117,987,1120,215,976;46;F
93372;1669,1562,1713,1039,1443,155,680,1212,749,950,1120;51;F
93397;1120,1259,1443,907,145,92,725,1209,1669,1440,1449,1668,941,987,1039;46;F
93411;1440,996,680,749,675,1039;37;F
93443;796,1501,680,987,1212,749,1259,1120,976,215;16;M
93474;1120,1259,155,907,795,1501,976;42;F
93476;1233,675,1472;24;F
93484;1440,941,1120,976,215;51;M
93488;1209,1669,92,1440,607,456,1449,1668,680,891,146,1233,749,1259,1120;36;F
93489;1436,1443,1450,891,907,996,1668,941,215,1259,1120,976;52;M
93505;796,207,255,907,996,941,987;75;M
93511;1639,891,749,930,1039,40,215,996,1443,1235,907,748,1212,1259,1120;41;M
93545;987,146,749,1205,790,104,215,796,1669,92,748,1443,1449,582,1212;64;F
93574;1212,1450,987,941,582,742,1449,1669,207,1229,996,1668,1233,930,675;25;F
93583;725,941,1120,207,907,1443,1219,1039;35;F
93586;725,941,1039;35;M
93590;725,1212,40,749,1233,996,465,1268,1219,1450,1259,675,1120,215,1324;40;M
93603;1324;37;F
93615;465,117,769,996,742,582,680,987,749,1039,1324,1120,215,796,1472;35;M
93635;1440,1436;21;M
93642;607,155;75;F
93654;1669,117,92,1268,255,907,516,1443,996,1668,941,1450,891,1259,1120;36;F
93703;996,1669,92,1440,907,1443,1501,1668,582,987,891,749,1259,1120,1197;41;F
93708;796,1324,607,1229,146,1472,976,1440,1197,104,465,1449,155,1039,255;39;F
93709;796,996,680,941,987,1450,1259,1120,1039,215,255,516,1449,907,1440;42;M
93715;796,907,675,1120;34;M
93716;1235,1143,907,456,1229,1639,255,607,795,748,207,796,1205,675,1039;15;M
93717;1713,907,1501,1668,680,987,976;54;F
93733;1450,796,117,155,749,516,907,1670,1440,1669,996,1219,941,1120;29;M
93734;796,1120,1472,930,749,941,680,996,516,907,891,1501,987,976,215;43;M
93736;1324,1713,145,456,255,1229,742,680,987,930,675,1039,146;35;F
93741;907,516;31;M
93759;907,1143,1219,582,680,749,930,1259,790,796,1449,996,1501,1120,1197;24;F
93760;145,155,40,104,796,748,907,996,749,1259,1197,941;35;F
93762;1669,1209,796,996,1501,1668,582,680,987,1259,675,1120,215,976;26;F
93765;996,1449,725,907,891,1120,1039;45;M
93784;742,891,749,117,796,748,1235,1449,1039,790,1120,40,680,582,465;44;F
93807;1472;39;M
93817;1197,796,1669,92,1440,1229,907,1449,1219,1450,1233,1259,1472,1120;36;M
93837;146,1259,1120,976;46;F
93845;1212;51;M
93849;117,92,1668,1212,996,1443,907,582,1450,1259,675,1120,40,976,215;34;M
93883;1450,1212,1120,215,891,749,1472,40;33;M
93884;996,516,795,748,769,1268,1562,796,465,1324,117,92,1668,680,749;49;M
93900;907,92,1713,117,796,1229,1235,1443,996,941,1450,1233,1259,1120,1039;36;F
93920;1324;8;M
93937;1229,465,1669,907,996,1501,1668,941,987,891,1259,1120,976,104,215;43;F
93945;1259,987,1668,996,1440,92,117,1209,907,976,1120;40;M
93983;1229;41;F
94002;1324;16;F
94007;1440,1639,907,680,796,725,1670,996,941,1450,891,1212,749,1259,1120;38;M
94011;1268,795,996,1501,941,1212,891,1450,749,1259,1120,1449,680,976,215;26;M
94012;1212;41;F
94034;1668,796,1501,987,675,1120,976;27;M
94035;795,1450,891,1668,1259,1120,1197,976,907,1501;35;M
94044;725,465,456,155,1219,1501,742,680,1450,1039,941,1440,207,748,607;41;F
94064;215,1120,987,1501,1219,907,1639,1669,725,1209,1449,1668,680,675,976;36;F
94076;1440,145,155,749,976,907,987,950,1120,1197,1209,795,680,675,40;47;F
94083;1268,1324,950,675,40,1039;45;F
94102;92,1268,207,1219,1668,1233;45;F
94103;1440,607,996,1219,941,1450,1212,950,215,907,891,1233,749,1259,1120;30;F
94124;1440,795,907,1443,1449,155,742,680,987,1212,146,950,675,1120,215;68;F
94143;796,1436,769,748,1443,987,1212,749,1259,1120,40,976,1324,1039,680;29;M
94197;465,1324,92,748,795,1449,1501,1668,680,749,40,1197;8;F
94216;145,207,748,255,516,1219,987,1450,891,146,675,1472,1039,976,215;35;M
94232;465,1324,795,987;32;M
94234;1669,92,795,907,996,1668,680,215,1120,40;58;F
94268;680,1668,795,769,1713,117,1669,1562,796,987,930,742,1209,1197,215;53;M
94270;117,795,255,456,1443,1449,996,1219,987,1212,1259,1120,976,215,1501;17;F
94277;516,1235,145,1713,92,1268,795,907,996,1668,749,1259,675,1120,976;26;M
94300;1449,1443,516,907,1268,1669,796,996,1668,1501,1259,1120,1197,104;21;F
94304;795,255,1501,941,1450,891,675,1197,1143,907,1440,749,930,1259,1120;32;M
94305;465,1440,769,907,1443,742,796,1562,998,950;46;F
94328;941,987,749,930,675,1670,1268,516,1501,1668,1450,891,1259,1120,976;44;F
94337;795,680,987,40,976,215;58;F
94346;976,215,104,796,725,771,1219,1501,582,891,1212,1233,1259,1120,1197;33;F
94362;795,771,1713,796,1670,907,1449,1501,1259,1472,790,976;62;F
94382;1233,1443,1229;15;F
94384;796,1324,748,907,1449,996,1259,742,749,1120;38;M
94386;1209,796,1669,1440,795,907,996,941,1450,891,1212,749,1259,790,1120;30;M
94407;1440,207,1443,1501,987,146,675,1120;38;F
94429;996,1219,1501,1668,930,1259,796,680,941,1450,891,146,749,1120,1039;43;M
94435;795,255,907,1668,987,1212,146,680,675,1120,40,1039,950,1443,742;9;F
94439;996,907,456,795,145,1669,771,1120,891,1450,1668,725;30;F
94448;907,1209,725,1219,941,891,675,1120,976,215;40;F
94455;1562,796,1212,215;22;M
94461;607,996,582,1212,1259,1443,1450;43;F
94479;950;62;M
94490;796,1209,1324,207,907,1449,996,1501,582,891,1233,749,675,1039,1120;20;M
94491;117,1669,92,1268,795,255,907,996,1668,582,1450,1212,1259,1120,1197;61;F
94496;1670,117,1669,465,1324,1436,1268,907,996,1233,1259,1120,215,1229,1449;37;M
94503;976,1450,891,1212;29;M
94504;215,1197,1209,742,930,987,796,1562,1669,117,1713,769,795,1668,680;22;M
94517;796,795,907,1449,891;18;M
94522;1443,1259,1639;36;F
94552;796,92,996,941,1450,1212,1233,749,930,1259,1120,40,976;36;M
94562;1443,950,742;31;F
94565;1669,1440,907,1219,891,465,1449,1668,941,1450,1259,1120;69;M
94568;941,987,1450,1259,675,1669,1670,92,1440,516,1668,1120,1197,976,215;39;F
94574;1440,1259,1039;46;F
94587;1668,1450,976,215,155,987,1259,675,1120,1501;44;F
94603;1259,1039;43;M
94607;1713,117,1669,1562,796,607,1449,1219,680,1212,465,749,1197,215;29;M
94609;790,1669,1713,1443,155,1668,749,1197,796,607,891,950,1120;49;F
94620;1324,1713,1436,1440,145,255,1443,1134,1668,1186,742,987,146,40,1039;31;F
94639;680,1212,1259,1120,40,796,1562,795,996,1450,891,749,1668,976,215;61;F
94666;215,796,1268,607,907,1235,1449,996,680,1450,891,1259,1120,1039,976;1;M
94674;465,1209,145,207,748,607,1668,1186,582,680,987,146,749,1205,790;44;F
94678;1501,1668,749,796,725,92,1440,680,1639,1450,1259,675,1120,215;38;M
94697;1233;33;M
94724;725,907,1450,749,1259,950,1120,215;28;M
94737;1443,1449,1668,987,749,675,1039,207,748,680,146,1205,1120,40,976;44;F
94781;1562,1713,1268,769,795,907,996,987,1259,1120;45;M
94783;1212,1120,1259,976,907,891;34;M
94789;1450,680,742,1501,996,1449,1235,907,1639,607,1268,796,1039,976,215;4;M
94827;795,1324,1562,725,1436,748,996,680,1212,215,255,907,1186,749,675;26;F
94840;1120,1443,1212;13;F
94846;1324,155,146;39;F
94847;1205,1120,1212,1450,1669;55;M
94866;465,117,145,207,607,255,456,907,790,1205,950,930,146,891,1186;1;M
94872;1209,1440,207,255,907,1449,742,1259,749,1212,1443,680,950,675;84;F
94875;796,941,1669,117,795,907,749,1120,40;41;F
94881;891,1501;44;M
94893;796,92,907,996,1668,1212,749,950,675,790,1120,40,1197;54;F
94906;1209,907,680,1259,675;34;M
94910;1443,1449,516;5;F
94911;465,207,748,255,907,1449,996,742,891,146,1233,749,1205,1120,104;37;F
94929;1440,1713,796,1669,92,996,516,987,1212,1259,675,1120,40,1039,976;42;F
94933;796,465,1268,1440,748,255,907,1449,1186,680,891,790,1120,1039,104;45;F
94943;1443,996,742,941,749,796,1440,907,680,891,1212,675,1039,976,215;36;M
94957;907,1120,1713,1440,167;28;F
94962;1120,1039,516,155,987,675,1501;40;M
94971;796,1440,907,996,1450,891,1212,749,1259,1120,40,1197;30;F
94984;749,1233,680,996,1449,1443,907,255,207,145,771,1440,1436,1209,796;26;F
95026;1562,1268,769,796,907,516,1449,996,680,987,891,1259,1120,976,215;26;F
95028;582,1259,1450,1197;42;M
95091;1440,907,516;8;M
95100;1197,1039,742,1219,1443,255,1670,92,145,907,516,996,1668,1259,1120;37;F
95121;680,987,1212,1436,976,1039,1668,1449,1324,1209,675,155,145,255,92;24;M
95127;207,1443,1501,891,1472,790,1449,996,680,749,1205,1120,40,1197,104;39;F
95147;675,215,976;39;M
95162;1440,607,155,742,1450,1212,146,950,255,1259,1197,1039,976,92,1120;40;F
95163;1443,146,1324,1713,145,795,987,950,675,40,1039,215,1669,92,1668;42;F
95171;976,1501,680;33;F
95172;891;75;F
95215;1268,1440,907,516,891;;F
95227;1440,1436,1212,891,465,1449,996,941,1120,749,680,1450,1259,950,1472;38;M
95239;207,907,1039;41;M
95280;1562,1268,795,987;50;M
95289;675,1472,92,1501,1197,1039;38;F
95324;1669,1562,725,117,92,996,1668,987,1450,1259,1120,255,1219,146,215;51;F
95330;1120,582,1501,996,1449,607,207,725,1197,675,1668,92,1669,104,215;25;F
95338;796,1562,1268,795;38;M
95356;1562,796,1436,1440,795,1639,1235,680,749,950,40;66;M
95374;796,907,1443,891,1259,516,1668,680,941,675;35;F
95381;1120,1450,941,1668,1501,92,996,1219;51;F
95382;1668,582,680,1450,891,1212,1259,790,796,1669,92,1440,1449,749,1120;29;F
95383;145,255,976,1212,1219,456,1670,1440,795,907,1501,1668,680,941,1259;31;F
95448;1639,907,1668,941,1450,891,675,1472,92,1440,996,1212,1259,1120,1197;37;F
95466;92,145,456,907,155,146,1259,1120;38;M
95523;1669,769,516,155,1668,998,742,987,891,1259,1120,40,1039,976,104;34;F
95558;1268,1324,465,1209,1449,742,941,891,930,675,207,907,1450,1259,1120;41;M
95560;1501,1450,1233,1259,1120,104,92,771,145,456,907,996,1219,1668,941;63;F
95578;1209,1436,1268,255,516,1449,996,582,680,1450,1120,40,907;32;F
95581;215,769,976,1120,987,680,1440,1713,1562,796;28;M
95583;1209,725,92,1440,255,516,1501,1668,987,891,1259,1120,40,1197,104;23;F
95590;607,748,207,145,1440,1268,796,907,996,987,675,1120,40,1197,215;40;F
95598;907,1449,996,1501,941,1450,749,725,1209,987,891,1259,675,1120,976;36;M
95604;725,680,1450,749,1120,1039,1268,1440,907,941,987,891,1212,976,1259;50;M
95606;941,1120,1259,1212,891,1668,1639,976,1449,996,907,1440,796,1443,1501;26;M
95614;749,1233,1120;51;F
95623;796,465,207,255,907,1449,996,582,987,891,749,930,675,790,1120;32;M
95624;748,607,1233,155,749,1436,1639,907,1472;12;M
95653;207,907,1449,40,976,1039,725,465,255,155,680,1450,891,749,1120;29;F
95656;1713,1443,1668,891,1120,1039,930,1449,255,92,1669,1209,796;40;F
95667;1668,1212,796,1235,1449,742,891,930,1205,790,1120,465,1268;41;M
95674;950,1197,155,1443,907,607,795,92,207,1450,930,1259,675,1120,1039;45;F
95675;1268,1440,1639,907,1186,680,891,790,976;29;F
95694;907,215,1120,976;32;F
95698;996,680,1669,92,795,950,675,1501,1197,976,907,891,1259,1209,796;27;F
95700;796,1324,145,207,255,907,996,582,742,950,1120,1039;30;M
95714;516;56;F
95733;680,749,675,1120,796,1562,1713,92,1268,769,795,167,1668,146,40;35;M
95740;742,1212,891,1450,1668,1501,1449,907,92,796,1562,1235,749,790,1120;31;F
95748;215,742,930,950,675,1120,1209,1324,207,680,891,146,749,40,1039;32;F
95756;1501,40,976,680,987,146,675,1120;42;F
95798;516,996,941,1450,891,1212,930,1259,675,976,215,987,1039,145,146;37;F
95802;1324,207,1449,742,680,987;41;M
95837;996,1229,255,607,207,145,1436,1670,1324,516,155,987,146,675,976;40;F
95838;1669,516,996,1668,891,1233,749,1259,92,1268,155,1501,104;46;F
95844;1562,1324,1268,155,996,1668,891,1205,790;31;M
95852;1440,1449,1197,215;30;F
95853;987,891,1233,749,1039,465,1324,1440,207,255,907,1449,996,675,1120;18;M
95854;1120,1440,1436,92,795,907,1443,996,1501,1668,582,680,1450,1212,1259;53;M
95855;607,907,1235,1443,1449,996,1186,742,680,891,749,1259,790,1120,104;14;M
95870;891,1212,146,749,930,1205,675,1472,790,1120,40,1197,1039,976,104;40;F
95875;748,1209,1713,1440,207,795,255,1449,996,1186,582,930,1205,1120,1197;21;F
95876;742,941,1450,891,146,1259,1120,1039;37;F
95881;907,996,1668,1259,1120,1197,1039,1669,1440,516,1219,1501,1450,941,891;30;F
95889;1324,207,255,1039;51;F
95940;790,607,255,1449,1186;30;F
95947;950,1039;40;F
95952;996,891,749,1259,1120,1472,1562;34;M
95956;1501,1668,1120,891,1259;69;F
95969;1449,796,1209,255;29;F
95980;1436,1713,1670,117,796,465,907,1235,1449,996,680,891,749,790,1120;5;M
96008;1440,465,680;38;M
96012;1268,1259,1668,941,1450,891;50;F
96026;1197,104,1436,680,1268,1440,516,891,1120,215;30;F
96040;1209,1562,1713,795,1443,742,582,680,146,950,1120,1039;35;F
96055;987,1713,1209,796,1669,769,145,907,155,1668,749,950,675,1120,1197;63;F
96058;1235,1669,1670,1268,1440,1639,1501,1668,987,1450,749,1259,1120,1039,976;33;M
96060;976,1219,607,795,1436,1669,1209,1562,92,1268,996,1668,891,987,215;27;F
96064;1324;32;F
96067;1668,891,1212,40,796,1562,1713,92,769,795,907,996,950,1120,215;41;F
96089;996;36;M
96090;996,1501,907,117,795,680,1120,40,941,796,1209,1670,1440,215;42;M
96104;155,1443,1229,255,769,1268,1713,1209,145,207,582,146,930,675,1039;42;F
96114;950,1324;42;M
96140;725,796,1209,1440,1668,1233,795,607,907,996,749,40,1212,680,891;12;F
96145;796,1209,92,207,748,255,907,1449,996,582,930,675,1120,40;25;F
96159;796,1209,1713,1440,207,907,996,1668,680,987,891,675,1120;10;F
96197;987;37;F
96244;796,92,795,907,1233,749,1039,1443,996,941,1450,891,1212,1259,1120;38;F
96256;1039,950,742;46;M
96284;795,907,1668,582,1259,1120,92,1501,987,891,1197,976;42;F
96325;1562,1235,675,1120,1197,987,680,907,1440,1713,1209,796;28;M
96337;1713,1268,1440,255,1443,742,987,146,1039,215;65;M
96340;1443,907,795,748,207,145,1436,117,1209,725,255,742,146,1233,930;37;F
96353;1039,40,1562,1713,950,998,795,1268,790,1212,796,1449,891,749,1120;30;M
96367;796,1562,1713,1268,1440,795,607,907,582,680,987,1212,950,40,1039;24;F
96373;1669,907,516,891,749,40,92,1440,748,1235,1668,1212,790,1472,1120;31;F
96399;748,1440,117,1209,1562,725,1669,1713,92,795,1443,155,1668,749,1120;44;F
96400;1669,145,1501,1668,987,146,1259,675,1120,976,215;44;F
96403;996,680,1259,950,675,1197;32;M
96407;1436,516;44;F
96421;207,748,907,1449,996,1668,1450,891,749,1259,40,1120,790,1472,680;26;M
96464;207,1229,907,1449,155,996,1134,1501,742,987,146,1259,1120,1039,104;50;F
96494;1670,976,1212,907,796,1562,1324,1713,1268,769,996,1219,987,1120,215;56;M
96506;1440,996,907,1501,1233,92,1219,680,891,749,1259,950,1120,1039,976;39;M
96511;941,1259,675,1120,1039,215,930,1219,456,255,207,1440,1324,1669,725;47;M
96514;996,1501;35;F
96518;976,1039,1197,1134,1229,795,1324,465,1143,1186,215,987;48;M
96528;255,907,1449,996,742,582,930,1205,1120,1197,145,207,146,675,1039;44;F
96529;680,155,1668,749,1039,1268,1324,1197,987,1713,795,996,1501,1259,675;19;F
96546;1450,1209,891,1440,255,907,996,1501,680,987,675,1120,40,976,215;27;F
96553;1235,1449,155,1219,1668,146,1205,1472;39;F
96562;167;76;M
96565;1668,680,987,146,675,1120,1197,907,207,1268,92,1669,1501,976,215;38;F
96606;891,1639,1229,1713,1670,1436,1268,1443,1449,1668,976,1209,907,1120,1259;32;F
96611;1450,146,1212,1668,1501,907,92,1669,1259,1120;67;M
96622;1324,950,1039;10;M
96645;1209,725,1440,907,1668,1233,1259,1120,1472,1039,795,987,1212,675,215;28;M
96650;941,1197,1039,976,796,1324,92,907,987,1450,891,1233,749,1259,1120;45;M
96673;582,680,1212,930,40,795,1209,796,92,207,987,675,1120,976,215;27;F
96684;1235,680,749,1120,40;35;M
96731;92,1449,996,1501,1450,976,607,1669,1436,1668,749,1259,950,675,1120;35;F
96739;941,675,1669,1713,795,207,155,996,1668,680,1450,749,1259,1120,1197;34;M
96743;92,796,1669,1440,771,1668,582,941,987,1450,1259,675,1120,1197,976;45;F
96747;891,1212,40,1120,796,1562,1713,1436,1268,769,795,749,1259,790,104;33;F
96787;1039;32;F
96790;1324,950,1039;12;M
96820;891,1450,1219,996,1449,907,1268,92,1669,796,1440,680,941,146,749;52;M
96826;1259,1120,40,1197,1039,976,215,92,1440,1219,1501,680,941,987,1450;35;F
96832;1450,891,749,1259,1120,1039;38;M
96842;207,607,255,1443,1197,104,771,748,456,1449,987,1259,950,1205,675;34;F
96854;1670,92,1440,207,748,255,907,1668,680,1212,146,1233,1120,675,40;10;F
96859;1669,1440,907,996,1219,1668,1450,891,1259,1120;56;F
96874;1669,92,907,1443,1668,891,1501,742,582,987,1212,675,1120,976,215;35;F
96875;215,796,1562,1440,907,996,680,941,1450,891,749,1259,1120,40,976;31;F
96887;1259,1039,976,104;42;F
96889;987,680,996,907,795,1440,796,92,607,1449,1668,1212,749,1120,215;33;F
96891;1443,950,742;54;M
96899;155,145,1324,1440,207,1229,1143,1450,891,1164,146,1259,1205,1120,1039;60;M
96928;1197,796,1209,104,40,1120,1205,255,146,1440,465;46;F
96939;1669,1209,465,92,1235,1449,1219,1668,1233,1120,104,769,796,795,1229;45;F
96971;516;46;M
97008;725,215,104,40,155,456,771,207,255,680,146,950,675,1197;52;F
97014;1562,1324,1268,207,1449,742,680,987,675,40,1039,976,215;46;M
97016;145,795,255,456,996,680,987,146,749,675,1120,40,1039,976,215;8;M
97017;1713,1268,516,1449,996,680,675,1501,987,891,749,1259,1120,976,215;31;F
97031;725,1669,748,607,1449,996,1668,749;63;F
97054;1449,1143,907,207,92,891,1197,725,1669,1668,680,1450,1233,1259,1120;53;F
97077;582,680,891,749,1209,771,748,1449,1134,742,146,950,1205,675,1039;5;F
97093;516,907,748,1501,891,996,987,1120,976,215;35;M
97100;796,1668,680,891,1259,1120,40,1039,976,215;39;F
97140;796,907,1443,1449,1205,790,40;42;F
97147;1562,795,255,155,996,998,1039,950;34;F
97166;1669,996,950,675,1120,40,1039,976;37;M
97171;456,255,1449,1235,207,582,1186,1164,790,996,1143;31;F
97172;117,92,907,996,998,680,749,950,675,1120,796,1713,1268,1440,167;35;F
97198;976,1436,1440,1639,516,680,987,941,891,1212,1233,1259,1472,1039,215;33;M
97203;1713,1670,465,1669,1324,795,1229,1143,1134,1186,987,1197,1039,104,215;51;F
97204;1440,907,465,516,255,215,1039,1120,1259,1450,987,941,680,996,796;35;F
97224;1440,207,748,255,907,1449,742,891,930,1205,1472,790,1120,40,1039;37;F
97226;1449,155,996,1501,146,790,907,1440,1669,725,92,1668,891,1120,1197;22;F
97256;1443,680,941,891,1233,930,1324,748,1229,907,1219,1450,1259,1120,1039;42;F
97259;255,748,996,582,749,1259,680,146,1212,40,1120,215,1197,1209,1669;7;M
97304;1324,1235,1668,891,1472,1120,790,749,680,748,117;36;M
97362;790;73;M
97366;996;35;F
97382;104,1259,92,117,1669,1209,255,1219,1134,1186,146,675,1197;32;F
97385;1449,1443,456,795,207,117,1669,796,1268,145,255,907,516,891,675;34;F
97387;516,907,456,465,255,1449,930,1120;20;F
97394;1449,907,92,1669,796,1501,1668,582,1450,891,749,930,1259,790,1120;64;F
97401;1713,771,907,1449,996,976,215,796,1440,1501,987,941,680,891,1120;30;F
97404;996,1501,1668,987,1450,1259,1197,976,40,1120,1212,891,680,748,215;39;F
97439;930,950,607,891,790,1120,1197,104,215,796,1669,207,748,1668,680;29;F
97450;941,1259,215,92,907,996,1219,987,1450,891,1212,1120,1436;25;F
97464;1235,1443,1449,987,1120,40,796,465,748,680,749;41;M
97482;582,680,941,1450,146,1259,675,1440,207,1443,1501,987,1120,976,215;34;F
97497;950,790,675,987,155,1443,516,607,1268,1436,1670,117,465,1562,796;71;M
97506;675,104,215,1713,796,795,996,680,941,987,1450,749,1259,1120,976;45;F
97513;117,748,516,1219,1472;43;M
97516;987,1639,796,1713,92,795,1039,1197,1120,749,1449,155,1668,680,582;38;F
97526;996,907,92,1209,1450,1259,1120,976,215;31;F
97529;891,950,976,725,1669,996,1668,1259,1120,92,907,749,40,1197,104;48;F
97540;1197,1713,680,1235,215,1209,1212,749,92,255,582,790,607,996,1449;31;M
97551;1670,891,907,516,1450,680,1668,795,1440,1501,1212,1259,1120,40,976;40;F
97555;465,1235,680;44;M
97578;907,891,1212,1472,1120,1449,680,1233;39;M
97586;146,215,1209,117,795,748,1639,1449,1450,749,1259,1472,1120,40,976;48;M
97606;582,1120,1449;35;F
97613;987,1259,675,1120;39;M
97654;104,92,1639,907,1668,680,891,146,1472,1120,1039,976,748,465,749;32;F
97661;1562,1268,987,1120,1039,215;34;M
97678;748,907,1443,1449,996,1668,1186,582,680,891,146,749,1205,790,1120;33;F
97679;996;33;F
97690;582,207,748,607,1449,1501,1134,1205,996,146,790;32;F
97692;907,1449,790,1120;65;F
97704;771,1440,1268,92,1713,1670,117,1324,1669,516,996,987,1450,1212,1120;27;F
97711;1449,996,1501,680,987,1450,891,1212,1233,749,1259,1120,40,976,215;35;M
97730;1212,1259,675,1039,215,92,1440,516,1450;32;F
97741;155,1443,207,1670,145,255,907,516,742,582,1450,891,146,1259,1120;36;F
97747;1120,1197,215,1436,987,675,976;20;M
97753;987,907,1324,1209,1669,1713,1436,1268,1440,207,1668,680,749,976,215;30;F
97756;255,1443,582,40,1449,742,680,891,749,1120;42;F
97763;1449,996,1259,1120,1039;29;F
97764;117,1268,1440,907,1443,1449,996,1219,680,1259,1472,1120,976,215,987;34;F
97777;1209,145,207,1212,146,456,930;23;F
97783;1440,907,516,941,146,675,1501,987,976,1039,255,92,930,1259;39;F
97788;680,1450,675,40,1120,215,117,1713,1268,1440,207,155,1668,987,976;29;F
97796;117,1713,92,1268,1440,769,207,907,1668,891,749,950,40,1197,976;73;F
97820;1449;6;M
97840;1443,742;32;F
97842;1440,907,675,215,1669,92,996,1668,987,1120,976;44;M
97849;1209,1120,207,255,1449;45;F
97851;796,1713,795,607,907,167,1120,582,950;16;F
97857;1639,1235,516,1449,742,155,167,1501,1668,582,680,987,146,950,675;16;M
97865;117,725,155,1443,1235,92,907,1668,941,1120,1669,1440,795,996,680;53;F
97870;1668,891,749,725,796,795,907,996,1501,941,1450,1259,950,1120,1197;49;F
97878;748,1440,1713,117,465,1209,1562,680,987,930,675,790,1120,40,976;26;M
97891;1324,1713,1268,145,207,255,1229,456,1443,155,146,930,1259,675,1039;6;M
97904;1669,725,987,1450,891,146,1259,1205,675,1120,1197,1039,976,104,215;44;F
97908;1713,92,607,1229,907,1668,582,1450,891,1212,749,1259,1120,1197,1235;38;F
97926;1120,891,996,1449;36;F
97932;1669,92,907,987,1501,1120,1197;46;F
97952;796,1562,1268,769,795;72;M
98001;207,795,1440,1235,1449,607,1668,680,987,891,790,1120,40,1197,465;66;M
98013;1233,675,725,1209,1440,255,1443,1219,742,930,941,146,1120,1197,1039;40;F
98020;796,1669,1324,145,207,907,1449,996,1668,742,582,987,950,1120,1039;31;F
98024;1450,941,1501,996,1449,1443,907,1639,255,795,1268,92,465,215,796;22;F
98068;1668,1205,950,155,769,92,1670,465,1669,1440,516,987,146,790,1197;29;F
98105;207,1443,1449,155,167,996,1219,998,742,680,987,950,675,1120,40;10;M
98108;1669,1324,92,207,255,1229,1134,1668,742,930,950,675,104;10;F
98122;92,146,1120,1501,907,145;31;F
98153;207,145,771,92,465,456,907,1235,1449,1186,891,749,1205,1120,104;24;F
98170;1039,215,1209,207,748,607,1449,155,1668,742,582,891,146,1205,1120;37;F
98172;680,941,1450,40,1039,976,215,749,891,1212,146,1259,1440,92,1120;40;F
98178;950,1443,1235,742,891,790;40;M
98191;1669,1562,1197,1501,907,145,117,465,796,516,1440,680,987,976,1039;40;F
98202;996,1186,930,1205,790,1209,145,207,748,1449,742,582,146,255,104;30;F
98206;1639,1268,1197,987,1443,215,976,1120,749,891,1450,155,907,1670;37;M
98207;92,1440,795,607,996,1450,891,1212,1259,1120,1039,976,950,1443,742;9;M
98223;255,796,1713,607,1668,987,1472,40,215,1669,1449,1233,749,1197,104;33;F
98234;1324,207,998,680,675,1039;67;M
98245;749,1259,796,215,1120,1450,891,680,996,1449,907,1268,465;64;F
98270;796,1209,1219,680,1450,1259,675,1120;38;F
98290;1268,117,1209,1562,769,456,680,987,146,930,950,675,1120,1039,976;41;F
98302;1713,907,1443,996,1668,987,891,1120,1197,976,1501;33;F
98304;1440,207,790,675,930,1233,891,987,796,465,255,907,1449,582;29;F
98307;1209,1669,92,1440,771,1668,1450,725,465,941,891,1259,675,1120,1039;70;M
98308;1324;26;F
98309;795,996,1668,1212,675,1120;29;F
98322;1668,680,1212,146,749,104,215,796,998,742,987,950,675,1120,1039;33;F
98328;996;38;F
98334;516,1670,1209,117,92,907,996,1501,1668,987,1259,675,1120,1197,976;31;M
98347;146,1443,742;72;F
98348;1449,996,1668,582,680,941,1639,1501,1450,891,1212,1233,930,1259,1120;28;F
98388;907,1324;47;F
98395;146,749,1472,40,1197,976,725,1324,742,987,1450,1259,1120,1039,215;37;M
98407;1669,796,1562,1268,769,795,1668,891,1212,749,1259,104,790,1120,40;57;F
98435;996,976,465,796,117,1449,582,680,1039,1268,1440,907,1120,675,930;20;M
98457;1212,1233,930,675,796,725,1440,1639,1219,1501,941,1450,1120,1197,976;35;M
98467;1713,1440,207,795,607,1235,1449,1219,680,987,891,790,40,1197,976;66;F
98489;725,145,1205,1039,104,146;28;F
98492;950,1120,1669,1562,1443,749,742;43;F
98497;465,790,215;40;M
98504;907,996,1668,742,582,891,1212,146,749,1039,1450,1259,976,456,1120;33;F
98505;1229;37;M
98546;1436,1440,1450,891;77;F
98557;207,1229,146,950,1039;39;F
98575;117,891,582,1120,465,1669,92,748,795,255,907,1449,996,1219,1668;66;F
98579;582,1120,215,1205,1209,92,771,207,748,255,907,1449,891,1212,146;36;F
98589;907,996,1259,1120;40;F
98603;1259,675,907,92,1209,987;41;M
98612;796,1669,1324,145,207,907,1449,996,1668,742,582,987,950,1120,1039;4;M
98652;607,795,748,771,1440,1268,1713,1669,465,1209,725,1212,930,950,675;19;F
98658;1562,465,117,1436,1639,516,155,996,1450,941,987,1233,1259,976,215;62;F
98688;680,215;42;M
98710;1443,742,891,950,790,40;9;F
98712;796,748,795,1235,1219,742,680,941,987,675,976;43;M
98743;749,1259,1120,976,215,1209,207,255,1449,987,675,680;30;F
98746;1143,996,1134,1186,1164,1205,790;66;F
98761;1120,1039,1668,1501,516,907,1440,92,725,207,1259,976,215,117,1639;48;F
98772;976,796,1440,1639,456,1219,1501,680,1670,92,795,907,996,1668,749;36;F
98780;1212,725,92,795,1639,907,1668,582,749,1120,996,680,930,1259,1450;27;F
98781;1670,516,891,1197;34;M
98784;1259,92,146,1450,891,1501,996,1443,1669,255,1668,749,1120;38;F
98819;1197,40,1120,749,1668,907,1440,92,725,1443,680,1212,950;47;F
98826;1440,796,1219,987,891,146,930,1259,1120,1197,104,771,145,207,1668;31;F
98835;891,465,1120,92,976,796,1436,1268,1668,680,1212,749,1233,1472,215;32;M
98862;1713,92,771,795,1668,987,725,607,155,950,675,1120,1197,976,104;26;F
98867;255,907,1443,996,1501,680,987,891,146,1259,1205,675,1039,1324,1120;36;F
98890;255,1443,1212,742,987,1450,146,930,1259,950,1120,1197,1039,976,215;41;F
98892;1562,749,104,1669,1449,675,1120;32;F
98894;1449,1440,1669,796,465,92,1233,749,40,215,941,1450,891,1259,1120;51;M
98901;146,987,1186,795,456;30;F
98902;1669,1143,996,1134,1186,1205,790;67;M
98909;742,950;70;M
98921;771,1670,255,795,1440,117,1669,465,92,748,1449,1186,891,790;64;M
98924;1449,941,1450,749,40,215,976,795,796,907,996,891,1259,1120,1197;44;F
98936;996,680,1450,891,146,1259,40,215,1209,1440,987,675,976,1120;41;M
98942;941,742,1501,1449,516,1229,607,907,155,996,1450,749,1259,950,1120;36;F
98954;1324;37;F
98971;976,796,1562,1209,465,1440,907,1235,516,1449,996,749,215,680,987;54;F
98974;1235,1449,796,749,1324;44;M
98985;1268,1639,1197,987,1443,215,976,1120,749,891,1450,155,907,1670;32;F
98991;796,92,1440,582,987,976,40;30;F
98997;1713,796,1562,725,465,117,1670,215,1450,996,1449,907,1639,1268,1436;34;F
99016;465,1449,104;37;M
99029;104,1143,996,1134,1186,1164,1205,790;70;M
99060;1235,1443,1449,104,742,950,1472;9;M
99074;771,92,749,1120,1197,1039,1259,1268,1669,1209,675,1668,987,146,1233;48;F
99083;255,907,516,996,891,1212,930,1259,1120,1039,976,215,950,1443,742;8;M
99092;742,680,976,1268,1039,1562,796,1235,155,998,891,950,1120,1197,215;50;F
99103;92,207,941,1219,796;26;F
99115;1209,1436,516,996,680,987,950,675,40;37;M
99122;907,155,996,1501,1668,742,680,987,146,930,950,40,1197,1039,215;73;F
99124;1143,996,1134,1186,1164,1205,790;42;F
99133;1440,749,1197,1212,941,516;32;F
99151;92,795,255,907,996,1668,582,749,1120,771,748,1449,1186,930,675;30;F
99165;1669,1668,987,675,1197;30;F
99169;1268,1440,680,987,1212,1039,1562,795,607,155,1668,749,950,1120,40;51;M
99184;516,1219,1668,1670,1669,941,1450,891,1259,675,1120,1197,215;47;F
99187;465,907,996,1134,987,891,749,930,1259,1472,790,1120,40,976,215;61;F
99192;1450,996,1449,1443,907,1713,1669,725,1209,207,1219,987,930,1259,675;47;F
99195;146,1120,930;36;M
99214;1562,1268,769,155,742,207,795,1443,987,950,1039;45;F
99225;1212,1443,1143,796,1713,1268,795,167,742,987,146,675,1120,40,1039;51;F
99234;1120,891,950,796,215,607,456;26;F
99240;1209,1713,92,1268,1449,155,1668,930,950,675;18;F
99270;1039,1197,1120,1205,749,146,1668,516,907,207,145,771,92,1324,465;20;F
99273;1668,987,1259,40,1197,976;61;M
99281;907,996,930,1120,1268,255,1450,891,1039,976,1259,950,1443,742,215;49;M
99318;465,749,950,1235,1449,1443,742,1472,104;11;F
99327;796,92,155,1668,1212,1120,1197,976;30;F
99328;92,748,907,1449,996,891,749,790,1120,215;40;F
99346;1449,891,607,104,1212,748,749,996;36;M
99374;1670,92,1440,1443,996,582,987,1039,40,215,1668,976,907,146,930;40;F
99381;1501,1668,1186,167,1449,907,456,255,607,207,145,771,1713,796,1209;27;F
99402;996,930,907,941,891,1450,255,1443,742,1259,950,1120,1039,976,215;72;M
99407;40,1259,1450,582,1449,796,1713,92,795,907,155,996,680,1212,749;49;F
99411;1562,1639,1235,1449,996,1501,891,40,796,907,215,255,680,1713,1120;32;M
99422;796,1209,1670,1440,207,255,907,1219,930;47;F
99427;465,1268,1197,907,1449,996,1668,1450,891,1259,1120,796,1501,680,941;34;M
99432;1713,1670,1562,796,996,742,1197,1669,117,92,1268,1440,1668,1120,1039;38;M
99446;92,207,796,748,907,1449,155,996,1668,1450,891,1233,749,1259,1120;48;F
99461;1450,987,941,582,1668,1501,1219,996,516,907,1440,1669,796,1259,1120;21;M
99465;255,1639,1449,1501,1668,987,1212,907,996,941,1450,891,749,1259,1120;28;F
99473;1669,582,749,1259,796,907,996,1120,92,1668,987,976,215;26;F
99482;796,907,749,790,1120,748,1449,996;40;M
99487;796,1713,92,1440,795,607,255,907,516,1449,996,1668,790,1120,1197;27;F
99492;1562,1436,92,1639,1501,1186,742,40,1472,1197,215,207,1219,1668,987;35;F
99498;790,1120,1197,1212,1501,1668,1219,907,1669,796,92,996;32;M
99507;796,465,748,607,1449,680,891,146;43;M
99538;1669,607,1668,1186,987,950,675,1120,215;29;F
99549;996,907,145,92,465,796,117,680,891,1212,1259,1472,1120,1197,976;24;F
99558;1501,1668,582,1450,1212,1233,1259,1205,675,1120,1197,1039,1713,167,987;36;F
99561;1120,796,1562,1713,92,795,907,675,1197,215,1324,1268,207,987,950;46;F
99574;145,1229;36;F
99575;1449,1186,1219,1120,796,104,748,749;67;F
99587;92,207,748,907,1449,996,1668,742,891,1212,146,1233,749,1120,215;69;M
99594;1233,1669,907,996,1219,1668,680,941,1450,891,1164,1212,1259,1120;62;M
99640;891,987,680,1235,1639,1440,1713,1562,907,998,516,1268,1670,465,790;30;M
99647;456,1501,582,1450,1259,1209,1713,795,1449,1219,680,675,1120,1197,215;16;F
99648;796,1562,92,749,1268,907,996,1668,582,987,1212,950,1120,40,215;76;F
99665;950;23;F
99674;1436;65;M
99698;1562,465,117,891,40,1209,680,1324,207,255,1449,742,675,987,1039;39;F
99708;996,155,145,796,1440,907,1443,1668,1450,891,146,1259,1120,1197,1039;35;F
99712;1669,1670,1268,1440,907,996,1668,1120;31;F
99715;1669,155;45;F
99737;456,1120,1259;34;F
99740;907,1440,996,1219,987,1120,976;30;F
99745;465,1120,1669,92,1443,1668,582,680,1212,749,1197;37;M
99763;680,1212,749,215,1668,907,1639,1268,987,1450,930,1259,675,1120,976;40;F
99766;1205,155,1440,92,796,1669,748,907,1235,1443,996,1668,582,146,749;47;M
99767;117,941,987,1450,749,1259,1120,40,1197,976,215;51;M
99796;1324,1268,907,1235,1443,941,1259,1449,996,742,680,1450,891,1039,976;48;M
99800;607,1472,1039,796,1501,907,145,1669,465,1197,1449,996,1219,1120,930;47;F
99812;1268,207,607,1449,155,1219,1668,742,582,1039;58;M
99817;465,790,796,92,748,907,1449,996,1668,582,680,891,1212,749,1120;55;F
99818;1501,996,1449,1668,1450,675,582,891,1197,976,1259,1212,1233,941,725;20;F
99828;1562,1209,1713,1268,769,1668,998,680,987,950,675,1197,1039,976,215;48;M
99845;725,1669,255,1143,1449,155,1668,680,987,749,40,104;34;F
99862;456,1197,117,1713,1268,255,582,749,40,725,465,748,1449,998,680;36;F
99873;790,1212,1449,930,891,680,742,1219,1443,1229,607,748,1440,1324,1669;33;F
99878;1259,1209,207,907,1668,1120,996,1501,976,1440,795,680,987,40,1197;43;M
99886;1120,1259,1212,891,1450,941,680,582,1449;40;M
99890;1713,796,795,255,1639,907,1449,987,1450,930,1259,675,40,1197,976;26;F
99892;796,1440,255,996,1219,465,92,795,907,1449,891,749,790,1120,104;53;M
99899;996,675,790,1120,1562,1713,1436,769,748,1235,167,680,1233,1472,215;30;M
99906;117,907,1443,1449,996,1450,1259,941,1120,40,1197,749;26;M
99909;976,1120,891,1450,941,680,1668,996,907,207,1669,1440,930;40;F
99923;167,1713;83;M
99942;1639,907,516,1668,930,1120,1039,680,1450,891,1259,1670,1440,1219,1197;34;M
99954;796,465,1440,748,907,1449,680,941,1450,891,749,930,1259,675,1120;41;M
99957;1120,675,891,680,996,255;33;F
99958;796,725,1209,1440,748,987,1472,790,215,1120,891,680,1449,907,465;47;M
99965;1669,1436,1268,795,941,465,255,516,1450,891,1259,675,790,1120,976;32;F
99975;1259,675,680,1120,582,1668,996,1449,1443,1235,907,456,1229,769,891;34;F
99980;155,1443,907,748,1669,92,607,1449,996,1668,891,146,950,1120,104;41;F
99984;725,1669,117,1670,1713,1436,1120;60;M
100007;92,748,1229,456,907,1449,155,1668,742,987,891,930,1205,675,790;30;F
100008;582,1186,996,796,1209,1669,92,1440,255,907,1668,930,1259,675,1120;36;F
100013;1205,1209,207,255,996,941,987,891,907,1450,1259,675,1120,976,215;29;F
100034;1713,167;70;F
100051;1120,1197,215,796,907,996,1668,582,1450,891,1212,749,1259,675,1039;26;F
100063;1449,1186,1472,790,1120,104;35;F
100067;1450,796,1713,1440,907,1449,996,1501,582,1259,976,1120,215,1670,516;35;M
100073;1501,1449,907,607,795,1268,996,1212,1120,976,1436,987,891,675,215;28;M
100082;748,1449,749,675,1472,790,1120,104;41;F
100087;996;34;F
100090;795,1440,92,117,1669,996,742,987,1450,675,1120,1197,1039,976,215;39;F
100093;1436,1440,145,255,456,742,582,680,1209,987,146,950,675,1039,976;41;F
100096;155;39;F
100101;1186,582,40,1197,215,725,1209,1669,795,1219,1668,941,987,675,104;25;F
100106;215,1197,40,1120,1669,1209,725,675;31;F
100128;987,1450,891,1164,1259,790,40,104,1268,1143,1668,675,1039,976,215;26;M
100143;796,1669,92,207,1668,742,1259,675,1472,1501,987,1120,976,215;42;F
100160;215,796,1209,1449,996,1501,1450,891,930,1259,675,976,1120;23;M
100167;769,1562,117,1268,795,1233,675,40,976,215;29;M
100178;1450,891,1212,1259,40,796,1669,92,1440,907,1449,1668,749,1120,996;33;F
100210;465,795,1501,1668,1233,941,104,1436,1219,725,1450,92,1259,1120,40;21;F
100211;680,582,996,907,1268,92,796,516,1668,1450,891,1259,675,1120;48;F
100221;996,1259,907,155,1120,1039;48;M
100223;1039,950,998,92,117,1562;43;M
100245;1450,146,1120,92,465,1324;43;F
100249;1443,748,1562,796,1669,92,1440,907,1449,996,1668,680,891,1120,749;27;F
100254;987,1212,790,465,1449,749,1120;44;F
100260;1440,255,1229,456,742,680,987,1450,146,1259,950,1205,675,1039,976;5;F
100292;796,1562,1268;70;F
100298;796,907,996,742,891,749,930,1120;36;F
100308;1639,795,1670,1209,725,796,92,996,1668,582,1450,749,1259,675,1120;23;F
100312;1209,1669,207,748,255,907,1219,987,749,675,1120,40,1197;50;F
100361;796,92,748,607,996,1668,582,680,987,891,749,790,1120,976,215;52;M
100363;1440,1268,796,1669,907,155,987,749,950,1197;53;F
100371;1197,1440,207,607,255,1501,1450,891,749,1120,796,725,748,155,996;34;F
100389;796,907,996,1501,941,1450,891,1259,1120;33;F
100396;1472;47;M
100411;796,465,1440,748,1449,742,891,1212,255,207;44;F
100417;742,987,930,40,1197,1039,215,796,748,1235,996,680,1212,749,790;28;F
100436;582,465,771,748,1229,907,749,675,790,145,207,255,1143,1668,1120;45;F
100446;1669,796,92,907,1449,996,1501,1668,891,749,1259,675,1120,1039,104;38;F
100451;680,582,1449;45;M
100455;996,92,207,1443,1501,891,1164,146,675,1205,790,1120,1197,1039,104;29;F
100475;998,582,680,987,749,1259,950,976,215,1562,1324,1713,1268,1440,1120;51;F
100476;1713,117,1669,1209,465,1440,207,748,255,582,680,987,749,930,1120;31;F
100480;1233,215;35;F
100496;1209,1669,1449,1501,1668,1120,1039;30;M
100506;796,1669,92,748,795,907,1443,1449,996,1668,891,790,1120;70;F
100538;796,1562,1268,996,987,1120,40;39;F
100540;748,1235,1668,1233,930,749,40,1197,796,907,1449,996,1501,1120,104;28;F
100547;796,725,1209,465,1440,748,907,1449,680,987,891,1472,790,1120,215;10;M
100552;1713,1209,1562,796,465,92,748,795,155,891,749,950,1120,40,976;34;F
100558;465,92,907,996,1668,680,1450,891,1212,749,1259,1120,40,1197,976;33;F
100567;1209,1668,1186,582,146,771,607,255,907,1449,215,40,1120,930,1205;13;F
100575;1472,1449;35;F
100577;796,1562,1268,207,748,1449,167,996,742,680,891,1212,950,1120,1039;35;F
100629;1669,92,607,255,456,1449,1668,582,1212,749,1205,1472,790,1120,104;30;F
100631;92,1440,145,1639,255,1229,907,155,1219,1450,146,1039,516,1259,1120;31;F
100643;1668,891,1212,950;42;M
100679;996,1449,456,1639,255,145,1440,1268,92,1669,207,146,1120,976,215;29;F
100684;987,1501,1219,155,1440,1436,1209,725,1669,92,907,996,1668,675,1120;29;F
100687;145,607,1143,146,675,40,725,1209,1669,92,207,795,996,1668,1212;40;F
100697;255,907,516,1501,1668,987,1450,930,1259,675,976,104,146,1120,771;30;F
100701;1209,907,1668,987,675,1120,215,976;26;M
100718;465,92,748,607,1235,1186,987,891,1233,749,950,1472,790,215,1449;30;M
100736;725,891,1197,1120,675,1212,941,582,1668,1501,996,1449,255,207,1713;24;F
100743;1668,996,907,795,207,92,117,1562,582,987,1212,1120,215;37;F
100750;1639,516,996,742,582,941,891,1212,1259,1120,40,976;35;F
100752;996,92,1449,1668,891,790,1120;16;M
100770;796,1562,92,1440,748,1449,998,582,680,987,1212,40,976;27;F
100804;207,255,742,146,749,930,1205,675,1120,1039,104;33;F
100805;465,1562,996,146,907,748,207,1440,1669;41;F
100808;1670,465,1562,796,950,607,1449,155,996,891,749,790,1120,1197,104;47;F
100820;725,796,92,1440,907,1449,996,1501,1450,891,930,1212,1259,1120,215;40;F
100833;465,92,1268,907,1449,680,987,1450,1259,675,1120,40,1039,976,215;42;M
100834;680,796,92,795,255,1229,1668,742,907,155,996,1501,1450,1259,1120;37;F
100869;1501,1120;36;M
100897;748,607,1186,891,1472,790,1120,104;26;F
100907;987;66;F
100912;1219,675,1120,976,987,1212;32;F
100936;1669,675,40,465,92,1440,207,795,255,680,1450,146,749,1205,104;19;F
100963;145,771,941,976,1219,1120;32;F
100986;117,1440,907,675,1197,92,996,1501,891,1120,1039,976;39;M
100992;582,987,1219,996,155,1449,607,748,207,145,92,749,1259,1120,40;34;F
100996;1713,771,996,1501,582,1450,1212,1259,1197,976,796,465,1268,795,907;36;M
101028;796,1324,950,675,1120,215,976;48;M
101035;1713,92,998,742,796,795,749,950,40;41;M
101048;607,1440,1209,725,675;26;F
101051;456,680,941,1450,146,1259,675,1120,1039,104;35;F
101060;987,117,255,1449,680,207;36;M
101077;1120;28;M
101081;1668,1450,930,1259,1120,1039,92,1268,1440,1501,998,987,675,1197,976;35;F
101084;92,907,1443,1501,950,40,1197,976;22;F
101093;907,996,1219,941,1450,1233,749,1259,1120;39;M
101094;1268,607,907,516,996,1501,1186,1450,1668,92,1259,1120,40,1197,104;28;F
101114;907;68;F
101124;1440,207,1229,907,1449,1443,167,1219,996,1501,742,790,104,582,215;13;M
101126;1436,92,680,1472,1120;34;M
101167;1235,748,1449,749,675,790,104;35;F
101171;1120,215,40,680,1209,796,748,749,92,1235,1186,1205,790,607,996;56;M
101173;1143,996,1134,1186,1164,1205,790;72;F
101189;790,796,92,748,607,996,1668,582,680,987,891,749,1120,976,215;51;F
101191;796,1233;33;F
101197;1259,1039,456,516,1443,1449,1668,582,987,1450,749,930,675,1120,1197;48;F
101277;796,1562,1713,1268,255,155,996,1219,582,680,987,1450,891,749,1120;35;F
101288;1670,680,749,941,1443,1669,92,907,996,1668,987,1259,1120,976,215;33;M
101291;725,796,1443,155,1186,749,675,1197,976,215,465,795,680,1120,40;44;M
101292;1472,790,255,907,1443,1501,104,1205,749,680,996,1449,1235,748,465;;F
101312;680,987,749,675,907,1443,742,891,1212,146,930,950,1120,1039,215;41;F
101332;1209,907,1449,941,1450,146,1259,675,1197,1039,104,255,987,1120,976;31;F
101342;1449;23;M
101357;465,796,1669,117,907,1443,1449,996,1501,1668,582,1259,675,1120,1039;46;F
101368;748,907,1449,950,1562,465,117,795,155,749,1120;53;F
101385;1436,1440,1450,891;76;F
101405;1449;12;M
101418;725,1209,1669,607,456,1143,516,155,1668,998,987,1212,675,40,1197;31;F
101431;1669,117,1670,1268,1639,516,1668,987,891,40,104,749,790,465,930;22;M
101432;1443,907,1639,748,1713,796,465,117,92,1120,749,582,1668,996,1449;30;F
101445;255,907,680,1205,1219,996,748,607,1449,987,891,146,790,1120,1039;34;F
101455;748,907,1449,996,1219,1186,742,891,749,790,1120;73;F
101477;1668,796,465,92,907,1449,1501,680,996,1450,891,1212,749,1259,1120;33;M
101479;1562,92,255,907,1449,996,1668,582,680,891,1233,749,1259,1120,40;35;F
101483;1668,1212,1209,1436,1669,1268,1440,1449,1501,1450,891,1259,1120,1197,976;34;M
101517;680,1235,1449;37;M
101521;1197,796,891,1212,1120;22;F
101526;1440,907,1443,1449,996,1501,941,987,1450,146,1259,1205,976,215,675;29;F
101542;1669,1324,92,1440,207,1229,907,1443,1449,1219,742,582,987,1259,675;42;F
101548;145,255,1713,725,117,92,1668,675;25;F
101561;1120,1039,1205,749,146,891,742,1668,996,1449,907,748,92,1669,675;34;F
101592;1440,796,1562,1713,907,167,680,1212,146,930,950,675,1120,976,1039;45;M
101603;1449,1186,1205,607,748,749,582,790;37;F
101609;796,1562,465,1669,117,92,1268,1440,769,1449,996,1668,998,1197,215;42;F
101611;1443,907,167,998,680,1039,1450,1212,1501,1668,987,1120,40,1197,796;48;F
101612;92,255,155,749,1259,1039,104,1197,1120,675,950,1450,1669,607,1668;27;F
101616;1143,255,207,1209,1440,907,996,941,930,1259,1450,1164,1120,976,215;42;F
101621;930,1450,582,996,1639,255,907,516,1443,742,987,215,1039,1120,950;43;F
101632;1143,516,1443,1668,987,1450,1164,146,930,1259,675,1120,40,1197,215;34;F
101636;1212,1670,1713,92,748,891,1039,1120,1443,907,796,1449,582,749,790;47;F
101642;1668,998,987,891,749,1120,976,215,1268,92,1562,117,1713,155,950;62;F
101645;1449,117,1209,996,1219,1212,40,1197,215,796,1713,92,907,1668,1120;36;F
101647;40,891,998,907,987,1440,796,680;32;M
101654;465,207,748,255,1235,1443,1449,996,680,891,749,1205,1472,790,104;39;M
101668;1197,1219,1449,1235,607,1209,1669,456,155,1668,987,950,675,215;67;F
101677;1120,92,207,1443,742,950,1039;10;M
101691;1449,146,1205,1120,104,207,607,255;42;M
101693;796,1669,1268,1440,748,907,996,1668,1450,675,1120;33;F
101696;582,996,1235,748,796,1713,92,907,1449,1501,891,1212,749,790,1120;34;F
101704;907,607,207,145,465,748,255,1443,1449,582,680,146,1120,1039;36;F
101711;1440,207,950,1039;39;M
101723;1450,941,582,1668,1443,907,207,465,92,996,987,891,1259,1120,1197;42;F
101726;1039,771,145,1639,1668,998,680,1209,1268,795,987,146,950,675,40;54;M
101730;40,1197,749,930,1440,92,465,796,117,742,675,976,1268,748,607;31;F
101746;1268,907,1501,941,987,891;33;F
101748;1268,607,907,998,987,1450,891,1212,1197,40,1120,790,1259,950,675;23;M
101755;749,1449,92,1669,1209,796,1668,996,1235,907,607,680,40,1120,215;56;F
101762;1449,941,1450,891,749,930,1259,1120;26;F
101763;1440,1449,1668,680,749,40;32;F
101773;950,976,1186,1668,1219,155,1143,907,255,607,145,92,1669,1670,207;25;F
101774;796,92,1440,795,907,996,1501,891,749,1120,1668;32;M
101791;996,1450,146,1259,1120;31;F
101794;1450,996,907,1668,1501,1259,1120;30;M
101799;1209,1324,950,675;47;F
101806;1268,255,456,1450,582,680,1120,1713,771,607,1501,1668,675,1197,976;19;F
101809;1668,582,1450,891,796,725,1713,92,907,996,998,680,749,1120,40;26;F
101813;987,749,930,40,215,796,1436,1440,907,1449,996,1450,1212,1259,976;40;F
101816;796,771,907,1449,996,1501,941,1450,891,749,930,1259,1120;30;M
101824;749,891,987,941,582,1501,996,155,1449,907,795,1440,1670,1209,1120;37;F
101834;749,987,996,1449,796,92,1440,516,680,1450,976;37;M
101835;796,1209,92,748,907,1449,996,1668,1450,891,749,930,1259,675,1120;33;F
101838;748,907,1449,1501,680,891,790,104;42;F
101841;117,92,255,1639,907,996,1668,1120,1197,582,987,1450,1259,976,215;69;F
101844;796,1436,907,996,742,941,1450,891,1259,1120;35;M
101852;607,976,465,1268,1233,749,582,255,1440,996,790,215,891,941;28;M
101858;1209,1324,1713,1436,207,255,1449,155,1186,680,987,930,675,1039,976;24;F
101881;996,1259,104,1197,582,941,891,1450,1212,1233,1120,92,1229,1443,1219;46;M
101882;1639,1449,1219,1501,1233,950,790,796,1713,1268,795,907,996,1212,1120;20;M
101885;796,92,1668,950;56;F
101892;1639,1501,941,1450,891,1259,1039;33;M
101893;117,1669,465,748,1440,92,796,207,907,742,891,749,790,1205,1120;43;M
101933;795,1669,987,1120,40,796,1562,1268,1440,769,1443,998,1668,680,950;45;M
101939;582,749,790,1120,104,950,1212,891,1450,1668,155,795,607,207,92;84;F
101942;1501,1670,92,1440,456,907,516,996,1668,891,941,1212,1259,1120;40;F
101950;1324;47;M
101957;1229;38;F
101990;1039,1324;42;F
102000;796,1209,1268,207,907,516,680,987,891,930,1259,675,1197,976,215;54;F
102002;607,790,1120,1039,796,117,1713,907,1443,1449,1668,891,749,92,996;44;F
102010;1436,1669,465,92,795,907,996,1668,998,582,680,1212,950,1120,40;30;M
102019;1209,1450,92,1440,207,996,1668,582,891,1212,1233,749,930,1259,1120;25;F
102020;1440,907,1219,1668,582,987,1450,891,1212,146,930,1259,675,1120,1197;25;M
102030;92,155,996,1259,1120,1197,1669,1713,607,255,1134,1668,1450,950,675;35;F
102068;996,607;31;F
102089;1268,1713,976,40,1472,891,987,998,1501,167,1235,465,117,1436,1639;32;M
102094;1197,1259,987,1219,996,1443,465,582,907,255,748,207,1268,1436,1324;49;F
102105;1209,255,456,1449,1219,1668,680,987,930,950,675;58;F
102116;1209,1440,748,456,1143,1235,1449,996,1668,680,987,1164,749,675,215;53;M
102128;40,1197,1120,790,1233,1668,795,92,607,155,680,749,950;43;F
102155;748,207,1440,796,1449,146,790;35;M
102158;1669,1501,1450,891,1212,749,40,796,725,1668,996,1259,1120,215,976;32;M
102166;145,207,255,907,1449,1501,742,582,1450,891,1212,146,930,1259,1120;31;F
102181;92,255,1164,1212,749,1205,1143,996,907,1449,1219,891,790,1120,104;61;F
102195;1039,930,1259,1120,1440,207,255,987,1233,675,1197,941,1219,1235,725;30;F
102196;1713,207,907,1235,1449,1501,941,749,215,92,1219,1668,1259,675,1120;29;F
102205;207,930,146,987,582,1268,92,1669,1324,456,1668,680,1039,215,976;39;F
102206;742,582,1472,1197,465,207,748,255,1449,680,891,146,749,1205,104;39;F
102216;1669,1668,891,749,1501,996,1449,907,680,987,1450,1259,1120,1197,976;43;M
102229;907,996,930,1259,255,1143,987,1164,1197,1039,215,742,1443,950,1120;15;M
102261;1268,891,1212,1440,1449,680,941,987,1450,749,930,1259,1120,976,1209;41;M
102328;146,582,742,1668,255,145,92,207,987,930,675,1197,976,215;41;F
102333;725,1562,1268,987,675,215;28;F
102360;1669,1713,92,1268,1440,907,1443,1449,996,1668,987,891,1259,675,1120;22;F
102366;155,607;36;F
102391;675,1472,117,465,796,748,1449,1219,1668,1186,891,1212,790,1120,40;32;F
102490;1212;49;M
102491;1668,92,907,1209,607,1449,1186,891,146,749,1205,675,790,1120,104;40;F
102506;769,950,675,1039,1197;64;M
102525;1235,987,790,976,996,1449,465,796,207,907,680,146,749,930,1120;42;M
102530;1229,1443,155,582,1164,146,1205,40,1197,771,145,795,607,1668,950;30;F
102539;1562,117,92,1235,1443,1449,996,742,749,930,1120,40,465,1440,680;38;F
102540;1324,465,1443,1449,1219,742,891,146,930,1205,675,1472,1120,1039;6;F
102557;996,742,1212,790,1440,1229,998,516,1443,146,950,675,1120,1039,104;36;F
102602;1713,1562,1443,1669,1268,749,795,907,996,987,1450,1212,1259,1120,40;39;F
102616;215,1235,680,891,1164,1212;28;M
102624;907,1669,796,1209,465,92,255,1449,996,1186,582,891,930,1120,215;34;F
102637;987,930,1450,1039,215,796,1209,795,996,1219,1668,891,1259,1120,1197;45;M
102640;1713,907,891;34;F
102648;680,930,1209,465,1436,1268,255,516,1450,891,1259,675,1120,976,215;32;F
102649;1443,725,1209,1669,92,1440,795,996,1668,680,987,749,1259,675,976;34;F
102660;1197,1039,1501,1219,996,907,795,1713,796,1669,92,1668,891,1259,1120;32;M
102670;891,680,907,796,1449,996,1501,1186,582,987,146,930,1205,790,1120;39;M
102722;1440,1209,207,255,907,1219,146,930,1259,675,1039,104,950,1443,742;38;F
102731;680,907,1562,516,1501,987,891,930,1259,675,40,1197,1039,976,215;43;F
102742;1449,1501,796,1669,1713,92,607,155,1668,680,749,950,1120,40,215;34;F
102745;1212,146,749,1472,40,1039,215,796,92,769,795,1449,1668,680,950;39;F
102760;796,1209,769,255,680,987,1212,950,1120;29;M
102761;1259,1668,1212;47;F
102768;996;33;M
102777;92,1039,1443,950,1268,1713,796,1120,742;50;M
102791;1164;26;F
102796;796,1713,207,795,1449,680,146,1120,1039,1668,891,1212,749;32;F
102803;92,907,516,680,987,1450,891,930,1472,1120,976,215,1259,1212,996;35;M
102808;207,255,1668,891,104;50;F
102825;1501,996,1449,1209,1669,92,207,255,907,1668,1186,749,1120,104;30;F
102833;976,1205,146,987,1443,1143,607,796,769,795,996,582,1212,1197,215;30;F
102838;255,976,996,675,907,1501;39;M
102839;215,255,456,1143,1449,1219,1134,1186,582,987,891,1164,930,675;28;F
102845;1212,146,749,950,1205,1120,675,1440,1039,1197,1443,104,891,796,790;47;F
102881;1668,987,749,1259,675,1120,40,1197,976;20;F
102884;465,1209,796,725,117,1670,92,1440,748,795,255,1668,1120,1197,1039;33;F
102892;1669,1440,1668,1186,680,675,40,465,92,771,607,1219,749,1197,104;32;F
102893;1639,769,1268,1670,1436,117,1562,1713,1440,907,516;30;F
102924;255,92,207,1120,742,987,1713,796,976,1668,950,907,1443,675,1039;40;M
102926;1669,1713,1268,92,795,1501,1668,680,987,749,930,1120,40,976,215;28;M
102964;1209,1324,1268,1440,1235,1443,1449,155,996,1501,987,891,749,1120,675;40;F
102969;1324,1669,465,1562,1120,1450,1449,1440,1219,1209,1197,941,771,675,255;35;F
102970;1259,1472,790,104,749,1212,1186,1436,92,465,1669,1235,1219,1668,1233;34;M
103012;742,1449,907,1229,1440,92,1713,796,725,1443,996,1219,1212,1233,1259;35;F
103014;1134,680,941,987,1450,891,1212,146,950,675,790,1120,976,104,215;38;F
103042;1212,1233,941,582,1501,1668,996,1443,1449,907,1229,769,92,1669,104;7;F
103048;1450,941,582,742,1449,1229,748,207,145,1324,255,907,1219,146,1039;45;F
103068;976,1197,1120,675,1259,941,582,1219,516,1143,907,795,207,1268,1670;55;F
103092;1219,1668,1233,1259,725,1039,941;37;F
103098;1669,207,255,1443,1219,742,941,1450,146,1259,1205,675,1120,40,1039;7;M
103111;907,680,941,1450,146,749,930,675,1120,215,976,796,465,996,987;19;M
103114;987,1450,1120,976,215,1669,92,930;32;M
103128;465,1669,1440,207,255,1639,456,907,996,582,891,146,1259;38;F
103138;1120,976,1472,749,1212,891,941,680,1235,796,40,996,907,1440,771;3;M
103145;796,795,907,941,891,749,92,1440,996,1668,680,1450,1212,1259,1120;50;M
103148;796,680,976,1120,675,987,582,1668,996,1443,907,92,1440,1501,1197;40;F
103155;1233,930,1120,215;38;F
103166;725,1669,92,1668,891,1212,749,1259,1120;31;F
103180;456,907,1443,1668,582,941,987,891,930,1259,675,1120,976,796,516;32;M
103187;795,996;44;M
103192;1669,1670,1713,1449,1668,987,1212,725,1209,207,255,516,930,675,1120;14;F
103206;1219,996,796,725,1669,92,748,1229,1233,1450,941,582,742,1501,104;10;M
103207;92,1669,795,1219,1501,1668,582,1450,891,1212,930,1259,1120,1197,1039;26;F
103209;1120,796,92,748,795,1235,1449,1668,680,891,1212,749,40,1197,976;33;M
103213;907,1668,582,675,1039,1209,1440,145,207,456,167,680,987,146,950;43;F
103219;1449,1219,1668,1186,1450,1212;53;F
103254;1450,146,1233,930,1259,1120,92,1268,1440,771,145,795,907,1501,1197;26;M
103260;1639,1219,987,1212,146,796,907,996,941,1450,891,749,1259,976,1120;28;M
103272;1449,795,92,1669,796,1209,771,1501,1186,1450,1212,675,1120,40,215;34;F
103278;796,465,1268,1143,1235,1449,1186,987,891,1164,749,675,790,976,215;73;F
103294;1120,891,1668,907,748,1449,155,215;39;F
103311;1669,1436,1713,117,92,1440,907,516,1443,1668,987,1212,749,930,1259;22;M
103324;748,795,607,255,907,1449,1668,1186,582,891,1164,146,930,1205,1120;33;F
103329;146,145,1440,465,891,1197,987,582,1039,92,1219,1443,725,1668,1259;44;M
103361;725,607,1449,582,941,1450,891,1233,749,930,1259,1120,104,215;29;F
103371;749,675,1120,1440,907,680,891;31;M
103373;1212,749,1259,1120,796,907,996,941,1450,891;25;F
103377;1713,907,1501,1668,941,891,1259,1120,976,215;28;M
103382;796,1713,769,748,1449,167,1219,891,1472,1120,215;65;F
103393;1436,117,1669,1639,907,996,1668,582,1450,891,930,1259,1120,976,104;33;F
103397;92,725,796,1501,1450,1233,749,1670,907,155,996,941,1259,1120;38;F
103403;92,1443,950,1268,1713,796,742,1120;46;F
103404;987,1212,996,1235,1443,749,930,1205,40,1450,1233,1259,215,1440,907;45;M
103410;1120,976,1472,749,1212,891,941,680,1235,796,40,996,907,1440,771;34;F
103414;1440,92,1235,996,1219,1501,1450,891,749,1259,1120;31;F
103417;1562,117,1268,1449,1639,1324,1186,976,1120,749,1450,465,1472,1440,680;24;F
103454;1713,790,1120,40;39;M
103462;92,795,255,907,1449,996,1501,1668,582,891,146,930,950,1120,1039;31;F
103485;795,907,996,941,987,1450,749,1259,1120;57;F
103513;92,907,996,976,215;52;F
103517;117,771,456,1443,996,1668,146,1259,215,976,907,1501,987,1120;41;M
103522;930,796,92,145,795,456,1443,1668,582,146,1259,950,1120,40,1197;31;M
103530;796,1209,1669,771,1443,155,1186,92,1449,996,1668,987,891,104,1205;31;F
103537;1450,1259,1120,1209,748,907,1443,742,987,146,930,950,675,1039,976;42;F
103545;1669,1668,996;33;F
103562;1501,1450,749,790,1120,104,255,907,516,1668,987,891,1212,675,1197;24;F
103566;996,1134,1205,40,104,796,465,92,1449,1668,680,891,749,790,1120;38;M
103570;207,748,1229,1472;32;F
103592;796,1562,1209,117,1713,207,907,167,996,1668,950,675,1120,1197,1039;38;M
103594;749,1668,680,1259,1472,1268,1449,1450,1120,1212;49;F
103595;742,1120,796,1713,1268,950,1443,1039,92;9;F
103606;215,1440,1639,907,155,996,1450,1120,1197,976,207,516,680,987,675;34;M
103630;1212;47;F
103648;1450,1039;7;F
103649;1670,465,725,1219,1501,1668,680,987,891,1212,1259,675,40,1197,976;37;F
103676;907,680,941,1259,1449,1501,987,891,1450,1472,790,1120,40,976,215;30;M
103684;796,92,145,207,456,1450,907,996,1501,987,146,930,675,976,215;32;F
103688;771,255,582,950,40,104,167,1713,795,907,1668,891,749,790,1120;40;F
103690;1669,1562,1440,950,1443,742,680;48;M
103693;1449,680,987,950,1039,796,1713,92,795,167,891,749,790,1120,215;42;M
103712;680,950,675,1039;32;M
103747;104;22;F
103748;92,790,941,680,987,1639,996,1450,891,215,1436,1440,1259,1120,976;61;F
103755;1501,1449,907,1639,207,1268,725,1669,92,1440,145,795,516,996,976;31;F
103763;92,255,907,996,1668,582,680,1212,749,1259,675,1120,40,1197,976;43;F
103768;907,1668,891,1120;37;F
103777;987;58;M
103798;1450,1039;9;M
103808;1669,1436,92,1440,1639,907,996,1668,582,1450,749,1259,1120,40,104;36;F
103817;1440,1639,987,1259,1120,215;49;F
103823;155,1186,215,749,796,725,1562,1669,769,1143,1668,998,680,987,40;36;M
103825;1209,725,1440,1639,516,1449,680,1450,930,1205,675,40,1197,1039,976;40;M
103850;1501,1205,104,1197,1120,790,146,1668,1449,255,145,92,1669,465,725;31;F
103853;891,1209,675,92,996,1668,1450,1259,1120,1197,1440,907,680,976;30;F
103861;607,1443,996,1501,1668,941,1450,891,1212,1233,749,1259,1120,40,1197;24;M
103882;1039,749,1212,92,1713,907,1449,976,1209,582,680,987,675,1120,215;28;F
103889;796,941,891,1120,1039;13;M
103896;582;47;F
103899;155,907,92,255,1209,796,1669,1436,1668,680,941,891,675,1259,1120;33;F
103934;987,1259,1443,1713,796,92,795,907,1449,996,891,1212,749,1120,1197;44;F
103943;1669,607,155,1668,1120,104;27;F
103957;1669,1713,790,1268,1562,725,680,607,215,769,167,465,117,516,40;35;M
103961;987,1212,1233,215,1120,1259,749,891,1450,1668,996,1449,907,92,1669;75;F
104003;796,1669,1713,680,987,891,749,790,1120,215;28;F
104004;207,996,1219,742,891,146,749,930,1259,1205,675,1120,1039;38;F
104014;1209,1713,769,1668,930,950,675,1120;24;F
104019;1209,1449,742,582,930,1039,1219;35;M
104051;1436,1440,748,907,1443,1501,891,790,40;25;F
104075;1259,1120,1197,1450,891,987,1668,92,796,1436,1268,1440,907,996,1212;31;M
104091;117,465,796,795,1639,907,941,1450,891,1120,1259,215,1268,680,976;42;F
104094;117,1436,795,1501,998,1450,891,749,1259,790,1120,40,1039,976,215;27;M
104112;795,456,907,1668,987,1120,1197,976,215;30;M
104133;996,907,215;60;M
104137;1449,155,996,1134,1668,582,1212,749,930,1205,1120,1197,1039,104,215;42;F
104142;1449,1501,1668,1186,891,1233,582,996,907,465,1450,1212,749,1259,1120;29;F
104155;795,950;42;F
104173;1235,1449,582;7;F
104180;1209,725,1219,1668,1197,795,749,1670,155;54;M
104182;255,1219,1449,1443,1562,1324,1229,907,941,891,1259,950,1120,976,215;55;F
104221;145,1440,465,1209,796,1562,117,1670,1268,769,207,795,255,998,680;56;F
104222;907,996,1219,1501,1668,1450,891,1212,146,1233,749,1259,1120,976,215;29;F
104262;207,748,1449,950,1443,742;44;F
104266;891,987,1233;25;F
104280;941,891,146,749,1120,796,795,907,1668,1501,680,1450,1259,976,215;36;F
104301;1639,907,996,1501,941,987,1450,891,1212,1259,1472,790,1120,1039,976;37;M
104323;1668,155,1449,1440,1436,1669,465,1324,607,582,680,1472,790,40,1039;6;F
104324;987,1450,40,1259,92,1120,1268,680,950,1039,1668,1197,675,465,976;35;F
104330;1440,907,1219,680,891,749,1120,976;41;F
104343;92,607,255,907,155,996,1668,1186,987,1450,891,146,1259,950,1120;35;F
104350;996,1501,1668,582,941,987,1450,1212,749,1259,675,790,1120,40,976;28;F
104373;1120;37;M
104382;1436,215,907;81;F
104384;1120,976,215,675,1668,207,725,1669,1501,941,891,1212,1259,1197,1039;35;F
104396;771,1197,456;27;F
104398;1120,104,1039,1197,40,950,1669,92,1668;49;F
104407;1713,1670,796,725,465,1669,907,1449,1668,998,582,749,1259,1120,40;29;F
104411;40,1120,1472,950,749,891,1668,1501,516,907,1639,1440,117,1669,1562;29;F
104419;1472;41;M
104451;996,465,92,1668,941,891,1212,1233,1197,215;66;F
104457;1235,1449,582;37;M
104467;1440,92,1713,117,796,215,1450,941,996,725,1669,1219,1120,1197,1233;34;F
104473;749,1450,941,1268,796,1669,92,907,996,1501,1668,1212,1259,215,1120;46;F
104474;516,742,1259,790,1120,1669,92,1449,996,1668,930,40,1197,976;29;F
104477;1449,996,1501,998,680,987,891,1212,749,1259,790,1120,40,1039,215;39;F
104484;996;39;M
104492;1259,1472,749,1212,790,796,1268,907,996,891,1233,1120,207,92,465;28;M
104506;207;44;M
104516;155,996,742,582,987,950,40,104,1562,907,146,930,1120,1039,215;33;F
104531;796,1562,1436,92,1268,795,456,907,996,1668,1186,1450,749,930,215;42;F
104551;796,1669,1713,92,907,1449,996,1668,1501,1450,891,1212,749,1259,1120;36;F
104553;207,255,516,1443,1501,987,1450,146,930,1259,675,1120,1197,1039,976;39;F
104589;1639,907,996,1450,749,1197,1669,92,1268,1668,891,1259,1120,976,215;49;F
104612;796,1669,117,748,1229,907,1143,155,996,1668,146,749,1205,1120,1039;43;F
104618;996,907,748,1120,1449;32;F
104656;1120,92,465,1440,748,796,516,155,998,680,795,1668,1212,749,1197;32;F
104657;146,976,725,607,941,1039;48;F
104658;1324;39;F
104684;92,1436,1670,1669,1209,795,255,996,941,1450,891,1164,1212,1259,1120;33;F
104688;1324;50;M
104691;796,1669,117,92,907,167,1668,1713;31;F
104693;749,790,1120,215,796,1669,1440,748,907,1668,680;56;M
104696;1219,92,207,796,907,1443,1449,996,1501,941,1450,891,749,1259,1120;23;F
104716;795,1450,1669,1219,1668,941,1259,675,1120;49;M
104717;796,1186,950,1472,1197,1669,117,1443,155,1219,941,1205,675,1233,795;55;F
104743;465,117,1713,1436,92,1440,748,795,1235,1443,680,1450,891,1212,749;30;M
104756;796,1324,1268,1449,680,1259,1120;48;M
104767;207,255,675,1039;39;M
104819;1669,92,795,607,1449,155,996,1668,891,749,950,790,1120,40,104;31;F
104824;796,1209,1440,207,1143,1186,1164,1259,675,607,155,950;48;M
104857;92,607,255,907,155,996,1668,1186,987,1450,891,146,1259,950,1120;63;F
104874;725,1668,1164,1209,1440,207,748,1229,1143,1449,1186,146,1233,930,675;16;F
104901;1143,725,1209,1440,207,748,1449,1186,987,1233,1205,675,1164,146,1229;42;F
104921;1670,1209,1440,795,607,255,1229,155,996,1186,987,1450,146,930,1259;21;M
104939;795,907,1443,1449,1501,987,891,146,749,1120,1669,1713,92,1268,1668;51;F
104951;907,891,1212,796,92,1440,1449,1668,680,1233,749,1259,950,675,1120;35;M
104954;1039,1450,155,1670,516;30;F
104989;1268,155,1219,1668,1120,976,215,1440,795,680,987,950,675,40,1197;31;F
104998;1472,1259,891,1450,996,1449,907,1436,117,1440,748,516,1233;76;M
105001;748,1449,950,1443,742;10;F
105009;907,1229,255,607,1713,796,207,145,795,1039;29;F
105015;1713,1436,92,795,907,996,1501,1668,582,1450,891,749,1259,1120,976;36;F
105024;582,680,1450,891,1669,92,996,1668,1212,749,1259,675,790,1120,40;33;M
105025;996,987,1205,749,1219,1501,1668,941,1450,891,1212,1233,1259,1120,796;28;F
105026;796,1209,1713,92,1440,456,987,1212,1120,1197;34;M
105027;145,1440,92,1670,907,1501,582,1713,516,1219,1259,976,1120,987,1668;23;M
105044;1668,941,987,950;42;F
105047;155,996,1219,1134,1501,1668,998,941,987,1450,1212,1259,1120,1197,104;38;F
105048;796,92,907,516,996,891,1212,146,1259,1120,976,1501;46;M
105053;1120,1197,976,771,1268,1436,1324,465,1134,1219;69;F
105057;516,1449,996,1219,1501,680,1450,749,1120,40,1197,976,907,1440,941;55;F
105069;92,1324,465,796,1669,1219,1668,1450,891,146,749,1197,104,1259,1120;36;F
105080;1440,795,92,117,1669,1562,796,1324,1443,680,749,790,1120,1039;41;M
105081;1436,92,1440,1639,996,680,941,987,1450,891,1259,790,1120,976,215;26;M
105082;796,1562,92,145,207,607,1668,1212,146,749,1120,1197;49;F
105083;907,996;30;F
105101;1472;41;F
105114;1669,92,907,1449,996,1219,1501,1186,680,1450,987,930,1259,1120,104;72;F
105121;516,796,1562,1669,907,1443,1668,1450,891,1212,749,1259,40,1120,790;33;M
105122;796,1209,117,92,987,1120,749;36;M
105140;1235,976,104,748,145,155,749,92,795,456,1449,1668;31;F
105150;680,1668,582,675,1229,987,950,1039;39;F
105215;1668,941;33;F
105216;582,1443,1229,255,607,207,771,1219,1259,1039;33;F
105227;987,582,996,1449,907,748,796,795,1186,680,749,1120,40,976,104;34;F
105229;796,1668,680,987,40,976;30;M
105236;1639,748,465,1669,1324,1436,1440,607,907,1449,742,582,680,790,40;10;M
105238;465,92,680,146,749,790,1120;33;F
105239;680,941,987,1450,891,749,215,976,1039,40,1120,950;44;F
105247;1449,1229,456,607,1713,207,255,155,582,987,146,930,950,675,1039;34;F
105255;1449,796,207,748,950,1443,742;16;F
105258;516,1670,907,941,987,1450,1212,40,976,1120;2;F
105260;1440,607,1501,1668,987,1197,976,215;36;M
105263;941,1450,675,1235,795,207,1268,796,725,1219,891,1259,1120,976,215;41;M
105267;92,1669,1268,1440,207,255,907,516,1501,680,146,930,1120,1039,976;47;F
105269;1219,582,680,987,930,950,675,1120,40,104,255,1449;36;F
105271;1713,167;45;M
105283;92,1268,1440,907,1449,996,1501,1668,891,1212,749,1259,675,1120,215;32;F
105302;465,1209,725,255,680,987,1472;31;F
105305;465,796,1669,92,1440,748,907,1449,996,1668,582,891,1120,749,215;34;M
105321;1501,92,1669,725,1668,930,749;28;M
105322;907,1501,582,941,891,1212,976,1670,1440,996,1668,1450,1259,675,1120;32;F
105329;996,891,1164,1212,941,1668,1219,516,907,1436,1450,749,1259,1120,215;51;M
105335;1668,104,796,1562,1713,795,607,456,1443,1134,582,146,749,215,790;39;F
105340;1670,771,907,1668,891,1669,215,516,1501,941,987,1450,1259,1120,976;48;M
105361;796,1669,92,1449,996,1501,1668,582,680,1450,891,1212,749,1259,1197;28;F
105373;725,1209,795,1443,1668,987,146,950,1120,40,1039;41;F
105399;1713,1668,1501,1450,1449,1259,1212,1120,987,941,907,891,796,680,749;26;M
105439;742,987,1450,891,146,1233,749,930,950,1205,675,1197,1039,976,104;67;F
105449;1562,465,1324,1713,1268,748,1443,1449,155,996,742,680,1120,950,930;42;F
105457;796,1436,207,748,976,92,1668,742,891,950,790;39;F
105467;215,742,1443,1235,907,748,456;35;F
105474;117,907,1443,996,582,680,987,675,1120,1197,104,215,1268;32;F
105491;996,456,92,796,1209,465,1669,207,748,607,255,907,1668,680,1120;40;F
105493;675,1120,1039,104,680,1233,1212,1268,255,1440,1259,1235,749,92,941;27;M
105498;1449,996,1501,680,941,1450,891,1212,749,930,1259,675,790,1120,976;31;M
105512;1440,145,795,255,907,1212,749,1259,1205,1472,1039,92,996,582,1120;34;F
105518;796,92,1443,1449,1501,1668,582,891,1233,1259,1120;28;F
105523;92,255,907,1449,996,1668,891,790,1120;30;F
105524;516;5;M
105527;1450,1259,1120,725,465,92,795,907,1219,1668,941,891,1212,1233,749;34;F
105556;796,465,795,907,996,1501,1668,891,1212,749,1120;37;F
105564;1259,675,215,1669,92,907,996,1501,1668,742,987,891,146,1120,976;40;F
105573;976,465,92,607,1443,155,950,996,749,1120,215,796,1449,891,790;48;M
105580;92,145,1186,582,1669,748,907,1449,996,1668,680,987,891,749,1120;43;M
105586;207,607,907,1143,1449,155,996,1186,891,146,950,675,1205,790,104;31;F
105591;1212,582,1449,1440,1268,891,1450,1668,907,1436,725,941,1233,1120;40;F
105600;742,516,987,976,40,907,996,1212,1668,941,1450,891,1259,1120,1039;38;F
105601;1713,1449,796,92,1268,1440,748,907,996,891,749,790,1120,40,215;35;F
105610;1669,92,795,255,1639,907,1259,1219,1668,930,146,1120,1039;71;M
105626;796,1669,607,1501,987,1212,1233,749,950,675,1120,40,1197,996,1668;26;F
105660;1259,796,1209,465,1268,1440,769,907,516,1449,1501,891,675,790,725;37;F
105663;795,796,1324,1229,1443,742,1039;39;F
105665;1186,680,1450,1212,146,1197,976,796,1440,516,582,987,1259,675,1120;31;F
105671;92,607,255,907,155,996,1668,1186,987,1450,891,146,1259,950,1120;65;M
105677;680,1443,996,1501,1450,891,1259,1472,790,1120,465,748,1212,749,40;45;F
105692;742,1443;71;M
105694;1120,725,796,1209,771,255,1449,1501,1668,891,749,950,1197,1039,790;30;M
105705;92,1669,748,795,1443,996,1668,680,891,1212,749,1120,40,1197,976;32;F
105715;796,1324,1436,516,1668,146,1233,1120,255,1472,891,749,907,1449,790;36;F
105734;1209,1440,207,255,1229,987,146,930,675,1039,1324;42;F
105735;215,1670,891,40,155,516,769,1436,1324,465,1562,1039;56;F
105755;796,465,1324,769,1229,1235,1668,742,680,1233,1259,790,976,215;43;F
105771;1669,92,795,907,155,1668,1212,146,950,1120,1197;50;F
105791;607,748,207,1713,1209,796,907,516,996,582,749,950,675,1120,976;29;F
105795;891,1713,1669,796,92,1440,907,1449,996,1668,582,680,1212,749,1120;32;F
105809;1440,1501,680,987,146,930,675,1120,1197,976;30;M
105810;1639,907,1120,40,976,215;40;M
105811;1713,987,1268,1440,796,996,941,1450,749,1120,1219,680,891,1259,907;41;M
105816;1443,1668,987,1039,1197,215,796,1562,1713,795,907,167,1212,950,1120;52;F
105817;796,1449,582,790,1120,976,215;40;F
105822;1209,1324,1268,1440,255,1450,1443,987,146,950,907,1120,1197,1039,104;31;M
105861;1443,1039,941;40;F
105869;1440,748,1443,987,1259,1120,40,976,1039,1639,1229,907,680,1450,1324;7;M
105873;725,1209,1440,207,748,1229,1143,1449,1186,1164,146,1233,1205,675,1039;5;M
105876;680,1039,40,1205,930,146,996,456,907,1229,742,1235,1443;40;M
105893;987,1450,1259,215,796,1209,1268,255,1639,907,1219,1501,1120,976;45;M
105896;1669,1209,796,996,987,1713,92,769,795,907,1219,40;27;F
105899;215,582,1219,92,1713,1209,1562,255,1639,987,1450;25;F
105909;1209,207,748,1449,1501,1186,998,1450,907,1219,1259,1472,1120,215,976;31;M
105915;215,1120,996,680,92,207,748,795,891,749,790;40;M
105916;465,1268,255,907,516,941,1450,1212,976,215,796,680,891,1259,1120;51;F
105931;92,796,725,1669,996,1501,1668;28;F
105936;582,680,749,930,40,1197,215,207,255,1219,987,675,104,976,1039;67;F
105951;92,1668,891,749,1233,1259,1120;32;M
105952;1259,749,465,1268,1219,907,725,1670,92,795,516,146,1120,1039,104;71;F
105955;1669,92,907,1501,1668,680,1450,1259,1197;28;F
105963;1669,795,1235,1449,1668,40,92,748,680,891,790;44;M
105964;796,1268,976,907,92,941,725,1472;26;M
105966;1443,155,996,1501,1668,998,680,941,1450,891,1212,749,1259,1120,976;30;M
105974;987,1134,996,516,1443,907,1209,1324,1436,207,795,1639,1039,976,215;40;M
105978;907,207,1436,891,1259,749,748,465,725,104,1268,1219,92,255,941;46;F
105983;907,1209,1324,207,1639,146,675,215;7;M
105994;1143,987,1450,891,1259,1120,1669,92,795,255,1219,1668,941,146,215;37;F
105999;582;40;M
106004;1324,465,796,207,607,255,456,1443,155,582,680,146,749,104,1197;45;F
106014;146,675,1197,1669,1440,207,92,255,1668,987,1120,40,976,215,907;33;F
106023;582;38;F
106028;742;45;M
106030;255,1212,1233,930,1449,987,796,725,1440,907,1443,941,1450,1120,1039;41;M
106037;582;8;M
106040;987,1197,40,1259,749,92,1669,796,1562,769,795,1668,1120,976,215;42;M
106061;680,1450,891,930,675,1197,104,215,1186,1501,1219,1436,607,255,1449;27;F
106076;907,582,996,1219,1668,1472,1209,207,255,456,987,675,790,1120,104;26;F
106088;1669,907,1219,1197;31;F
106089;1670,155,680,1212,146,950,675,516,796,1501,987,976,215;62;F
106093;1233,1324,92,1440,255,456,1670,1450,675,1197,215,145,1229,891,146;36;M
106114;1639,907,215,1268,771,795,1219,941,1450,891,1212,1259,675,1472,1120;41;M
106126;92,1668,1186,582,891,1212,749;49;F
106159;1669,725,1209,1440,207,748,1229,1143,1449,1186,1164,1233,146,1205,675;12;M
106179;725,907,1668,941,1450,146,1233,930,1259,675,1120,1197,1039,976,215;63;F
106180;456,680,941,215,104,976,1639,795,1440,145,1120,1259,987,1209,771;58;F
106190;748,1164,790,996,1143,1235,1449;58;F
106192;680,1440,207,748,1212,1472,1229;50;M
106222;465,1501,582,1450,891,1259,1120,40,215,748,907,1668,987,749,976;29;F
106236;725,1259,1443,1219,941;53;F
106241;40,790,1205,950,749,146,941,582,255,607,795,207,1669,1562,796;3;M
106246;1562,796,1713,92,1268,795,1668,582,987,1212,749,930,675,976,215;26;F
106257;1212;38;M
106286;607,456,907,996,1450,950,1120,1197,976,1669,92,155,1219,1668,675;54;F
106299;725,92,1268,607,907,996,1668,1450,749,1259,675,1120,40,1197,1039;37;M
106307;1668,1197,92,1639,1229,1443,742,1450,40,1039,976,1268,1440,680,1324;5;F
106323;1268,769,795,1229,1219,891,749,976,907,146,675,1120,215,456,987;34;F
106332;1120,1233,749,796,907,950,1212,891,996,582,607,790,1197,1235,1449;23;M
106339;1440,92,465,1209,1143,1449,1134,1501,1668,1186,891,146,930,790,1120;30;F
106360;465,1449,996,1219,742,1450,891,1212,1233,749,1259,1120,40,1197,976;37;F
106374;465,1562,117,1713,1436,1440,987,1233,1039,976;20;M
106390;941,1209,207,795,516,891,930,1259,675;38;F
106407;795,680,1436,1450,1259,1039,941,1501;42;M
106420;1669,92,1440,1449,996,1501,680,930,40,215;39;F
106422;675,1449,1268,1669,725,1440,145,207,748,1229,1143,1186,1164,146,1233;62;F
106432;1120,941,607,1143,907,215,996,1450,146,1233,1039,725,950,1259,1197;51;F
106437;1436,92,795,516,1219,1501,941,1450,1259;41;M
106439;987,1197,976,516,996,582,146,790;37;F
106489;941,891,1120,215;31;M
106507;796,92,748,255,1235,1449,1219,1668,1186,680,987,749,930,675,104;26;F
106513;1501,1209,1450,1120,255,456,1449,146,207,930,1039,215,742,1443,950;15;M
106533;1324,1268,155,1668,1212,607,255,1229,582,930,950,675,1039,907,1443;42;F
106568;607,996,950,790;39;M
106594;1212,1669,92,1268,907,1443,998,891,796,1562,769,950,1120,40,1039;34;F
106599;796,996,582,1450,1212,749,930,675,1120,215,117,92,680,1259,976;34;M
106611;725,92,1440,155,1219,998,582,680,987,930,675,1120,1197,976,215;36;F
106613;796,465,1669,748,907,1449,1219,146,1212,1259,1205,675,1120,215;48;F
106624;795,456,907,155,996,1501,582,891,749,1259,950,790,1120,40,215;61;M
106627;796,92,1268,769,795,255,1668,680,987,1212,950,1120,40,976,1197;41;F
106639;1229;26;M
106654;1212,1450,207,465,907,996,1324,891,1259,1120,1039,215;46;F
106655;675,1120,796;46;M
106657;40,987,680,582,1440,796,1209,1669,1713,1449,167,1668,675,1120;62;F
106658;725,92,607,907,1449,1134,1501,998,582,680,1259,675;29;F
106663;1443,742;70;F
106669;1268,255,1235,1449,1668,582,680,941,891,749,1259,790,1120,40,976;30;F
106672;465,1668,930,790,1120;76;M
106674;465,1669,92,1668,680,749,40,104;49;F
106710;675,1449,1669,1209,725,1440,145,207,748,1229,1143,1186,1164,146,1233;82;F
106711;1450,891,1440,748,1639,1229,1668,680,1259,1120,40,1197,1039,976,1324;11;F
106717;796,996,1668,1233,1259,790,465,1669,748,907,1449,1501,749,930,1120;38;F
106723;996,1219,680,1450,1259,675,1197,1120;42;F
106736;1562,1669,92,1440,907,1501,1668,680,987,891,675,1120,1197,976,215;23;M
106754;1449,996,891,749,930,1472,790,1120,104;36;F
106762;207,907,1449,996,1501,941,1450,891,749,1259,675,1120,40,1197,104;11;F
106773;207,1668,582,680,941,891,1212,146,930,1259,1205,675,1120,1197,1039;20;F
106785;456,155,92,1209,1670,1440,516,1501,1668,680,891,146,1259,675,1120;33;F
106787;1669,1440,742,976,92,155,1501,987,675,1197;37;F
106808;1440,769,145,207,795,907,155,996,680,1450,950,675,1197,1039,976;43;M
106819;117,92,1440,748,1668,996,907,582,941,1450,891,749,1259,1120;27;M
106842;796,1120,1259,749,891,1450,987,996,1449,255,907,675,976,104,215;33;F
106853;725,1443,1219,941;55;M
106866;40,976,1120,790,1472,950,891,680,742,1668,1229,748,1324,465,796;39;F
106884;749,1212,92,1259,1120,796,907,996,582,748,215,1449,1324,680,976;26;M
106887;1039,215,1562,117,1713,1268,1440,769,207,795,607,1219,950,675,1197;65;M
106889;104,987;33;F
106912;950,1443,742;38;F
106918;207,1501,891,749,1259,1472,104;58;F
106926;1233,1472,680,749,1120,996,1235,92,1449;35;F
106974;1562,1440,795,680,891,1259,790,215,1713,465,117,1268,1212,1120,40;37;F
106988;1229;10;F
106990;1713,465,92,1268,795,891,1212,117,1440,607,155,680,950;58;M
106996;796,207,255,456,907,1443,1449,996,582,891,1212,1233,930,950,1120;24;F
107008;796,207,907,680,987,1212,930,675,1120,976,215;29;F
107023;1212,1120,215,1472,1259,891,1450,996,1449,907,1639,207,465,1562,1324;12;F
107026;725,996,1219,1668,742,582,146,930,1120,1039;33;F
107035;215,145,456,907,1219,1501,1668,582,987,1259,950,1120,976,1197;11;F
107060;796,155,891,117,1713,1440,795,167,680,987,1120;39;M
107063;1229;47;F
107067;465,1440,907,1501,680,40,104;46;M
107073;1670,1639,907,1668,987,1233,930,1120,790,675;33;F
107078;1449;36;M
107104;1713,92,795,907,1443,996,1668,998,582,987,1212,950,1120,40,1039;4;F
107121;1669,92,996,1501,1668,680,987,891,1212,749,1259,675,1120,1039,976;33;F
107172;1186,582,891,1212,675,1197,215,725,207,907,1449,1501,987,1120,104;33;F
107188;1209,796,996,795,907,155,1450,1212,1120,1668,680,998,1501,950,1039;32;M
107198;1443,1501,1164,1212,1233,1259,950,1205,1472,1120,1197,1186,1450,1039,1229;34;F
107200;207,1639,516,155,167,987,146,950,1472,1197;30;F
107205;907,1443,996,1501,941,215,117,1670,516,987,1450,1259,1120,40,976;31;F
107209;1120,796,1209,1713,795,1639,1235,167,40,1668,680,998,1501,950,1039;33;F
107211;1449,796,1669,92,907,1235,996,1668,680,891,1233,1259,749,1472,1120;65;M
107218;930,1259,1120,40,976,215,1450,941,1668,996,907,1440,1268,1670,675;37;F
107231;1134,1219,996,155,1449,907,456,255,748,465,207,1235,749,675,1120;43;M
107235;891,1668,516,1670,1669,146,930;40;F
107246;680,1450,1212,675,1120,1197,215,1669,92,1501,1668,998,987,1259,976;25;F
107260;1450,987,891,1039,742,1229,1639,748,145,769,771,1436,117,1324,215;4;M
107285;465,748,680,749,790,40;64;M
107291;1120,796,465,1669,92,795,155,1668,749,1259,40,976;36;M
107295;725,996,1219,1668,987,1450,1259,1120,976;35;F
107313;1472,680,1669,1209,1562,796,117,748,465,1449,1235,749,582,996,607;35;M
107317;255,907,40,92,1440,145,207,1501,680,987,146,1259,675,1120,976;40;F
107339;987,1450,891,930,1259,675,1120,1039;43;M
107345;1209,255,582,987,1259,675;31;F
107360;1670;33;M
107368;1268,465;30;M
107374;1197,104,215,1219,795,207,1440,1713,1670,1562,92,1668,680,930,675;69;F
107389;1501,582,891,1164,1212,749,1259,1120,40,104,790,1669,92,1668,1472;29;F
107396;987;46;M
107443;941,749,92,795,1639,907,516,996,1501,680,1450,891,1259,675,1120;58;F
107444;941,930,1259,1120,1039,92,907,996,1668,891;32;M
107470;1562,1669,1713,92,795,155,996,1668,146,675;26;F
107477;1713,795,749,215,796,1669,1268,769,1668,1562,1120,40;69;F
107484;1670,207;37;F
107485;1501,1443,1449,1450,941,1639,1268,1436,795,516,987,1120,40,976,215;35;M
107488;1450,1259,790,117,92,748,1668,1120,40,907,465,891,1212,749,930;36;M
107500;465,1713,907,1449,996,1501,582,680,987,1450,891,1212,1197,215,1120;45;F
107501;1039,907,207,145,1669,465,516,146;42;F
107511;1259,1120,215,1669,1562,976,40,749,680,1668,155,92,465,796,950;34;F
107537;996,891,1450,680,742,1668,1501,907,456,1229,255,950,1120,1039,976;6;F
107550;1259,255,92,1450,1039;39;M
107552;40,976,796,1268,795,1639,1219,941,117,1670,680,215,516;63;M
107559;1205,146,155,1669,582,1449,207,145,1209;35;M
107560;675,1219,1268,795,891,941,976,1436,1440,680,1259,1120;36;M
107565;675,1713,155,996,1668,582,941,891,1450,749,930,1259,207,255,1120;25;F
107581;725,1440,996,987,1259,675,1120,1039;67;M
107588;92,207,907,1443,996,1501,1668,941,1450,146,1259,1120,1197,976,104;73;F
107594;996,1219,941,1450,1259,40,1197,976,215,725,1120,1669,92,1501,1668;35;F
107610;1164,771,1039;35;F
107632;996,1501,1449,907,1209,796,1450,891,749,930,1259,675,1120,40,1197;28;F
107639;92,1440,207,456,907,1443,1449,996,1134,1501,1668,1450,1197,1259,1120;45;F
107657;748,207,769,891,987,1501,607,907,996,1450,1259,1472,1120,215,1324;6;M
107661;1259,1668,1501,996,1449,1443,907,92,1669,796,941,1450,891,749,1120;30;F
107666;1259,1450,1668,1501,907,1669,1562,996,987,1212,749,1120,1197,976,215;39;F
107702;1501,1212,215,796,907,1669,92,795,155,1668,40,1324,742,950,1039;58;M
107713;117,1440,987,675,976,215,1219,1197,104;32;M
107728;930,941;47;F
107730;1259,465,680,907,796,92,1501,1668,1450,749,950,1120,40,976,1197;35;M
107757;891,941,1120,1501,996,907,456,1440,725,1668,92,1669,1197,1450;33;M
107760;769,1562,796,1324,1713,1268,748,516,891,465,92,155,1668,749,950;46;F
107781;976,790,675,987,582,1134,1449,907,255,795,771,92,1713,117,1120;22;F
107788;1186,941,1450,891,976,796,207,1639,456,907,996,987,1259,1120,215;47;F
107797;742,790,1440,1436,941,1450,891,1259,1472,1120,996,907,1670,950,976;31;F
107804;771,92,1669,255,456,1449,1219,1668,1186,582,146,950,790,1197,1039;63;F
107807;255,795,207,1440,92,465,748,1449,996,1668,1186,582,891,749,790;32;F
107814;1669,92,1668;32;F
107823;215;44;F
107827;1268,155,891,1205,1039,796,1324,92,795,1143,1668,680,790,40,215;34;F
107830;92,907,516,996,1501,1668,582,941,1450,891,930,1259,1120,40,976;32;M
107839;907,456,255,145,1440,104,742,607,796,207,748,1449,1186,1120;38;M
107850;1450,1259;55;F
107859;796,771,145,795,456,907,1219,1501,1668,987,1120,950,1268,1197,976;47;F
107879;607,996,941,1450,891,1212,930,749,1259,950,1472,1120,1440,680;45;M
107885;675,1259,749,680,1186,456,748,1668,1501,996,582,796,907,255,607;28;M
107895;1669,92,1268,207,795,1639,907,996,1219,582,1450,1212,1259,675,1120;27;F
107907;996;2;M
107914;1209,92,1268,1440,891,1212,40,907,680,987,1450,1259,1120,976,215;41;M
107919;749,104,215,1209,1562,465,1713,748,795,607,255,155,891,950,790;31;F
107921;117;51;M
107929;891,749,92,795,1639,907,516,996,1501,680,941,1450,1259,675,1120;60;M
107946;255,907,1668,987,891,1259,675,1197,1205,1450,795,748,1219,146,1233;36;F
108000;1440,92,117,1669,796,1562,1713,1268,769,795,680,987,950,1197;48;M
108002;207,255,456,1143,155,996,1668,1186,742,582,1212,950,675,1120,40;44;F
108006;207,1235,996,749,675,1120;25;F
108017;796,1562,1713,769,680,987,1212,146,675,1120,1197,1039;59;F
108027;987,891,40,1039,215,1669,92,748,907,1668,1450,1212,1120,1259,976;38;F
108028;582,92,1440,748,1668,680,749;45;M
108029;117,769,1449,155,1450,1259,1120,976,796,1436,907,996,1501,941,891;35;F
108037;891;72;F
108059;742,941,987,1233,749,950,1205,725,1670,680,1450,1259,1120,1039,976;39;F
108061;117,1436,1440,795,255,1229,907,996,742,1259,1450,987,146,1120,976;35;F
108063;607,941,1039,907,1449,996,987,1450,891,1212,1259,1472,1120,215,1324;69;F
108083;92,1120,1668,1501,1219,1449,907,456,795,1440,1670,1669,796,1197,1039;36;F
108096;950,456;44;F
108103;1209,516,941,987,1713,1440,1259,1120,1197,976;38;F
108104;796,1669,1713,907,1501,1668,1450,1212,749,1259,675,40,976,215;28;M
108136;92,907,941,1450,1120;35;M
108139;748,795,680,987,146,749,675,40,215;71;M
108141;742,996,907,748,207,1324,675,1472,40,790,749,987,1039;9;M
108144;582,987,790,40,215,796,92,795,907,1639,996,1212,749,1259,1120;41;M
108154;207,769,1713,465,1562,92,748,795,1668,680,749,675,215,1120,40;47;F
108158;146,582,1440,92,117,1669,796,1209,207,748,607,255,675,1472,790;34;F
108185;1440,1235,1449,996,1501,582,680,1212,146,950,1713,92,607,1668,1186;26;F
108188;207,795,950,675,1197,1039,976;40;M
108206;769,795,1120,941,796,1562,1268,907,516,680,987,1450,1039,215,40;77;F
108208;725,941;26;F
108210;725,1440,795,1197;38;M
108229;465,1440,748,1449,680,1212,749,1472,1120;43;F
108236;465,1440,207,748,155;42;F
108246;582,1668,907,255,92,1440,145,680,987,146,930,675,1120,976,215;38;F
108256;1669,1436,92,215,607,907,155,996,1668,1450,1259,950,675,1120,1197;35;M
108266;1120,976,215,1562,769,996,167,1501,680,987,1450,907,891,1259,941;31;M
108273;950,40;78;M
108283;1669,748,1668,680,749,40;58;M
108289;725,795,907,996,1668,998,891,749,1120,215;66;F
108294;907,1501,1449,996,1668,680,941,1450,215,796,1268,891,1259,1120,976;32;F
108299;1186,1268,796,465,1143,1235,1449,987,891,1164,749,675,790,976,215;72;M
108302;1212,930,675,1197,1039,907,1229,92,1669,1209,795,1668,891,1259,1120;41;F
108316;907,996,1186,891,1120,790,40,104;32;F
108325;907,891,146,1120,465;48;M
108326;1562,1268,1668,1212,1205,1197,1713,92,795,907,1219,1186,749,976,1120;52;F
108335;92,607,255,941,891,1450,1259,1219,930,675,1472,1120,976,215,1440;25;M
108343;950,796,1324,607,907,167,996,1134,941,1450,891,1229,742,1039,1443;9;M
108352;1186,748,1209,796,582,891,207,1229,1449,742,790,104;41;F
108380;907,1235,1449,996,1501,1668,680,891,1212,146,930,950,1205,675,1120;43;F
108392;976,40,1120,1668,155,516,795,1268,92,1436,117,1669,465,796;30;F
108398;1639,796,607,907,1449,996,987,1450,1212,1259,1472,1120,1039,215,1324;49;M
108415;465,748,795,607,1233,749;42;F
108425;1713,1450,1205,796,607,907,996,1668,1186,891,749,790,1120,1197;46;F
108451;725,1209,1440,207,607,255,215,976,891,1219,1143,1229,987,675;52;M
108456;1120,1259,749,891,1443,796,1713,771,795,907,996,1212,950,675,1197;25;F
108468;92,1639,907,996,941,891,749,1039,1668,680,1450,1212,40,1120,1197;38;F
108490;1669,607,1143,1219,749,930,1205,675,1197,1449,891,146,255,155,582;41;F
108492;582,92,1449;31;F
108497;145,796,1669,92,607,207,456,1449,155,996,1668,891,1120,1197,104;57;F
108506;675,1668,1669,92,1440,680,987,950,40,1039;12;M
108528;582,987,930,675,1713,92,145,207,255,155,167,146,950,1197,1039;5;M
108565;1713,92,1668,675,1120,104,117,465,1209,796,725;38;M
108567;1197,930,891,1501,516,907,1440,92,1669,1668,1450,1259,675,1120,976;49;F
108568;1639,1229,907,1668,742,1450,1233,1259,1120,92,675,1713;31;F
108569;1450,987,680,465,725,1436,92,1268,748,1443,1219,1668,941,1259,1039;38;F
108573;1440,748,1229,907,1449,155,1668,680,796,607,996,891,749,930,790;46;M
108579;725,796,907,742,941,1450,891,1212,465,117,1324,1440,516,155,950;2;F
108588;1639,941,1235,1259,40,1440,1120,1472,996,92,790,1212,465,749,748;34;F
108590;104,215,796,465,117,92,795,607,155,1668,891,749,950,1120,1197;70;F
108610;796,1562,748,996,1668,680,891,146,950,675,40,976,215;29;F
108631;1501,1235,907,255,607,1209,725,796,795,1449,996,582,749,215;44;F
108665;516,680,1450,146,749,930,1268,1449,996,1501,582,891,1259,675,1120;31;F
108676;1259,930,891,987,941,155,1449,907,145,1209,796,207,255,146,675;37;F
108682;465,1713,1440,607,255,155,996,1186,582,680,749,790,1120,40,1197;30;F
108683;907,1449,996,680,1472,92,1668,1186,891,1212,749,790,1120,796,465;30;M
108702;891,1450,1219,996,907,456,255,145,725,941,1212,146,1259,1120,1039;26;F
108704;1562,1440,769,207,680,950,1120,40,1039;30;M
108715;1229,907,1268,207,795,1443,976,104,215,1562,1324,742,987,40,1039;39;F
108722;769,795,907,516,996,1219,680,941,987,1212,749,1259,790,1120,40;67;M
108742;207,1562,1713,1449,582,891,104,950,675,1197,976,215,680,987,40;46;F
108743;215,1501,987,891,1120,976;40;F
108753;796,1209,1669,795,907,582,1212,976;39;F
108768;582,1668,1501,996,1449,1443,516,907,145,92,796,941,1450,1259,1120;32;F
108775;1235,1436,1669,465,796,1440,1668,1450,790,748,1639,1449,749,1259,1120;21;F
108790;1120,40,1212,1450,907,796,465,1436,996,1668,987,891,1259,976,215;33;M
108792;1436,145,907,516,1443,155,996,1450,146,749,1259,675,1120,1197,1039;35;M
108798;1120,675,749,891,680,1219,996,1449,92,796,1713,1669,907,930,1197;46;M
108822;1450;51;M
108826;1197,976,796,207,907,996,1501,742,582,680,146,930,1259,1120,1039;42;F
108828;145,207,795,255,155,167,1668,582,987,146,930,1205,950,1120,1039;5;M
108835;907,996,1501,891,1120,1440,680,950,607,155,117,725,1713,92,1197;23;F
108843;1219,930,215,255,907,1668,742,582,987,1450,146,1259,675,1120,1039;38;F
108853;795,155,1219,742,146,40,1039,215,950,1562,92,1268,1668,987,976;37;M
108886;92,907,1449,996,582,891,749,1259,1120,40,796,465,675,790,1197;37;F
108887;796,675,891,582,1501,996,1449,465,215,1669,92,748,1668,987,1120;43;F
108889;795,92,1562,796,465,1669,1440,1449,680,1212,749,607,950,1120,456;46;F
108892;1669,1440,155,680,987,146,950,675,40,1039;7;M
108902;725,748,907,1235,996,987,749,1120,40,1562,1713,1440,680,976,215;32;M
108905;796,465,255,907,1449,996,742,680,891,146,749,1205,675,790;32;F
108930;1440,255,155,1472,790,104,1670,1219,1450,891,1120,725,465,516,941;50;F
108933;680,1670,1501,987,675,1120,976,215;36;F
108944;1449,607,465;38;F
108950;996,1440,117,1209,92,255,907,1501,987,1259,675,1120,976,215;29;F
108957;987,1501,1219,996,1449,92,1669,796,1436,907,749,1259,1120,40;50;F
108959;796,795,907,976,117,1120,891,1449,1235,790,996,748,465,749,92;19;M
108962;891;12;F
108974;207,255,907,516,1443,996,1219,1668,582,1450,146,1120,40,1039;64;F
108981;976,1120,950,891,941,998,1501,155,516,907,1229,1440,1324,465,796;4;M
109005;680;58;M
109037;1669,92,1668,749;15;M
109051;891,1039,1205,1209,117,145,207,607,255,1449,996,1668,582,146,1120;31;F
109066;40;79;F
109072;891,146,40,1039,796,1562,907,1501,1668,582,987,930,950,976,1120;41;M
109075;92,795,582,1472,1669,771,1143,996,1164,104,1219,1449,1235,1134,790;28;F
109082;582,1668,255,795,207,145,1209,1669,1713,155,167,146,950,1205,1039;5;M
109088;996,117,907,582,1212,146,1120;19;M
109091;907,996,582,1212,1120,104,1669,92,607,1449,1668,1186,891,1205,790;45;M
109094;92,1440,748,1668,582,680,749;9;F
109096;941,1450,1259,675,907,996,1501,1668,742,987,891,146,1120,976,215;3;F
109124;1209,1713,795,1212,749,930,1120,40,215,1669,92,1443,675,117;36;F
109129;40;54;F
109137;1713,167,1039;37;F
109144;1668,92,1669;29;F
109156;1440,145,996,742,1259,215,92,207,456;40;F
109178;1268,1120,1450,1668,1501,725,1669,92,607,155,1259,941,950,1197;47;F
109191;796,465,907,1449,40,1197,749,1120;32;F
109192;155,92,1440,795,1668,680,987,146,950,1039;4;M
109227;465,92,1268,769,748,795,607,255,1186,891,1205,790,1197,104;62;F
109272;465,117,1472,1669,891,1212,1120,215,1233;38;M
109285;1143,748,1440,215,976,1120,675,1259,749,1450,987,941,907,1209,680;40;M
109303;950,1472,40,796,725,117,1713,207,607,907,1449,891,749,930,1120;24;F
109311;1209,1436,1440,207,1639,516,1449,1501,1668,987,675,976;28;F
109317;1449,749;56;F
109324;1120,1259,1212,907,207,1209;40;M
109339;92,1440,207,255,907,1668,998,146,1120,1197,976,987;32;F
109342;1440,748,1233;32;F
109346;1562,1268,1440,748,795,680,891,749,40,1039,976,215;29;M
109348;680,796,117,976,1197,1669,996,1668,1120,795,1440,907,1209,92,1501;33;F
109361;1670,1229,155,1197,92,748,1501,1668,146,749,1120,742,582;40;F
109380;725,155,996,1501,1668,742,582,941,987,1450,891,1212,749,1259,1120;61;F
109385;675,987,207,725,215;30;M
109389;1440,748,255,907,1450,891,1212,1259,1120;29;M
109390;796,92,1440,907,1443,996,1501,1668,582,680,891,1212,749,1259,1120;44;F
109399;1219,1713,769,1449,996,950,1120,215,796,1562,795,680,891,40,976;50;M
109427;1440,748,1212,146,1120,40,215,207,907,891,1472,976,465,749,680;32;F
109451;92,1440,748,1668,582,680,749;13;F
109461;941,1120,976,215,796,1669,117,92,907,1443,680,987,1450,749,1259;43;M
109484;1324,742,1259,950,1120,976;30;M
109499;769,215,680,1268,749,976,907,117,796,1713,795,996,998,987,1120;36;M
109511;1268,907,996,1668,1205,796,582,680,891,749,950,1120,215,1449,987;34;M
109518;950,146,1134,795,1324,1562,1219;69;F
109534;796,117,92,907,996,1668,1450,1259,215,976,1120,1669,987,675;29;M
109545;255,930,1443,950,742,1039;71;F
109558;1562,1713,92,748,607,1449,1668,582,987,891,749,1472,790,1120,40;63;F
109584;907,941,1450,749,1259,976,215,680,891,1212,1233,1120;49;M
109594;1449,1219,582,1450,1501,1212,1120,976,215;43;F
109602;1229,907,516,996,1668,987,1212,146,1259,950,1472,1120,1197,1039,215;39;F
109605;155,1449,907,465,796,117,92,1440,891,749,1259,950,1120,976,104;48;M
109610;456;31;F
109618;996,92,155,1668,680,790,1120,1259,796,1449,891,215,1235,748,749;38;M
109621;1501,607,1324,1669,1440,207,795,907,516,941,146,930,1259,950,1120;37;F
109631;607,795,771,1268,1713,207,907,996,1219,582,1450,146,675,1039,104;34;F
109634;516,1212,790,749,1472,1440,207,748,1229;48;F
109636;796,92,1668,680,987,1450,891,749,1259,1120,976,215,907,1501,996;29;F
109639;465,1501,796,907,1449,996,941,1450,891,749,1259,790,1120,215,976;23;M
109640;796,92,1668,680,987,1450,891,749,1259,1120,976,215,907,996,1501;29;M
109667;907,1449,996,1219,1134,1668,1186,941,891,749,1259,675,790,1120,1197;68;M
109691;795,996,742,891,1197,1120,1436,1268,1639,680,1450,1212,987,215;37;F
109693;996,1120,104;34;M
109696;796,92,1668,680,987,1450,891,749,1259,1120,976,215,907,996,1501;32;F
109703;796,92,1668,680,987,1450,891,749,1259,1120,976,215,907,996,1501;35;M
109719;1039;38;F
109750;582,680,1233;26;M
109762;1120,725;30;M
109773;1229,516,155,996,742,796,1450,891,146,1205,1120,790,1039,976,215;37;F
109784;795,255,1450,930,1259,1120,976;32;F
109789;117,1324,465,1440,1639,907,996,742,891,748,516,1450,930,1259,1120;40;F
109821;1212,155,998,950,582,1472,749,675,1186,1440,1668,680,987,1120,976;46;F
109837;1713,167;43;M
109842;1449,907,92,796,996,1668,891,749;42;M
109844;582,1501,996,907,456,987,92,1668,941,1450,891,749,1259,1120,215;52;M
109882;92,1440,748,1143,516,1443,155,1219,582,680,1450,1259,1120,1197,1039;44;F
109892;1713,748,1229,1449,987,146,930,1259,1205,790,1120,976,725,1670,516;30;F
109950;725,941,675,1197;31;M
109954;796,907,680,1450,1259,1120;27;M
109968;1450,146,1259,1120,1197,1039,976;35;M
109985;796,582,1713,255,907,1143,1449,996,1219,891,1212,749,790,1120,104;68;M
109990;456;33;M
109998;675,907,117,1669,1562,796,976,1197,40,1120,987,680,1639,1440,92;34;M
110001;207,795,1143,155,1668,987,1164,146,930,675,976;51;M
110028;795,1440,1268,92,907,1197,987,976;39;F
110030;1039;41;F
110035;1039,749,1212,891,1450,1443,456,607,92,255,907,1449,996,146,1120;30;F
110043;748,795,907,1449,155,796,1668,40,680,1450,891,749,1259,1120,976;36;M
110062;1039;29;F
110071;998,987,1562,1713,769,795,1668,680,891,675,40,1039,976,104,215;35;F
110076;255,1668,891,146,92,1440,207,1639,907,1450,1259,675,1120,976,215;46;F
110084;1449,996,1668,680,941,987,1450;46;F
110153;465,1440,1039;38;F
110154;215;27;M
110166;987,891,1212,146,1197,796,1268,771,1443,1449,155,790,1120,40,795;33;M
110168;1449;38;F
110190;1562,1268,207,1219,1668,1164,1233,1472,215,255,167,987,146,1205,675;49;M
110237;1209,996,1501,941,987,1450,1259,675,1120,976,215;33;F
110243;1039;12;F
110283;1440,582,749,976,891,742,1668,1501,996,1449,907,748,92,1443,930;34;F
110298;1713,255,155,742,796,117,748,680,891,146,790,40,1039;43;M
110303;1669,92,749,930,976,1209,1713,1668,675,1039;31;M
110305;1259,907,255,516;32;M
110308;215,465,92,1268,795,516,155,1668,987,749,950,675,790,1120,40;42;M
110318;1669,771,795,1449,996,680,1212,1440,1668,891,749,1120,104,465,1197;35;F
110323;907,1443,996,582,891,1212,749,1120,1197,465,1669,1713,92,1668,1449;38;F
110345;796,1669,1436,92,1268,795,907,155,996,1668,891,749,790,1120,104;75;F
110360;1039;10;M
110365;1501,996,1449,1443,907,92,796,725,1669,748,155,1668,1212,1205,1120;45;M
110381;1197,1039,215,742,996,516,907,255,771,1268,92,795,1501,1120,976;47;F
110386;796,1669,907,516,996,1501,1668,680,941,987,1450,1259,1120,976,215;51;F
110404;725,675,40,976;23;F
110407;207,1443,891,1212,146,749,930,1205,790,1120,215;36;F
110455;796,907,996,1120,1259,1212,1450,941,891,749,40,1669,92,1668,1235;38;M
110484;796,465,1268,907,1501,680,1450,891,749,1120,40,976,215;38;M
110486;1039;6;M
110501;92,941,1450,1259,950,1120;45;M
110519;207,771,1713,1324,907,1449,996,987,891,976,1668,680,749,1472,215;49;F
110530;1668,1197,941,1669,907,516,1449,582,987,891,1450,930,1259,675,1120;31;F
110534;1669,1670,1713,1440,207,907,1235,1443,996,1668,742,987,1212,1259,1197;33;F
110536;996,1219,1668,941,1450,891,1212,1233,749,1259,1120;60;F
110571;1501,1229,796,748,907,1449,996,941,1450,891,1233,749,930,1259,1120;2;F
110594;1669,607,155,1668,146,950,675,1120,1197,742;37;F
110610;1039;47;M
110620;749,1324,92,725,1450,941,1668,996,907,1669,891,1212,1259,1120,1039;34;M
110634;1120,796,1212,1233,749,1259,40,1440,607,907,996,1134,1668,1450,1197;29;M
110649;749,996,941,891,1120,40,1039,207,155,1668,987,1450,1259,976,215;49;F
110658;1209,1324,1713,92,145,748,255,1449,155,1219,1668,680,987,675,1039;64;F
110673;465,1440,748,795,1443,996,680,987,1212,749,1472,790,40,1197,215;74;F
110685;907,1143,167,996,1259,675,1120,725,796,1668,998,1197,215,1669,950;45;F
110687;1120,465,796,117,1436,1440,748,607,795,907,996,749,790,582;11;M
110690;996,1268,796,1669,92,748,907,1449,1668,1450,749,1259,675,1120,215;67;F
110703;92,582;57;M
110706;40,1713,950;58;F
110709;1440,930,675,680,987,582,1449,1209,1324,207,255,1229,742,1039;8;M
110719;1443,680,1450,891,1212,749,796,795,996,1501,1668,675,1039,976,215;21;M
110730;907,1449,996,1450,891,1212,749,1259,1120;38;F
110761;891,1668,1669,725,941,1212,1233,675;30;F
110772;1450,1120,92,1268,907,996,1668,1039,725,769,456,1443,1219,941,1197;63;F
110783;465,748,996,1212,680,987,930;34;M
110785;796,40,790,1205,930,749,1164,891,1186,1449,748,92,1713,465,607;77;M
110796;941,1670,1259,117,1436,907,516,1120;36;M
110800;1668,1501,996,516,795,1268,92,1669,465,1713,1449,1219,1186,749,104;35;F
110803;1219,941,749,215,796,996,987,1450,1212,1259,675,1120;31;M
110826;92,1669,907,1668,680,987,1450,891,749,675,1120,40,215;43;F
110848;145,1713,117,1209,796,1562,769,155,167,998,582,987,146,950,215;63;F
110857;1449,891,1212,1205,996;30;F
110869;1668,117,92,607,40,1197,104,725;22;M
110873;117,1713,1268,207,907,167,742,891,1205,675,1120;64;F
110875;207,795,456,907,996,1219,1209,1197,104,941,1259;26;F
110876;976,516,1229,796,907,582,891,996,941,1450,930,92,1259,1120,1039;28;F
110882;680,215,976,891,1450,1668,1639,796,1562,1268,907,1449,1259,790,1120;31;F
110887;456,607,207,145,92,255,1443,1501,987,146,675,1120,215,1197,976;37;F
110892;145,907,582,1039,1120,1259,1670,92,795,996,1668,742,891,146,215;37;F
110902;748,1209,907,1219,582,987,930,1205,40,1197,215,1440,207,255,680;19;M
110920;1209,1440,1229,907,1212,146,675,215,207,255,1219,742,987,1039,104;38;F
110943;1562,1268,795,907,987,769,1443,1134,1668,146,950,1039,215;49;F
110950;207,748,607,1639,456,1235,516,155,167,742,1259,1205,1120,1197,215;36;M
110957;1443,742,950,1039;38;F
110981;1669,92,795,907,456,1443,1668,987,1450,146,1259,675,1197,1039,976;29;F
110995;1229,907,1212,1259,1120,1039;30;F
110997;725,465,1669,1440,607,1449,1501,1668,680,891,1212,790,1120,1197,104;32;M
111021;1436,1440,1229,1164,1212;32;M
111034;795,1440,207,748,907,1235,1443,1449,996,1501,1668,680,930,950,40;64;F
111047;675,987,516,207,1669,1443,1668,680,1039,1562,769,795,146,950;68;M
111058;796,92,1120,155,996,1668,891,1197;44;F
111062;742,950;6;F
111074;1440,1668,680,749,950;38;M
111077;1440,749,891,1219,996,907,1669,92,155,1501,1668,941,1450,1259,1120;38;F
111082;1443,907,1229,1440,1713,725,1669,1668,987,1259,1205,1120,1197,1039,976;44;M
111087;1039,1324;35;M
111095;796,1209,92,907,996,1668,1450,891,1212,749,1259,1120;30;F
111096;796,1562,1268,769,795,1668,998,680,987,1120,40;36;F
111107;1501,907,748,1440,92,1436,465,1209,796,1268,795,1449,891,1205,790;71;M
111109;907,1440,1324,1669,725,1562,92,1229,516,155,742,941,891,1120,1039;36;F
111113;725,207,1449,996,1668,680,582,1212,675,255,1440,1669,1562,1209,1197;31;F
111115;950,1324;14;F
111144;675,1120,1259,930,1229,1324,796,1669,92,255,516,1668,987,1450,891;36;F
111169;891,92,1440,255,996,1668,941,1450,146,1259,675,1120,215,976,987;34;F
111202;1668,1450,891,40,1562,92,1268,1440,907,987,950,675,1120,1197,976;44;F
111233;749,1212,582,996,1669,92,748,1668,1186,796,1449,1219,891,790,1120;55;F
111247;675,680,1440,1324,207,255,1229,1449,742,582,1039;10;M
111254;1039,207,771,1440,1209,117,456,1219,987,1212,930,1259,675,1120,976;24;F
111269;1229,907,998,749,1120,796,891,675,1039,976,1669,795,1668,680,40;25;F
111271;1669,748,795,607,1143,907,1449,155,996,749,1259,790,1120,976,40;27;F
111273;465,92,907,1449,680,891,1212,1233,749,1120,40;39;F
111275;1120,104,725,92,1440,456,1443,1668,582,941,987,146,930,675,1197;41;F
111285;1670,907,891,976;39;M
111293;891,680,1212,40,749,996,907,607,795,1233,1668,1440,1209,796,725;10;M
111304;1639,117,680,749,1120,40,215;28;M
111307;1562,92,1440,1639,907,1668,680,1450,891,1259,675,1120,40,976,215;43;M
111318;742;4;F
111336;1449,1235,1164,1186,1134,1205,996,255,207,790,582,1143;29;F
111340;941,1120,215,907,930,891,1440,1209,795,255,40,680,1259,1450,749;25;M
111354;996,907,255,92,1668,680,950,1120;27;F
111377;1440,907,155,1443,742,950;45;F
111404;465,1670,1268,1440,516,1668,742,941,987,1450,1259,1120,976,215;39;M
111424;1197,976,1259,1120,680,998,1668,996,907,796,1562,117,92,769,749;45;M
111434;1324;44;F
111441;796,907,996,891,215,1669,92,1668,582,1450,1212,749,1259,1120;37;F
111454;1229;42;F
111462;742,582;39;M
111475;725,92,795,941,891,1120;38;F
111478;1235,167,1233,749,1120,92,1449,1668,891,976;26;F
111501;796,1669,92,907,996,1668,941,1450,891,1212,1259,1205,1472,1120,104;33;M
111502;749,155,117,987,976;49;F
111525;607,146,1205,930,891,1668,516,907,117,1436,1449,996,749,1120,582;8;M
111537;92,117,1440,907,516,996,1668,582,680,1450,891,1259,1120,1039,215;32;F
111553;1120,1197,215,742,1443,950,40;37;M
111559;1440,1259,1197,976,891,796,795,749,465,146,1668,40,907;21;M
111603;1443,742;37;M
111607;1449,976,907,795,92,1713,1669,796,1668,987,1212,749,1259,950,1120;36;F
111619;930,1259,950,1039;37;M
111626;155,92,607,1449,749;40;F
111633;207,950,1039;36;F
111648;748,769,725,1219,1668,941,1212,749,1472;30;M
111683;749,1259,796,1669,92,207,748,907,1449,996,1668,146,930,1120,1197;34;F
111695;92,1440,1668,907,1235,996,891,1259,1120,40,155,680,749,950,976;37;M
111703;742,950,675,465,1443;44;F
111736;607,92,1713,1562,796,465,1669,117,748,1501,1668,891,1212,790,1197;25;F
111742;215,1039,987,146,950;31;F
111765;456;5;M
111817;1669,1436,92,1440,607,1143,1235,1449,748,680,987,749,675,40,1039;38;M
111818;796,1562,456,950,976;48;M
111822;749,891,1219,1449,907,1639,255,145,92,1209,607,675,104,790,996;20;F
111823;1501,1212,1259,996,516,1639,1669,1440,907,941,1450,891,1120,1039,215;1;F
111834;582;39;F
111845;796,1209,1669,92,1440,1449,1668,680,1450,749,675,40;28;F
111848;1164,748,1143,1235,1449,996;65;M
111853;1669,40,92,1449,155,1501,1668,742,680,891,950,215;46;F
111865;145,796,1713,771,749,92,582,1668,1212,1205,1197,680,1669,1209,987;36;M
111867;1219,998,987,1259,675,748,749,796,1436,1501,1668,1212,1120,1197,976;27;F
111876;1669,748,1668,891,749,1120,104;42;M
111881;795,748,796,1713,790,1039,1235,1120,155,950,749;51;M
111894;1120,1449,1212,907,941,680,891,1233,1472;79;F
111901;40,891,582,1440,92,796,795,1235,996,1668;34;M
111914;1443,742;47;M
111917;796,987,1450,891,1212,1259,1120,790,1472;28;F
111932;950;46;M
111934;1668,996,941,40,749,796,907,1450,1259,675,1120,976,215,680,987;47;M
111959;1120,1472,749,680,582,1668,1501,996,1449,1235,795,92,1713,796,1197;45;F
111972;1440,117,465,796,1562,92,1268,795,1639,1235,680,987,675,1120,976;34;M
112028;1120,145,207,255,456,582,941,146;38;F
112032;771,104,891,1668,1219,145,1669,1449,749,146;68;F
112034;607,255,516,1449,582,742,987,146,930,675,1120,790,40,1197,1039;21;F
112075;987,1668,996,907,255,1670,92,1443,1501,146,675,1120,1197,976,215;37;F
112077;907,1449,996,1212,749,1472,790,987,582,1668,1501,1219,1440,92,1669;39;F
112082;1562,456,1713,117;32;F
112097;582;10;F
112126;1164,680,987,1668,1134,155,1235,207,1440,92,1669,675,1120,976,215;21;M
112143;465,796,1268,795,907,996,1219,1501,582,941,1450,891,1212,1259,1120;41;F
112147;92,725,1440,907,516,1443,1449,996,1668,582,987,1259,950,675,1120;10;F
112153;1120,1472,749,680,582,1668,1501,996,1449,1235,795,92,1713,796,1197;57;M
112161;680,996,117,1669,1259,1120,215,104,976,1639;41;F
112167;950,1443,742;43;F
112174;1668,725,1436,675,516,976;25;M
112184;1229,996,1501,1668,582,680,941,987,1450,891,1212,146,749,1259,1120;46;M
112187;796,92,795,1443,742,790;40;F
112197;207,516,987,675,1120,215;28;F
112208;907,92,1668,1186,941,987,1450,891,1212,146,749,1259,950,675,1120;40;F
112213;1268,92,1713,117,465,907,1443,1449,996,1450,749,1259,1205,1120,796;7;M
112223;117,1268,1440,207,907,167,996,891,675,790,1120,1039;67;M
112235;796,465,92,1268,748,155,1186,790,795,255;49;M
112237;1443,930,976,215,1669,92,996,1501,1668,582,987,146,675,1120,1197;63;F
112249;1440,907;24;F
112261;675;38;M
112292;92,207,795,607,1449;27;F
112297;796,1669,1501,1668,749,92,255,907,1449,996,1450,891,1259,1120,104;30;F
112307;145,771,1670,795,255,1639,1229,516,155,742,987,891,146;4;F
112321;1440,92,1669,207,607,1668,1219,680,930,950,1205,1120,1197,1039,215;9;M
112342;1219,1259,1472,1120,1209,796,92,145,456,996,1668,146,675,1039,104;30;F
112345;1039,976,215,1443,996,1450,1259,1120;29;M
112357;1440,907,1668,465,1669,891,790,1120,1197,92,795,255,987,215,104;41;F
112363;1197,1120,675,1205,950,1268,771,117,796,748,680,987,146,40,1039;62;F
112382;582;13;F
112395;465,907,1235,1443,1449,996,582,680,891,1212,1259,790,1120,976,215;43;M
112438;976,215,167,769,725,465,1324,117,92,748,1668,680,749,1120,40;26;M
112455;465,1268;62;F
112492;1669,1713,1436,996,1668,987,1259,1120,1197,976,795,255,907;21;F
112499;1219,1668,941,987,1450,891,1233,930,749,1259,950,1472,1120,1197,976;37;M
112505;1039,1120,950,1212,891,742,1668,1443,607,1440,92,1713,1669,796,795;15;F
112513;725,976,996,1668,1039,742,796,1713,748,795,907,1443,1449,950,1120;46;M
112536;907,255,607,796,465,1268,1440,207,1449,680,749,790,40,748,1120;40;F
112539;790,582,996,1449,1235,907,465,796,1450,891,1212,1233,749,1259,1120;34;F
112554;1268,675,748,795,255,1235,1449,891,749,790;34;F
112561;1212,950,675,1205,1197,92,1268,795,255,1229,1219,104,987,1450,1120;32;F
112571;1449,907,456,771,1440,725,1209,1669,92,607,1501,1668,1233,1259,675;32;F
112595;582;9;M
112606;891,1164,40,1501,1219,1440,1562,1324,92,1268,769,795,680;23;F
112613;907,996,1450,1259,675,92,1440,1501,1668,1120,1197;25;F
112618;1501,1268,117,1669,1668,987,146,930,976,675;33;F
112627;207,255,907,680,891,1212,1233,749,930,1259,1472,790,1120,40,1197;29;M
112629;1039;57;M
112633;582;40;F
112662;1668,582,941,891,1259,1120,796,1562,1209,465,1268,1450,680,987,675;35;F
112688;1669,92,207,795,255,1443,1668,215,950,104;40;F
112689;725,742,1233,950,675,40,1039;49;F
112700;996,1501,1668,582,680,941,1450,891,1212,749,1259,950,1120,40,1197;24;F
112702;104,1039,1120,930,1134,456,795,145,155,1164,146,207,1143,675;56;M
112723;796,907,1443,996,680,941,1450,891,1212,1233,749,1259,1120,40,976;35;M
112725;1197,1039,146,891,941,742,155,516,1229,795,207,145,771,1670,1324;;M
112733;1440,1259,1443,1501,1450,146,930,1120,1039,976,215,907,516,680,987;35;M
112739;1134,1501,1668,742,680,1450,1233,675,1120,1039,104,725,1669,255,146;35;F
112742;891,1120,1197,796,1324,207,607,1235,1449,996;38;M
112747;1039,1713,167;22;F
112757;796,1669,92,1268,1440,795,1219,996,1668,1120;39;F
112773;582;7;M
112774;907,680,1259,1120,1436,1450,795,1668,582,146,1197,976,104,92,1268;35;F
112775;582,680,950,1120,40,215,1562,1713,1268,769,1668,742,987,675,1039;33;F
112785;1669,92,742,1440,748,1443,996,950,1205,790;11;F
112831;1209,92,207,907,516,996,1501,1668,582,987,1259,675,1120,40,1197;30;F
112836;796,725,1209,771,207,255,1229,1449,742,680,987,146,1233,675,1039;6;F
112839;607,1449,790,1197,1669,1668,1562,1268,1120,891,996,749,680,215,40;68;M
112844;1209,725,796,465,155,996,1501,1668,582,675,790,1120,40,1039,215;10;M
112911;92,987,891,749,976,215;43;F
112941;215,976,1197,1440,207,907,1443,950;42;F
112950;92,795,891,1197,104,976,1501,215,1668,1212,1268,907,1259,1219,1120;31;F
112958;1212,1450,1668,1501,1134,1219,1449,1443,1229,1639,1440,1268,1436,1669,1209;29;F
112968;987,516,92,1209,215;48;M
112970;795,907,1440,207,155,930,950,675;58;M
112987;1229,1669,796,1209,1440,207,1443,1219,1668,941,987,891,146,675,1039;40;F
112992;996;76;F
112999;582;1;F
113001;1668,1229,1143,207,145,1235,1443,1449,1186,891,146,1205,675,790,1197;66;F
113031;748,907,1443,680,796,1562,167,998,742,1212,749,950,1120,1039,215;8;M
113041;465,1268;61;M
113043;907,1235,1449,155,1219,582,680,891,1212,749,1259,1205,790,1120,40;35;F
113055;907,996,1668,749,1120,1197,465,207,748,1449,582,680,891,1205,790;41;F
113060;607,1229,1443,742,1212,146,950,40,1039,215;39;F
113062;1670,1449,996;59;F
113083;742,796,1562,1268,769,1443,167,998,680,749,950,1120,40,1039,215;44;M
113094;1713,92,1450,40,215,996,465,907,1449,680,891,749,1120,976,582;47;M
113098;92,207,748,255,1443,1449,1186,891,749,1205,675,790,1120,1197,104;42;F
113100;1449,907,465,749,1120;23;M
113107;1259,40,1197,516,465,796,907,996,1449,680,891,1212,749,790,1120;52;F
113108;1209,1669,92,516,1501,998,680,987,1212,1259,675,1120,40,1197,215;31;F
113109;1440,996,1668,582,680,941,1450,146,749,1259,1120,1197,907,1501,891;39;M
113110;675,749,891,1212,950,1450,987,1668,1639,795,796,907,1501,1259,976;49;F
113111;996,1443,907,207,1440,92,1669,465,796,1449,1668,582,749,790,1120;30;F
113138;1039,1668,92,1713,1562,207,680,987,950;37;F
113140;607,1197,104,117,92,1219;47;F
113175;456,907,155,996,1219,1668,146,950,1120,976,215,1501,987,675,1197;39;F
113180;1268,795,1229,907,1443,1449,1501,1668,941,1450,891,1212,749,1259,1120;53;F
113181;907,1443,582,146,795,771,1713,996,1668,930,1120,976,215;24;M
113187;742,996,516,1268,92,1440,1443,215,104,976,40,1120,930,987,680;33;M
113210;1197,891,582,607,1449,1668;20;F
113211;465,1209,796,1669,1436,1443,1449,996,1219,1668,1450,1212,1259,1120,1039;33;F
113225;255,1235,516,1219,1668,998,680,987,891,1212,675,790,40,1197,104;33;M
113237;582;39;M
113245;1143,1443,950;35;M
113253;907,976,1219,987,1120,215,1562,796,1713,1440,795,996,680,675,1197;31;F
113266;92,1669,607,907,1449,996,1501,1668,582,1450,1212,1259,1120,1197,215;18;F
113267;1209,1440,207,582,680,987,1450,146,930,1259,675,976,215;33;M
113276;1440,1235,1443,1450,1197,725,1259,987,976,215,769,1268,795,680,516;35;M
113277;1440,748,1449,1668,998,680,891,146,749,930,1259,1205,1120,40,1197;31;M
113280;1669,1120,215,907,1259;29;M
113285;996,1134,1668,998,987,1212,950,675,1120,40,1197,976,215,92,1436;26;F
113293;582;12;F
113311;1449,215;35;F
113371;465,207,748,607,907,1449,996,1186,742,582,680,749,1205,1120,40;35;F
113374;796,145,907,996,1450,891,146,1233,749,1472,1120;38;F
113380;1713,996,1440,907,941,1450,891,1212;32;F
113399;1039,1268,680,987,675,40,976,215;37;F
113410;1562,769,155,987,146,749,950,1039,976,215;37;M
113433;1209,145,1229,1443,742,950,40,1197;14;M
113457;582;37;M
113458;796,465,1669,1713,207,1449,1668,891,790,1120,1039;37;M
113461;92,1268,607,155,996,1501,1668,1450,891,1212,930,1259,950,675,1120;41;F
113481;1669,796,1209,92,907,1449,996,1501,1668,1212,749,1450,891,1259,1120;28;F
113491;582;68;F
113494;796,1440,1219,582,1450,930,1259,675,1472,1120;43;M
113507;796,907,1450,1212,749,1259,92,155,891,1120,215;45;F
113510;582;8;F
113515;796,1669,92,795,907,1450,1259,1120,1668,749,976;35;F
113548;1324,680,930,675,1039,976;33;M
113550;465,1670,145,207,255,456,1143,516,146,1472;40;F
113555;725,92,907,996,1668,941,1120,1039;31;M
113563;1268,907,1449,1668,1186,742,582,891,749,1205,675,790,1120,1197,1039;24;F
113571;941,1443,1039;40;M
113575;795,255,1443,167,996,1668,998,742,1212,146,930,950,1205,1039,976;1;F
113576;796,998,516,215,117,1713,1268,1440,769,795,1639,167,680,987,976;30;F
113587;1259,516,795,1209,771,675,1120,1039,104,207,255,1143,1219,1450,146;40;F
113591;796,1209,92,907,996,1668,582,680,1450,1212,749,1259,1120,40;35;F
113629;1134,1186,680,749,1205,104,796,748,607,1668,891,790,1669,92,996;35;F
113637;950,1669,1120,796,92,207,607,996,1668,790;35;M
113651;207,145,92,465,582,146,930;36;F
113655;950,675,40,790;20;F
113658;117,92,996,1450,891,1212,749,1259,1120,40;32;M
113664;749,1197,891,1501,996,1443,907,796,1120,1668,92,1669;41;M
113666;92,1440,998,742,987,1212,1259,950,1120,1039;4;M
113673;1324,516,1449,155,1501,680,987,675,1472,976,215;33;M
113681;582;7;M
113689;255,1449,1235,749,748,582,207,790,607,1164,1205,1143,1134,1186,996;37;M
113693;1501,891,1039,215,907,1440,1436,465,680,1450,1212,1259,675,1120,1197;40;M
113705;582;68;M
113719;1440,749,1259,950,790,796,456,516,1668,680,987,891,1120,976,215;42;F
113730;907,996,1450,1259,1120;43;F
113756;146,1233,1472,215;36;F
113776;941,1501,996,907,255,607,92,1669,1209,1219,1450,1259,675,1120,1197;41;F
113780;1120,790,1205,930,749,456,795,1324,465,1268,207,748,255,907,1449;36;F
113782;749,1212,996,1713,796,1562,92,1668,998,680,950,1120,40,215;36;M
113798;1209,769,748,516,1443,742,582,1212,950,40,1197,1039,215;11;M
113803;607,796,1669,207,748,465,1229,907,1443,155,1186,680,749,675,104;48;F
113811;907,795,145,1324,1209,796,92,1449,996,1501,1668,1120,1197,1039;32;F
113813;725,987,1259,40,907,749,950,796,1440,795,1443,155,1668,680,1120;44;F
113870;207,607,255,1449,582,1450,930,675,1120,104,215,117,680,987,516;27;F
113875;1443,1235,748,92,1713,796,907,1449,996,582,891,1212,749,790,1120;29;F
113884;907,996,1668,1259,675,1120,1197,976;37;F
113887;582;41;M
113916;1450,930,1259,1120,1501,996,907,796,987,941,680,1440,516;28;M
113943;40,1562,987,215;54;M
113947;117,769,207,748,795,255,1443,155,996,1668,742,1212,950,40,1039;77;F
113948;1209,1440,930,40,215,976;18;M
113961;1134,1186,891,104,145,771,92,1669,907,1449,215;32;F
113974;1713,748,1186,891,1472,1120,215,207,1443,1143,582,1164,1205;42;M
113979;796,748,207,607,146,1205,1472,790,1120;35;M
113992;1212,749,976,1039,1450,1259,1472,1120,215,941,1233;43;F
114003;207,1669,1713,92,1440,769,748,607,1235,155,680,950,215,1197,1039;5;F
114026;907;25;F
114045;1501,1668,742,582,680,987,1212,146,950,976,215,1039,1197,207,930;38;M
114060;1668,742,907,1229,145,769,117,1562,1268,996,749,950,1120,40,1039;40;M
114061;796,1562,1268,117,1209,748,1440,1713,1670,255,167,680,987,675,1120;74;F
114064;796,117,1120,1197,1039,1501,941,976,215,1440,996,680,675;39;M
114065;516,1443,742,1450,146,950;36;F
114066;941,1670,1669,725,92,748,1449,1668,680,1212,749,1259,1120,40,976;23;F
114068;796,1562,1436,1440,795,1639,1235,680,891,950,40;38;M
114087;207,1229,996,1212,1120,215,771,1713,1268,769,1443,742,987,950,1039;49;M
114100;1259,1120,1229,255,607,1324,215,1670,145,207,516,1219,742,941,146;45;F
114107;996,941,1450,891,1164,1212,1233,749,1259,1472,1197,104,92,1186,1120;29;F
114116;607,1235,796,1209,1324,1449,155,996,680,1450,891,1212,749,1259,1120;57;F
114117;976,40,1472,987,1235,465,1436,167,680,891;39;M
114120;1120,1039,215,607,795,207,145,1268,92,1436,1670,117,1324,465,1209;47;M
114123;1229,907,1443,996,742,941,1450,891,1212,1259,675,1120;30;F
114155;145,607,1443,996,1219,1668,941,1450,891,146,1259,1205,1120,40,1039;66;M
114169;1164,1440,1436,1324,465,117,1143,516;61;M
114176;796,92,1440,255,907,742,40,1235,117,996,1668,749,1120,1197,104;30;F
114182;675,1259,987,1134,996,795,1713,907,1143,1668,582,930,950,1120,1197;28;F
114184;998,680,987,1212,1259,1120,1039,976,117,92,516,1443,891,790,1197;27;F
114187;117,1268,769,748,1229,998,987,1669,92,607,155,1668,950,40,1039;33;F
114194;607,456,155,950,796,92,255,516,1501,1668,987,1259,1120,1197,976;37;F
114205;1669,92,907,1143,996,1501,1668,1450,891,1164,1212,146,1233,1259,1120;72;F
114237;207,748,1229,1235,516,996,1134,1668,998,891,146,1472,40,1197,104;36;F
114242;155,1197,215,796,1324,1639,1501,1668,950,1039,1670,907,1450,1259,976;43;F
114251;155,167,950,1039,1197,749,146,1212,1668,516,748,1436,1670,465,1562;35;F
114286;930,207,255,1209,1229;34;M
114289;996,680,891,1212,749,40,1197,976,92,1440,1668,941,1450,1259,1120;49;F
114292;40,749,742,92,1120,215,117,795,1443,680,891;41;M
114301;1668,907,1450;41;F
114304;92,907,996,40,796,891,749,1212,582,680,456,607,1440,1449,950;45;M
114311;795,1268,1562,1669,1713,92,769;45;F
114341;790,950,1212,891,987,1039,1229,207,607,255;44;F
114358;1219,1668,680,1212,749,40,1197,1039,215,1268,92,1669,1562,796,1443;42;F
114382;1209,1440,1443,1501,742,582,987,1450,891,1259,675,1120,976;38;F
114430;769,1268,1669,796,1209,92,907,516,996,1668,998,987,1120,40,976;33;M
114441;1120,215,976,40,891,1209,796,92,1440,748,907,1449,1668,680,987;42;F
114442;117,1436,1268,516,1449,996,680,987,1450,1259,675,790,1120,976,215;27;M
114443;456,891,146;30;F
114453;607,207,1440,1670,1669,92,907,996,998,582,749,1259,675,1120,1197;28;F
114479;1209,207,1120,145,516,255,680,930,1205;36;M
114482;891,680,1501,996,907,748,1440,1713,1562,1120,749,1212,1449,796,465;47;F
114492;941,1259,104,796,92,207,748,155,465,1209,891,1450,1440,675,1039;36;M
114500;1669,92,1668,950;31;M
114503;40,1259,749,891,1668,1501,796,117,680,675;35;F
114527;607,907,582,1212,1443,155,796,1668,1039,1120,950,1268,1562;50;F
114554;1209,771,145,207,456,1219,1186,675;32;M
114578;465,1268;88;M
114585;1440,465,796,1713,748,907,1235,1668,891,749,1120,790,996,1669,680;30;M
114609;987,941,1501,1449,907,1268,1713,1324,92,1440,996,1668,930,1120,1039;25;M
114619;1197,1039,907,1120,155,1668,987;36;F
114624;996,465,117,207,255,1219,1668,582,987,1212,1120,146,930,1197,1039;42;M
114626;771,145,607,255,516,1219,891,1259,1440,146,930;36;F
114642;1120,40,1197,976,1443,907,456,255,1440,117,145,207,1039,987,215;37;F
114658;891,1233,1039,725,1209,207,255,996,749,930,675,1120,1229;33;F
114685;207,1229,456,907,516,1443,996,1219,742,941,1450,891,146,930,1259;76;F
114690;976,92,1440,1668,796,907,996,1501,680,941,1450,891,1259,1120,1197;28;F
114717;207,145,1669,941,976;31;F
114737;1443,996,1501,1668,742,1120,1212,582,680,456,607,796,1440,1449,950;11;F
114740;996,1450,749,1259,1120,976,1268,456,907,1449,1219,742,675,1197,1039;33;F
114785;725,92,1268,1259,155,950,607,795,1219,941,930,1039;42;F
114803;607,1219,941,930,1039;42;M
114832;796,725,117,607,255,907,1219,1668,891,1212,930,1259,790,1197;31;F
114839;1209,1450,891,1233,1324,1259,725,465,92,1219,680,941,987,1120,675;31;F
114847;748,907,1449,996,1668,582,680,1450,891,749,930,1259,790,1120,1039;32;M
114848;1209,92,1268,795,1668,1450,146,976,1259,675,1120,1197;48;F
114903;1669,680,675,1197,92,987;59;M
114914;1501,1450,1039,1669,1324,1443,1668,987,146,950,675,1120,1197,976,215;38;F
114923;1440,907,516,1668,742,976,215,996;37;M
114927;795,1229,907,516,1443,996,1668,742,987,749,950,1120,40,976,215;30;M
114965;1450,941,742,996,907,891,1259,1120;34;F
114966;1259,215,1440,907,117,1501,987,996,1120,976;40;M
114978;1668,742,987,1212,146,749,1259,950,1205,1120,1197,1039,976,104,215;34;F
115009;1562,1443,950,1039;35;F
115014;1205,1120,215,996,941,1450,891,146;33;M
115032;1212,1668,92,796,1669,907,1449,996,891,790,1120,976;47;F
115038;1209,1324,145,207,607,456,155,742,146,1233,1205,104,1219,215;33;F
115051;607,907,1235,1443,996,1668,582,680,1212,790,1120,1440,1449,796,950;16;M
115052;1039;30;F
115069;796,1562,1268,795,907,996,1501,1668,987,1450,1259,950,675,1120,976;48;M
115080;215,1209,207,255,742,675,1440,1039;33;M
115083;1120,950,1259,1450,987,796,725,1669,1639,155,1668,680,749,976;52;F
115087;1443,1449,996,1219,1501,1668,582,941,1450,891,1212,749,1120,1713,1259;31;F
115099;907,516,1449,996,1501,1668,680,941,1450,891,1212,749,1259,675,1120;34;M
115101;796,92,1440,907,680,987,749,1259,1120,976;32;F
115116;1562,769,1668,215,987,950,675,40,891;53;F
115118;207,742,146,950,1039;5;F
115155;796,1440,748,996,1134,1668,1186,582,891,1164,146,1205,790,1120,104;37;M
115177;465,748,795,1229,907,996,1219,1450,1233,104,1259,1205;43;F
115187;1219,146,1205,104,675,1039;43;F
115198;1440,742;35;M
115220;1209,748,907,1443,1449,996,891,146;34;F
115227;255,607,207,1440,1268,117,1209,725,516,930,1259,675,976;28;M
115232;795,582,1120,1669,1449,1501,1668;20;F
115257;796,1440,748,891,749,1120,215;39;F
115261;207,607,907,1449,155,1219,742,680,891,146,749,930,1259,950,1205;41;M
115291;117,725,796,465,1440,748,795,1449,996,1450,891,749,1259,1120,976;16;M
115301;92,795,582,987,749,1120,1197,1440,771,907,1219,1501,680,675,976;33;F
115326;40,1259,891,1450,582,998,1668,996,907,748,92,1268,1670,117,465;21;M
115332;145,1670,1186,146,725,1669,92,1440,255,456,1668,987,675,1120,1197;32;M
115335;1443,117,1268,1440,907,1449,987,891,795,207,796,155,675,1120,1039;53;F
115347;996,1668,742,582,680,987,1212,146,749,950,675,1120,40,1039,215;34;F
115368;117,92,1268,255,907,516,1668,941,1450,891,1212,146,1233,1259,1120;31;F
115393;1436,1670,1324,465,1268,1440,1639,907,941,1450,891,1259,1120,976,215;32;M
115404;1449,1501,941,891,1212,749,976,1670,907,516,996,1219,1450,1259,1120;38;F
115409;1501,680,950,1669,40,1440,215;43;M
115411;145,1440,1669,725,1713,92,207,748,907,996,950,1120,104,1197,215;43;F
115412;92,1440,748,1449,1219,742,582,891,1212,930,790,1039,1197,976,215;42;F
115431;996,998,976,742,1268,769,748,1443,167,680,1212,749,950,1039,215;6;M
115475;907,1449,1219,1134,1186,582,941,987,1450,891,1233,749,1259,675,1120;25;M
115484;1443,1219,1501,796,1713,92,795,907,155,996,1668,891,1212,749,1120;31;F
115487;215,207,795,255,1443,680,987;38;F
115499;1440,1713,1670,117,465,796,1450,891,1212,1233,749,1259,1120,40,976;51;M
115546;1449,749,1259,40,1197,1120,987,680,1668,796,1209,1440,255,456,155;33;M
115578;891,1186,749,40;66;M
115586;796,1669,92,145,950,675,207,255,456,907,996,1668,146,1120,104;11;F
115642;907,1209,1268,1440,795,1443,996,941,1450,987,146,1259,675,1120,1039;35;F
115645;582,680,941,1212,146,749,1259,950,92,795,742,987;36;M
115650;1562,1209,1324,1268,155,769,207,891,680,987,950,215;53;M
115660;769,1268,1713,1324,1669,1562,1219,742,998,675,1197,1039,987,146,950;39;F
115661;1713,1440,207,1501,987,891,749,675,1120,40,1197;24;M
115682;1039,146,748,1440,456,950,1197;35;M
115699;145,1209,725,1440,1443,996,1219,742,941,146,1259,675,1120,1039,104;38;F
115745;1501,1449,725,1443,92,796,1440,907,996,680,987,749,1259,1120,976;32;M
115755;680;51;M
115794;207,145,1440,92,1670,1713,907,516,1501,1668,987,582,1259,1120,976;28;F
115806;742,582,680,891,146,749,930,950,675,1472,790,1120,40,1197,104;43;F
115814;796,92,1268,907,1443,1449,1668,582,680,891,749,790,1120,40;42;M
115819;796,92,1268,1440,795,456,907,1668,1212,1120,1197,976,215;61;M
115826;92,748,907,1501,1668,582,1212,749,1259,675,790,1120,1197,104,215;32;F
115832;976,40,1120,675,930,891,680,1668,1501,996,1449,1235,92,1324,1669;29;M
115849;1669,1219,941,1450,1259;36;F
115859;790;35;M
115878;607,207,907,987,1039;38;M
115926;1440,907,1449,155,996,1668,680,987,1450,891,1259,950,675,1120,976;32;F
115932;950,215,796,1562;32;M
115944;1209,465,117,1449,749,1120,40,976,104;45;M
115956;1268,1440,1639,907,167,680,987,891,146,1259,1205,1197,1209,1120,215;25;M
115963;255,1229,680,1197,976;29;F
116008;680,742,255,1209,1440,1449,582,987,675;32;F
116069;749,675,1197,1039,976;29;M
99999937954;1039,104,987,207,255,680,930,950,675,1209,1440,1186;33;F
99999944009;145,207,795,607,255,456,582,1164,146,749,1205,675,104,1120;40;F